/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.configuration.licence;

import com.huawei.dc.common.asndatacenter.AsnDCImportLicenseReq;
import com.huawei.dc.common.asndatacenter.AsnLicenseModeEnum;
import com.huawei.dc.common.components.DCFilePathTextField;
import com.huawei.dc.common.components.dialog.DCModalDialog;
import com.huawei.dc.common.components.u2kcbb.DCPasswordFiled;
import com.huawei.dc.common.framework.system.SystemManager;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.DCFileChooser;
import com.huawei.dc.common.util.DCHelpManager;
import com.huawei.dc.common.util.DCOptionPane;
import com.huawei.dc.common.util.StringUtils;
import com.huawei.dc.configuration.licence.LicenseInfo;
import com.huawei.dc.configuration.licence.LicenseInfoDlg;
import com.huawei.dc.configuration.licence.LicenseMonitor;
import com.huawei.dc.configuration.licence.authorization.AbstractAuthorization;
import com.huawei.dc.configuration.licence.authorization.AuthorizationFactory;
import com.huawei.dc.framework.ErrorCodeReader;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.math.BigInteger;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class LicenseApplyDlg
extends DCModalDialog {
    private static final long serialVersionUID = -7454472740062895894L;
    private JPanel oUpPanel = null;
    private JRadioButton oFileLicenseRadBtn = null;
    private JRadioButton oNetRadBtn = null;
    private JRadioButton oTempRadBtn = null;
    private LicenseInfoDlg oParentDlg = null;
    private JLabel oAuthFileLab = null;
    private JLabel oAuthFilePathLab = null;
    private DCFilePathTextField oAuthFilePathFiled = null;
    private JLabel filePathAsteriskl = new JLabel("*");
    private JButton oAuthFilePathBtn = null;
    private JPanel oFileLicensePanel = null;
    private JLabel oAuthNetLab = null;
    private JLabel oAuthNetUserLab = null;
    private JTextField oAuthNetUserFiled = null;
    private JLabel userNameAsteriskl = new JLabel("*");
    private JLabel oAuthNetPassLab = null;
    private DCPasswordFiled oAuthNetPassFiled = null;
    private JLabel passwordAsteriskl = new JLabel("*");
    private JPanel oNetLicensePanel = null;
    private JLabel oAuthTempLab = null;
    private JPanel oTempLicensePanel = null;

    public LicenseApplyDlg(DCModalDialog parentDlg) {
        super(parentDlg);
        this.oParentDlg = (LicenseInfoDlg)parentDlg;
        this.setSize(400, 350);
        this.setTitle(ResourceManager.getInstance().getResString("LICENSE_AUTH_TITLE"));
        this.setDefaultCloseOperation(2);
        this.setResizable(false);
        this.jinit();
    }

    private void jinit() {
        this.getContentPane().setLayout(new GridBagLayout());
        JPanel oRadioBtnPan = this.createButtonPanel();
        if (DCFrameWorkUtil.getIsSingleClient()) {
            oRadioBtnPan.add((Component)this.oTempRadBtn, new GridBagConstraints(2, 0, 1, 5, 0.0, 0.0, 17, 0, new Insets(10, 12, 0, 0), 0, 0));
        } else {
            oRadioBtnPan.add((Component)this.oTempRadBtn, new GridBagConstraints(1, 0, 1, 5, 0.0, 0.0, 17, 0, new Insets(10, 12, 0, 0), 0, 0));
            JPanel jpanel = new JPanel();
            jpanel.setPreferredSize(new Dimension(100, 21));
            jpanel.setMinimumSize(new Dimension(100, 21));
            oRadioBtnPan.add((Component)jpanel, new GridBagConstraints(2, 0, 1, 5, 0.0, 0.0, 17, 0, new Insets(10, 12, 0, 0), 0, 0));
        }
        this.oUpPanel.add((Component)oRadioBtnPan, "Center");
        this.getContentPane().add((Component)this.oUpPanel, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 11, 0, new Insets(12, 12, 0, 0), 0, 0));
        if (DCFrameWorkUtil.getIsSingleClient()) {
            this.getContentPane().add((Component)this.getNetLicensePanel(), new GridBagConstraints(0, 2, 1, 4, 0.0, 0.0, 10, 0, new Insets(10, 12, 0, 10), 0, 0));
            this.oNetRadBtn.setSelected(true);
            this.oNetRadBtn.setEnabled(true);
        } else {
            this.getContentPane().add((Component)this.getFileLicensePanel(), new GridBagConstraints(0, 2, 1, 4, 0.0, 0.0, 10, 0, new Insets(10, 12, 0, 10), 0, 0));
            this.oNetRadBtn.setSelected(false);
            this.oNetRadBtn.setEnabled(false);
            this.oFileLicenseRadBtn.setSelected(true);
        }
        JPanel oBtnPan = this.createBottomPanel();
        this.getContentPane().add((Component)oBtnPan, new GridBagConstraints(0, 7, 1, 1, 0.0, 0.0, 15, 1, new Insets(8, 12, 10, 0), 0, 0));
        this.requestFocus(true);
        DCHelpManager.getInstance().enableF1HelpKey(this.getContentPane(), this.getCurrentContext());
    }

    private JPanel createBottomPanel() {
        JPanel oBtnPan = new JPanel();
        oBtnPan.setLayout(new GridBagLayout());
        oBtnPan.setPreferredSize(new Dimension(400, 35));
        oBtnPan.setMinimumSize(new Dimension(400, 35));
        JPanel oPanel = new JPanel();
        oPanel.setPreferredSize(new Dimension(122, 21));
        oPanel.setMinimumSize(new Dimension(122, 21));
        oBtnPan.add((Component)oPanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 12, 12, 0), 0, 0));
        this.m_oOKBtn.setText(ResourceManager.getInstance().getResString("LICENSE_AUTH_OK"));
        this.m_oOKBtn.setPreferredSize(new Dimension(100, 21));
        this.m_oOKBtn.setMinimumSize(new Dimension(100, 21));
        oBtnPan.add((Component)this.m_oOKBtn, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 12, 12, 12), 0, 0));
        this.m_oCancelBtn.setText(ResourceManager.getInstance().getResString("LICENSE_AUTH_CANCEL"));
        this.m_oCancelBtn.setPreferredSize(new Dimension(100, 21));
        this.m_oCancelBtn.setMinimumSize(new Dimension(100, 21));
        oBtnPan.add((Component)this.m_oCancelBtn, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 12, 12, 0), 0, 0));
        return oBtnPan;
    }

    private JPanel createButtonPanel() {
        this.oUpPanel = new JPanel();
        this.oUpPanel.setPreferredSize(new Dimension(380, 70));
        this.oUpPanel.setMinimumSize(new Dimension(380, 70));
        BorderLayout oUpBorderLayout = new BorderLayout();
        this.oUpPanel.setLayout(oUpBorderLayout);
        JLabel oLicenseLabDesc = new JLabel();
        oLicenseLabDesc.setText(ResourceManager.getInstance().getResString("LICENSE_AUTH_CONTENT"));
        this.oUpPanel.add((Component)oLicenseLabDesc, "North");
        JPanel oRadioBtnPan = new JPanel();
        oRadioBtnPan.setLayout(new GridBagLayout());
        ButtonGroup oLicenseAuthBtnGroup = new ButtonGroup();
        this.oNetRadBtn = new JRadioButton();
        this.oNetRadBtn.setPreferredSize(new Dimension(100, 21));
        this.oNetRadBtn.setMinimumSize(new Dimension(100, 21));
        this.oNetRadBtn.setFocusable(false);
        this.oNetRadBtn.setText(ResourceManager.getInstance().getResString("LICENSE_AUTH_NET_OPTION"));
        oLicenseAuthBtnGroup.add(this.oNetRadBtn);
        this.oNetRadBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LicenseApplyDlg.this.netLicenseAction();
                LicenseApplyDlg.this.oNetLicensePanel.requestFocus();
            }
        });
        if (DCFrameWorkUtil.getIsSingleClient()) {
            oRadioBtnPan.add((Component)this.oNetRadBtn, new GridBagConstraints(0, 0, 1, 5, 0.0, 0.0, 17, 0, new Insets(10, 12, 0, 0), 0, 0));
        }
        this.oFileLicenseRadBtn = new JRadioButton();
        this.oFileLicenseRadBtn.setPreferredSize(new Dimension(130, 21));
        this.oFileLicenseRadBtn.setMinimumSize(new Dimension(130, 21));
        this.oFileLicenseRadBtn.setFocusable(false);
        this.oFileLicenseRadBtn.setText(ResourceManager.getInstance().getResString("LICENSE_AUTH_FILE_OPTION"));
        oLicenseAuthBtnGroup.add(this.oFileLicenseRadBtn);
        this.oFileLicenseRadBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LicenseApplyDlg.this.fileLicenseAction();
                LicenseApplyDlg.this.oFileLicensePanel.requestFocus();
            }
        });
        if (DCFrameWorkUtil.getIsSingleClient()) {
            oRadioBtnPan.add((Component)this.oFileLicenseRadBtn, new GridBagConstraints(1, 0, 1, 5, 0.0, 0.0, 17, 0, new Insets(10, 12, 0, 0), 0, 0));
        } else {
            oRadioBtnPan.add((Component)this.oFileLicenseRadBtn, new GridBagConstraints(0, 0, 1, 5, 0.0, 0.0, 17, 0, new Insets(10, 12, 0, 0), 0, 0));
        }
        this.oTempRadBtn = new JRadioButton();
        this.oTempRadBtn.setPreferredSize(new Dimension(100, 21));
        this.oTempRadBtn.setMinimumSize(new Dimension(100, 21));
        this.oTempRadBtn.setFocusable(false);
        this.oTempRadBtn.setText(ResourceManager.getInstance().getResString("LICENSE_AUTH_TEMP_OPTION"));
        oLicenseAuthBtnGroup.add(this.oTempRadBtn);
        this.oTempRadBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LicenseApplyDlg.this.tempLicenseAction();
                LicenseApplyDlg.this.oTempLicensePanel.requestFocus();
            }
        });
        return oRadioBtnPan;
    }

    private JPanel getFileLicensePanel() {
        if (null == this.oFileLicensePanel) {
            BorderLayout oNetBorderLayout = new BorderLayout();
            this.oFileLicensePanel = new JPanel();
            this.oFileLicensePanel.setPreferredSize(new Dimension(380, 200));
            this.oFileLicensePanel.setMinimumSize(new Dimension(380, 200));
            this.oFileLicensePanel.setBorder(BorderFactory.createEtchedBorder());
            this.oFileLicensePanel.setLayout(oNetBorderLayout);
            this.oAuthFileLab = new JLabel();
            this.oAuthFileLab.setPreferredSize(new Dimension(350, 50));
            this.oAuthFileLab.setMinimumSize(new Dimension(350, 50));
            this.oAuthFileLab.setText(ResourceManager.getInstance().getResString("LICENSE_AUTH_FILE_DESC_LAB"));
            this.oFileLicensePanel.add((Component)this.oAuthFileLab, "North");
            JPanel panel = new JPanel();
            panel.setLayout(new GridBagLayout());
            panel.setPreferredSize(new Dimension(360, 150));
            panel.setMinimumSize(new Dimension(360, 150));
            this.oAuthFilePathLab = new JLabel();
            this.oAuthFilePathLab.setText(ResourceManager.getInstance().getResString("LICENSE_AUTH_FILE_LAB"));
            this.oAuthFilePathLab.setPreferredSize(new Dimension(110, 21));
            this.oAuthFilePathLab.setMinimumSize(new Dimension(110, 21));
            panel.add((Component)this.oAuthFilePathLab, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 15, 0, new Insets(10, 12, 10, 0), 0, 0));
            this.oAuthFilePathFiled = new DCFilePathTextField();
            this.oAuthFilePathFiled.setPreferredSize(new Dimension(160, 21));
            this.oAuthFilePathFiled.setMinimumSize(new Dimension(160, 21));
            panel.add((Component)this.oAuthFilePathFiled, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 15, 0, new Insets(10, 0, 10, 0), 0, 0));
            this.oAuthFilePathBtn = new JButton();
            this.oAuthFilePathBtn.setText("...");
            this.oAuthFilePathBtn.setPreferredSize(new Dimension(20, 21));
            this.oAuthFilePathBtn.setMinimumSize(new Dimension(20, 21));
            this.oAuthFilePathBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LicenseApplyDlg.this.openFileChooser();
                }
            });
            panel.add((Component)this.oAuthFilePathBtn, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 15, 0, new Insets(10, 0, 10, 0), 0, 0));
            this.filePathAsteriskl.setForeground(Color.RED);
            this.filePathAsteriskl.setPreferredSize(new Dimension(11, 20));
            this.filePathAsteriskl.setMinimumSize(new Dimension(11, 20));
            panel.add((Component)this.filePathAsteriskl, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 15, 0, new Insets(10, 0, 10, 10), 0, 0));
            this.oFileLicensePanel.add((Component)panel, "Center");
        }
        return this.oFileLicensePanel;
    }

    private void openFileChooser() {
        DCFileChooser oFileChooser = new DCFileChooser();
        oFileChooser.setTitle(ResourceManager.getInstance().getResString("IMPORT_LICENCE_FILE_TITLE"));
        oFileChooser.setApproveButtonText(ResourceManager.getInstance().getResString("OK"));
        oFileChooser.setFileFilter(16);
        int returnVal = oFileChooser.showOpenDialog(DCFrameWorkUtil.getMainFrame());
        if (returnVal != 0) {
            return;
        }
        String strFileName = oFileChooser.getFullFileName();
        this.oAuthFilePathFiled.setText(strFileName);
        this.oAuthFilePathFiled.setToolTipText(strFileName);
    }

    private JPanel getNetLicensePanel() {
        if (null == this.oNetLicensePanel) {
            BorderLayout oNetBorderLayout = new BorderLayout();
            this.oNetLicensePanel = new JPanel();
            this.oNetLicensePanel.setPreferredSize(new Dimension(380, 200));
            this.oNetLicensePanel.setMinimumSize(new Dimension(380, 200));
            this.oNetLicensePanel.setBorder(BorderFactory.createEtchedBorder());
            this.oNetLicensePanel.setLayout(oNetBorderLayout);
            this.oAuthNetLab = new JLabel();
            this.oAuthNetLab.setPreferredSize(new Dimension(350, 50));
            this.oAuthNetLab.setMinimumSize(new Dimension(350, 50));
            this.oAuthNetLab.setText(ResourceManager.getInstance().getResString("LICENSE_AUTH_NET_DESC_LAB"));
            this.oNetLicensePanel.add((Component)this.oAuthNetLab, "North");
            JPanel panel = new JPanel();
            panel.setPreferredSize(new Dimension(360, 180));
            panel.setMinimumSize(new Dimension(360, 180));
            panel.setLayout(new GridBagLayout());
            this.oAuthNetUserLab = new JLabel();
            this.oAuthNetUserLab.setText(ResourceManager.getInstance().getResString("LICENSE_AUTH_NET_NAME_LAB"));
            this.oAuthNetUserLab.setPreferredSize(new Dimension(70, 21));
            this.oAuthNetUserLab.setMinimumSize(new Dimension(70, 21));
            panel.add((Component)this.oAuthNetUserLab, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 15, 0, new Insets(12, 12, 12, 0), 0, 0));
            this.oAuthNetUserFiled = new JTextField();
            this.oAuthNetUserFiled.setPreferredSize(new Dimension(100, 21));
            this.oAuthNetUserFiled.setMinimumSize(new Dimension(100, 21));
            panel.add((Component)this.oAuthNetUserFiled, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 15, 0, new Insets(0, 0, 10, 0), 0, 0));
            this.userNameAsteriskl.setForeground(Color.RED);
            this.userNameAsteriskl.setPreferredSize(new Dimension(11, 20));
            this.userNameAsteriskl.setMinimumSize(new Dimension(11, 20));
            panel.add((Component)this.userNameAsteriskl, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 15, 0, new Insets(0, 0, 10, 0), 0, 0));
            this.oAuthNetPassLab = new JLabel();
            this.oAuthNetPassLab.setText(ResourceManager.getInstance().getResString("LICENSE_AUTH_NET_PASS_LAB"));
            this.oAuthNetPassLab.setPreferredSize(new Dimension(70, 21));
            this.oAuthNetPassLab.setMinimumSize(new Dimension(70, 21));
            panel.add((Component)this.oAuthNetPassLab, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 15, 0, new Insets(12, 12, 12, 0), 0, 0));
            this.oAuthNetPassFiled = new DCPasswordFiled(40);
            this.oAuthNetPassFiled.setPreferredSize(new Dimension(100, 21));
            this.oAuthNetPassFiled.setMinimumSize(new Dimension(100, 21));
            panel.add((Component)((Object)this.oAuthNetPassFiled), new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 15, 0, new Insets(0, 0, 10, 0), 0, 0));
            this.passwordAsteriskl.setForeground(Color.RED);
            this.passwordAsteriskl.setPreferredSize(new Dimension(11, 20));
            this.passwordAsteriskl.setMinimumSize(new Dimension(11, 20));
            panel.add((Component)this.passwordAsteriskl, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 15, 0, new Insets(0, 0, 10, 0), 0, 0));
            this.oNetLicensePanel.add((Component)panel, "Center");
        }
        return this.oNetLicensePanel;
    }

    private JPanel getTempLicensePanel() {
        if (null == this.oTempLicensePanel) {
            BorderLayout oNetBorderLayout = new BorderLayout();
            this.oTempLicensePanel = new JPanel();
            this.oTempLicensePanel.setPreferredSize(new Dimension(380, 200));
            this.oTempLicensePanel.setMinimumSize(new Dimension(380, 200));
            this.oTempLicensePanel.setBorder(BorderFactory.createEtchedBorder());
            this.oTempLicensePanel.setLayout(oNetBorderLayout);
            this.oAuthTempLab = new JLabel();
            this.oAuthTempLab.setPreferredSize(new Dimension(150, 42));
            this.oAuthTempLab.setMinimumSize(new Dimension(150, 42));
            this.oAuthTempLab.setText(ResourceManager.getInstance().getResString("LICENSE_AUTH_TEMP_DESC_LAB"));
            this.oTempLicensePanel.add((Component)this.oAuthTempLab, "Center");
        }
        return this.oTempLicensePanel;
    }

    protected void netLicenseAction() {
        if (null != this.oFileLicensePanel) {
            this.getContentPane().remove(this.oFileLicensePanel);
        }
        if (null != this.oTempLicensePanel) {
            this.getContentPane().remove(this.oTempLicensePanel);
        }
        this.getContentPane().add((Component)this.getNetLicensePanel(), new GridBagConstraints(0, 1, 1, 4, 0.0, 0.0, 10, 0, new Insets(10, 12, 0, 10), 0, 0));
        DCFrameWorkUtil.updateUI(this.oNetLicensePanel);
        this.getContentPane().repaint();
    }

    protected void fileLicenseAction() {
        if (null != this.oNetLicensePanel) {
            this.getContentPane().remove(this.oNetLicensePanel);
        }
        if (null != this.oTempLicensePanel) {
            this.getContentPane().remove(this.oTempLicensePanel);
        }
        this.getContentPane().add((Component)this.getFileLicensePanel(), new GridBagConstraints(0, 1, 1, 4, 0.0, 0.0, 10, 0, new Insets(10, 12, 0, 10), 0, 0));
        DCFrameWorkUtil.updateUI(this.oFileLicensePanel);
        this.getContentPane().repaint();
    }

    protected void tempLicenseAction() {
        if (null != this.oFileLicensePanel) {
            this.getContentPane().remove(this.oFileLicensePanel);
        }
        if (null != this.oNetLicensePanel) {
            this.getContentPane().remove(this.oNetLicensePanel);
        }
        this.getContentPane().add((Component)this.getTempLicensePanel(), new GridBagConstraints(0, 1, 1, 5, 0.0, 0.0, 10, 0, new Insets(10, 12, 0, 10), 0, 0));
        DCFrameWorkUtil.updateUI(this.oTempLicensePanel);
        this.getContentPane().repaint();
    }

    @Override
    protected String getCurrentContext() {
        return "HELP_TOPIC_APPLY_LICENSE";
    }

    @Override
    protected void oKButton_ActionPerformed() {
        AuthorizationFactory oAuthorizationFactory = null;
        AbstractAuthorization oAuthorization = null;
        if (null != this.oFileLicenseRadBtn && this.oFileLicenseRadBtn.isSelected()) {
            String filePath = this.oAuthFilePathFiled.getText();
            if (0 == filePath.length()) {
                DCOptionPane.showMessageDialog((Component)((Object)this), ResourceManager.getInstance().getResString("LICENSE_AUTH_FILE_EMPTY_MSG"), ResourceManager.getInstance().getResString("ERROR"), 0);
                this.oAuthFilePathFiled.requestFocus();
                return;
            }
            oAuthorizationFactory = new AuthorizationFactory(this.oAuthFilePathFiled.getText());
            oAuthorization = oAuthorizationFactory.creatAuthorization(0);
        } else if (null != this.oNetRadBtn && this.oNetRadBtn.isSelected()) {
            String userName = this.oAuthNetUserFiled.getText();
            if (StringUtils.isNullOrEmptyStr(userName)) {
                DCOptionPane.showMessageDialog((Component)((Object)this), ResourceManager.getInstance().getResString("LICENSE_AUTH_NET_NAME_MSG"), ResourceManager.getInstance().getResString("ERROR"), 0);
                this.oAuthNetUserFiled.requestFocus();
                return;
            }
            char[] password = this.oAuthNetPassFiled.getPassword();
            if (StringUtils.isNullOrEmptyChar(password)) {
                DCOptionPane.showMessageDialog((Component)((Object)this), ResourceManager.getInstance().getResString("LICENSE_AUTH_NET_PASS_MSG"), ResourceManager.getInstance().getResString("ERROR"), 0);
                this.oAuthNetPassFiled.requestFocus();
                return;
            }
            oAuthorizationFactory = new AuthorizationFactory(userName, password);
            oAuthorization = oAuthorizationFactory.creatAuthorization(1);
            password = null;
        } else if (null != this.oTempRadBtn && this.oTempRadBtn.isSelected()) {
            oAuthorizationFactory = new AuthorizationFactory();
            oAuthorization = oAuthorizationFactory.creatAuthorization(2);
        } else {
            DCDebugTracer.trace("LicenseApplyDlg#oKButton_ActionPerformed=>Invalid operation");
            return;
        }
        try {
            if (0 == oAuthorization.authorization()) {
                LicenseInfo licenseInfo = oAuthorization.createLicense();
                AsnDCImportLicenseReq oAsnLicenseRequest = new AsnDCImportLicenseReq();
                oAsnLicenseRequest.enLicenseMode = new AsnLicenseModeEnum(licenseInfo.getiLicenseModeType());
                oAsnLicenseRequest.strLicenseInfo = licenseInfo.getStrLicenseInfo();
                SystemManager sysMgr = new SystemManager();
                int iErrorCode = sysMgr.sendLicenseInfomation(oAsnLicenseRequest);
                if (0 != iErrorCode) {
                    if (null != DCFrameWorkUtil.getTaskTableButtonPanel()) {
                        DCFrameWorkUtil.getTaskTableButtonPanel().checkButtonsStatus();
                    }
                    DCOptionPane.showMessageDialog((Component)((Object)this), ErrorCodeReader.getInstance().getErrorDesc(BigInteger.valueOf(iErrorCode)), ResourceManager.getInstance().getResString("ERROR"), 0);
                } else {
                    LicenseMonitor.getInstance().setiCurrStatus(1);
                    if (null != DCFrameWorkUtil.getTaskTableButtonPanel()) {
                        DCFrameWorkUtil.getTaskTableButtonPanel().checkButtonsStatus();
                    }
                    DCOptionPane.showMessageDialog((Component)((Object)this), ResourceManager.getInstance().getResString("OPERTION_SUCCESS"), ResourceManager.getInstance().getResString("INFO"), 1);
                    this.oParentDlg.updateLicenseInfo();
                    this.dispose();
                }
            } else {
                DCDebugTracer.trace(oAuthorization.getLastError());
                DCOptionPane.showMessageDialog((Component)((Object)this), oAuthorization.getLastError(), ResourceManager.getInstance().getResString("ERROR"), 0);
            }
        }
        catch (IOException e) {
            DCDebugTracer.trace(e);
        }
    }
}

