/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.common.util;

import com.huawei.dc.common.framework.interfaces.IDCObjectDeallocator;
import com.huawei.dc.common.framework.utility.ConfigurationInfo;
import com.huawei.dc.common.framework.utility.DCObjectDestructor;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.regionalxml.DataSource;
import com.huawei.dc.common.regionalxml.XMLConfig;
import com.huawei.dc.common.util.DCDebugTracer;
import com.swimap.imap12.util.dateChooser.InmDateDocument;
import com.swimap.iview.util.format.TimeDateFormatUtil;
import com.swimap.iview.util.format.ValueNamePair;
import java.text.Collator;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Locale;
import java.util.TimeZone;

public class XMLDateTimeReader
implements IDCObjectDeallocator {
    private Calendar m_oCalendar = null;
    private String m_strTimeSeparatorSymbol = ":";
    private String m_strTimeFormate = "HH:mm:ss";
    private String m_srtAM = "AM";
    private String m_srtPM = "PM";
    private String m_strDateSeparateSymbol = "-";
    private String m_strDateFormat = "dd$MM$yyyy";
    private static XMLDateTimeReader m_oXmlReader = null;
    private boolean m_bIs24HourFormat = true;
    private XMLConfig m_oCurXMLConfig = null;

    public static synchronized XMLDateTimeReader getInstance() throws Exception {
        if (null == m_oXmlReader) {
            m_oXmlReader = new XMLDateTimeReader();
            DCObjectDestructor.getInstance().addObjectForDestructor(m_oXmlReader);
        }
        return m_oXmlReader;
    }

    @Override
    public void setToNULL() {
        m_oXmlReader = null;
        this.m_oCurXMLConfig = null;
    }

    private XMLDateTimeReader() throws Exception {
        this.dateSettingInit();
        this.timeSettingInit();
    }

    public String getFormatedDateTime(Calendar oCalObject) {
        int iYear = oCalObject.get(1);
        int iMonth = oCalObject.get(2) + 1;
        int iDay = oCalObject.get(5);
        int iHours = oCalObject.get(10);
        int iMinutes = oCalObject.get(12);
        int iSecond = oCalObject.get(13);
        int iAM_PM = oCalObject.get(9);
        String strYear = String.valueOf(iYear);
        String strMonth = null;
        String strDay = null;
        String strHour = null;
        String strMinute = null;
        String strSecond = null;
        strMonth = iMonth < 10 ? String.valueOf("0" + iMonth) : String.valueOf(iMonth);
        strDay = iDay < 10 ? String.valueOf("0" + iDay) : String.valueOf(iDay);
        strHour = iHours < 10 ? String.valueOf("0" + iHours) : String.valueOf(iHours);
        strMinute = iMinutes < 10 ? String.valueOf("0" + iMinutes) : String.valueOf(iMinutes);
        strSecond = iSecond < 10 ? String.valueOf("0" + iSecond) : String.valueOf(iSecond);
        StringBuffer strbufFormatedDateTime = new StringBuffer();
        Collator oCompare = Collator.getInstance();
        if (0 == oCompare.compare(this.m_strDateFormat, "dd$MM$yyyy")) {
            strbufFormatedDateTime.append(strDay);
            strbufFormatedDateTime.append(this.m_strDateSeparateSymbol);
            strbufFormatedDateTime.append(strMonth);
            strbufFormatedDateTime.append(this.m_strDateSeparateSymbol);
            strbufFormatedDateTime.append(strYear);
        } else if (0 == oCompare.compare(this.m_strDateFormat, "MM$dd$yyyy")) {
            strbufFormatedDateTime.append(strMonth);
            strbufFormatedDateTime.append(this.m_strDateSeparateSymbol);
            strbufFormatedDateTime.append(strDay);
            strbufFormatedDateTime.append(this.m_strDateSeparateSymbol);
            strbufFormatedDateTime.append(strYear);
        } else {
            strbufFormatedDateTime.append(strYear);
            strbufFormatedDateTime.append(this.m_strDateSeparateSymbol);
            strbufFormatedDateTime.append(strMonth);
            strbufFormatedDateTime.append(this.m_strDateSeparateSymbol);
            strbufFormatedDateTime.append(strDay);
        }
        strbufFormatedDateTime.append(" ");
        if (0 == oCompare.compare(this.m_strTimeFormate, "HH:mm:ss")) {
            if (0 == iAM_PM) {
                strbufFormatedDateTime.append(strHour);
            } else {
                strbufFormatedDateTime.append((Object)(iHours + 12));
            }
            strbufFormatedDateTime.append(this.m_strTimeSeparatorSymbol);
            strbufFormatedDateTime.append(strMinute);
            strbufFormatedDateTime.append(this.m_strTimeSeparatorSymbol);
            strbufFormatedDateTime.append(strSecond);
        } else {
            strbufFormatedDateTime.append(strHour);
            strbufFormatedDateTime.append(this.m_strTimeSeparatorSymbol);
            strbufFormatedDateTime.append(strMinute);
            strbufFormatedDateTime.append(this.m_strTimeSeparatorSymbol);
            strbufFormatedDateTime.append(strSecond);
            strbufFormatedDateTime.append(" ");
            if (0 == iAM_PM) {
                strbufFormatedDateTime.append(this.m_srtAM);
            } else {
                strbufFormatedDateTime.append(this.m_srtPM);
            }
        }
        boolean bDaylight = TimeZone.getDefault().inDaylightTime(oCalObject.getTime());
        if (bDaylight) {
            strbufFormatedDateTime.append(" ");
            strbufFormatedDateTime.append(ResourceManager.getInstance().getResString("DST"));
        }
        return strbufFormatedDateTime.toString();
    }

    public String getDateFormat() {
        return this.m_strDateFormat;
    }

    public String getDateSeperatorSymb() {
        return this.m_strDateSeparateSymbol;
    }

    public String getFormatedTime(Calendar calObject) {
        int iHours = calObject.get(10);
        int iMinutes = calObject.get(12);
        int iAM_PM = calObject.get(9);
        String strHour = null;
        String strMinute = null;
        strHour = iHours < 10 ? "0" + iHours : String.valueOf(iHours);
        strMinute = iMinutes < 10 ? "0" + iMinutes : String.valueOf(iMinutes);
        StringBuffer strbufFormatedDateTime = new StringBuffer();
        if (0 == Collator.getInstance().compare(this.m_strTimeFormate, "HH:mm:ss")) {
            if (0 == iAM_PM) {
                strbufFormatedDateTime.append(strHour);
            } else {
                strbufFormatedDateTime.append((Object)(iHours + 12));
            }
            strbufFormatedDateTime.append(this.m_strTimeSeparatorSymbol);
            strbufFormatedDateTime.append(strMinute);
        } else {
            if (0 == Integer.parseInt(strHour)) {
                strHour = "12";
            }
            strbufFormatedDateTime.append(strHour);
            strbufFormatedDateTime.append(this.m_strTimeSeparatorSymbol);
            strbufFormatedDateTime.append(strMinute);
            strbufFormatedDateTime.append(" ");
            if (0 == iAM_PM) {
                strbufFormatedDateTime.append(this.m_srtAM);
            } else {
                strbufFormatedDateTime.append(this.m_srtPM);
            }
        }
        return strbufFormatedDateTime.toString();
    }

    private String makeFormattedString() {
        StringBuffer strbufFormatedDateTime = new StringBuffer();
        String strDateFormate = this.m_strDateFormat.replace('$', this.m_strDateSeparateSymbol.charAt(0));
        strbufFormatedDateTime.append(strDateFormate);
        strbufFormatedDateTime.append(" ");
        String strTimeFormate = this.m_strTimeFormate;
        if (0 == Collator.getInstance().compare(this.m_strTimeFormate, "hh:mm:ss tt")) {
            strTimeFormate = this.m_strTimeFormate.replace('t', 'a');
        }
        strbufFormatedDateTime.append(strTimeFormate);
        return strbufFormatedDateTime.toString();
    }

    public String toString() {
        String strFormatedPattern = this.makeFormattedString();
        SimpleDateFormat formatter = null;
        formatter = new SimpleDateFormat(strFormatedPattern, ConfigurationInfo.getInstance().getLocale());
        formatter.setCalendar(this.m_oCalendar);
        return formatter.format(this.m_oCalendar.getTime());
    }

    public String toGMTString() {
        String strFormatedPattern = this.makeFormattedString();
        SimpleDateFormat formatter = null;
        formatter = new SimpleDateFormat(strFormatedPattern, ConfigurationInfo.getInstance().getLocale());
        formatter.setTimeZone(TimeZone.getTimeZone("GMT"));
        formatter.setCalendar(this.m_oCalendar);
        return formatter.format(this.m_oCalendar.getTime());
    }

    public byte getDateChooserFormat() {
        int byDTFormat = 3;
        Collator oCompare = Collator.getInstance();
        byDTFormat = 0 == oCompare.compare(this.m_strDateFormat, "dd$MM$yyyy") ? (0 == oCompare.compare(this.m_strTimeFormate, "HH:mm:ss") ? 8 : 9) : (0 == oCompare.compare(this.m_strDateFormat, "MM$dd$yyyy") ? (0 == oCompare.compare(this.m_strTimeFormate, "HH:mm:ss") ? 10 : 11) : (0 == oCompare.compare(this.m_strTimeFormate, "HH:mm:ss") ? 3 : 7));
        return (byte)byDTFormat;
    }

    public SimpleDateFormat getSimpleDateFormat() {
        StringBuffer strbufFormatedDateTime = new StringBuffer();
        String strTemp = this.m_strDateFormat;
        strTemp = strTemp.replace('$', this.m_strDateSeparateSymbol.charAt(0));
        strbufFormatedDateTime.append(strTemp);
        strbufFormatedDateTime.append(" ");
        if (0 == Collator.getInstance().compare(this.m_strTimeFormate, "HH:mm:ss")) {
            strbufFormatedDateTime.append("HH:mm:ss");
        } else {
            strbufFormatedDateTime.append("hh:mm:ss aa");
        }
        SimpleDateFormat dateFormater = new SimpleDateFormat(strbufFormatedDateTime.toString(), Locale.US);
        return dateFormater;
    }

    public boolean is24HourFormat() {
        return this.m_bIs24HourFormat;
    }

    public void dateSettingInit() {
        try {
            DataSource.disposeInstance();
        }
        catch (Exception e) {
            DCDebugTracer.trace(e);
        }
        this.m_oCurXMLConfig = DataSource.getInstance().getUserSettingXMLConfig();
        if (XMLConfig.isValid(this.m_oCurXMLConfig.getCurDateSeparateSymbol())) {
            TimeDateFormatUtil.setCurDateSeparatorSymbol((ValueNamePair)this.m_oCurXMLConfig.getCurDateSeparateSymbol());
            this.m_strDateSeparateSymbol = InmDateDocument.dateSeparator = this.m_oCurXMLConfig.getCurDateSeparateSymbol().toString();
        }
        if (XMLConfig.isValid(this.m_oCurXMLConfig.getCurDateShowFormat())) {
            TimeDateFormatUtil.setCurDateFormat((ValueNamePair)this.m_oCurXMLConfig.getCurDateShowFormat());
            String strDateFormat = Integer.toString(TimeDateFormatUtil.getCurDateFormat());
            Collator oCompare = Collator.getInstance();
            this.m_strDateFormat = 0 == oCompare.compare(strDateFormat, "0") ? "dd$MM$yyyy" : (0 == oCompare.compare(strDateFormat, "1") ? "MM$dd$yyyy" : "yyyy$MM$dd");
        }
        InmDateDocument.defaultType = TimeDateFormatUtil.getFormatTimeDateType();
    }

    public void timeSettingInit() {
        try {
            DataSource.disposeInstance();
        }
        catch (Exception e) {
            DCDebugTracer.trace(e);
        }
        this.m_oCurXMLConfig = DataSource.getInstance().getUserSettingXMLConfig();
        TimeDateFormatUtil.setCurTimeSeparatorSymbol((ValueNamePair)TimeDateFormatUtil.DEFAULT_TIME_SEPARATOR_SYMBOL);
        InmDateDocument.timeSeparator = TimeDateFormatUtil.DEFAULT_TIME_SEPARATOR_SYMBOL.toString();
        if (XMLConfig.isValid(this.m_oCurXMLConfig.getCurTimeFormat())) {
            TimeDateFormatUtil.setCurTimeFormat((ValueNamePair)this.m_oCurXMLConfig.getCurTimeFormat());
            String strTimeFormat = Integer.toString(TimeDateFormatUtil.getCurTimeFormat());
            Collator oCompare = Collator.getInstance();
            if (0 == oCompare.compare(strTimeFormat, "0")) {
                this.m_strTimeFormate = "HH:mm:ss";
                this.m_bIs24HourFormat = true;
            } else if (0 == oCompare.compare(strTimeFormat, "1")) {
                this.m_strTimeFormate = "hh:mm:ss tt";
                this.m_bIs24HourFormat = false;
            }
        }
        if (XMLConfig.isValid(this.m_oCurXMLConfig.getCurTimeAmFormat())) {
            TimeDateFormatUtil.setCurAmFormatSymbol((ValueNamePair)this.m_oCurXMLConfig.getCurTimeAmFormat());
            this.m_srtAM = ResourceManager.getInstance().getResString("AM_TIME_STRING");
        }
        if (XMLConfig.isValid(this.m_oCurXMLConfig.getCurTimePmFormat())) {
            TimeDateFormatUtil.setCurPmFormatSymbol((ValueNamePair)this.m_oCurXMLConfig.getCurTimePmFormat());
            this.m_srtPM = ResourceManager.getInstance().getResString("PM_TIME_STRING");
        }
        InmDateDocument.time_AM_PM_symbols = TimeDateFormatUtil.getTime_AM_PM_Symbols();
        InmDateDocument.defaultType = TimeDateFormatUtil.getFormatTimeDateType();
        InmDateDocument.isAM_PMEnable = TimeDateFormatUtil.isAM_PMEnable();
    }
}

