/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.common.util;

import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.util.FieldBorder;
import com.huawei.dc.common.util.StatusBarManager;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JButton;
import javax.swing.JPanel;

public class WindowStyleButton
extends JButton {
    private static final long serialVersionUID = -7578116976879686908L;

    public WindowStyleButton() {
        this.setBorder(null);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                WindowStyleButton.this.doActionOnMouseClick();
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                WindowStyleButton.this.doActionOnMouseEntered();
            }

            @Override
            public void mouseExited(MouseEvent e) {
                WindowStyleButton.this.doActionOnMouseExited();
            }

            @Override
            public void mousePressed(MouseEvent e) {
                WindowStyleButton.this.doActionOnMousePressed();
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                WindowStyleButton.this.doActionOnMouseReleased();
            }
        });
    }

    private void doActionOnMouseClick() {
        if (this.isEnabled()) {
            FieldBorder fieldBorder = new FieldBorder();
            fieldBorder.setLowered(true);
            this.setBorder(fieldBorder);
        }
    }

    private void doActionOnMousePressed() {
        if (this.isEnabled()) {
            FieldBorder fieldBorder = new FieldBorder();
            fieldBorder.setLowered(true);
            this.setBorder(fieldBorder);
        }
    }

    private void doActionOnMouseReleased() {
        this.setBorder(null);
    }

    private void doActionOnMouseEntered() {
        if (this.isEnabled()) {
            FieldBorder fieldBorder = new FieldBorder();
            fieldBorder.setLowered(false);
            this.setBorder(fieldBorder);
            if (null == DCFrameWorkUtil.getStatusBarManager()) {
                StatusBarManager m_statusBarManager = new StatusBarManager(new JPanel());
                m_statusBarManager.setIPAddress(DCFrameWorkUtil.getServerIP());
                DCFrameWorkUtil.setStatusBarManager(m_statusBarManager);
            }
            DCFrameWorkUtil.getStatusBarManager().setComment(this.getName());
        }
    }

    private void doActionOnMouseExited() {
        this.setBorder(null);
        if (null == DCFrameWorkUtil.getStatusBarManager()) {
            StatusBarManager m_statusBarManager = new StatusBarManager(new JPanel());
            m_statusBarManager.setIPAddress(DCFrameWorkUtil.getServerIP());
            DCFrameWorkUtil.setStatusBarManager(m_statusBarManager);
        }
        DCFrameWorkUtil.getStatusBarManager().setComment("  ");
    }
}

