/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.common.util;

import java.awt.Toolkit;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DocumentFilter;

public class TextFieldFilter
extends DocumentFilter {
    private int iLimitCharactersLength;

    public TextFieldFilter(int iLimitChars) {
        this.iLimitCharactersLength = iLimitChars;
    }

    @Override
    public void replace(DocumentFilter.FilterBypass fb, int offs, int length, String str, AttributeSet a) throws BadLocationException {
        int LENGTH = fb.getDocument().getLength() + str.length() - length;
        if (LENGTH <= this.iLimitCharactersLength) {
            super.replace(fb, offs, length, str, a);
        } else {
            Toolkit.getDefaultToolkit().beep();
        }
    }

    @Override
    public void insertString(DocumentFilter.FilterBypass fb, int offsSize, String str, AttributeSet a) throws BadLocationException {
        int LENGTH = fb.getDocument().getLength() + str.length();
        if (LENGTH <= this.iLimitCharactersLength) {
            super.insertString(fb, offsSize, str, a);
        } else {
            Toolkit.getDefaultToolkit().beep();
        }
    }

    public void setMaxSize(int iMaxChars) {
        this.iLimitCharactersLength = iMaxChars;
    }
}

