/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.common.util;

import com.huawei.dc.common.framework.utility.ConfigurationInfo;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.framework.utility.print.PrintSupportor;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.DCOptionPane;
import com.huawei.dc.common.util.DCSaveFileChooser;
import com.huawei.dc.common.util.FileUtil;
import com.huawei.dc.common.util.LocalDiskDriveDetails;
import com.huawei.dc.common.util.StringUtils;
import java.awt.Component;
import java.io.File;

public class TempletExportUtil {
    private boolean m_isWinSys = StringUtils.isWinSystem();
    private static final String CSV_TYPE = ".csv";
    private static final String XLS_TYPE = ".xls";
    private static final long MIN_MEMORY = 30000L;
    private String strTempletName = null;
    private String strCopyFileName = null;
    private String strTitle = null;
    private static final String TEMPLATE_PATH = "template/dc/";

    public TempletExportUtil(String copyFileName, String oDefaultTempletName, String oTitle) {
        this.strCopyFileName = copyFileName;
        this.strTempletName = oDefaultTempletName;
        this.strTitle = oTitle;
    }

    public void exportTemple() {
        DCSaveFileChooser oFileChooserDialog = this.initExportDialog();
        if (null == oFileChooserDialog) {
            DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), ResourceManager.getInstance().getResString("FILE_EXPORT_FAILED"), ResourceManager.getInstance().getResString("INFO"), 1);
            return;
        }
        int iRetVal = -1;
        iRetVal = oFileChooserDialog.showSaveDialog(DCFrameWorkUtil.getMainFrame());
        if (iRetVal != 0) {
            DCDebugTracer.trace("ExportCheckItemTemp/exportTemple:Get export dialog error!");
            return;
        }
        String strEndName = CSV_TYPE;
        if (this.m_isWinSys) {
            strEndName = XLS_TYPE;
        }
        String strDocName = oFileChooserDialog.getSelectedFile().getParent();
        String strFileName = oFileChooserDialog.getSelectedFile().getName();
        if (!oFileChooserDialog.getSelectedFile().getName().endsWith(strEndName)) {
            strFileName = strFileName + strEndName;
        }
        if (strDocName.length() < 1) {
            DCDebugTracer.trace("exportTemple/exportTemple:Get document name to short!");
            return;
        }
        boolean isDirExist = this.checkDocExist(strDocName);
        if (!isDirExist) {
            DCDebugTracer.trace("exportTemple/exportTemple:Check document exist error!");
            return;
        }
        boolean isCapDir = this.checkTargetDirectory(strDocName);
        if (!isCapDir) {
            DCDebugTracer.trace("DC:exportTemple/exportTemple:Check document capability error!");
            return;
        }
        boolean copyFile = FileUtil.copyFile(TempletExportUtil.getTemplatePath(), strDocName, this.strCopyFileName + strEndName, strFileName);
        if (copyFile) {
            DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), ResourceManager.getInstance().getResString("FILE_EXPORT_SUCCESSFULLY"), ResourceManager.getInstance().getResString("INFO"), 1);
        } else {
            DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), ResourceManager.getInstance().getResString("FILE_EXPORT_FAILED"), ResourceManager.getInstance().getResString("INFO"), 1);
        }
    }

    public static String getTemplatePath() {
        return FileUtil.getDefaultFilePath() + TEMPLATE_PATH + ConfigurationInfo.getInstance().getLocale();
    }

    private boolean checkDocExist(String strDocName) {
        boolean bMakeDir;
        File fileDoc = new File(strDocName);
        if (!fileDoc.exists() && !(bMakeDir = fileDoc.mkdir())) {
            DCDebugTracer.trace("exportTemple/checkDocExist:Error when make new document:" + strDocName);
            return false;
        }
        return true;
    }

    private DCSaveFileChooser initExportDialog() {
        PrintSupportor.setIsFileSelection(false);
        String strPath = ConfigurationInfo.getInstance().getAbsoluteBaseDirectory() + File.separator + "report/";
        boolean isDocExist = this.checkDocExist(strPath);
        if (!isDocExist) {
            return null;
        }
        DCSaveFileChooser oFileChooserDialog = new DCSaveFileChooser(strPath, false);
        oFileChooserDialog.setTitle(ResourceManager.getInstance().getResString(this.strTitle));
        if (this.m_isWinSys) {
            oFileChooserDialog.setFileFilter(8);
        } else {
            oFileChooserDialog.setFileFilter(2);
        }
        oFileChooserDialog.setAcceptAllFileFilterUsed(false);
        oFileChooserDialog.setDefaultFileName(this.strTempletName);
        return oFileChooserDialog;
    }

    public boolean checkTargetDirectory(String strPosition) {
        LocalDiskDriveDetails oDiskDriveDetails;
        long lFreeMemoryAvail;
        if (this.m_isWinSys && (lFreeMemoryAvail = (oDiskDriveDetails = LocalDiskDriveDetails.getInstance()).getFreeMemoryAvail(strPosition)) < 30000L) {
            DCDebugTracer.trace("exportTemple/checkTargetDirectory:The target directory:" + strPosition + " is not enough for export!");
            DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), ResourceManager.getInstance().getResString("ERROR_MESSAGE_EXPORT_TEMPLET_MEMERY_LACK"), ResourceManager.getInstance().getResString("INFO"), 1);
            return false;
        }
        return true;
    }
}

