/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.common.util;

import com.huawei.dc.common.asndatacenter.AsnTaskResource;
import com.huawei.dc.common.asndatacenter.AsnTaskResourceLst;
import com.huawei.dc.common.controller.IDeviceInfoManager;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.DCOptionPane;
import com.huawei.dc.common.util.DeviceInfoUtil;
import com.huawei.dc.deviceinfo.DeviceInfo;
import com.huawei.dc.deviceinfo.DeviceTypeInfo;
import com.huawei.dc.devicemanagement.deviceoperation.IOperationConfigPara;
import com.huawei.dc.devicemanagement.deviceoperation.ITaskDeviceOperation;
import com.huawei.dc.devicemanagement.deviceoperation.LoadFileInfo;
import com.huawei.dc.devicemanagement.deviceoperation.LoadFileInfoListParam;
import com.huawei.dc.devicemanagement.deviceoperation.activation.ActivationOperation;
import com.huawei.dc.devicemanagement.deviceoperation.loadpatch.LoadPatchOperation;
import com.huawei.dc.devicemanagement.deviceoperation.loadsoftware.LoadSoftwareOperation;
import com.huawei.dc.devicemanagement.deviceoperation.upgradeoperation.IUpgradeSubOperation;
import com.huawei.dc.devicemanagement.deviceoperation.upgradeoperation.PrepareUpgradeOperation;
import com.huawei.dc.devicemanagement.deviceoperation.upgradeoperation.StartupConfigParam;
import com.huawei.dc.devicemanagement.deviceoperation.upgradeoperation.UpgradeSubOperation;
import com.huawei.dc.devicemanagement.model.ContentType;
import com.huawei.dc.devicemanagement.model.DeviceType;
import com.huawei.dc.devicemanagement.model.GUITempleteInfo;
import com.huawei.dc.devicemanagement.model.xmlconfig.DeviceXMLConfigModel;
import com.huawei.dc.devicemanagement.model.xmlconfig.IDeviceTypeConfigModel;
import com.huawei.dc.sam.controller.TargetVersionPathGetter;
import com.huawei.dc.taskmgmt.isolation.model.IsolationTaskInfoObj;
import com.huawei.dc.taskmgmt.model.ActiveBoardInfo;
import com.huawei.dc.taskmgmt.model.ActiveDevInfo;
import com.huawei.dc.taskmgmt.model.ActiveGroupInfo;
import com.huawei.dc.taskmgmt.model.ActiveInfo;
import com.huawei.dc.taskmgmt.model.ITask;
import com.huawei.dc.taskmgmt.model.Resource;
import com.huawei.dc.taskmgmt.model.ResourceProgressInfo;
import com.huawei.dc.taskmgmt.model.TaskDataModel;
import com.huawei.dc.taskmgmt.model.TaskProgressInfo;
import com.swimap.iview.util.DebugTracer;
import gnu.trove.THashSet;
import java.awt.Component;
import java.text.Collator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class TaskInfoUtil {
    public static boolean isDownGradeTask(int iTaskTypeID) {
        boolean bDownGradeTask = false;
        if (iTaskTypeID == 1 || iTaskTypeID == 10 || iTaskTypeID == 11 || iTaskTypeID == 12 || iTaskTypeID == 13) {
            bDownGradeTask = true;
        }
        return bDownGradeTask;
    }

    public static boolean isContainsPTNDevices(ITask oTask) {
        boolean bContansPTNDevice = false;
        if (null == oTask) {
            return bContansPTNDevice;
        }
        int iDevTypeID = -1;
        List<DeviceTypeInfo> oDevTypeLst = oTask.getDeviceTypeLst();
        for (DeviceTypeInfo oDevTypeInfo : oDevTypeLst) {
            if (null == oDevTypeInfo || !DeviceInfoUtil.isPTNDevice(iDevTypeID = oDevTypeInfo.getDevTypeID())) continue;
            return true;
        }
        return bContansPTNDevice;
    }

    public static boolean isContainsBMSDevices(ITask oTask) {
        boolean bContansBMSDevice = false;
        if (null == oTask) {
            return bContansBMSDevice;
        }
        List<DeviceTypeInfo> oDevTypeLst = oTask.getDeviceTypeLst();
        for (DeviceTypeInfo oDevTypeInfo : oDevTypeLst) {
            if (null == oDevTypeInfo || !oDevTypeInfo.isBMSDomain()) continue;
            return true;
        }
        return bContansBMSDevice;
    }

    public static boolean isRollbackEnable(ITask oTask) {
        boolean bRollbackEnable = false;
        if (null == oTask) {
            return bRollbackEnable;
        }
        int iTaskTypeID = oTask.getTaskTypeId();
        if (iTaskTypeID != 0 && iTaskTypeID != 1 && iTaskTypeID != 10) {
            return bRollbackEnable;
        }
        TaskProgressInfo oTaskProgress = oTask.getTaskProgressInfo();
        if (null == oTaskProgress) {
            return bRollbackEnable;
        }
        int iTaskStatus = oTaskProgress.getState();
        int iTaskResult = oTaskProgress.getResult();
        if (iTaskStatus != 3 || iTaskResult != 0) {
            return bRollbackEnable;
        }
        boolean bSelectLoadSw = false;
        boolean bSelectActivate = false;
        List<ITaskDeviceOperation> oOperLst = oTask.getSupportedOperation();
        ITaskDeviceOperation oTaskOperation = null;
        int iOperID = -1;
        for (int i = 0; i < oOperLst.size(); ++i) {
            oTaskOperation = oOperLst.get(i);
            if (null == oTaskOperation) continue;
            iOperID = oTaskOperation.getOperationId();
            if (!bSelectLoadSw && iOperID == 6) {
                bSelectLoadSw = true;
            } else if (!bSelectActivate && iOperID == 8) {
                bSelectActivate = true;
            }
            if (!bSelectLoadSw || !bSelectActivate) continue;
            return true;
        }
        return bRollbackEnable;
    }

    public static boolean isFileSelectedForContentType(ITask oTask, String strContentType) {
        LoadSoftwareOperation oLoadSoftwareOperation;
        boolean bRetVal = false;
        ITaskDeviceOperation oTaskOp = TaskInfoUtil.getTaskOperation(oTask, 6);
        if (oTaskOp instanceof LoadSoftwareOperation && null != (oLoadSoftwareOperation = (LoadSoftwareOperation)oTaskOp) && null != oLoadSoftwareOperation.getConfiguredPara() && oLoadSoftwareOperation.isSelected()) {
            LoadFileInfoListParam oLoadParam = (LoadFileInfoListParam)oLoadSoftwareOperation.getConfiguredPara();
            bRetVal = TaskInfoUtil.isFileExistForFileType(oLoadParam, strContentType);
        }
        return bRetVal;
    }

    public static ITaskDeviceOperation getTaskOperation(ITask oTask, int iOperationID) {
        if (null == oTask || null == oTask.getSupportedOperation() || 0 == oTask.getSupportedOperation().size()) {
            return null;
        }
        List<ITaskDeviceOperation> oSupportedOpLst = oTask.getSupportedOperation();
        int iSize = oSupportedOpLst.size();
        for (int i = 0; i < iSize; ++i) {
            ITaskDeviceOperation oTaskOp = oSupportedOpLst.get(i);
            if (iOperationID != oTaskOp.getOperationId()) continue;
            return oTaskOp;
        }
        return null;
    }

    public static boolean isFileExistForStartupConfig(StartupConfigParam oStartupConfigParam, String strContentType) {
        boolean bRetVal = false;
        if (null == oStartupConfigParam) {
            return bRetVal;
        }
        HashMap<Integer, List<LoadFileInfo>> oFileInfoMap = oStartupConfigParam.getDeviceLoadFileInfoMap();
        if (null == oFileInfoMap) {
            return bRetVal;
        }
        List<LoadFileInfo> oFileList = null;
        LoadFileInfo oLoadFileInfo = null;
        Iterator<Map.Entry<Integer, List<LoadFileInfo>>> oFileInfoItr = oFileInfoMap.entrySet().iterator();
        Map.Entry<Integer, List<LoadFileInfo>> oFileInfoEntry = null;
        while (oFileInfoItr.hasNext()) {
            oFileInfoEntry = oFileInfoItr.next();
            oFileList = oFileInfoEntry.getValue();
            if (null == oFileList) continue;
            int iSize = oFileList.size();
            for (int i = 0; i < iSize; ++i) {
                oLoadFileInfo = oFileList.get(i);
                if (!Collator.getInstance().equals(strContentType, oLoadFileInfo.getContentType().getId())) continue;
                bRetVal = true;
                return bRetVal;
            }
        }
        return bRetVal;
    }

    public static boolean isOperationSelected(ITask oTask, int iOperationID) {
        boolean bRetVal = false;
        ITaskDeviceOperation oTaskOp = TaskInfoUtil.getTaskOperation(oTask, iOperationID);
        if (null != oTaskOp && oTaskOp.isSelected()) {
            bRetVal = true;
        }
        return bRetVal;
    }

    public static boolean isFileSelectedForLoad(ITask oTask) {
        LoadSoftwareOperation oLoadSoftwareOperation;
        boolean bRetVal = false;
        ITaskDeviceOperation oTaskOp = TaskInfoUtil.getTaskOperation(oTask, 6);
        if (oTaskOp instanceof LoadSoftwareOperation && null != (oLoadSoftwareOperation = (LoadSoftwareOperation)oTaskOp) && null != oLoadSoftwareOperation.getConfiguredPara() && oLoadSoftwareOperation.isSelected()) {
            LoadFileInfoListParam oLoadParam = (LoadFileInfoListParam)oLoadSoftwareOperation.getConfiguredPara();
            bRetVal = oLoadParam.getNumberOfFiles() != 0;
        }
        return bRetVal;
    }

    public static void createTemporaryDevTypeByActiGroup(ITask oTask) {
        DeviceType devType = oTask.getTemporaryDevType();
        THashSet oResHs = new THashSet();
        ActiveInfo activeInfo = oTask.getActivationInfo();
        if (null == activeInfo || null == activeInfo.getGroupList()) {
            return;
        }
        Vector<ActiveGroupInfo> groupList = activeInfo.getGroupList();
        int groupCount = groupList.size();
        for (int i = 0; i < groupCount; ++i) {
            ActiveGroupInfo groupInfo = groupList.get(i);
            Vector devList = groupInfo.getActivationInfoLst();
            int deviceCount = devList.size();
            for (int j = 0; j < deviceCount; ++j) {
                ActiveDevInfo devInfo = (ActiveDevInfo)devList.get(j);
                Vector boardList = devInfo.getBoardList();
                int boardCount = boardList.size();
                for (int l = 0; l < boardCount; ++l) {
                    ActiveBoardInfo boardInfo = (ActiveBoardInfo)boardList.get(l);
                    Resource resource = new Resource();
                    resource.setDeviceID(devInfo.getDevId());
                    IDeviceInfoManager devInfoManager = DCFrameWorkUtil.getDeviceInfoManager();
                    DeviceInfo deviceInfo = devInfoManager.getDevice(devInfo.getDevId());
                    resource.setDeviceIP(deviceInfo.getDevIPAddress());
                    resource.setDeviceName(devInfo.getDevName());
                    resource.setDeviceVersion(deviceInfo.getDevVersion().getDevVersion());
                    resource.setFrameId(0);
                    resource.setSlotId(boardInfo.getSlotId());
                    oResHs.add((Object)resource);
                }
            }
        }
        devType.setResources((THashSet<Resource>)oResHs);
        oTask.setTemporaryDevType(devType);
    }

    public static boolean isResouceInTask(ITask oTaskObj, Resource res) {
        boolean bResourcInTask = false;
        if (null == res) {
            return false;
        }
        THashSet<Resource> oResList = oTaskObj.getDeviceType().getResources();
        Iterator oResItor = oResList.iterator();
        Resource oResoruce = null;
        while (oResItor.hasNext()) {
            oResoruce = (Resource)oResItor.next();
            if (null == oResoruce || oResoruce.getDeviceID() != res.getDeviceID()) continue;
            return true;
        }
        return bResourcInTask;
    }

    public static boolean isOtherResourceInProgress(ITask oTask, int iDevID, String sOprName) {
        boolean bContains = false;
        if (null == oTask) {
            return bContains;
        }
        THashSet<Resource> resList = oTask.getDeviceType().getResources();
        Iterator oResItor = resList.iterator();
        Resource oRes = null;
        while (oResItor.hasNext()) {
            ResourceProgressInfo oProgress;
            oRes = (Resource)oResItor.next();
            if (null == oRes || oRes.getDeviceID() == iDevID || !oRes.getProgressInfo().getCurrentOperationId().equals(sOprName) || null != (oProgress = oRes.getProgressInfo()) && oProgress.getState() == 4) continue;
            bContains = true;
            break;
        }
        return bContains;
    }

    public static boolean isContainsManualResourceInTask(ITask oTask) {
        boolean bContainsManualResource = false;
        if (oTask.getTaskTypeId() != 3) {
            return bContainsManualResource;
        }
        ActiveInfo oActiveInfo = oTask.getActivationInfo();
        if (null == oActiveInfo) {
            return bContainsManualResource;
        }
        Vector<ActiveGroupInfo> oAcGroup = oActiveInfo.getGroupList();
        if (null == oAcGroup) {
            return bContainsManualResource;
        }
        for (ActiveGroupInfo oGroupInfo : oAcGroup) {
            if (null == oGroupInfo || oGroupInfo.getGroupId() != Short.MAX_VALUE || oGroupInfo.getActivationInfoLst().size() <= 0) continue;
            bContainsManualResource = true;
            break;
        }
        return bContainsManualResource;
    }

    public static boolean isResourceParseInActivationStep(ITask oTask, AsnTaskResourceLst oAsnTaskResourceLst) {
        boolean isResParseInActivateStep = false;
        for (int i = 0; i < oAsnTaskResourceLst.size() && !(isResParseInActivateStep = TaskInfoUtil.isResourceParseInActivationStep(oTask, (AsnTaskResource)oAsnTaskResourceLst.get(i))); ++i) {
        }
        return isResParseInActivateStep;
    }

    public static boolean isResourceParseInActivationStep(ITask oTask, AsnTaskResource oResource) {
        boolean bManualReboot = false;
        if (null == oTask) {
            return bManualReboot;
        }
        DeviceType oDevType = oTask.getDeviceType();
        if (null == oDevType) {
            return bManualReboot;
        }
        THashSet<Resource> oResLst = oDevType.getResources();
        if (null == oResLst || oResLst.size() == 0) {
            return bManualReboot;
        }
        ResourceProgressInfo oResProgress = null;
        Iterator oResItor = oResLst.iterator();
        Resource oRes = null;
        while (oResItor.hasNext()) {
            oRes = (Resource)oResItor.next();
            if (null == oRes || null != oResource && oRes.getDeviceID() != oResource.iDeviceId.intValue() || null == (oResProgress = oRes.getProgressInfo()) || !Collator.getInstance().equals(oResProgress.getCurrentOperationId(), "ActivateSoftware") || oResProgress.getState() != 4 || oResProgress.getResult() != 2) continue;
            bManualReboot = true;
            break;
        }
        return bManualReboot;
    }

    public static ITaskDeviceOperation getNextSelectedOpration(ITask oTask, int iCurrentOpeID) {
        if (null == oTask || null == oTask.getSupportedOperation() || 0 == oTask.getSupportedOperation().size()) {
            return null;
        }
        boolean foundCurrentID = false;
        List<ITaskDeviceOperation> oSupportedOpLst = oTask.getSupportedOperation();
        int iSize = oSupportedOpLst.size();
        for (int i = 0; i < iSize; ++i) {
            ITaskDeviceOperation oTaskOp = oSupportedOpLst.get(i);
            if (iCurrentOpeID == oTaskOp.getOperationId()) {
                foundCurrentID = true;
                continue;
            }
            if (!foundCurrentID || !oTaskOp.isSelected()) continue;
            return oTaskOp;
        }
        return null;
    }

    public static boolean isContainsClusterNE(ITask oTask) {
        if (null == oTask) {
            DCDebugTracer.trace("isContainsClusterNE task is null");
            return false;
        }
        if (null == oTask.getDeviceType()) {
            DCDebugTracer.trace("isContainsClusterNE oTask.getDeviceType() is null");
            return false;
        }
        if (oTask.getDeviceType().getDeviceDomain() != 2) {
            DCDebugTracer.trace("isContainsClusterNE oTask getDeviceDomain() != DMS");
            return false;
        }
        THashSet<Resource> oResLst = oTask.getDeviceType().getResources();
        boolean bContainsClusterDev = DeviceInfoUtil.isContainsClusterDevice(oResLst);
        return bContainsClusterDev;
    }

    public static int[] getTaskDeviceIdLst(ITask oTask, DeviceTypeInfo oDevTypeInfo) {
        if (null == oTask) {
            DCDebugTracer.trace("getTaskDeviceIdLst task is null");
            return null;
        }
        if (null == oTask.getDeviceType()) {
            DCDebugTracer.trace("getTaskDeviceIdLst oTask.getDeviceType() is null");
            return null;
        }
        THashSet<Resource> oResLst = oTask.getDeviceType().getResources();
        Iterator oResItor = oResLst.iterator();
        Resource oResource = null;
        int[] iDeviceIdLst = new int[1];
        DeviceTypeInfo oDevTypeInfoFromDevid = null;
        DeviceInfo oDeviceInfo = null;
        while (oResItor.hasNext()) {
            oResource = (Resource)oResItor.next();
            int iDevId = oResource.getDeviceID();
            oDeviceInfo = DCFrameWorkUtil.getDeviceInfoManager().getDevice(iDevId);
            oDevTypeInfoFromDevid = oDeviceInfo.getDeviceTypeInfo();
            if (null == oDevTypeInfo || !oDevTypeInfo.equals(oDevTypeInfoFromDevid)) continue;
            iDeviceIdLst[0] = iDevId;
            break;
        }
        return iDeviceIdLst;
    }

    public static boolean isContainsStackNE(ITask oTask) {
        if (null == oTask) {
            DCDebugTracer.trace("isContainsStackNE task is null");
            return false;
        }
        if (null == oTask.getDeviceType()) {
            DCDebugTracer.trace("isContainsStackNE oTask.getDeviceType() is null");
            return false;
        }
        if (oTask.getDeviceType().getDeviceDomain() != 2) {
            DCDebugTracer.trace("isContainsStackNE oTask getDeviceDomain() != DMS");
            return false;
        }
        THashSet<Resource> oResLst = oTask.getDeviceType().getResources();
        return DeviceInfoUtil.isStackDevicePresent(oResLst, 3);
    }

    public static boolean isManualSelectCCFile(PrepareUpgradeOperation oPreUpgradeOpr) {
        boolean isSelCC = false;
        List<IUpgradeSubOperation> oSubOprLst = oPreUpgradeOpr.getUpgradeSubOperationList();
        if (null == oSubOprLst) {
            return isSelCC;
        }
        IUpgradeSubOperation oSubOpr = null;
        for (int i = 0; i < oSubOprLst.size(); ++i) {
            oSubOpr = oSubOprLst.get(i);
            if (!"StartupConfig".equals(oSubOpr.getOperationIdString())) continue;
            StartupConfigParam oConfigPara = (StartupConfigParam)oSubOpr.getUpgradeSubOperationConfig();
            if (null == oConfigPara) break;
            if (oConfigPara.getStartupType() != 2 && oConfigPara.getStartupType() != 3) continue;
            HashMap<Integer, List<LoadFileInfo>> oFileMap = oConfigPara.getDeviceLoadFileInfoMap();
            Iterator<Map.Entry<Integer, List<LoadFileInfo>>> oItor = oFileMap.entrySet().iterator();
            List<LoadFileInfo> oFileLst = null;
            block1: while (oItor.hasNext()) {
                oFileLst = oItor.next().getValue();
                if (null == oFileLst) continue;
                for (int j = 0; j < oFileLst.size(); ++j) {
                    if (null == oFileLst.get(j) || !oFileLst.get(j).getFileName().endsWith("cc") && !oFileLst.get(j).getFileName().endsWith("CC")) continue;
                    isSelCC = true;
                    continue block1;
                }
            }
            break;
        }
        return isSelCC;
    }

    public static boolean isCommitForNextOperation(List<IsolationTaskInfoObj> oIsolationTaskInfoLst) {
        if (null != oIsolationTaskInfoLst && 0 < oIsolationTaskInfoLst.size()) {
            for (IsolationTaskInfoObj oDevNodeInfo : oIsolationTaskInfoLst) {
                ITask oTask = TaskDataModel.getInstance().getTask(oDevNodeInfo.getTaskId());
                if (null == oTask) continue;
                List<ITaskDeviceOperation> oOprList = oTask.getSupportedOperation();
                int iOprCount = oOprList.size();
                ITaskDeviceOperation oObj = null;
                int index = 0;
                for (index = 0; !(index >= iOprCount || (oObj = oOprList.get(index)).isSelected() && oObj.getOperationName().equals(oDevNodeInfo.getCurrentOperation())); ++index) {
                }
                if (++index >= iOprCount || !(oObj = oOprList.get(index)).isSelected() || !"Commit".equals(oObj.getOperationIdString())) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isActivateForRollbackOperation(List<IsolationTaskInfoObj> oIsolationTaskInfoLst) {
        if (null != oIsolationTaskInfoLst && 0 < oIsolationTaskInfoLst.size()) {
            for (IsolationTaskInfoObj oDevNodeInfo : oIsolationTaskInfoLst) {
                ITask oTask = TaskDataModel.getInstance().getTask(oDevNodeInfo.getTaskId());
                if (null == oTask) continue;
                List<ITaskDeviceOperation> oOprList = oTask.getSupportedOperation();
                int iOprCount = oOprList.size();
                ArrayList<String> oOprListIdString = new ArrayList<String>();
                ArrayList<String> oOprListName = new ArrayList<String>();
                ITaskDeviceOperation oObj = null;
                int index = 0;
                for (index = 0; index < iOprCount; ++index) {
                    oObj = oOprList.get(index);
                    oOprListIdString.add(index, oObj.getOperationIdString());
                    oOprListName.add(index, oObj.getOperationName());
                }
                int curOperationIndex = oOprListName.indexOf(oDevNodeInfo.getCurrentOperation());
                int activeOperationIndex = oOprListIdString.indexOf("ActivateSoftware");
                if (activeOperationIndex > curOperationIndex) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isActivateForNextOperation(List<IsolationTaskInfoObj> oIsolationTaskInfoLst) {
        if (null != oIsolationTaskInfoLst && 0 < oIsolationTaskInfoLst.size()) {
            for (IsolationTaskInfoObj oDevNodeInfo : oIsolationTaskInfoLst) {
                ITask oTask = TaskDataModel.getInstance().getTask(oDevNodeInfo.getTaskId());
                if (null == oTask) continue;
                List<ITaskDeviceOperation> oOprList = oTask.getSupportedOperation();
                int iOprCount = oOprList.size();
                ITaskDeviceOperation oObj = null;
                int index = 0;
                for (index = 0; !(index >= iOprCount || (oObj = oOprList.get(index)).isSelected() && oObj.getOperationName().equals(oDevNodeInfo.getCurrentOperation())); ++index) {
                }
                if (++index >= iOprCount || !(oObj = oOprList.get(index)).isSelected() || !"ActivateSoftware".equals(oObj.getOperationIdString())) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean checkIsAllDevInSameOperAndStaus(ITask oTask, String operStr, int iStatus) {
        if (null == oTask || null == oTask.getDeviceType()) {
            return false;
        }
        THashSet<Resource> resList = oTask.getDeviceType().getResources();
        if (resList.size() <= 0) {
            return false;
        }
        for (Resource resource : resList) {
            ResourceProgressInfo progressInfo = resource.getProgressInfo();
            if (null == progressInfo) {
                DCDebugTracer.trace("TaskInfoUtil#checkIsAllDevSameOperAndStaus:ResourceProgressInfo is null#" + resource.getDeviceID());
                return false;
            }
            if (!operStr.equals(progressInfo.getCurrentOperationId())) {
                DCDebugTracer.trace("TaskInfoUtil#checkIsAllDevSameOperAndStaus:progressInfo is no match#" + resource.getDeviceID());
                return false;
            }
            if (iStatus == progressInfo.getResult()) continue;
            DCDebugTracer.trace("TaskInfoUtil#checkIsAllDevSameOperAndStaus:getResult is no match#" + resource.getDeviceID());
            return false;
        }
        return true;
    }

    public static boolean isDevOperAndStausInTask(ITask oTask, String operStr, int iStatus) {
        if (null == oTask || null == oTask.getDeviceType()) {
            return false;
        }
        THashSet<Resource> resList = oTask.getDeviceType().getResources();
        if (resList.size() <= 0) {
            return false;
        }
        for (Resource resource : resList) {
            ResourceProgressInfo progressInfo = resource.getProgressInfo();
            if (null == progressInfo) {
                DCDebugTracer.trace("TaskInfoUtil#checkIsDevOperAndStausInTask:ResourceProgressInfo is null#" + resource.getDeviceID());
                continue;
            }
            if (!operStr.equals(progressInfo.getCurrentOperationId()) || iStatus != progressInfo.getResult()) continue;
            return true;
        }
        return false;
    }

    public static ResourceProgressInfo getResourceProgress(ITask oTask, int iDevID, String strOprId) {
        if (null == oTask) {
            return null;
        }
        DeviceType oDevType = oTask.getDeviceType();
        if (null == oDevType) {
            return null;
        }
        ResourceProgressInfo oResProgress = null;
        THashSet<Resource> oResLst = oDevType.getResources();
        for (Resource oRes : oResLst) {
            if (oRes.getDeviceID() != iDevID) continue;
            oResProgress = oRes.getOprResultInfo(strOprId);
            break;
        }
        return oResProgress;
    }

    public static boolean isOperationStarted(ITask oTask, String sOperationID) {
        boolean isOperationStarted = false;
        if (oTask.getTaskProgressInfo().getState() == 0) {
            return isOperationStarted;
        }
        THashSet<Resource> oRess = oTask.getDeviceType().getResources();
        for (Resource oRes : oRess) {
            ResourceProgressInfo oOperResult;
            if (null == oRes || null == (oOperResult = oRes.getOprResultInfo(sOperationID)) || oOperResult.getState() == 0) continue;
            isOperationStarted = true;
            break;
        }
        return isOperationStarted;
    }

    public static boolean isDiffTaskAndDevLevel(int iTaskTypeID, int taskUpgradeLevel) {
        boolean isDevLevelDiffTask = false;
        if (iTaskTypeID == 5 && 1 == taskUpgradeLevel) {
            isDevLevelDiffTask = true;
        }
        return isDevLevelDiffTask;
    }

    private static boolean isFileExistForFileType(LoadFileInfoListParam oLoadParam, String strContentTypeId) {
        boolean bExist = false;
        if (null == oLoadParam) {
            return bExist;
        }
        int iSize = oLoadParam.getNumberOfFiles();
        for (int i = 0; i < iSize; ++i) {
            LoadFileInfo oLoadFile = oLoadParam.getLoadFileInfo(i);
            ContentType contentType = oLoadFile.getContentType();
            if (null == contentType || null == contentType.getId() || !contentType.getId().equals(strContentTypeId)) continue;
            bExist = true;
            break;
        }
        return bExist;
    }

    public static boolean isTargerVerEqualSelectFile(ITask iTask) {
        DeviceTypeInfo oDeviceTypeInfo;
        String strSelectPath;
        String strTargetFilePath;
        block8: {
            LoadFileInfoListParam oLoadFileInfoListParam;
            block7: {
                if (null == iTask) {
                    return true;
                }
                strTargetFilePath = TargetVersionPathGetter.getTargetVersionDir(iTask.getDeviceType(), iTask.getTargetVersion(), iTask);
                DebugTracer.trace((String)("TaskInfoUtil#isTargerVerEqualSelectFile#strTargetFilePath:" + strTargetFilePath));
                strSelectPath = null;
                oLoadFileInfoListParam = iTask.getLoadFileInfoListParam();
                if (null == oLoadFileInfoListParam) break block7;
                List<LoadFileInfo> oLoadFileInfoLst = oLoadFileInfoListParam.getLoadFileInfoList();
                if (null == oLoadFileInfoLst || oLoadFileInfoLst.size() != 1) break block8;
                strSelectPath = oLoadFileInfoLst.get(0).getFileName();
                break block8;
            }
            List<ITaskDeviceOperation> oTaskOperLst = iTask.getSupportedOperation();
            ITaskDeviceOperation oTaskOperObj = null;
            for (int i = 0; i < oTaskOperLst.size(); ++i) {
                List<LoadFileInfo> oLoadFileInfoLst;
                if (null == oTaskOperLst.get(i)) continue;
                oTaskOperObj = oTaskOperLst.get(i);
                if (oTaskOperObj instanceof LoadSoftwareOperation) {
                    oLoadFileInfoListParam = (LoadFileInfoListParam)oTaskOperObj.getConfiguredPara();
                } else if (oTaskOperObj instanceof LoadPatchOperation) {
                    oLoadFileInfoListParam = (LoadFileInfoListParam)oTaskOperObj.getConfiguredPara();
                }
                if (null == oLoadFileInfoListParam || null == (oLoadFileInfoLst = oLoadFileInfoListParam.getLoadFileInfoList()) || oLoadFileInfoLst.size() < 1) continue;
                strSelectPath = oLoadFileInfoLst.get(0).getFileName();
                break;
            }
        }
        if (null == strSelectPath) {
            return false;
        }
        DebugTracer.trace((String)("TaskInfoUtil#isTargerVerEqualSelectFile#strSelectPath:" + strSelectPath));
        if (null != strSelectPath && null != strTargetFilePath && strSelectPath.equals(strTargetFilePath)) {
            return true;
        }
        List<DeviceTypeInfo> oDeviceTypeInfoLst = iTask.getDeviceTypeLst();
        return null != oDeviceTypeInfoLst && oDeviceTypeInfoLst.size() > 0 && null != (oDeviceTypeInfo = oDeviceTypeInfoLst.get(0)) && oDeviceTypeInfo.getDevDomain() != 4;
    }

    public static IDeviceTypeConfigModel getDevTypeConfigByTask(ITask taskObj) {
        if (null == taskObj) {
            return null;
        }
        DeviceType oDeviceType = taskObj.getSelectedDeviceType();
        if (null == oDeviceType) {
            return null;
        }
        IDeviceTypeConfigModel oDevTypeConfigModel = DeviceXMLConfigModel.getInstance().getDeviceTypeConfigModel(oDeviceType);
        return oDevTypeConfigModel;
    }

    public static int getInnerTaskTypeIDByTaskObj(ITask taskObj) {
        if (null == taskObj) {
            return -1;
        }
        DeviceType oDeviceType = taskObj.getSelectedDeviceType();
        if (null == oDeviceType) {
            return -1;
        }
        IDeviceTypeConfigModel oDevTypeConfigModel = DeviceXMLConfigModel.getInstance().getDeviceTypeConfigModel(oDeviceType);
        if (null == oDevTypeConfigModel) {
            return -1;
        }
        GUITempleteInfo guiInfo = oDevTypeConfigModel.getGuiTempleteInfo();
        if (null == guiInfo) {
            return taskObj.getTaskTypeId();
        }
        return guiInfo.getInnerTaskTypeId();
    }

    public static boolean bContainV8Dev(ITask oTaskDataObj) {
        boolean bV8Device = false;
        DeviceType oDeviceType = oTaskDataObj.getDeviceType();
        THashSet<Resource> oResHash = oDeviceType.getResources();
        for (Resource oRes : oResHash) {
            if (null == oRes || !oRes.getDeviceVersion().startsWith("V800") || !DeviceInfoUtil.isDomainDevice(oRes.getDeviceID(), 2)) continue;
            bV8Device = true;
            break;
        }
        return bV8Device;
    }

    public static void enableLoadSoftwareOpr(ITask m_oTask, boolean bValue) {
        ITaskDeviceOperation oTaskLoadSoftware = TaskInfoUtil.getTaskOperation(m_oTask, 6);
        if (oTaskLoadSoftware instanceof LoadSoftwareOperation) {
            LoadSoftwareOperation oTaskLoadSoftWare = (LoadSoftwareOperation)oTaskLoadSoftware;
            if (!bValue) {
                oTaskLoadSoftWare.setSelected(bValue);
            }
            oTaskLoadSoftWare.setEnabled(bValue);
        }
    }

    public static void checkLoadSoftwareWithPrepareUpgrade(ITaskDeviceOperation oTaskPreUpgrade, ITask m_oTask) {
        PrepareUpgradeOperation oPreOper = (PrepareUpgradeOperation)oTaskPreUpgrade;
        List<IUpgradeSubOperation> oIUpgradeSubOperationLst = oPreOper.getUpgradeSubOperationList();
        for (int i = 0; i < oIUpgradeSubOperationLst.size(); ++i) {
            StartupConfigParam oStartupConfigParam;
            UpgradeSubOperation oUpgradeSubOperation = (UpgradeSubOperation)oIUpgradeSubOperationLst.get(i);
            IOperationConfigPara oIOperationConfigPara = oUpgradeSubOperation.getUpgradeSubOperationConfig();
            if (oIOperationConfigPara instanceof StartupConfigParam && oPreOper.isSelected() && oUpgradeSubOperation.isSelected() && (oStartupConfigParam = (StartupConfigParam)oIOperationConfigPara).getStartupType() == 3) {
                TaskInfoUtil.enableLoadSoftwareOpr(m_oTask, false);
                return;
            }
            TaskInfoUtil.enableLoadSoftwareOpr(m_oTask, true);
        }
    }

    public static void checkLoadSoftwareWithStartupConfig(IUpgradeSubOperation oUpSubOperation, ITask m_oTask) {
        ITaskDeviceOperation oTaskPreUpgrade = TaskInfoUtil.getTaskOperation(m_oTask, 32);
        if (oTaskPreUpgrade instanceof PrepareUpgradeOperation) {
            StartupConfigParam oStartupConfigParam;
            UpgradeSubOperation oUpgradeSubOperation;
            IOperationConfigPara oIOperationConfigPara;
            PrepareUpgradeOperation oPreOper = (PrepareUpgradeOperation)oTaskPreUpgrade;
            if (oUpSubOperation instanceof UpgradeSubOperation && oPreOper.isSelected() && (oIOperationConfigPara = (oUpgradeSubOperation = (UpgradeSubOperation)oUpSubOperation).getUpgradeSubOperationConfig()) instanceof StartupConfigParam && oUpgradeSubOperation.isSelected() && (oStartupConfigParam = (StartupConfigParam)oIOperationConfigPara).getStartupType() == 3) {
                TaskInfoUtil.enableLoadSoftwareOpr(m_oTask, false);
                return;
            }
            TaskInfoUtil.enableLoadSoftwareOpr(m_oTask, true);
        }
    }

    public static boolean checkGTLLicenseWithISSU(IUpgradeSubOperation oUpgradeSubOpr, ITask m_oTask) {
        ITaskDeviceOperation oTaskPreUpgrade;
        if (oUpgradeSubOpr.getOperationIdString().equals("ActiveGTL") && (oTaskPreUpgrade = TaskInfoUtil.getTaskOperation(m_oTask, 32)) instanceof PrepareUpgradeOperation) {
            PrepareUpgradeOperation oPreOper = (PrepareUpgradeOperation)oTaskPreUpgrade;
            List<IUpgradeSubOperation> oIUpgradeSubOperationLst = oPreOper.getUpgradeSubOperationList();
            for (int i = 0; i < oIUpgradeSubOperationLst.size(); ++i) {
                StartupConfigParam oStartupConfigParam;
                UpgradeSubOperation oUpgradeSubOperation = (UpgradeSubOperation)oIUpgradeSubOperationLst.get(i);
                IOperationConfigPara oIOperationConfigPara = oUpgradeSubOperation.getUpgradeSubOperationConfig();
                if (!(oIOperationConfigPara instanceof StartupConfigParam) || !oPreOper.isSelected() || !oUpgradeSubOperation.isSelected() || (oStartupConfigParam = (StartupConfigParam)oIOperationConfigPara).getStartupType() != 3) continue;
                DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), DCFrameWorkUtil.getLocalizedString("GTL_LICENSE_NO_SUPPORT"));
                return false;
            }
        }
        return true;
    }

    public static void updateLoadSoftware(ITaskDeviceOperation oTaskPreUpgrade, ITask m_oTaskDataObj) {
        if (oTaskPreUpgrade instanceof PrepareUpgradeOperation) {
            PrepareUpgradeOperation oPreOper = (PrepareUpgradeOperation)oTaskPreUpgrade;
            if (!oPreOper.isSelected()) {
                TaskInfoUtil.enableLoadSoftwareOpr(m_oTaskDataObj, true);
            } else {
                TaskInfoUtil.checkLoadSoftwareWithPrepareUpgrade(oTaskPreUpgrade, m_oTaskDataObj);
            }
        }
    }

    public static void checkloadSoftwareWithStartupConfig(ITask m_oTask) {
        ITaskDeviceOperation oTaskPreUpgrade = TaskInfoUtil.getTaskOperation(m_oTask, 32);
        if (oTaskPreUpgrade instanceof PrepareUpgradeOperation && oTaskPreUpgrade.isSelected()) {
            TaskInfoUtil.enableLoadSoftwareOpr(m_oTask, false);
        }
    }

    public static void updatePreUpgradeWithLoadSoftWare(ITaskDeviceOperation oTaskDevOP, ITask m_oTask) {
        if (oTaskDevOP instanceof LoadSoftwareOperation) {
            ActivationOperation oActivationOpr = TaskInfoUtil.getActivationOperation(m_oTask);
            if (null != oActivationOpr.getActivateConfigPara() && oActivationOpr.getActivateConfigPara().isSelISSU()) {
                oActivationOpr.getM_oActivationPanel().detectedPreUpgrade();
            }
        } else if (oTaskDevOP instanceof PrepareUpgradeOperation) {
            TaskInfoUtil.updateLoadSoftware(oTaskDevOP, m_oTask);
        }
    }

    private static ActivationOperation getActivationOperation(ITask m_oTask) {
        ITaskDeviceOperation oTaskActivate = TaskInfoUtil.getTaskOperation(m_oTask, 8);
        if (oTaskActivate instanceof ActivationOperation) {
            ActivationOperation m_oTaskDevOPeration;
            ActivationOperation oActivationOpr = m_oTaskDevOPeration = (ActivationOperation)oTaskActivate;
            return oActivationOpr;
        }
        return null;
    }
}

