/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.common.util;

import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JTable;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;

public class TableColumnFitAdapter
extends MouseAdapter {
    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getClickCount() != 2) {
            return;
        }
        JTableHeader tableHeader = (JTableHeader)e.getSource();
        TableColumn tableCol = this.getResizingColumn(tableHeader, e.getPoint());
        if (null == tableCol) {
            return;
        }
        JTable table = tableHeader.getTable();
        int width = this.getPreferenceWidth(tableHeader, tableCol, table);
        tableHeader.setResizingColumn(tableCol);
        tableCol.setWidth(width + table.getIntercellSpacing().width);
        tableHeader.updateUI();
        table.updateUI();
        DCFrameWorkUtil.setCursor(tableHeader, Cursor.getDefaultCursor());
    }

    private int getPreferenceWidth(JTableHeader tableHeader, TableColumn tableCol, JTable table) {
        int col = tableHeader.getColumnModel().getColumnIndex(tableCol.getIdentifier());
        int rowCount = table.getRowCount();
        int width = (int)tableHeader.getDefaultRenderer().getTableCellRendererComponent(table, tableCol.getIdentifier(), false, false, -1, col).getPreferredSize().getWidth();
        for (int row = 0; row < rowCount; ++row) {
            int preferedWidth = (int)table.getCellRenderer(row, col).getTableCellRendererComponent(table, table.getValueAt(row, col), false, false, row, col).getPreferredSize().getWidth();
            width = Math.max(width, preferedWidth);
        }
        return width;
    }

    private TableColumn getResizingColumn(JTableHeader header, Point p) {
        return this.getResizingColumn(header, p, header.columnAtPoint(p));
    }

    private TableColumn getResizingColumn(JTableHeader jTableHeader, Point p, int column) {
        if (-1 == column) {
            return null;
        }
        Rectangle r = jTableHeader.getHeaderRect(column);
        r.grow(-3, 0);
        if (r.contains(p)) {
            return null;
        }
        int columnIndex = this.getColIndex(jTableHeader, p, column, r);
        if (-1 == columnIndex) {
            return null;
        }
        return jTableHeader.getColumnModel().getColumn(columnIndex);
    }

    private int getColIndex(JTableHeader jTableHeader, Point p, int column, Rectangle r) {
        int midPoint = (r.x + r.width) / 2;
        int columnIndex = jTableHeader.getComponentOrientation().isLeftToRight() ? (p.x < midPoint ? column - 1 : column) : (p.x < midPoint ? column : column - 1);
        return columnIndex;
    }
}

