/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.common.util;

import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.DCTimeDateUtil;
import com.huawei.dc.devicemanagement.model.deviceinfo.VisualData;
import com.swimap.iview.commstyle.resource.ResourceMng;
import java.text.Collator;
import java.text.Normalizer;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;

public final class StringUtils {
    private static final String ALL_COLORS_REG = "color=\"[A-Za-z0-9]{6}\"";
    private static final String WHITE_COLOR = "color=\"FFFFFF\"";
    private static boolean isWinSys = StringUtils.isWinSystem();
    public static final String TIME_FORMAT_1 = "yyyyMMddHHmmss";
    public static final String TIME_FORMAT_2 = "dd/MM/yyyy HH:mm:ss";
    public static final String TIME_FORMAT_3 = "yyyy_MM_dd-HH_mm_ss";
    private static final int ONE_MINUTE_SECOND = 60;
    private static final int ONE_HOUR_SECONE = 3600;
    private static final int ONE_DAY_HOUR = 24;

    private StringUtils() {
    }

    public static boolean isNullOrEmptyStr(String info) {
        boolean isNullOrEmpty = false;
        if (null == info || info.length() == 0 || 0 == info.trim().length()) {
            isNullOrEmpty = true;
        }
        return isNullOrEmpty;
    }

    public static boolean isNullOrEmptyChar(char[] info) {
        boolean isNullOrEmpty = false;
        if (null == info || info.length == 0) {
            isNullOrEmpty = true;
        }
        return isNullOrEmpty;
    }

    public static String convertTimeToString(Calendar oCalendar) {
        if (oCalendar != null) {
            return DCTimeDateUtil.getLocaleDisplayTime(oCalendar);
        }
        return "";
    }

    public static String getStrNowTime(String format) {
        if (StringUtils.isNullOrEmptyStr(format)) {
            return "";
        }
        SimpleDateFormat oTimeStampFormat = new SimpleDateFormat(format);
        Date oTimeStampFolder = new Date();
        return oTimeStampFormat.format(oTimeStampFolder);
    }

    public static String getClietNowTime() {
        Calendar oCalendar = Calendar.getInstance();
        DCTimeDateUtil.switchToLocalCalendar(oCalendar);
        return DCTimeDateUtil.getLocaleDisplayTime(oCalendar);
    }

    public static boolean isWinSystem() {
        return isWinSys;
    }

    private static String getNormalizeString(String source) {
        if (StringUtils.isNullOrEmptyStr(source)) {
            return source;
        }
        return Normalizer.normalize(source, Normalizer.Form.NFC);
    }

    public static int compareStr(String source, String target) {
        int result = -1;
        String strSource = StringUtils.getNormalizeString(source);
        String strTarget = StringUtils.getNormalizeString(target);
        result = StringUtils.isNullOrEmptyStr(strSource) ? (StringUtils.isNullOrEmptyStr(strTarget) ? 0 : -1) : (StringUtils.isNullOrEmptyStr(strTarget) ? 1 : Collator.getInstance().compare(strSource, strTarget));
        return result;
    }

    public static String subDateStr(Calendar calStartTime, Calendar calEndTime) {
        long second;
        long minute;
        long hour;
        if (null == calStartTime || null == calEndTime) {
            return "";
        }
        StringBuilder strBuild = new StringBuilder();
        long between = (calEndTime.getTimeInMillis() - calStartTime.getTimeInMillis()) / 1000L;
        long day = between / 86400L;
        if (0L != day) {
            strBuild.append(day);
            strBuild.append(ResourceManager.getInstance().getResString("DAY_KEY"));
        }
        if (0L != (hour = between / 3600L % 3600L)) {
            strBuild.append(hour);
            strBuild.append(ResourceManager.getInstance().getResString("HOUR_KEY"));
        }
        if (0L != (minute = between / 60L % 60L)) {
            strBuild.append(minute);
            strBuild.append(ResourceManager.getInstance().getResString("MINUTE_KEY"));
        }
        if (0L != (second = between % 60L)) {
            strBuild.append(second);
            strBuild.append(ResourceManager.getInstance().getResString("SECOND_KEY"));
        }
        return strBuild.toString();
    }

    public static String getNumberFormatStr(Object obj) {
        Locale oLocal = ResourceMng.getInstance().getLocale();
        NumberFormat oNumberFormat = NumberFormat.getNumberInstance(oLocal);
        int iFormatStr = 0;
        try {
            iFormatStr = Integer.parseInt(obj.toString());
        }
        catch (NumberFormatException e) {
            return obj.toString();
        }
        return oNumberFormat.format(iFormatStr);
    }

    public static boolean isIPV4(String strIp) {
        if (StringUtils.isNullOrEmptyStr(strIp)) {
            return false;
        }
        String[] segments = strIp.split("[.]");
        int SEGMENT_LEN = 4;
        if (4 != segments.length) {
            return false;
        }
        boolean isIPV4 = true;
        boolean begin = false;
        int end = 255;
        try {
            int iSegment = -1;
            for (String segment : segments) {
                iSegment = Integer.valueOf(segment);
                if (0 <= iSegment && iSegment <= 255) continue;
                isIPV4 = false;
                break;
            }
        }
        catch (NumberFormatException e) {
            isIPV4 = false;
        }
        return isIPV4;
    }

    public static boolean isContainsWhitespace(String str) {
        if (StringUtils.isNullOrEmptyStr(str)) {
            return true;
        }
        for (int i = 0; i < str.length(); ++i) {
            if (!Character.isWhitespace(str.charAt(i))) continue;
            return true;
        }
        return false;
    }

    public static boolean isContainsSpecialChar(String str) {
        if (StringUtils.isNullOrEmptyStr(str)) {
            return false;
        }
        for (int i = 0; i < str.length(); ++i) {
            if ("`~!@#$%^&*()+=|\"';?>.<,".indexOf(str.charAt(i)) == -1) continue;
            return true;
        }
        return false;
    }

    public static String removeRepeatPostfix(String sourceStr, String postfixStr) {
        if (StringUtils.isNullOrEmptyStr(sourceStr)) {
            return sourceStr;
        }
        if (StringUtils.isNullOrEmptyStr(postfixStr)) {
            return sourceStr.trim();
        }
        if (!sourceStr.endsWith(postfixStr)) {
            return sourceStr;
        }
        String tempStr = sourceStr;
        int index = tempStr.lastIndexOf(postfixStr);
        int iRepeatCnt = 0;
        while (index != -1) {
            ++iRepeatCnt;
            tempStr = tempStr.substring(0, index);
            index = tempStr.lastIndexOf(postfixStr);
        }
        tempStr = sourceStr;
        int removeCnt = iRepeatCnt;
        index = tempStr.lastIndexOf(postfixStr);
        while (removeCnt > 1 && index != -1) {
            --removeCnt;
            tempStr = tempStr.substring(0, index);
            index = tempStr.lastIndexOf(postfixStr);
        }
        return tempStr;
    }

    public static String removePostfix(String sourceStr, String postfixStr) {
        if (StringUtils.isNullOrEmptyStr(sourceStr)) {
            return sourceStr;
        }
        if (StringUtils.isNullOrEmptyStr(postfixStr)) {
            return sourceStr.trim();
        }
        if (!sourceStr.endsWith(postfixStr)) {
            return sourceStr;
        }
        String tempStr = sourceStr;
        int index = tempStr.lastIndexOf(postfixStr);
        while (index != -1) {
            tempStr = tempStr.substring(0, index);
            index = tempStr.lastIndexOf(postfixStr);
        }
        return tempStr;
    }

    public static String removePrefix(String sourceStr, String prefixStr) {
        if (StringUtils.isNullOrEmptyStr(sourceStr)) {
            return sourceStr;
        }
        if (StringUtils.isNullOrEmptyStr(prefixStr)) {
            return sourceStr.trim();
        }
        if (!sourceStr.startsWith(prefixStr)) {
            return sourceStr;
        }
        String tempStr = sourceStr;
        int index = tempStr.indexOf(prefixStr);
        while (index != -1) {
            tempStr = tempStr.substring(index + prefixStr.length());
            index = tempStr.indexOf(prefixStr);
        }
        return tempStr;
    }

    public static String getHtmlString(String sourceStr) {
        StringBuffer oStringBuf = new StringBuffer();
        oStringBuf.append("<HTML>");
        oStringBuf.append(sourceStr);
        oStringBuf.append("</HTML>");
        return oStringBuf.toString();
    }

    public static VisualData getShowIP(String ip) {
        String[] ipSegs = ip.split("\\.");
        int value = 0;
        try {
            int bit_in_byte = 8;
            int byte_in_int = 4;
            for (int i = 0; i < ipSegs.length; ++i) {
                int seg = Integer.parseInt(ipSegs[i]);
                int byteIndex = i + 1;
                int shift = (4 - byteIndex) * 8;
                value |= seg << shift;
            }
        }
        catch (Exception e) {
            return new VisualData(ip, ip);
        }
        return new VisualData(value, ip);
    }

    public static String convertColorsToWhite(String str) {
        if (StringUtils.isNullOrEmptyStr(str)) {
            return "";
        }
        return str.replaceAll(ALL_COLORS_REG, WHITE_COLOR);
    }

    public static byte[] convertCharsToBytes(char[] chs) {
        return String.valueOf(chs).getBytes();
    }

    public static void clearCharCipher(char[] charCipher) {
        for (int i = 0; i < charCipher.length; ++i) {
            charCipher[i] = 42;
        }
    }

    static {
        String osName = System.getProperty("os.name");
        boolean isWin = false;
        if (!StringUtils.isNullOrEmptyStr(osName)) {
            if (osName.charAt(0) == 'W' || osName.charAt(0) == 'w') {
                isWin = true;
            } else {
                isWin = false;
                DCDebugTracer.trace("osName : " + osName);
            }
        }
        isWinSys = isWin;
    }
}

