/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.common.util;

import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.util.Enumeration;
import javax.swing.JPanel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;

public class ResizeMouseMotionListener
extends MouseAdapter
implements MouseMotionListener {
    JPanel m_currentPan;
    JTableHeader m_tableHeader;
    private boolean m_bMousePressed = false;
    private boolean m_bOnDivider = false;

    public ResizeMouseMotionListener(JPanel currPan, JTableHeader header) {
        this.m_currentPan = currPan;
        this.m_tableHeader = header;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (this.m_bOnDivider) {
            this.m_bMousePressed = true;
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.m_bMousePressed = false;
        Cursor oDefaultCursor = Cursor.getPredefinedCursor(0);
        if (DCFrameWorkUtil.getMainFrame().getCursor() != oDefaultCursor || this.m_currentPan.getCursor() != oDefaultCursor) {
            DCFrameWorkUtil.setCursor(oDefaultCursor);
            Dimension oDimension = new Dimension(this.m_currentPan.getSize());
            this.m_currentPan.setSize(oDimension.width + 1, oDimension.height + 1);
            DCFrameWorkUtil.setCursor(this.m_currentPan, new Cursor(0));
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.m_bMousePressed) {
            Cursor oResizeCursor = Cursor.getPredefinedCursor(11);
            if (DCFrameWorkUtil.getMainFrame().getCursor() != oResizeCursor || this.m_currentPan.getCursor() != oResizeCursor) {
                DCFrameWorkUtil.setCursor(oResizeCursor);
                Dimension oDimension = new Dimension(this.m_currentPan.getSize());
                this.m_currentPan.setSize(oDimension.width + 1, oDimension.height + 1);
                DCFrameWorkUtil.setCursor(this.m_currentPan, new Cursor(11));
            }
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        if (this.getResizingColumn(e.getPoint()) != -1) {
            Cursor oResizeCursor = Cursor.getPredefinedCursor(11);
            if (DCFrameWorkUtil.getMainFrame().getCursor() != oResizeCursor || this.m_currentPan.getCursor() != oResizeCursor) {
                DCFrameWorkUtil.setCursor(oResizeCursor);
                Dimension oDimension = new Dimension(this.m_currentPan.getSize());
                this.m_currentPan.setSize(oDimension.width + 1, oDimension.height + 1);
                DCFrameWorkUtil.setCursor(this.m_currentPan, new Cursor(11));
            }
            this.m_bOnDivider = true;
        } else {
            Cursor oDefaultCursor = Cursor.getPredefinedCursor(0);
            if (DCFrameWorkUtil.getMainFrame().getCursor() != oDefaultCursor || this.m_currentPan.getCursor() != oDefaultCursor) {
                DCFrameWorkUtil.setCursor(oDefaultCursor);
                Dimension oDimension = new Dimension(this.m_currentPan.getSize());
                this.m_currentPan.setSize(oDimension.width + 1, oDimension.height + 1);
                DCFrameWorkUtil.setCursor(this.m_currentPan, new Cursor(0));
            }
            this.m_bOnDivider = false;
        }
    }

    @Override
    public void mouseExited(MouseEvent e) {
        DCFrameWorkUtil.setCursor(Cursor.getPredefinedCursor(0));
        Dimension oDimension = new Dimension(this.m_currentPan.getSize());
        this.m_currentPan.setSize(oDimension.width + 1, oDimension.height + 1);
        DCFrameWorkUtil.setCursor(this.m_currentPan, new Cursor(0));
    }

    private int getResizingColumn(Point p) {
        int column = 0;
        Rectangle headerRect = this.m_tableHeader.getBounds();
        Rectangle resizeRect = new Rectangle(-3, 0, 6, this.m_tableHeader.getSize().height);
        Enumeration<TableColumn> enumeration = this.m_tableHeader.getColumnModel().getColumns();
        while (enumeration.hasMoreElements()) {
            TableColumn aColumn = enumeration.nextElement();
            resizeRect.x += aColumn.getWidth();
            if (p.x > headerRect.x + headerRect.width - 5) break;
            if (resizeRect.contains(p)) {
                return column;
            }
            ++column;
        }
        return -1;
    }
}

