/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.common.util;

import com.huawei.dc.common.util.DCDebugTracer;
import java.awt.Toolkit;
import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;

public class NumberTextField
extends JTextField {
    private static final long serialVersionUID = -668423389533324628L;
    private int type = 0;
    private int fractionNum = 0;
    private int maxLength = 20;
    private boolean bBeep = false;
    private Number min = null;
    private Number max = null;
    public static final int INTEGER_TYPE = 0;
    public static final int LONG_TYPE = 1;
    public static final int FLOAT_TYPE = 2;

    public NumberTextField() {
        this(0, Integer.MAX_VALUE, 20);
    }

    public NumberTextField(int iMaxLength) {
        this(0, Integer.MAX_VALUE, iMaxLength);
    }

    public NumberTextField(int iMin, int iMax) {
        this(iMin, iMax, 20);
    }

    public NumberTextField(int iMin, int iMax, int iMaxLength) {
        this.min = iMin;
        this.max = iMax;
        this.maxLength = iMaxLength;
        this.type = 0;
        this.setDocument(new NumberDocument(this.type));
    }

    public NumberTextField(long lMin, long lMax, int iMaxLength) {
        this.min = lMin;
        this.max = lMax;
        this.maxLength = iMaxLength;
        this.type = 1;
        this.setDocument(new NumberDocument(this.type));
    }

    public NumberTextField(float fMin, float fMax) {
        this(fMin, fMax, 20, 3);
    }

    public NumberTextField(float fMin, float fMax, int iMaxLength) {
        this(fMin, fMax, iMaxLength, 3);
    }

    public NumberTextField(float fMin, float fMax, int iMaxLength, int iFraction) {
        this.min = new Float(fMin);
        this.max = new Float(fMax);
        this.maxLength = iMaxLength;
        this.type = 2;
        this.fractionNum = iFraction;
        if (this.fractionNum < 0 || this.fractionNum > 5) {
            this.fractionNum = 5;
        }
        this.setDocument(new NumberDocument(this.type));
    }

    private String getNonzeroNumber(String s) {
        String tmp = s;
        if (s.charAt(0) == '0') {
            if (s.length() > 1) {
                tmp = s.substring(s.indexOf(48) + 1, s.length());
                this.getNonzeroNumber(tmp);
            } else {
                return "0";
            }
        }
        return tmp;
    }

    public synchronized void setMaxLength(int length) {
        this.maxLength = length;
    }

    public synchronized void setRespondBeep(boolean b) {
        this.bBeep = b;
    }

    public String getValueText() {
        String text = super.getText().trim();
        if (text != null && !text.equals("")) {
            if (this.type == 0) {
                return Integer.valueOf(Integer.parseInt(text)).toString();
            }
            if (this.type == 1) {
                return Long.valueOf(Long.parseLong(text)).toString();
            }
            if (this.type == 2) {
                return new Float(Float.parseFloat(text)).toString();
            }
        }
        return text;
    }

    public int getIntValue() {
        String text = super.getText().trim();
        if (text == null || text.equals("")) {
            return Integer.MIN_VALUE;
        }
        return Integer.parseInt(text);
    }

    public long getLongValue() {
        String text = super.getText().trim();
        if (text == null || text.equals("")) {
            return Long.MIN_VALUE;
        }
        return Long.parseLong(text);
    }

    public float getFloatValue() {
        String text = super.getText().trim();
        if (text == null || text.equals("")) {
            return Float.MIN_VALUE;
        }
        return Float.parseFloat(text);
    }

    @Override
    public String getSelectedText() {
        int p1;
        String txt = null;
        Caret caret = this.getCaret();
        int p0 = Math.min(caret.getDot(), caret.getMark());
        if (p0 != (p1 = Math.max(caret.getDot(), caret.getMark()))) {
            try {
                Document doc = this.getDocument();
                txt = doc.getText(p0, p1 - p0);
            }
            catch (BadLocationException e) {
                throw new IllegalArgumentException(e.getMessage());
            }
        }
        return txt;
    }

    private class NumberDocument
    extends PlainDocument {
        private static final long serialVersionUID = -1632960064501347661L;

        public NumberDocument(int iType) {
            NumberTextField.this.type = iType;
        }

        @Override
        public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
            try {
                switch (NumberTextField.this.type) {
                    case 0: {
                        Integer.parseInt(str);
                        break;
                    }
                    case 1: {
                        Long.parseLong(str);
                        break;
                    }
                    case 2: {
                        Float.parseFloat(str);
                        break;
                    }
                    default: {
                        throw new Exception("unknown number type!!!");
                    }
                }
            }
            catch (Exception ex) {
                if (NumberTextField.this.bBeep) {
                    Toolkit.getDefaultToolkit().beep();
                }
                return;
            }
            String sOld = this.getText(0, this.getLength());
            String beforeOffset = sOld.substring(0, offs);
            String afterOffset = sOld.substring(offs, sOld.length());
            String sNew = beforeOffset + str + afterOffset;
            if (sNew.length() > NumberTextField.this.maxLength) {
                if (NumberTextField.this.bBeep) {
                    Toolkit.getDefaultToolkit().beep();
                }
                return;
            }
            if (sNew.length() > 1) {
                sNew = NumberTextField.this.getNonzeroNumber(sNew);
            }
            try {
                float fValue;
                long lValue;
                int iValue;
                if (NumberTextField.this.type == 0 && ((iValue = Integer.parseInt(sNew)) < NumberTextField.this.min.intValue() || iValue > NumberTextField.this.max.intValue())) {
                    throw new Exception("invalid number!!!");
                }
                if (NumberTextField.this.type == 1 && ((lValue = Long.parseLong(sNew)) < NumberTextField.this.min.longValue() || lValue > NumberTextField.this.max.longValue())) {
                    throw new Exception("invalid number!!!");
                }
                if (NumberTextField.this.type == 2 && ((fValue = Float.parseFloat(sNew)) < NumberTextField.this.min.floatValue() || fValue > NumberTextField.this.max.floatValue())) {
                    throw new Exception("invalid number!!!");
                }
            }
            catch (Exception ex) {
                if (NumberTextField.this.bBeep) {
                    Toolkit.getDefaultToolkit().beep();
                }
                return;
            }
            super.insertString(offs, str, a);
        }

        @Override
        public void remove(int offs, int len) throws BadLocationException {
            super.remove(offs, len);
        }

        @Override
        public void replace(int offset, int length, String text, AttributeSet attrs) throws BadLocationException {
            try {
                Integer.parseInt(text);
            }
            catch (Exception e) {
                DCDebugTracer.trace(e);
                return;
            }
            super.replace(offset, length, text, attrs);
        }
    }
}

