/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.common.util;

import com.huawei.dc.common.DCConstants;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.swimap.iview.commstyle.commini.Menu;
import com.swimap.iview.commstyle.commini.MenuItem;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Map;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;

public class MenuUtil {
    public static JMenuItem getMenuItemForID(Map<Object, Object> oMenuIDMap, String strMenuItemID) {
        Object oValue = null;
        if (null != oMenuIDMap && null != strMenuItemID) {
            oValue = oMenuIDMap.get(strMenuItemID);
        }
        if (oValue instanceof JMenuItem) {
            return (JMenuItem)oValue;
        }
        return null;
    }

    public static void enableAllMenuItems(Map<Object, Object> oMenuIDMap, boolean bFlag) {
        for (String string : oMenuIDMap.keySet()) {
            JMenuItem oMenuItem = MenuUtil.getMenuItemForID(oMenuIDMap, string);
            if (null == oMenuItem) continue;
            oMenuItem.setEnabled(bFlag);
        }
    }

    public static JSeparator getSeparator(JPopupMenu oMenu, int iSeperatorIndex) {
        if (null == oMenu || 0 > iSeperatorIndex) {
            return null;
        }
        int iCompCount = oMenu.getComponentCount();
        int iCurrentIndex = 0;
        Component oComponent = null;
        for (int i = 0; i < iCompCount; ++i) {
            oComponent = oMenu.getComponent(i);
            if (!(oComponent instanceof JSeparator) || iSeperatorIndex != ++iCurrentIndex) continue;
            return (JSeparator)oComponent;
        }
        return null;
    }

    public static void enableAllSeparators(JPopupMenu oMenu, boolean bFlag) {
        JSeparator oSeparator = null;
        int iIndex = 1;
        do {
            if (null == (oSeparator = MenuUtil.getSeparator(oMenu, iIndex++))) continue;
            oSeparator.setEnabled(bFlag);
            oSeparator.setVisible(bFlag);
        } while (null != oSeparator);
    }

    public static void enableMenuItem(Component oComponent, boolean bEnable) {
        MenuUtil.enableMenuItem(oComponent, bEnable, -1);
    }

    public static void enableMenuItem(Component oComponent, boolean bEnable, int iCmdCode) {
        JMenuItem oMenuItem;
        String sMenuID;
        if (null == oComponent) {
            return;
        }
        boolean bPrivilege = true;
        if (!DCFrameWorkUtil.getIsSingleClient() && -1 != iCmdCode) {
            bPrivilege = DCFrameWorkUtil.hasUserOperationPrivilege(iCmdCode);
        }
        if (-1 != iCmdCode && bEnable) {
            bEnable = bEnable && bPrivilege;
        }
        oComponent.setEnabled(bEnable);
        if (bEnable) {
            oComponent.setVisible(bEnable);
        } else if (oComponent instanceof JMenuItem && (sMenuID = (oMenuItem = (JMenuItem)oComponent).getText()).equals(DCConstants.ROLLBACK_SOFTWARE_MENU)) {
            oComponent.setVisible(bEnable);
        }
    }

    public static void enableMenuItem(Component oComponet, int iCmdCode) {
        MenuUtil.enableMenuItem(oComponet, true, iCmdCode);
    }

    public static void visibleMenuItem(Component oComponent, boolean bVisible) {
        if (null == oComponent) {
            return;
        }
        oComponent.setVisible(bVisible);
    }

    public static void enableMenuItem(Menu oMenu, String sMenuItem, boolean bEnable) {
        MenuUtil.enableMenuItem(oMenu, sMenuItem, bEnable, -1);
    }

    public static void enableMenuItem(Menu oMenu, String sMenuItem, boolean bEnable, int iCmdCode) {
        if (null == oMenu) {
            return;
        }
        MenuUtil.enableMenuItem(oMenu.getMenuItem(sMenuItem), bEnable, iCmdCode);
    }

    public static void visibleMenuItem(Menu oMenu, String sMenuItem, boolean bEnable) {
        if (null == oMenu) {
            return;
        }
        MenuUtil.visibleMenuItem(oMenu.getMenuItem(sMenuItem), bEnable);
    }

    public static void orgSeparator(JPopupMenu oMenu) {
        if (null == oMenu) {
            return;
        }
        ArrayList<Component> comLst = new ArrayList<Component>(0);
        int iCompCount = oMenu.getComponentCount();
        Component oComponent = null;
        for (int i = 0; i < iCompCount; ++i) {
            oComponent = oMenu.getComponent(i);
            if (!oComponent.isVisible()) continue;
            comLst.add(oComponent);
        }
        int iVisComSize = comLst.size();
        for (int i = iVisComSize - 1; i > 0 && (oComponent = (Component)comLst.get(i)) instanceof JSeparator; --i) {
            oComponent.setVisible(false);
            comLst.remove(i);
        }
        iVisComSize = comLst.size();
        int seqSepCnt = 0;
        for (int i = 0; i < iVisComSize; ++i) {
            oComponent = (Component)comLst.get(i);
            if (!oComponent.isVisible()) continue;
            seqSepCnt = oComponent instanceof JSeparator ? ++seqSepCnt : 0;
            if (seqSepCnt <= 1) continue;
            oComponent.setVisible(false);
        }
    }

    public static MenuItem getMenuItem(Menu oMenu, String menuItemName) {
        if (null == oMenu) {
            return null;
        }
        Component[] oComponents = oMenu.getMenuComponents();
        Component oComponent = null;
        int iCompCount = oComponents.length;
        MenuItem menuItem = null;
        for (int i = 0; i < iCompCount; ++i) {
            oComponent = oComponents[i];
            if (!(oComponent instanceof MenuItem) || !menuItemName.equals((menuItem = (MenuItem)oComponent).getName())) continue;
            return menuItem;
        }
        return null;
    }

    public static boolean isAllItemUnVisible(JPopupMenu oMenu) {
        if (null == oMenu) {
            return true;
        }
        boolean isAllItemUnVisible = true;
        int iCompCount = oMenu.getComponentCount();
        Component oComponent = null;
        for (int i = 0; i < iCompCount; ++i) {
            oComponent = oMenu.getComponent(i);
            if (!oComponent.isVisible()) continue;
            isAllItemUnVisible = false;
            break;
        }
        return isAllItemUnVisible;
    }
}

