/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.common.util;

import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.util.DCCleanupUtil;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.DCHelpManager;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.KeyStroke;

public abstract class JDialogExt
extends JDialog {
    private static final long serialVersionUID = 8375633766026575911L;
    protected JButton m_oOKBtn;
    protected JButton m_oCancelBtn;
    protected JButton m_oSaveBtn;
    private ActionListener m_oEscKeyHandler;
    private KeyStroke m_oEscKeyStroke;
    private ActionListener m_oF1KeyHandler;
    private KeyStroke m_oF1KeyStroke;

    public JDialogExt() {
        super((Frame)DCFrameWorkUtil.getMainFrame(), true);
        this.setModal(true);
        this.setResizable(false);
        this.setSize(410, 310);
        this.setLocationRelativeTo(DCFrameWorkUtil.getMainFrame());
        this.jbInit();
    }

    public JDialogExt(JDialog parentDlg) {
        super((Dialog)parentDlg, true);
        this.setModal(true);
        this.setResizable(false);
        this.setSize(410, 310);
        this.setLocationRelativeTo(DCFrameWorkUtil.getMainFrame());
        this.jbInit();
    }

    public JDialogExt(JFrame parentFrame) {
        super((Frame)parentFrame, true);
        this.setModal(true);
        this.setResizable(false);
        this.setSize(410, 310);
        this.setLocationRelativeTo(parentFrame);
        this.jbInit();
    }

    private void jbInit() {
        this.setDefaultCloseOperation(2);
        this.m_oCancelBtn = new JButton();
        this.m_oOKBtn = new JButton();
        this.m_oCancelBtn.setName("DCModalDialog_m_oCancelBtn");
        this.m_oOKBtn.setName("DCModalDialog_m_oOKBtn");
        this.m_oOKBtn.setFocusable(false);
        this.m_oCancelBtn.setFocusable(false);
        this.initializeButtonActions();
        this.initializeKeyStrokeActions();
        this.addDialogWindowListener();
    }

    protected void addDialogWindowListener() {
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent we) {
                JDialogExt.this.closeDialog();
            }
        });
    }

    private void initializeKeyStrokeActions() {
        ActionListener oEnterKeyHandler = this.createActionListenerForEnter();
        KeyStroke oEnterKeyStroke = KeyStroke.getKeyStroke(10, 0);
        this.registerKeyBoardActionFor(oEnterKeyStroke, oEnterKeyHandler);
        this.m_oEscKeyHandler = this.createActionListenerForEscape();
        this.m_oEscKeyStroke = KeyStroke.getKeyStroke(27, 0);
        this.registerKeyBoardActionFor(this.m_oEscKeyStroke, this.m_oEscKeyHandler);
    }

    private ActionListener createActionListenerForEnter() {
        ActionListener oEnterKeyHandler = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JDialogExt.this.m_oOKBtn.doClick();
            }
        };
        return oEnterKeyHandler;
    }

    private ActionListener createActionListenerForEscape() {
        ActionListener oEscKeyHandler = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JDialogExt.this.closeDialog();
            }
        };
        return oEscKeyHandler;
    }

    protected void addKeyListenerToComponent(Component oComp) {
        oComp.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 27) {
                    JDialogExt.this.closeDialog();
                } else if (e.getKeyCode() == 10) {
                    JDialogExt.this.m_oOKBtn.doClick();
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 27) {
                    JDialogExt.this.closeDialog();
                } else if (e.getKeyCode() == 10) {
                    JDialogExt.this.m_oOKBtn.doClick();
                }
            }
        });
    }

    private void registerKeyBoardActionFor(KeyStroke oKeyStroke, ActionListener oKeyHandler) {
        this.rootPane.registerKeyboardAction(oKeyHandler, oKeyStroke, 2);
    }

    protected void registerForHelp(JComponent component) {
        component.registerKeyboardAction(this.m_oF1KeyHandler, this.m_oF1KeyStroke, 0);
    }

    private void initializeButtonActions() {
        this.m_oCancelBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JDialogExt.this.cancelButton_ActionPerformed();
            }
        });
        this.m_oOKBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JDialogExt.this.oKButton_ActionPerformed();
            }
        });
    }

    protected void closeDialog() {
        this.doCleanUp();
        DCFrameWorkUtil.setCursor(this, Cursor.getDefaultCursor());
        this.setModal(false);
        this.setVisible(false);
        this.dispose();
    }

    public void doCleanUp() {
        DCCleanupUtil.cleanupComponent(this);
        DCCleanupUtil.cleanupComponent(this.m_oOKBtn);
        this.m_oOKBtn = null;
        DCCleanupUtil.cleanupComponent(this.m_oCancelBtn);
        this.m_oCancelBtn = null;
        this.m_oEscKeyHandler = null;
        this.m_oF1KeyHandler = null;
        if (null != this.m_oEscKeyStroke) {
            this.rootPane.unregisterKeyboardAction(this.m_oEscKeyStroke);
            this.m_oEscKeyStroke = null;
        }
        if (null != this.m_oF1KeyStroke) {
            this.rootPane.unregisterKeyboardAction(this.m_oF1KeyStroke);
            this.m_oF1KeyStroke = null;
        }
        this.rootPane.removeAll();
        this.getContentPane().removeAll();
        this.removeAll();
    }

    protected void cancelButton_ActionPerformed() {
        this.closeDialog();
    }

    protected void oKButton_ActionPerformed() {
    }

    protected void displayHelp() {
        String strContext = this.getCurrentContext();
        if (null == strContext || "".equals(strContext)) {
            return;
        }
        try {
            DCFrameWorkUtil.waitCursor();
            DCHelpManager.getInstance().enableF1HelpKey(this.getContentPane(), strContext);
        }
        catch (Exception e) {
            DCDebugTracer.trace(e);
        }
        DCFrameWorkUtil.defaultCursor();
    }

    protected abstract String getCurrentContext();

    public JButton getCancelBtn() {
        return this.m_oCancelBtn;
    }
}

