/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.common.util;

import com.huawei.dc.common.controller.DeviceInfoManagerImpl;
import com.huawei.dc.common.framework.utility.ConfigurationInfo;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.DCHelpBroker;
import com.huawei.dc.common.util.DCOptionPane;
import com.huawei.dc.common.util.DeviceInfoUtil;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.MenuItem;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import javax.help.CSH;
import javax.help.HelpBroker;
import javax.help.HelpSet;
import javax.help.HelpSetException;
import javax.help.Map;

public class HelpManager {
    private static HelpManager _instance = null;
    private DCHelpBroker helpBroker = null;
    private HelpSet helpset = null;
    private boolean firstTimeLaunch = true;
    private boolean successLaunch = true;

    private HelpManager() {
    }

    public static HelpManager getInstance() {
        if (_instance == null) {
            _instance = new HelpManager();
        }
        return _instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void launchHelper() {
        try {
            DCFrameWorkUtil.setCursor(Cursor.getPredefinedCursor(3));
            this.initialize();
            if (!this.successLaunch) {
                DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), ResourceManager.getInstance().getResString("HELP_INITIALIZATION_FAILED"), ResourceManager.getInstance().getResString("ERROR"), 0);
                DCFrameWorkUtil.setCursor(Cursor.getDefaultCursor());
                return;
            }
            this.setCurrentID(this.getHomeID());
            this.helpBroker.enableHelp(DCFrameWorkUtil.getMainFrame(), this.getHomeID(), this.helpset);
            this.helpBroker.setActivationWindow(this.getHomeID());
        }
        catch (Exception ex) {
            DCDebugTracer.trace(ex);
        }
        finally {
            DCFrameWorkUtil.setCursor(Cursor.getDefaultCursor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enableHelpOnButton(Component comp, String id) {
        try {
            DCFrameWorkUtil.setCursor(Cursor.getPredefinedCursor(3));
            this.initialize();
            if (!this.successLaunch) {
                DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), ResourceManager.getInstance().getResString("HELP_INITIALIZATION_FAILED"), ResourceManager.getInstance().getResString("ERROR"), 0);
                DCFrameWorkUtil.setCursor(Cursor.getDefaultCursor());
                return;
            }
            this.setCurrentID(id);
            this.helpBroker.enableHelp(DCFrameWorkUtil.getMainFrame(), id, this.helpset);
            this.helpBroker.setActivationWindow(id);
            this.setDisplayed(true);
        }
        catch (Exception e) {
            DCDebugTracer.trace(e);
        }
        finally {
            DCFrameWorkUtil.setCursor(Cursor.getDefaultCursor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enableHelpOnButton(MenuItem comp, String id) {
        try {
            DCFrameWorkUtil.setCursor(Cursor.getPredefinedCursor(3));
            this.initialize();
            if (!this.successLaunch) {
                DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), ResourceManager.getInstance().getResString("HELP_INITIALIZATION_FAILED"), ResourceManager.getInstance().getResString("ERROR"), 0);
                DCFrameWorkUtil.setCursor(Cursor.getDefaultCursor());
                return;
            }
            this.helpBroker.enableHelpOnButton(comp, id, this.helpset);
            this.setCurrentID(id);
            this.helpBroker.enableHelp(DCFrameWorkUtil.getMainFrame(), this.getHomeID(), this.helpset);
            this.setDisplayed(true);
        }
        catch (Exception e) {
            DCDebugTracer.trace(e);
        }
        finally {
            DCFrameWorkUtil.setCursor(Cursor.getDefaultCursor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enableHelpKey(Component comp, String id) {
        try {
            DCFrameWorkUtil.setCursor(Cursor.getPredefinedCursor(3));
            this.initialize();
            if (!this.successLaunch) {
                DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), ResourceManager.getInstance().getResString("HELP_INITIALIZATION_FAILED"), ResourceManager.getInstance().getResString("ERROR"), 0);
                DCFrameWorkUtil.setCursor(Cursor.getDefaultCursor());
                return;
            }
            this.helpBroker.enableHelpKey(comp, id, this.helpset);
            this.setCurrentID(id);
            this.helpBroker.setActivationWindow(id);
            this.setDisplayed(true);
        }
        catch (Exception e) {
            DCDebugTracer.trace(e);
        }
        finally {
            DCFrameWorkUtil.setCursor(Cursor.getDefaultCursor());
        }
    }

    public HelpBroker getHelpBroker() {
        return this.helpBroker;
    }

    public HelpSet getHelpSet() {
        return this.helpset;
    }

    private void initialize() {
        if (this.firstTimeLaunch) {
            ClassLoader loader = this.getClass().getClassLoader();
            StringBuffer helpSetNameBuf = new StringBuffer("");
            URL url = null;
            helpSetNameBuf.append("file:");
            File currentDir = new File(".");
            String baseDirectory = currentDir.getAbsolutePath();
            String strTemp = baseDirectory + File.separator + "dchelp";
            File oFile = new File(strTemp);
            if (oFile.exists()) {
                helpSetNameBuf.append("dchelp");
            } else {
                helpSetNameBuf.append("help");
            }
            helpSetNameBuf.append(File.separator);
            helpSetNameBuf.append(ConfigurationInfo.getInstance().getLocale().getLanguage());
            helpSetNameBuf.append("_");
            helpSetNameBuf.append(ConfigurationInfo.getInstance().getLocale().getCountry());
            helpSetNameBuf.append(File.separator);
            try {
                helpSetNameBuf.append("help.hs");
                if (!helpSetNameBuf.toString().endsWith(".hs")) {
                    helpSetNameBuf.append(".hs");
                }
                if ((url = HelpSet.findHelpSet((ClassLoader)loader, (String)helpSetNameBuf.toString())) == null) {
                    url = new URL(helpSetNameBuf.toString());
                }
                this.helpset = new HelpSet(loader, url);
                this.helpBroker = new DCHelpBroker(this.helpset);
            }
            catch (HelpSetException e) {
                DCDebugTracer.trace((Exception)((Object)e));
                this.successLaunch = false;
            }
            catch (MalformedURLException mue) {
                DCDebugTracer.trace(mue);
                this.successLaunch = false;
            }
        }
        this.firstTimeLaunch = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enableHelp(Component comp, String id) {
        try {
            DCFrameWorkUtil.setCursor(Cursor.getPredefinedCursor(3));
            this.initialize();
            if (!this.successLaunch) {
                DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), ResourceManager.getInstance().getResString("HELP_INITIALIZATION_FAILED"), ResourceManager.getInstance().getResString("ERROR"), 0);
                DCFrameWorkUtil.setCursor(Cursor.getDefaultCursor());
                return;
            }
            this.setCurrentID(id);
            this.helpBroker.enableHelp(comp, id, this.helpset);
            this.helpBroker.setActivationWindow(id);
            this.setDisplayed(true);
        }
        catch (Exception e) {
            DCDebugTracer.trace(e);
        }
        finally {
            DCFrameWorkUtil.setCursor(Cursor.getDefaultCursor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enableHelp(MenuItem comp, String id) {
        try {
            DCFrameWorkUtil.setCursor(Cursor.getPredefinedCursor(3));
            this.initialize();
            if (!this.successLaunch) {
                DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), ResourceManager.getInstance().getResString("HELP_INITIALIZATION_FAILED"), ResourceManager.getInstance().getResString("ERROR"), 0);
                DCFrameWorkUtil.setCursor(Cursor.getDefaultCursor());
                return;
            }
            this.helpBroker.enableHelp(comp, id, this.helpset);
            this.setCurrentID(id);
            this.setDisplayed(true);
        }
        catch (Exception e) {
            DCDebugTracer.trace(e);
        }
        finally {
            DCFrameWorkUtil.setCursor(Cursor.getDefaultCursor());
        }
    }

    public void setCurrentID(Component comp) {
        if (null != this.helpBroker) {
            this.helpBroker.setCurrentID(CSH.getHelpIDString((Component)comp));
        }
    }

    public void setCurrentID(String id) {
        if (null != this.helpBroker) {
            this.helpBroker.setCurrentID(id);
        }
    }

    public String getHomeID() {
        String homeId = "welcome";
        if (null != this.helpset) {
            homeId = this.helpset.getHomeID().id;
        }
        return homeId;
    }

    public void setHomeID(String id) {
        if (null != this.helpset) {
            this.helpset.setHomeID(id);
        }
    }

    public void setDisplayed(boolean b) {
        try {
            if (null != this.helpBroker) {
                this.helpBroker.setDisplayed(b);
            }
        }
        catch (Exception e) {
            DCDebugTracer.trace(e);
        }
    }

    public boolean isDisplayed() {
        if (null != this.helpBroker) {
            return this.helpBroker.isDisplayed();
        }
        return false;
    }

    public Font getFont() {
        Font font = null;
        if (null != this.helpBroker) {
            font = this.helpBroker.getFont();
        }
        return font;
    }

    public void setFont(Font f) {
        if (null != this.helpBroker) {
            this.helpBroker.setFont(f);
        }
    }

    public Dimension getSize() {
        Dimension dimension = null;
        if (null != this.helpBroker) {
            dimension = this.helpBroker.getSize();
        }
        return dimension;
    }

    public void setSize(Dimension d) {
        if (null != this.helpBroker) {
            this.helpBroker.setSize(d);
        }
    }

    public Map.ID getCurrentID() {
        return this.helpBroker.getCurrentID();
    }

    public void setViewDisplayed(boolean b) {
        if (null != this.helpBroker) {
            this.helpBroker.setViewDisplayed(b);
        }
    }

    public int getExistentNeDomains() {
        int bNEDomainFlag = 0;
        boolean bBMS = DeviceInfoUtil.isContainsDevices(DeviceInfoManagerImpl.getInstance().getExistDeviceTypes(), 1);
        boolean bDMS = DeviceInfoUtil.isContainsDevices(DeviceInfoManagerImpl.getInstance().getExistDeviceTypes(), 2);
        boolean bT2000 = DeviceInfoUtil.isContainsDevices(DeviceInfoManagerImpl.getInstance().getExistDeviceTypes(), 4);
        if (bBMS) {
            ++bNEDomainFlag;
        }
        if (bDMS) {
            bNEDomainFlag += 2;
        }
        if (bT2000) {
            bNEDomainFlag += 4;
        }
        return bNEDomainFlag;
    }
}

