/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.common.util;

import com.huawei.dc.common.DCException;
import com.huawei.dc.common.controller.DeviceInfoManagerImpl;
import com.huawei.dc.common.framework.system.SystemManager;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.IOStreamClose;
import com.huawei.dc.deviceinfo.DeviceInfo;
import com.huawei.dc.taskmgmt.controller.TaskSrcDstVersionCheck;
import com.swimap.iview.util.SaveFileChooser;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.channels.FileChannel;
import jxl.write.WritableWorkbook;
import jxl.write.WriteException;

public final class FileUtil {
    public static void mkDir(String fileSavePath, String msg) throws DCException {
        boolean isSucc;
        File directory = new File(fileSavePath);
        boolean isExistsDir = directory.exists();
        if (!isExistsDir && !(isSucc = directory.mkdir())) {
            throw new DCException(msg);
        }
    }

    public static void deleteReportFile(File file) throws DCException {
        boolean isSucc;
        if (null == file) {
            return;
        }
        boolean isExistsDir = file.exists();
        if (isExistsDir && !(isSucc = file.delete())) {
            throw new DCException(ResourceManager.getInstance().getResString("TASK_REPORT_DELETE_FAILED"));
        }
    }

    public static void deleteFile(File file) {
        boolean isSucc;
        if (null == file) {
            return;
        }
        boolean isExistsDir = file.exists();
        if (isExistsDir && !(isSucc = file.delete())) {
            DCDebugTracer.trace("Delete file failed : " + file.getName());
        }
    }

    public static void deleteReportFile(String fileName) throws DCException {
        File file = new File(fileName);
        FileUtil.deleteReportFile(file);
    }

    public static void deleteReportFile(File file, WritableWorkbook workbook) throws DCException {
        FileUtil.freeExcelReference(workbook);
        FileUtil.deleteReportFile(file);
    }

    public static void deleteReportFile(File file, BufferedWriter oBufferedWriter, OutputStreamWriter oWriter) throws DCException {
        IOStreamClose.closeWriter(oBufferedWriter);
        IOStreamClose.closeWriter(oWriter);
        FileUtil.deleteReportFile(file);
    }

    public static void freeExcelReference(WritableWorkbook excelWorkbook) {
        try {
            if (null != excelWorkbook) {
                excelWorkbook.close();
                excelWorkbook = null;
            }
        }
        catch (WriteException ignore) {
            DCDebugTracer.traceError(ignore.getMessage());
        }
        catch (IOException ignore) {
            DCDebugTracer.traceError(ignore.getMessage());
        }
    }

    public static String getSystemEncoding() {
        String sysEncoding = null;
        String[] encodingInfo = SaveFileChooser.getSystemEncodingInfo();
        if (null != encodingInfo && encodingInfo.length == 2) {
            sysEncoding = encodingInfo[1];
        }
        if (null == sysEncoding) {
            sysEncoding = ResourceManager.getInstance().getResString("DEFAULT_OUTPUT_FILE_ENCODING", "config");
        }
        return sysEncoding;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addUTFBOMHeader(File file) {
        FileOutputStream ios = null;
        try {
            boolean isSuccess;
            if (!file.isFile() && !(isSuccess = file.createNewFile())) {
                DCDebugTracer.trace("fail to create file<" + file.getAbsolutePath() + ">");
            }
            ios = new FileOutputStream(file);
            byte[] b = new byte[]{-17, -69, -65};
            ((OutputStream)ios).write(b);
            IOStreamClose.closeOutputStream(ios);
        }
        catch (IOException ignore) {
            DCDebugTracer.trace(ignore);
        }
        finally {
            IOStreamClose.closeOutputStream(ios);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isUTF8File(String fileName) {
        boolean isUTF8File = false;
        File file = null;
        FileInputStream ios = null;
        try {
            byte[] b;
            int len;
            file = new File(fileName);
            if (file.isFile() && 2 < (len = ((InputStream)(ios = new FileInputStream(file))).read(b = new byte[3])) && b[0] == -17 && b[1] == -69 && b[2] == -65) {
                isUTF8File = true;
            }
        }
        catch (IOException e) {
            DCDebugTracer.trace(e);
            isUTF8File = false;
        }
        finally {
            IOStreamClose.closeInputStream(ios);
        }
        return isUTF8File;
    }

    public static String getUTF8Encoding() {
        String sysEncoding = null;
        String[] encodingInfo = SaveFileChooser.getUtfEncodingInfo();
        if (null != encodingInfo && encodingInfo.length == 2) {
            sysEncoding = encodingInfo[1];
        }
        if (null == sysEncoding) {
            sysEncoding = ResourceManager.getInstance().getResString("DEFAULT_OUTPUT_FILE_ENCODING", "config");
        }
        return sysEncoding;
    }

    public static String getDefaultFilePath() {
        String dot = ".";
        File file = new File(".");
        String filePath = file.getAbsolutePath();
        int index = filePath.lastIndexOf(".");
        if (index != -1) {
            filePath = filePath.substring(0, index);
        }
        return filePath;
    }

    private FileUtil() {
    }

    public static String getFileName(String strFileName) {
        return strFileName.replace(" ", "_");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean copyFile(String sourceDir, String targetdir, String sourceFile, String targetFile) {
        boolean bCopySucc;
        block5: {
            bCopySucc = false;
            FileChannel in = null;
            FileChannel out = null;
            try {
                in = new FileInputStream(sourceDir + File.separator + sourceFile).getChannel();
                out = new FileOutputStream(targetdir + File.separator + targetFile).getChannel();
                in.transferTo(0L, in.size(), out);
                bCopySucc = true;
                IOStreamClose.close(in);
            }
            catch (IOException ioEX) {
                DCDebugTracer.trace("DC::FileUtil/copyFile:Error when copy file.");
                DCDebugTracer.trace(ioEX);
                bCopySucc = false;
                break block5;
            }
            finally {
                IOStreamClose.close(in);
                IOStreamClose.close(out);
            }
            IOStreamClose.close(out);
        }
        return bCopySucc;
    }

    public static String getPath(String sInitPath) {
        String strLastPath = sInitPath;
        if (null != sInitPath && sInitPath.contains(".")) {
            String strPathTmp = sInitPath;
            if (strPathTmp.contains("\\")) {
                strPathTmp = strPathTmp.replaceAll("\\\\", "/");
            }
            strLastPath = strPathTmp.contains("/") && strPathTmp.lastIndexOf("/") > 0 ? strPathTmp.substring(0, strPathTmp.lastIndexOf("/")) : "/";
        }
        return strLastPath;
    }

    public static String getRootDir(boolean m_bSelectThirdPartyFTP) {
        String strRootDir = "";
        SystemManager sysMgr = new SystemManager();
        strRootDir = !m_bSelectThirdPartyFTP ? sysMgr.getFTSInfo().getRootDirectory() : sysMgr.getBrowseFileDir(1, TaskSrcDstVersionCheck.getInstance().getThirdFTPServerName());
        return strRootDir;
    }

    public static String getUnifyPath(String strDir) {
        if (strDir.contains("\\") && (strDir = strDir.replaceAll("\\\\", "/")).contains("//")) {
            strDir = strDir.replaceAll("//", "/");
        }
        return strDir;
    }

    public static String getDirNameForDev(String strServerBckPath, int iDevId) {
        String sDevID;
        String strDirNameForDev = strServerBckPath;
        if (strServerBckPath.contains("_") && (sDevID = strServerBckPath.substring(0, strServerBckPath.indexOf("_"))).equals(String.valueOf(iDevId))) {
            DeviceInfo oDeviceInfo = DeviceInfoManagerImpl.getInstance().getDevice(iDevId);
            String strIP = oDeviceInfo.getDevIPAddress();
            strDirNameForDev = strIP + "_" + sDevID;
        }
        return strDirNameForDev;
    }
}

