/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.common.util;

import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.IOStreamClose;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public final class FileOperationUtils {
    private FileOperationUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File unZipFile(String strZipFileName) {
        DCDebugTracer.trace("FileOperationUtils#unZipFile start");
        DCDebugTracer.trace("strZipFileName enter : " + strZipFileName);
        String strUnzippedFileName = null;
        String path = "";
        File oFile = null;
        FileOutputStream out = null;
        ZipInputStream in = null;
        try {
            in = new ZipInputStream(new FileInputStream(strZipFileName));
            strZipFileName = strZipFileName.replace('/', File.separatorChar);
            int iFileIndex = strZipFileName.lastIndexOf(File.separatorChar);
            if (iFileIndex != -1) {
                path = strZipFileName.substring(0, iFileIndex);
            }
            ZipEntry entry = in.getNextEntry();
            strUnzippedFileName = entry.getName();
            DCDebugTracer.trace("strUnzippedFileName : " + strUnzippedFileName);
            oFile = new File(path, strUnzippedFileName);
            if (!oFile.canWrite()) {
                if (!oFile.delete()) {
                    DCDebugTracer.trace("DC::FileOperationUtils.unZipFile(fail to delete " + oFile + ")");
                }
                oFile = new File(path, strUnzippedFileName);
            }
            out = new FileOutputStream(oFile);
            byte[] buf = new byte[1024];
            int len = in.read(buf);
            while (len > 0) {
                ((OutputStream)out).write(buf, 0, len);
                len = in.read(buf);
            }
        }
        catch (IOException e) {
            try {
                DCDebugTracer.trace("unZipFile : " + strZipFileName);
                DCDebugTracer.trace(e);
            }
            catch (Throwable throwable) {
                IOStreamClose.closeOutputStream(out);
                IOStreamClose.closeZipInputStream(in);
                throw throwable;
            }
            IOStreamClose.closeOutputStream(out);
            IOStreamClose.closeZipInputStream(in);
        }
        IOStreamClose.closeOutputStream(out);
        IOStreamClose.closeZipInputStream(in);
        DCDebugTracer.trace("FileOperationUtils#unZipFile end..");
        return oFile;
    }
}

