/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.common.util;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.border.Border;

public class FieldBorder
implements Border {
    protected boolean isLowered;

    public FieldBorder() {
        this.isLowered = true;
    }

    public FieldBorder(boolean isLowered) {
        this.isLowered = isLowered;
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        int w = width;
        int h = height;
        g.translate(x, y);
        Color topColor = null;
        Color botColor = null;
        if (this.isLowered) {
            botColor = c.getBackground().brighter();
            topColor = c.getBackground().darker();
        } else {
            topColor = c.getBackground().brighter();
            botColor = c.getBackground().darker();
        }
        g.setColor(topColor);
        g.drawLine(0, 0, w - 1, 0);
        g.drawLine(0, 0, 0, h - 1);
        g.setColor(botColor);
        g.drawLine(w - 1, 0, w - 1, h - 1);
        g.drawLine(0, h - 1, w - 1, h - 1);
        g.translate(-x, -y);
    }

    @Override
    public Insets getBorderInsets(Component c) {
        return new Insets(1, 1, 1, 1);
    }

    @Override
    public boolean isBorderOpaque() {
        return false;
    }

    public boolean isLowered() {
        return this.isLowered;
    }

    public void setLowered(boolean isLowered) {
        this.isLowered = isLowered;
    }
}

