/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.common.util;

import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.taskmgmt.report.devlevel.model.ICheckReportTableCell;
import com.huawei.dc.taskmgmt.report.tasklevel.util.UpgradeInfoHelper;
import jxl.Cell;
import jxl.format.Alignment;
import jxl.format.Border;
import jxl.format.BorderLineStyle;
import jxl.format.CellFormat;
import jxl.format.Colour;
import jxl.format.UnderlineStyle;
import jxl.format.VerticalAlignment;
import jxl.write.Formula;
import jxl.write.Label;
import jxl.write.WritableCell;
import jxl.write.WritableCellFormat;
import jxl.write.WritableFont;
import jxl.write.WritableSheet;
import jxl.write.WritableWorkbook;
import jxl.write.WriteException;
import jxl.write.biff.RowsExceededException;

public class ExcelFileWtiterHelper {
    private static final long BANK_EXCEL_SIZE = 53248L;
    private static WritableCellFormat buleFormatFG;
    private static WritableCellFormat redFormat;
    private static WritableCellFormat redFormatFG;
    private static WritableCellFormat strFormat;
    public static final int PRECHECK_COLOR_MARK = 0;
    public static final int POSTCHECK_COLOR_MARK = 1;
    private WritableCellFormat blackFormat;
    private WritableCellFormat boldFormat;
    private WritableCellFormat brownFormat;
    private final WritableFont BULE_FONT = new WritableFont(WritableFont.ARIAL, 12, WritableFont.NO_BOLD, false, UnderlineStyle.NO_UNDERLINE, Colour.BLUE);
    private static WritableCellFormat buleFormat;
    private WritableFont colorfont;
    private WritableCellFormat leftAlign;
    private final WritableFont RED_FONT = new WritableFont(WritableFont.ARIAL, 12, WritableFont.NO_BOLD, false, UnderlineStyle.NO_UNDERLINE, Colour.RED);
    private WritableCellFormat rightLine;
    private WritableCellFormat teaFormat;

    public static void addAlarmCellData(int colum, int row, ICheckReportTableCell cell, WritableSheet sheet) {
        boolean PRECHECK_COLOR_MARK = false;
        boolean POSTCHECK_COLOR_MARK = true;
        int cellContentColorMark = cell.getoCellColorMark();
        WritableCellFormat format = 0 == cellContentColorMark ? buleFormatFG : (1 == cellContentColorMark ? redFormatFG : strFormat);
        Label label = new Label(colum, row, UpgradeInfoHelper.convertEmptyToUnSupportFlag(cell.toString()), (CellFormat)format);
        ExcelFileWtiterHelper.addCell(label, sheet);
    }

    public static void addCompareCellData(int colum, int row, int colorMark, String content, WritableSheet sheet) {
        WritableCellFormat format = 0 == colorMark ? buleFormat : (1 == colorMark ? redFormat : strFormat);
        Label label = new Label(colum, row, content, (CellFormat)format);
        ExcelFileWtiterHelper.addCell(label, sheet);
    }

    public static void addCell(int colum, int row, String text, WritableCellFormat format, WritableSheet sheet) {
        ExcelFileWtiterHelper.addCell(new Label(colum, row, text, (CellFormat)format), sheet);
    }

    public static void addDataNumberCell(int colum, int row, String text, WritableSheet sheet) {
        WritableFont tenfont = new WritableFont(WritableFont.ARIAL, 10, WritableFont.NO_BOLD, false, UnderlineStyle.NO_UNDERLINE);
        WritableCellFormat numberFormat = new WritableCellFormat(tenfont);
        try {
            numberFormat.setAlignment(Alignment.RIGHT);
            numberFormat.setBorder(Border.ALL, BorderLineStyle.THIN);
            numberFormat.setWrap(true);
        }
        catch (WriteException ignore) {
            ExcelFileWtiterHelper.traceIgnoreLog((Exception)((Object)ignore));
        }
        Label label = new Label(colum, row, text, (CellFormat)numberFormat);
        ExcelFileWtiterHelper.addCell(label, sheet);
    }

    public static void addDataStrCell(int colum, int row, String text, WritableSheet sheet) {
        ExcelFileWtiterHelper.addCell(new Label(colum, row, text, (CellFormat)strFormat), sheet);
    }

    public static void addHealthCellData(int colum, int row, ICheckReportTableCell cell, WritableSheet sheet) {
        int cellConColorMark = cell.getCheckResultMark();
        int CHECK_MARK_DEFAULT = 255;
        boolean isHavePreCheck = false;
        isHavePreCheck = 1 == (cellConColorMark & 1);
        boolean isHavePostCheck = false;
        isHavePostCheck = 2 == (cellConColorMark & 2);
        boolean isCompareSuccess = false;
        boolean bl = isCompareSuccess = 16 == (cellConColorMark & 0x10);
        WritableCellFormat format = 255 == cellConColorMark ? strFormat : (isHavePreCheck && !isHavePostCheck ? buleFormatFG : (isHavePostCheck && !isHavePreCheck ? redFormatFG : (isHavePreCheck && isHavePostCheck ? (isCompareSuccess ? redFormat : strFormat) : strFormat)));
        Label label = new Label(colum, row, UpgradeInfoHelper.convertEmptyToUnSupportFlag(cell.toString()), (CellFormat)format);
        ExcelFileWtiterHelper.addCell(label, sheet);
    }

    public static void addHyperLink(int colum, int row, String text, WritableSheet sheet) {
        Formula f = new Formula(colum, row, text, (CellFormat)buleFormatFG);
        try {
            sheet.addCell((WritableCell)f);
        }
        catch (RowsExceededException e) {
            ExcelFileWtiterHelper.traceIgnoreLog((Exception)((Object)e));
        }
        catch (WriteException e) {
            ExcelFileWtiterHelper.traceIgnoreLog((Exception)((Object)e));
        }
    }

    public static WritableCellFormat getRedFormatFG() {
        return redFormatFG;
    }

    public static WritableCellFormat getStrFormat() {
        return strFormat;
    }

    public static void mergeCells(WritableSheet sheet, int startCol, int startRow, int endCol, int endRow) {
        if (startCol < 0 || endCol < 0) {
            return;
        }
        try {
            sheet.mergeCells(startCol, startRow, endCol, endRow);
        }
        catch (RowsExceededException e) {
            ExcelFileWtiterHelper.traceIgnoreLog((Exception)((Object)e));
        }
        catch (WriteException e) {
            ExcelFileWtiterHelper.traceIgnoreLog((Exception)((Object)e));
        }
    }

    private static void addCell(Label label, WritableSheet sheet) {
        try {
            sheet.addCell((WritableCell)label);
        }
        catch (RowsExceededException e) {
            ExcelFileWtiterHelper.traceIgnoreLog((Exception)((Object)e));
        }
        catch (WriteException e) {
            ExcelFileWtiterHelper.traceIgnoreLog((Exception)((Object)e));
        }
    }

    public ExcelFileWtiterHelper() {
        this.initSheetConfigure();
    }

    public WritableCellFormat getBlackFormat() {
        return this.blackFormat;
    }

    public WritableCellFormat getBoldFormat() {
        return this.boldFormat;
    }

    public WritableCellFormat getBrownFormat() {
        return this.brownFormat;
    }

    public WritableCellFormat getBuleFormat() {
        return buleFormat;
    }

    public WritableFont getColorfont() {
        return this.colorfont;
    }

    public long getExcelFileContentSize(WritableWorkbook workbook) {
        long lFileSize = 0L;
        if (null == workbook) {
            return lFileSize;
        }
        int sheetNumber = workbook.getNumberOfSheets();
        if (0 == sheetNumber) {
            return lFileSize;
        }
        for (int i = 0; i < sheetNumber; ++i) {
            lFileSize += this.getSheetContentSize(workbook.getSheet(i));
        }
        return lFileSize + 53248L;
    }

    public WritableCellFormat getLeftAlign() {
        return this.leftAlign;
    }

    public WritableCellFormat getRedFormat() {
        return redFormat;
    }

    public WritableCellFormat getRightLine() {
        return this.rightLine;
    }

    private long getSheetContentSize(WritableSheet sheet) {
        long lFileSize = 0L;
        if (null == sheet) {
            return lFileSize;
        }
        int colNumber = 0;
        Cell[] oneRowCell = null;
        Cell oneCell = null;
        String contents = null;
        int rowNumber = sheet.getRows();
        for (int row = 0; row < rowNumber; ++row) {
            oneRowCell = sheet.getRow(row);
            colNumber = null != oneRowCell ? oneRowCell.length : 0;
            for (int col = 0; col < colNumber; ++col) {
                if (null == oneRowCell || null == (oneCell = oneRowCell[col])) continue;
                contents = oneCell.getContents();
                lFileSize += (long)contents.getBytes().length;
            }
        }
        return lFileSize;
    }

    public WritableCellFormat getTeaFormat() {
        return this.teaFormat;
    }

    private void initSheetConfigure() {
        this.colorfont = new WritableFont(WritableFont.ARIAL, 10, WritableFont.NO_BOLD, false, UnderlineStyle.NO_UNDERLINE);
        this.rightLine = new WritableCellFormat(this.colorfont);
        this.setStyle(this.rightLine, Colour.TAN, Alignment.CENTRE, Border.RIGHT, BorderLineStyle.THIN);
        this.colorfont = new WritableFont(WritableFont.ARIAL, 12, WritableFont.NO_BOLD, false, UnderlineStyle.NO_UNDERLINE);
        this.teaFormat = new WritableCellFormat(this.colorfont);
        this.setStyle(this.teaFormat, Colour.TAN, Alignment.CENTRE, Border.ALL, BorderLineStyle.THIN);
        WritableFont tenfont = new WritableFont(WritableFont.ARIAL, 10, WritableFont.NO_BOLD, false, UnderlineStyle.NO_UNDERLINE);
        strFormat = new WritableCellFormat(tenfont);
        this.leftAlign = new WritableCellFormat(tenfont);
        try {
            strFormat.setAlignment(Alignment.LEFT);
            strFormat.setBorder(Border.ALL, BorderLineStyle.THIN);
            strFormat.setWrap(true);
            this.leftAlign.setAlignment(Alignment.LEFT);
            this.leftAlign.setBorder(Border.ALL, BorderLineStyle.THIN);
        }
        catch (WriteException ignore) {
            ExcelFileWtiterHelper.traceIgnoreLog((Exception)((Object)ignore));
        }
        redFormat = new WritableCellFormat(tenfont);
        this.setStyle(redFormat, Colour.RED, Alignment.LEFT, Border.ALL, BorderLineStyle.THIN);
        this.blackFormat = new WritableCellFormat(tenfont);
        this.setStyle(this.blackFormat, Colour.PALETTE_BLACK, Alignment.LEFT, Border.ALL, BorderLineStyle.THIN);
        buleFormat = new WritableCellFormat(tenfont);
        this.setStyle(buleFormat, Colour.BLUE, Alignment.LEFT, Border.ALL, BorderLineStyle.THIN);
        this.brownFormat = new WritableCellFormat(tenfont);
        this.setStyle(this.brownFormat, Colour.DARK_YELLOW, Alignment.LEFT, Border.ALL, BorderLineStyle.THIN);
        WritableFont boldfont = new WritableFont(WritableFont.ARIAL, 12, WritableFont.NO_BOLD, false, UnderlineStyle.NO_UNDERLINE, Colour.BLACK);
        this.boldFormat = new WritableCellFormat(boldfont);
        this.setStyle(this.boldFormat, Colour.TAN, Alignment.LEFT, Border.ALL, BorderLineStyle.THIN);
        redFormatFG = new WritableCellFormat(this.RED_FONT);
        try {
            redFormatFG.setAlignment(Alignment.CENTRE);
            redFormatFG.setBorder(Border.ALL, BorderLineStyle.THIN);
            redFormatFG.setWrap(true);
        }
        catch (WriteException ignore) {
            ExcelFileWtiterHelper.traceIgnoreLog((Exception)((Object)ignore));
        }
        buleFormatFG = new WritableCellFormat(this.BULE_FONT);
        try {
            buleFormatFG.setAlignment(Alignment.CENTRE);
            buleFormatFG.setBorder(Border.ALL, BorderLineStyle.THIN);
            buleFormatFG.setWrap(true);
        }
        catch (WriteException ignore) {
            ExcelFileWtiterHelper.traceIgnoreLog((Exception)((Object)ignore));
        }
    }

    private void setStyle(WritableCellFormat teaFormat, Colour colour, Alignment alignment, Border border, BorderLineStyle lineStyle) {
        try {
            teaFormat.setBackground(colour);
            teaFormat.setAlignment(alignment);
            teaFormat.setVerticalAlignment(VerticalAlignment.CENTRE);
            teaFormat.setBorder(border, lineStyle);
            teaFormat.setWrap(true);
        }
        catch (WriteException ignore) {
            ExcelFileWtiterHelper.traceIgnoreLog((Exception)((Object)ignore));
        }
    }

    private static void traceIgnoreLog(Exception e) {
        DCDebugTracer.trace("[ignore]" + e);
    }

    public static void setRowGroup(WritableSheet sheet, int startRow, int endRow) {
        try {
            sheet.setRowGroup(startRow, endRow, false);
        }
        catch (RowsExceededException ignore) {
            ExcelFileWtiterHelper.traceIgnoreLog((Exception)((Object)ignore));
        }
        catch (WriteException ignore) {
            ExcelFileWtiterHelper.traceIgnoreLog((Exception)((Object)ignore));
        }
    }
}

