/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.common.util;

import com.huawei.dc.common.asndatacenter.AsnDCErrorCodeInfo;
import com.huawei.dc.framework.ErrorCodeReader;
import java.io.Serializable;
import java.math.BigInteger;

public class ErrorInfo
implements Serializable {
    private static final long serialVersionUID = -103990799221469053L;
    private int m_iErrorCode;
    private String m_strErrCodeDescription = "";
    private String m_strErrMsg = "";
    private String m_strHelpId = "";

    public ErrorInfo(AsnDCErrorCodeInfo oErrorInfo) {
        this.m_iErrorCode = oErrorInfo.iErrorNo.intValue();
        this.m_strErrCodeDescription = ErrorCodeReader.getInstance().getErrorDesc(oErrorInfo.iErrorNo);
        if (null != oErrorInfo.strResult) {
            this.m_strErrMsg = new String(oErrorInfo.strResult);
        }
    }

    public ErrorInfo(int iErrCode, String strErrMsg, String strHelpId) {
        this.m_iErrorCode = iErrCode;
        this.m_strErrMsg = strErrMsg;
        this.m_strHelpId = strHelpId;
        this.m_strErrCodeDescription = ErrorCodeReader.getInstance().getErrorDesc(BigInteger.valueOf(iErrCode));
    }

    public ErrorInfo(int iErrorCode, String strErrMsg) {
        this(iErrorCode, strErrMsg, "");
    }

    public ErrorInfo(int iErrCode) {
        this(iErrCode, "", "");
    }

    public int getErrorCode() {
        return this.m_iErrorCode;
    }

    public String getErrCodeDescription() {
        return this.m_strErrCodeDescription;
    }

    public String getErrMsg() {
        return this.m_strErrMsg;
    }

    public String getHelpId() {
        return this.m_strHelpId;
    }

    public String toString() {
        if ("".equals(this.m_strErrMsg)) {
            return this.m_strErrCodeDescription;
        }
        if ("".equals(this.m_strErrCodeDescription)) {
            return this.m_strErrMsg;
        }
        if (999293081 == this.getErrorCode()) {
            return this.m_strErrMsg;
        }
        return this.m_strErrCodeDescription + "(" + this.m_strErrMsg + ")";
    }
}

