/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.common.util;

import com.huawei.dc.common.framework.utility.ConfigurationInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DeviceOperationAdapter {
    private static DeviceOperationAdapter m_instance;
    private HashMap<String, ArrayList<Condition>> m_oOprAdapterMap;
    private static final String ADAPTER_FILE_NAME = "deviceoperationadapter.xml";
    private static final String OPERATION = "Operation";
    private static final String CONDITION = "Condition";
    private static final String ID = "id";
    private static final String DEVICE_TYPE_ID = "deviceTypeId";
    private static final String STEP = "step";
    private Condition emptyCondition = new Condition();

    private DeviceOperationAdapter() {
        this.m_oOprAdapterMap = new HashMap();
        this.init();
    }

    private void init() {
        String fileName = ConfigurationInfo.getInstance().getStyleDirectory() + ADAPTER_FILE_NAME;
        Document aDocument = ConfigurationInfo.getInstance().loadDocumentFromFile(fileName);
        Element rootNode = aDocument.getDocumentElement();
        NodeList oOperationLst = rootNode.getChildNodes();
        int iOperationCount = oOperationLst.getLength();
        for (int i = 0; i < iOperationCount; ++i) {
            Node oOperation = oOperationLst.item(i);
            if (!OPERATION.equals(oOperation.getNodeName())) continue;
            NamedNodeMap oAttr = oOperation.getAttributes();
            String strOperationId = oAttr.getNamedItem(ID).getNodeValue();
            NodeList oConditionLst = oOperation.getChildNodes();
            int iConditionCount = oConditionLst.getLength();
            ArrayList<Condition> oConditions = new ArrayList<Condition>();
            for (int j = 0; j < iConditionCount; ++j) {
                Node oConditionNode = oConditionLst.item(j);
                if (!CONDITION.equals(oConditionNode.getNodeName())) continue;
                NamedNodeMap oConditionAttr = oConditionNode.getAttributes();
                Condition condition = new Condition();
                String strConditionName = oConditionAttr.getNamedItem(DEVICE_TYPE_ID).getNodeValue();
                condition.setDeviceTypeId(Integer.valueOf(strConditionName.trim()));
                String strConditionValue = oConditionAttr.getNamedItem(STEP).getNodeValue();
                condition.setControlStep(strConditionValue.trim().split(","));
                oConditions.add(condition);
            }
            this.m_oOprAdapterMap.put(strOperationId, oConditions);
        }
    }

    public static synchronized DeviceOperationAdapter getInstance() {
        if (null == m_instance) {
            m_instance = new DeviceOperationAdapter();
        }
        return m_instance;
    }

    private List<Condition> getConditionValue(String strOprId) {
        return this.m_oOprAdapterMap.get(strOprId);
    }

    public String[] getControlSteps(String strOprId, int iDevTypeId) {
        List<Condition> conLst = this.getConditionValue(strOprId);
        if (null == conLst) {
            return null;
        }
        this.emptyCondition.setDeviceTypeId(iDevTypeId);
        for (Condition condition : conLst) {
            if (!this.emptyCondition.equals(condition)) continue;
            return condition.getControlSteps();
        }
        return null;
    }

    private class Condition {
        private int deviceTypeId;
        private String[] controlStepList;

        private Condition() {
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.getOuterType().hashCode();
            result = 31 * result + this.deviceTypeId;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Condition other = (Condition)obj;
            if (!this.getOuterType().equals(other.getOuterType())) {
                return false;
            }
            return this.deviceTypeId == other.deviceTypeId;
        }

        public int getDeviceTypeId() {
            return this.deviceTypeId;
        }

        public void setDeviceTypeId(int deviceTypeId) {
            this.deviceTypeId = deviceTypeId;
        }

        public String[] getControlSteps() {
            return this.controlStepList;
        }

        public void setControlStep(String ... controlStep) {
            this.controlStepList = controlStep;
        }

        private DeviceOperationAdapter getOuterType() {
            return DeviceOperationAdapter.this;
        }
    }
}

