/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.common.util;

import com.huawei.dc.common.asndatacenter.AsnDCDeviceInfo;
import com.huawei.dc.common.controller.DeviceInfoManagerImpl;
import com.huawei.dc.common.controller.IDeviceInfoManager;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.deviceinfo.DeviceInfo;
import com.huawei.dc.deviceinfo.DeviceTypeInfo;
import com.huawei.dc.devicemanagement.model.DeviceType;
import com.huawei.dc.policy.model.DevicePolicyState;
import com.huawei.dc.policy.model.PolicyInfo;
import com.huawei.dc.taskmgmt.model.ITask;
import com.huawei.dc.taskmgmt.model.Resource;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import gnu.trove.TIntArrayList;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public final class DeviceInfoUtil {
    private DeviceInfoUtil() {
    }

    public static String parseNEIDInt(int iID) {
        String strNEID = null;
        if (65535 < iID) {
            int iSubNetID = 0;
            int iNEid = 0;
            iSubNetID = iID >> 16;
            iNEid = iID & 0xFFFF;
            strNEID = iSubNetID + "-" + iNEid;
        } else {
            strNEID = Integer.valueOf(iID).toString();
        }
        return strNEID;
    }

    public static int parseNEIDStr(String str) {
        int index2;
        if (null == str) {
            return -1;
        }
        String s = str.trim();
        if (s.length() < 1) {
            return -1;
        }
        int index = s.indexOf(45);
        if (index != (index2 = s.lastIndexOf(45))) {
            return -1;
        }
        int subnet = 9;
        int ne = -1;
        int id = -1;
        try {
            String ls;
            String fs;
            if (index > -1) {
                fs = s.substring(0, index);
                ls = s.substring(index + 1);
                if (fs.length() > 9 || ls.length() > 9) {
                    return -1;
                }
            } else {
                if (s.length() > 9) {
                    return -1;
                }
                ne = Integer.parseInt(s);
                if (ne < 1) {
                    return -1;
                }
                return ne;
            }
            subnet = Integer.parseInt(fs);
            ne = Integer.parseInt(ls);
            if (ne < 1) {
                return -1;
            }
            id = (subnet << 16) + ne;
        }
        catch (Exception e) {
            return -1;
        }
        return id;
    }

    public static int getDeviceDomain(ITask parentTask) {
        DeviceType oDeviceType = parentTask.getSelectedDeviceType();
        if (oDeviceType != null) {
            int iDeviceDomain = oDeviceType.getDeviceDomain();
            return iDeviceDomain;
        }
        return 0;
    }

    public static boolean isPTNDevice(int iDeviceTypeID) {
        boolean isPTNDevice = false;
        List<Integer> oPTNDevTypeIDLst = DeviceInfoUtil.getDeviceTypeIDLst("PTN_DEVICE_TYPE_IDS", "config");
        if (oPTNDevTypeIDLst.contains(iDeviceTypeID)) {
            isPTNDevice = true;
        }
        return isPTNDevice;
    }

    public static boolean isCX600Device(int devID) {
        DeviceInfo oDeviceInfo = DeviceInfoManagerImpl.getInstance().getDevice(devID);
        if (null == oDeviceInfo) {
            return false;
        }
        int iDeviceTypeID = oDeviceInfo.getDeviceTypeInfo().getDevTypeID();
        return 1252 == iDeviceTypeID;
    }

    public static List<Integer> getDeviceTypeIDLst(String sKey, String sBundleName) {
        ArrayList<Integer> oDevTypeIDLst = new ArrayList<Integer>(0);
        String sDeviceTypeIDs = ResourceManager.getInstance().getResString(sKey, sBundleName);
        if (null == sDeviceTypeIDs || "".equals(sDeviceTypeIDs) || sKey.equals(sDeviceTypeIDs)) {
            return oDevTypeIDLst;
        }
        String sSourceStr = Normalizer.normalize(sDeviceTypeIDs, Normalizer.Form.NFC);
        String sFormat = Normalizer.normalize("[|]", Normalizer.Form.NFC);
        String[] deviceTypeIDs = sSourceStr.split(sFormat);
        Integer iDevTypeID = null;
        for (int i = 0; i < deviceTypeIDs.length; ++i) {
            if ("".equals(deviceTypeIDs[i])) continue;
            iDevTypeID = Integer.valueOf(deviceTypeIDs[i]);
            oDevTypeIDLst.add(iDevTypeID);
        }
        return oDevTypeIDLst;
    }

    public static void updateUpgradeModeForDevice(Resource oResoruce) {
        if (null == oResoruce) {
            return;
        }
        int iUpgradeMode = oResoruce.getUpgradeMode();
        int iUpgradeModeCfg = oResoruce.getUpgradeModeConfig();
        int iDevID = oResoruce.getDeviceID();
        DeviceInfo oDevInfo = DeviceInfoManagerImpl.getInstance().getDevice(iDevID);
        if (null == oDevInfo) {
            return;
        }
        oDevInfo.setUpgradeMode(iUpgradeMode);
        oDevInfo.setUpgradeModeConfig(iUpgradeModeCfg);
    }

    public static boolean isContainsT2000Devices(DeviceInfo[] oDeviceInfos) {
        boolean bContainsT2000Dev = false;
        if (null == oDeviceInfos || oDeviceInfos.length == 0) {
            return bContainsT2000Dev;
        }
        for (DeviceInfo oDevInfo : oDeviceInfos) {
            if (null == oDevInfo || !oDevInfo.getDeviceTypeInfo().isT2000Domain()) continue;
            return true;
        }
        return bContainsT2000Dev;
    }

    public static boolean isContainsDevices(DeviceTypeInfo[] oDevTypeInfos, int iDevDomain) {
        boolean bContainsT2000Dev = false;
        if (null == oDevTypeInfos || oDevTypeInfos.length == 0) {
            return bContainsT2000Dev;
        }
        int iDeviceDomain = -1;
        for (DeviceTypeInfo oDevTypeInfo : oDevTypeInfos) {
            if (null == oDevTypeInfo || iDevDomain != (iDeviceDomain = oDevTypeInfo.getDevDomain())) continue;
            return true;
        }
        return bContainsT2000Dev;
    }

    public static boolean isSupportUpgradeMode(DeviceInfo oDevInfo, int iUpgradeMode) {
        if (null == oDevInfo) {
            return false;
        }
        return 0 != (oDevInfo.getUpgradeMode() & iUpgradeMode);
    }

    public static String[] getSupportDevTypeIDs(String sSeriesName) {
        String strTmp = ResourceManager.getInstance().getResString(sSeriesName, "config");
        if (!strTmp.equals(sSeriesName)) {
            String[] sDevTypeIDs = strTmp.split("\\|");
            return sDevTypeIDs;
        }
        return null;
    }

    public static boolean isStackDevicePresent(THashSet<Resource> oResources, int checkRoleType) {
        boolean bStackDevcie = false;
        if (null == oResources || oResources.size() == 0) {
            return bStackDevcie;
        }
        for (Resource oRes : oResources) {
            if (checkRoleType != oRes.getRoleType()) continue;
            bStackDevcie = true;
            break;
        }
        return bStackDevcie;
    }

    public static boolean isAllStackDevice(THashSet<Resource> oResources) {
        if (null == oResources || oResources.size() == 0) {
            return false;
        }
        boolean bAllStackDevcie = true;
        for (Resource oRes : oResources) {
            if (3 == oRes.getRoleType()) continue;
            bAllStackDevcie = false;
            break;
        }
        return bAllStackDevcie;
    }

    public static boolean isAllClusterChildDevice(THashSet<Resource> oResources) {
        if (null == oResources || oResources.size() == 0) {
            return false;
        }
        boolean bIsAllClusterDevice = true;
        for (Resource oRes : oResources) {
            if (2 == oRes.getRoleType()) continue;
            bIsAllClusterDevice = false;
            break;
        }
        return bIsAllClusterDevice;
    }

    public static boolean isContainsClusterDevice(THashSet<Resource> oResources) {
        if (null == oResources || oResources.size() == 0) {
            return false;
        }
        boolean bContainsClusterDevice = false;
        IDeviceInfoManager oDevMgr = DeviceInfoManagerImpl.getInstance();
        DeviceInfo oDevInfo = null;
        boolean isClusterNE = false;
        for (Resource oRes : oResources) {
            if (null == oRes || !(isClusterNE = DeviceInfoUtil.isClusterNE(oDevInfo = oDevMgr.getDevice(oRes.getDeviceID())))) continue;
            return true;
        }
        return bContainsClusterDevice;
    }

    public static boolean isClusterNE(DeviceInfo oDevInfo) {
        if (null == oDevInfo) {
            return false;
        }
        DeviceTypeInfo oDevType = oDevInfo.getDeviceTypeInfo();
        if (null == oDevType || !oDevType.isDMSDomain()) {
            return false;
        }
        int iRoleType = oDevInfo.getRoleType();
        return 2 == iRoleType || 1 == iRoleType;
    }

    public static boolean isSNMPProtocol(DeviceInfo oDevInfo) {
        if (null == oDevInfo) {
            return false;
        }
        DeviceTypeInfo oDevType = oDevInfo.getDeviceTypeInfo();
        if (null == oDevType || !oDevType.isDMSDomain()) {
            return false;
        }
        int iUpMode = oDevInfo.getUpgradeMode();
        DCDebugTracer.trace("PatchDetail UpgradeMode:" + iUpMode);
        return 0 != (iUpMode & 0x2000);
    }

    public static List<String> getGatewayIPLst() {
        ArrayList<String> oGatewayIPLst = new ArrayList<String>();
        DeviceInfo[] oDevs = DeviceInfoManagerImpl.getInstance().getDevices();
        if (null == oDevs || oDevs.length == 0) {
            return oGatewayIPLst;
        }
        DeviceInfo oDevInfo = null;
        for (int i = 0; i < oDevs.length; ++i) {
            oDevInfo = oDevs[i];
            if (!oDevInfo.getDeviceTypeInfo().isT2000Domain() || oDevInfo.getRoleType() != 1) continue;
            oGatewayIPLst.add(oDevInfo.getDevIPAddress());
        }
        return oGatewayIPLst;
    }

    public static boolean isTL1Dev(int devId) {
        DeviceInfo deviceInfo = DeviceInfoManagerImpl.getInstance().getDevice(devId);
        if (null == deviceInfo) {
            DCDebugTracer.trace("isTL1Dev:deviceInfo=null.devId=" + devId);
            return false;
        }
        if (4 == deviceInfo.getProtocol()) {
            DCDebugTracer.trace("isTL1Dev:true");
            return true;
        }
        return false;
    }

    public static boolean isDomainDevice(int iDeviceID, int iDomain) {
        boolean bDomainDevice = false;
        DeviceInfo oDevInfo = DeviceInfoManagerImpl.getInstance().getDevice(iDeviceID);
        if (null == oDevInfo) {
            return bDomainDevice;
        }
        DeviceTypeInfo oDevType = oDevInfo.getDeviceTypeInfo();
        if (null == oDevType) {
            return bDomainDevice;
        }
        int iDevDomain = oDevType.getDevDomain();
        return iDevDomain == iDomain;
    }

    public static boolean updateDeviceInfo(PolicyInfo oPolicyInfo, AsnDCDeviceInfo oAsnDCDeviceInfo) {
        if (null == oPolicyInfo || null == oAsnDCDeviceInfo) {
            return false;
        }
        THashMap<Integer, DevicePolicyState> oDevHm = oPolicyInfo.getDevicePolicyStateHm();
        if (null == oDevHm) {
            return false;
        }
        DevicePolicyState oDev = (DevicePolicyState)oDevHm.get((Object)oAsnDCDeviceInfo.iDevId.intValue());
        if (null == oDev) {
            return false;
        }
        String neName = new String(oAsnDCDeviceInfo.strDevName);
        String neIPAdress = new String(oAsnDCDeviceInfo.strDevIPAddress);
        IDeviceInfoManager oDevMgr = DeviceInfoManagerImpl.getInstance();
        DeviceTypeInfo oDevType = null;
        oDevType = oDevMgr.getDeviceTypeInfo(oAsnDCDeviceInfo.iDevTypeId.intValue(), oAsnDCDeviceInfo.iDevTypeVersionId.intValue());
        if (neName.equals(oDev.getNEName()) && neIPAdress.equals(oDev.getIPAdress()) && oDevType.getDevTypeName().equals(oDev.getNETypeName())) {
            return false;
        }
        oDev.setNEName(new String(oAsnDCDeviceInfo.strDevName));
        oDev.setIPAdress(new String(oAsnDCDeviceInfo.strDevIPAddress));
        oDev.setDevTypeID(oAsnDCDeviceInfo.iDevTypeId.intValue());
        oDev.setDevTypeVerID(oAsnDCDeviceInfo.iDevTypeVersionId.intValue());
        if (null != oDevType) {
            oDev.setNETypeName(oDevType.getDevTypeName());
        }
        return true;
    }

    public static TIntArrayList getIDLst(String sKey) {
        String sGroupList = ResourceManager.getInstance().getResString(sKey, "config");
        String[] sGroups = sGroupList.split("[|]");
        TIntArrayList oGroupLst = new TIntArrayList();
        if (sGroupList.equals(sKey)) {
            return oGroupLst;
        }
        int iLen = sGroups.length;
        for (int i = 0; i < iLen; ++i) {
            oGroupLst.add(Integer.valueOf(sGroups[i]).intValue());
        }
        return oGroupLst;
    }

    public static int getDeviceDomain(int iDevId) {
        int iDeviceDomain = -1;
        IDeviceInfoManager oDevInfoMgr = DeviceInfoManagerImpl.getInstance();
        DeviceInfo oDeviceInfo = oDevInfoMgr.getDevice(iDevId);
        DeviceTypeInfo oDeviceTypeInfo = oDeviceInfo.getDeviceTypeInfo();
        iDeviceDomain = oDeviceTypeInfo.getDevDomain();
        return iDeviceDomain;
    }

    public static DeviceInfo[] getDevInfoArrayFromList(THashSet<Resource> oResList) {
        List<DeviceInfo> oDevInfoList = DeviceInfoUtil.getDeviceInfoList(oResList);
        DeviceInfo[] oDevTypeArr = new DeviceInfo[oDevInfoList.size()];
        for (int i = 0; i < oDevInfoList.size(); ++i) {
            oDevTypeArr[i] = oDevInfoList.get(i);
        }
        return oDevTypeArr;
    }

    private static List<DeviceInfo> getDeviceInfoList(THashSet<Resource> oResList) {
        ArrayList<DeviceInfo> oDevInfoList = new ArrayList<DeviceInfo>(0);
        Iterator oResItor = oResList.iterator();
        Resource oRes = null;
        while (oResItor.hasNext()) {
            oRes = (Resource)oResItor.next();
            int iDeviceId = oRes.getDeviceID();
            oDevInfoList.add(DeviceInfoManagerImpl.getInstance().getDevice(iDeviceId));
        }
        return oDevInfoList;
    }
}

