/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.common.util;

import com.huawei.dc.common.components.DCDateChooser;
import com.huawei.dc.configuration.policy.common.PolicyTime;
import com.swimap.external.sf.general.timelocalization.GeneralTimeConvertService;
import com.swimap.imap12.util.dateChooser.InmDateChooser;
import com.swimap.iview.util.format.TimeDateFormatUtil;
import com.swimap.iview.util.format.TimeFormatService;
import java.math.BigInteger;
import java.text.Collator;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;

public class DCTimeDateUtil {
    private static DCDateChooser c_oDateChooser = new DCDateChooser();
    private static InmDateChooser m_oTimeChooser = !DCTimeDateUtil.is12HrFormat() ? new InmDateChooser(6) : new InmDateChooser(14);

    public static Date switchToLocalCalendar(Calendar oCalendar) {
        return GeneralTimeConvertService.switch2LocalCalendar((Calendar)oCalendar);
    }

    public static Date switchToGMTCalendar(Calendar oCalendar) {
        return GeneralTimeConvertService.switch2GMTCalendar((Calendar)oCalendar);
    }

    public static String getLocaleDisplayTime(Calendar oCalender) {
        if (null == oCalender) {
            return null;
        }
        return TimeFormatService.getLocaleString((Calendar)oCalender);
    }

    public static boolean is12HrFormat() {
        return c_oDateChooser.is12_HourLock();
    }

    public static String formatTime(int iHours, int iMinutes, int iSeconds) {
        try {
            boolean bDisplaySeconds = true;
            if (-1 == iSeconds) {
                bDisplaySeconds = false;
                iSeconds = 0;
            }
            Calendar oCal = Calendar.getInstance();
            oCal.set(10, iHours);
            oCal.set(11, iHours);
            oCal.set(12, iMinutes);
            oCal.set(13, iSeconds);
            oCal.set(1, 9999);
            String strFormattedTime = DCTimeDateUtil.getLocaleDisplayTime(oCal);
            if (null == strFormattedTime || "".equals(strFormattedTime)) {
                return "";
            }
            int iStubIndex = strFormattedTime.indexOf(":");
            if (-1 == iStubIndex || iStubIndex < 2) {
                return strFormattedTime;
            }
            String strTime = strFormattedTime.substring(iStubIndex - 2, strFormattedTime.length());
            if (!bDisplaySeconds) {
                int iStringLength = strTime.length();
                String strHrAndMin = strTime.substring(0, 5);
                if (8 < iStringLength) {
                    String strSuffix = strTime.substring(8, iStringLength);
                    strTime = strHrAndMin + strSuffix;
                } else {
                    strTime = strHrAndMin;
                }
            }
            return strTime;
        }
        catch (Exception e) {
            return "";
        }
    }

    public static final String convertLocalPolicyTimeToUTC(String strLocalPolicyTime) {
        if (null == strLocalPolicyTime || strLocalPolicyTime.length() == 0) {
            return "";
        }
        int iHour = -1;
        int iMinute = -1;
        try {
            String strHour = strLocalPolicyTime.substring(0, 2);
            iHour = Integer.parseInt(strHour);
            String strMinute = strLocalPolicyTime.substring(3, 5);
            iMinute = Integer.parseInt(strMinute);
        }
        catch (NumberFormatException e) {
            return "";
        }
        Calendar oCalendar = Calendar.getInstance();
        oCalendar.set(11, iHour);
        oCalendar.set(12, iMinute);
        DCTimeDateUtil.switchToGMTCalendar(oCalendar);
        iHour = oCalendar.get(11);
        iMinute = oCalendar.get(12);
        StringBuffer strUTCPolicyTime = new StringBuffer(5);
        if (iHour < 10 && iMinute < 10) {
            strUTCPolicyTime.append('0').append(iHour).append(':').append('0').append(iMinute);
        }
        if (iHour < 10 && iMinute > 10 || iHour < 10 && iMinute >= 10) {
            strUTCPolicyTime.append('0').append(iHour).append(':').append(iMinute);
        }
        if (iHour > 10 && iMinute < 10 || iHour >= 10 && iMinute < 10) {
            strUTCPolicyTime.append(iHour).append(':').append('0').append(iMinute);
        }
        if (iHour >= 10 && iMinute >= 10) {
            strUTCPolicyTime.append(iHour).append(':').append(iMinute);
        }
        return strUTCPolicyTime.toString();
    }

    public static String convertUTCToLocalTime(String strUTCPolicyTime) {
        if (0 == strUTCPolicyTime.length()) {
            return "";
        }
        int iHour = -1;
        int iMinute = -1;
        try {
            String strHour = strUTCPolicyTime.substring(0, 2);
            iHour = Integer.parseInt(strHour);
            String strMinute = strUTCPolicyTime.substring(3, 5);
            iMinute = Integer.parseInt(strMinute);
        }
        catch (NumberFormatException e) {
            return "";
        }
        Calendar oCalendar = Calendar.getInstance();
        DCTimeDateUtil.switchToGMTCalendar(oCalendar);
        oCalendar.set(11, iHour);
        oCalendar.set(12, iMinute);
        DCTimeDateUtil.switchToLocalCalendar(oCalendar);
        iHour = oCalendar.get(11);
        iMinute = oCalendar.get(12);
        StringBuffer strLocalPolicyTime = new StringBuffer(5);
        if (iHour < 10 && iMinute < 10) {
            strLocalPolicyTime.append('0').append(iHour).append(':').append('0').append(iMinute);
        } else if (iHour < 10 && iMinute > 10 || iHour < 10 && iMinute >= 10) {
            strLocalPolicyTime.append('0').append(iHour).append(':').append(iMinute);
        } else if (iHour > 10 && iMinute < 10 || iHour >= 10 && iMinute < 10) {
            strLocalPolicyTime.append(iHour).append(':').append('0').append(iMinute);
        } else {
            strLocalPolicyTime.append(iHour).append(':').append(iMinute);
        }
        return strLocalPolicyTime.toString();
    }

    public static final String convertTo24HrFormat(String strLocalTime, int iHour) {
        if (null == strLocalTime || strLocalTime.length() == 0) {
            return "";
        }
        if (strLocalTime.endsWith("PM")) {
            int iNewHour = iHour + 12;
            String srtHour = iNewHour + "";
            strLocalTime = strLocalTime.replaceFirst(strLocalTime.substring(0, 2), srtHour);
            strLocalTime = strLocalTime.substring(0, strLocalTime.length() - 3);
        }
        if (strLocalTime.endsWith("AM")) {
            String strHour = strLocalTime.substring(0, 2);
            if (0 == Collator.getInstance().compare(strHour, "12")) {
                strLocalTime = strLocalTime.replaceFirst("12", "00");
            }
            strLocalTime = strLocalTime.substring(0, strLocalTime.length() - 3);
        }
        return strLocalTime;
    }

    public static final String convertTo24HrFormat(String strLocalTime) {
        if (null == strLocalTime || strLocalTime.length() == 0) {
            return "";
        }
        String strHour = strLocalTime.substring(0, 2);
        if (strLocalTime.endsWith(TimeDateFormatUtil.getCurPmFormatSymbol())) {
            int iNewHour = Integer.parseInt(strHour) + 12;
            String srtHour = iNewHour + "";
            strLocalTime = strLocalTime.replaceFirst(strLocalTime.substring(0, 2), srtHour);
            strLocalTime = strLocalTime.substring(0, strLocalTime.length() - 3);
        }
        if (strLocalTime.endsWith(TimeDateFormatUtil.getCurAmFormatSymbol())) {
            if (0 == Collator.getInstance().compare(strHour, "12")) {
                strLocalTime = strLocalTime.replaceFirst("12", "00");
            }
            strLocalTime = strLocalTime.substring(0, strLocalTime.length() - 3);
        }
        return strLocalTime;
    }

    public static final String convertTo12HrFormat(String strTime) {
        if (null == strTime || strTime.length() == 0) {
            return "";
        }
        String strHour = strTime.substring(0, 2);
        int iHour = Integer.parseInt(strHour);
        String strMinute = strTime.substring(3, 5);
        int iMinute = Integer.parseInt(strMinute);
        Calendar oCalObj = GregorianCalendar.getInstance();
        oCalObj.set(6, 1);
        oCalObj.set(11, iHour);
        oCalObj.set(12, iMinute);
        m_oTimeChooser.setCalendar(oCalObj);
        return m_oTimeChooser.getText();
    }

    public static String convertDateToTimeString(Date oDate) {
        if (null == oDate) {
            return "";
        }
        int iHours = oDate.getHours();
        int iMinutes = oDate.getMinutes();
        StringBuffer strDate = new StringBuffer(5);
        if (iHours < 10) {
            strDate.append('0');
        }
        strDate.append(iHours).append(':');
        if (iMinutes < 10) {
            strDate.append('0');
        }
        strDate.append(iMinutes);
        return strDate.toString();
    }

    public static Date convertTimeStringToDate(String strTime) {
        if (null == strTime || "".equals(strTime)) {
            return new Date();
        }
        String strHour = strTime.substring(0, 2);
        int iHours = Integer.parseInt(strHour);
        String strMinute = strTime.substring(3, 5);
        int iMinutes = Integer.parseInt(strMinute);
        Date oDate = new Date();
        oDate.setHours(iHours);
        oDate.setMinutes(iMinutes);
        return oDate;
    }

    public static void cleanUp() {
        c_oDateChooser = null;
    }

    public static final PolicyTime convertLocalPolicyTimeToUTC(PolicyTime oLocalPolicyTime) {
        if (null == oLocalPolicyTime) {
            return null;
        }
        int iHour = -1;
        int iMinute = -1;
        int iWeekDay = -1;
        try {
            String strHour = oLocalPolicyTime.getTime().substring(0, 2);
            iHour = Integer.parseInt(strHour);
            String strMinute = oLocalPolicyTime.getTime().substring(3, 5);
            iMinute = Integer.parseInt(strMinute);
        }
        catch (NumberFormatException e) {
            return null;
        }
        iWeekDay = oLocalPolicyTime.getWeekDay() + 1;
        Calendar oCalendar = Calendar.getInstance();
        if (-1 != iWeekDay) {
            oCalendar.set(7, iWeekDay);
        }
        oCalendar.set(11, iHour);
        oCalendar.set(12, iMinute);
        DCTimeDateUtil.switchToGMTCalendar(oCalendar);
        iHour = oCalendar.get(11);
        iMinute = oCalendar.get(12);
        if (-1 != iWeekDay) {
            iWeekDay = oCalendar.get(7) - 1;
        }
        StringBuffer strUTCPolicyTime = new StringBuffer(5);
        if (iHour < 10 && iMinute < 10) {
            strUTCPolicyTime.append('0').append(iHour).append(':').append('0').append(iMinute);
        }
        if (iHour < 10 && iMinute > 10 || iHour < 10 && iMinute >= 10) {
            strUTCPolicyTime.append('0').append(iHour).append(':').append(iMinute);
        }
        if (iHour > 10 && iMinute < 10 || iHour >= 10 && iMinute < 10) {
            strUTCPolicyTime.append(iHour).append(':').append('0').append(iMinute);
        }
        if (iHour >= 10 && iMinute >= 10) {
            strUTCPolicyTime.append(iHour).append(':').append(iMinute);
        }
        PolicyTime oNewTime = new PolicyTime();
        oNewTime.setTime(strUTCPolicyTime.toString());
        oNewTime.setWeekDay(iWeekDay);
        return oNewTime;
    }

    public static PolicyTime convertUTCToLocalTime(PolicyTime oUTCPolicyTime) {
        if (null == oUTCPolicyTime) {
            return null;
        }
        int iHour = -1;
        int iMinute = -1;
        int iWeekDay = -1;
        try {
            String strHour = oUTCPolicyTime.getTime().substring(0, 2);
            iHour = Integer.parseInt(strHour);
            String strMinute = oUTCPolicyTime.getTime().substring(3, 5);
            iMinute = Integer.parseInt(strMinute);
        }
        catch (NumberFormatException e) {
            return null;
        }
        if (-1 != oUTCPolicyTime.getWeekDay()) {
            iWeekDay = oUTCPolicyTime.getWeekDay() + 1;
        }
        Calendar oCalendar = Calendar.getInstance();
        DCTimeDateUtil.switchToGMTCalendar(oCalendar);
        oCalendar.set(11, iHour);
        oCalendar.set(12, iMinute);
        if (-1 != iWeekDay) {
            oCalendar.set(7, iWeekDay);
        }
        DCTimeDateUtil.switchToLocalCalendar(oCalendar);
        iHour = oCalendar.get(11);
        iMinute = oCalendar.get(12);
        if (-1 != iWeekDay) {
            iWeekDay = oCalendar.get(7) - 1;
        }
        StringBuffer strLocalPolicyTime = new StringBuffer(5);
        if (iHour < 10 && iMinute < 10) {
            strLocalPolicyTime.append('0').append(iHour).append(':').append('0').append(iMinute);
        } else if (iHour < 10 && iMinute > 10 || iHour < 10 && iMinute >= 10) {
            strLocalPolicyTime.append('0').append(iHour).append(':').append(iMinute);
        } else if (iHour > 10 && iMinute < 10 || iHour >= 10 && iMinute < 10) {
            strLocalPolicyTime.append(iHour).append(':').append('0').append(iMinute);
        } else {
            strLocalPolicyTime.append(iHour).append(':').append(iMinute);
        }
        PolicyTime oNewTime = new PolicyTime();
        oNewTime.setTime(strLocalPolicyTime.toString());
        oNewTime.setWeekDay(iWeekDay);
        return oNewTime;
    }

    public static BigInteger getRandomReqId() {
        Date oTimeStamp = new Date();
        SimpleDateFormat oTimeStampFormat = new SimpleDateFormat("MMddHHmmss");
        String date = oTimeStampFormat.format(oTimeStamp);
        return new BigInteger(date);
    }
}

