/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.common.util;

import com.huawei.dc.common.framework.utility.ConfigurationInfo;
import com.swimap.iview.commstyle.resource.ResourceMng;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DCParsePackageXmlUtil {
    private static DCParsePackageXmlUtil m_instance;
    private String m_strPackageName = " ";
    private String m_strVersion = " ";
    private String m_strClassPath = "";

    private DCParsePackageXmlUtil() {
        this.init();
    }

    public static synchronized DCParsePackageXmlUtil getInstance() {
        if (null == m_instance) {
            m_instance = new DCParsePackageXmlUtil();
        }
        return m_instance;
    }

    private void init() {
        String strStyledir = ConfigurationInfo.getInstance().getProductStyleDir();
        String strAboutDirectoryName = strStyledir + "conf" + "/" + "about/DC_package.xml";
        String strAboutDirectoryNameBak = strStyledir + "conf" + "/" + "about/DC_package_patch.xml";
        Document oDocument = ConfigurationInfo.getInstance().loadDocumentFromFile(strAboutDirectoryName);
        if (null == oDocument) {
            oDocument = ConfigurationInfo.getInstance().loadDocumentFromFile(strAboutDirectoryNameBak);
        }
        if (null != oDocument) {
            this.m_strPackageName = this.getPackageName(oDocument);
            this.m_strVersion = this.getPackageVersion(oDocument);
            this.m_strClassPath = this.getAboutDlgClassPath(oDocument);
        }
    }

    private String getPackageVersion(Document oDocument) {
        String strPckVersion = " ";
        NodeList oNodeList = null;
        Node oNode = null;
        String strLanguage = ConfigurationInfo.getInstance().getLocale().getLanguage().toUpperCase(ResourceMng.getInstance().getLocale());
        Element oRootNode = oDocument.getDocumentElement();
        oNodeList = this.getNodeList(oRootNode, "AREADESC");
        oNode = this.getNodebyAttributeValue(oNodeList, "areaname", "Package");
        oNodeList = this.getNodeList((Element)oNode, "DESC");
        oNode = this.getNodebyAttributeValue(oNodeList, "descname", "package_version");
        oNodeList = this.getNodeList((Element)oNode, "PARAS");
        oNode = oNodeList.item(0);
        oNodeList = this.getNodeList((Element)oNode, "PARA");
        oNode = this.getNodebyAttributeValue(oNodeList, "name", "DISPLAYNAME_" + strLanguage);
        strPckVersion = this.getNodeValue(oNode, "value");
        return strPckVersion;
    }

    private String getPackageName(Document oDocument) {
        String strPckName = " ";
        NodeList oNodeList = null;
        Node oNode = null;
        String strLanguage = ConfigurationInfo.getInstance().getLocale().getLanguage().toUpperCase(ResourceMng.getInstance().getLocale());
        Element oRootNode = oDocument.getDocumentElement();
        oNodeList = this.getNodeList(oRootNode, "AREADESC");
        oNode = this.getNodebyAttributeValue(oNodeList, "areaname", "Package");
        oNodeList = this.getNodeList((Element)oNode, "DESC");
        oNode = this.getNodebyAttributeValue(oNodeList, "descname", "package_name");
        oNodeList = this.getNodeList((Element)oNode, "PARAS");
        oNode = oNodeList.item(0);
        oNodeList = this.getNodeList((Element)oNode, "PARA");
        oNode = this.getNodebyAttributeValue(oNodeList, "name", "DISPLAYNAME_" + strLanguage);
        strPckName = this.getNodeValue(oNode, "value");
        return strPckName;
    }

    private String getAboutDlgClassPath(Document oDocument) {
        String strClassName = "";
        NodeList oNodeList = null;
        Node oNode = null;
        Element oRootNode = oDocument.getDocumentElement();
        oNodeList = this.getNodeList(oRootNode, "AREADESC");
        oNode = this.getNodebyAttributeValue(oNodeList, "areaname", "Package");
        oNodeList = this.getNodeList((Element)oNode, "DESC");
        oNode = this.getNodebyAttributeValue(oNodeList, "descname", "about_dialog_class_path");
        oNodeList = this.getNodeList((Element)oNode, "PARAS");
        oNode = oNodeList.item(0);
        oNodeList = this.getNodeList((Element)oNode, "PARA");
        oNode = this.getNodebyAttributeValue(oNodeList, "name", "classpath");
        strClassName = this.getNodeValue(oNode, "value");
        return strClassName;
    }

    private Node getNodebyAttributeValue(NodeList oNodeList, String strAttributeName, String strAttributValue) {
        Node oNode = null;
        for (int index = 0; index < oNodeList.getLength(); ++index) {
            oNode = oNodeList.item(index);
            String strNodeValue = this.getNodeValue(oNode, strAttributeName);
            if (!strNodeValue.equals(strAttributValue)) continue;
            return oNode;
        }
        return null;
    }

    private NodeList getNodeList(Element oElement, String strTagName) {
        NodeList oNodeList = oElement.getElementsByTagName(strTagName);
        return oNodeList;
    }

    private String getNodeValue(Node oNode, String strAttributeName) {
        String strNodeValue = " ";
        if (null != oNode) {
            NamedNodeMap NodeValueMap = oNode.getAttributes();
            Node oNodevalue = NodeValueMap.getNamedItem(strAttributeName);
            strNodeValue = oNodevalue.getNodeValue();
        }
        return strNodeValue;
    }

    public String getPackageName() {
        return this.m_strPackageName;
    }

    public String getPackageVersion() {
        return this.m_strVersion;
    }

    public String getAboutDlgClassPath() {
        return this.m_strClassPath;
    }
}

