/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.common.util;

import com.huawei.dc.common.framework.utility.ConfigurationInfo;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.u2000.framework.help.HelpUtil;
import com.huawei.u2000.framework.help.HelpWindowManager;
import com.swimap.iview.util.helpmanagement.HelpManager;
import java.awt.Component;
import java.io.File;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class DCHelpManager {
    static final String HEDEX_IP = "hedexWebIP";
    static final String CONFIG_IP = "server_IP";
    static final String HEDEX_PORT = "hedexWebPort";
    static final String CONFIG_PORT = "server_port";
    static final String HEDEX_WEBHOST = "webhost";
    private static final String HELP_DIR_CN = "client" + File.separator + "help" + File.separator + "hedex" + File.separator + "Chinese";
    private static final String HELP_DIR_US = "client" + File.separator + "help" + File.separator + "hedex" + File.separator + "English";
    private static final String HELP_START_PROCESS = "startup";
    private static DCHelpManager m_oInstance;
    private Process m_ohelpProcess;
    private String helpProcessName = null;

    private DCHelpManager() {
        this.getHelpProcessName();
    }

    public static synchronized DCHelpManager getInstance() {
        if (null == m_oInstance) {
            m_oInstance = new DCHelpManager();
        }
        return m_oInstance;
    }

    public void enableHelpKey(Component comp, String helpID) {
        if (DCFrameWorkUtil.isHelpIDFormSA()) {
            this.helpInChmStyle(comp, helpID);
        } else {
            HelpManager.getInstance().enableHelpKey(comp, helpID);
        }
    }

    public void enableF1HelpKey(Component comp, String helpID) {
        if (DCFrameWorkUtil.isHelpIDFormSA()) {
            this.helpInChmStyle(comp, helpID);
        } else {
            com.huawei.u2000.framework.help.HelpManager.getInstance().enableF1HelpKey(comp, helpID);
        }
    }

    public void setSystemProperty() throws Exception {
        System.setProperty(HEDEX_IP, this.getAttributeValue(this.getHelpProcessName(), CONFIG_IP));
        System.setProperty(HEDEX_PORT, this.getAttributeValue(this.getHelpProcessName(), CONFIG_PORT));
        System.setProperty("hedexWebProtocol", "http");
        if (DCFrameWorkUtil.isHelpIDFormSA()) {
            String webhost = System.getProperty("hedexWebProtocol") + "://" + System.getProperty(HEDEX_IP) + ":" + System.getProperty(HEDEX_PORT) + "/hdx.cgi?fe=0&lib=dc&v=01&homepage=";
            System.setProperty(HEDEX_WEBHOST, webhost);
            System.setProperty("homepage", webhost);
        }
        HelpUtil.initWebrenderer();
        HelpWindowManager.getInstance();
    }

    private String getAttributeValue(String path, String attribute) throws Exception {
        String attributeValue = null;
        DocumentBuilderFactory dcbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder dcb = dcbf.newDocumentBuilder();
        Document dc = dcb.parse(new File(path + File.separator + "config.xml"));
        NodeList nl = dc.getElementsByTagName(attribute);
        int len = nl.getLength();
        for (int i = 0; i < len; ++i) {
            Element em = (Element)nl.item(i);
            attributeValue = em.getAttribute("value");
        }
        return attributeValue;
    }

    public void startHedExServer() throws Exception {
        this.m_ohelpProcess = Runtime.getRuntime().exec(this.helpProcessName + HELP_START_PROCESS + " -start DC");
    }

    public void stopHedExServer() throws Exception {
        if (null != this.m_ohelpProcess) {
            this.m_ohelpProcess = Runtime.getRuntime().exec(this.helpProcessName + HELP_START_PROCESS + " -stop DC");
        }
    }

    private String getHelpProcessName() {
        String strCurrPath = this.getiMapInstallationPath();
        ConfigurationInfo m_ogetConfigurationInfo = ConfigurationInfo.getInstance();
        StringBuffer temp = new StringBuffer();
        temp.append(m_ogetConfigurationInfo.getLocale().getLanguage());
        temp.append("_");
        temp.append(m_ogetConfigurationInfo.getLocale().getCountry());
        String local = temp.toString();
        if ("zh_CN".equals(local)) {
            this.helpProcessName = strCurrPath + File.separator + HELP_DIR_CN + File.separator;
        } else if ("en_US".equals(local)) {
            this.helpProcessName = strCurrPath + File.separator + HELP_DIR_US + File.separator;
        }
        return this.helpProcessName;
    }

    public String getiMapInstallationPath() {
        File oCurrDir = new File(".");
        File oDC_Cli_Lib = new File(oCurrDir.getAbsolutePath());
        File oDC_Cli = oDC_Cli_Lib.getParentFile();
        if (null == oDC_Cli) {
            return "";
        }
        File oIMap = oDC_Cli.getParentFile();
        if (null == oIMap) {
            return "";
        }
        return oIMap.getAbsolutePath();
    }

    private void helpInChmStyle(Component comp, String helpID) {
        String strHelpID = "resources/concept/cp_fast_entrance.html";
        HelpManager.getInstance().enableHelpKey(comp, strHelpID);
    }
}

