/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.common.util;

import com.huawei.dc.common.asndatacenter.ASNDCFileInfoStruct;
import com.huawei.dc.common.asndatacenter.AsnDCGetDirReq;
import com.huawei.dc.common.asndatacenter.AsnDCGetDirRsp;
import com.huawei.dc.common.controller.BaseCommManager;
import com.huawei.dc.common.framework.system.SystemManager;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.DCOptionPane;
import com.swimap.iview.util.SyncCommand;
import java.awt.Component;
import net.commustru.fstru.FStruct;

public class DCFileSystemUtil {
    public static final char FILE_SEPARATOR_CHAR = '/';
    public static final String FILE_SEPARATOR = "/";

    public static String[] getDirectoriesFromServerPath(String strFilePath) {
        int returnCode;
        if (null == strFilePath) {
            return new String[0];
        }
        final BaseCommManager commManager = DCFrameWorkUtil.getCommManager();
        final AsnDCGetDirReq dirGetReq = new AsnDCGetDirReq();
        dirGetReq.strRootPath = strFilePath.getBytes();
        dirGetReq.oDeviceOperationType.value = 10;
        final AsnDCGetDirRsp dirRsp = new AsnDCGetDirRsp();
        SyncCommand syncCommand = new SyncCommand(){

            public Object call() throws Exception {
                int errorcode = commManager.sendSyncMsg(BaseCommManager.getMSGHead(43842), (FStruct)dirGetReq, (FStruct)dirRsp);
                return errorcode;
            }
        };
        syncCommand.startCall((Component)DCFrameWorkUtil.getMainFrame(), true);
        if (syncCommand.getResult() != null && (returnCode = ((Integer)syncCommand.getResult()).intValue()) != 0) {
            DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), returnCode, ResourceManager.getInstance().getResString("ERROR"), 0);
            return new String[0];
        }
        if (dirRsp.oErrorInfo.iErrorNo.intValue() != 0) {
            DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), dirRsp.oErrorInfo.iErrorNo.intValue(), ResourceManager.getInstance().getResString("ERROR"), 0);
            return new String[0];
        }
        int iDirCount = dirRsp.oDirectories.size();
        String[] arrDirectories = new String[iDirCount];
        for (int i = 0; i < iDirCount; ++i) {
            arrDirectories[i] = new String((byte[])dirRsp.oDirectories.get(i));
        }
        return arrDirectories;
    }

    public static String[] getFilesFromServerPath(String strFilePath) {
        int returnCode;
        if (null == strFilePath) {
            return new String[0];
        }
        final BaseCommManager commManager = DCFrameWorkUtil.getCommManager();
        final AsnDCGetDirReq dirGetReq = new AsnDCGetDirReq();
        dirGetReq.strRootPath = strFilePath.getBytes();
        dirGetReq.oDeviceOperationType.value = 10;
        final AsnDCGetDirRsp dirRsp = new AsnDCGetDirRsp();
        SyncCommand syncCommand = new SyncCommand(){

            public Object call() throws Exception {
                int errorcode = commManager.sendSyncMsg(BaseCommManager.getMSGHead(43842), (FStruct)dirGetReq, (FStruct)dirRsp);
                return errorcode;
            }
        };
        syncCommand.startCall((Component)DCFrameWorkUtil.getMainFrame(), true);
        if (syncCommand.getResult() != null && (returnCode = ((Integer)syncCommand.getResult()).intValue()) != 0) {
            DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), returnCode, ResourceManager.getInstance().getResString("ERROR"), 0);
            return new String[0];
        }
        if (dirRsp.oErrorInfo.iErrorNo.intValue() != 0) {
            DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), dirRsp.oErrorInfo.iErrorNo.intValue(), ResourceManager.getInstance().getResString("ERROR"), 0);
            return new String[0];
        }
        int iFileCount = dirRsp.oFiles.size();
        String[] arrFiles = new String[iFileCount];
        ASNDCFileInfoStruct oFileInfo = null;
        for (int i = 0; i < iFileCount; ++i) {
            oFileInfo = (ASNDCFileInfoStruct)dirRsp.oFiles.get(i);
            arrFiles[i] = new String(oFileInfo.strFilename);
        }
        return arrFiles;
    }

    public static String getPathRelativeToRoot(String strAbsolutePath) {
        String strRelativePath = strAbsolutePath;
        SystemManager sysMgr = new SystemManager();
        String strSystemRootDir = sysMgr.getFTSInfo().getRootDirectory();
        if (null == strAbsolutePath || "".equals(strAbsolutePath) || null == strSystemRootDir || "".equals(strSystemRootDir)) {
            return strRelativePath;
        }
        if (!(strSystemRootDir = DCFileSystemUtil.normalizePath(strSystemRootDir)).endsWith(FILE_SEPARATOR)) {
            strSystemRootDir = strSystemRootDir + FILE_SEPARATOR;
        }
        if ((strAbsolutePath = DCFileSystemUtil.normalizePath(strAbsolutePath)).startsWith(strSystemRootDir)) {
            strRelativePath = strAbsolutePath.replaceFirst(strSystemRootDir, "");
        }
        return strRelativePath;
    }

    public static String getParentDirectory(String strPath) {
        if (null == strPath || "".equals(strPath) || 0 > strPath.lastIndexOf(47) || strPath.length() <= strPath.lastIndexOf(47)) {
            return "";
        }
        int iLastIndex = strPath.lastIndexOf(47);
        return strPath.substring(0, iLastIndex);
    }

    public static String normalizePath(String strPath) {
        if (null != strPath) {
            strPath = strPath.replace('\\', '/');
        }
        return strPath;
    }

    public static String getAbsolutePath(String strRelativePath) {
        SystemManager sysMgr = new SystemManager();
        String strSystemRootDir = sysMgr.getFTSInfo().getRootDirectory();
        if (null == strSystemRootDir || "".equals(strSystemRootDir)) {
            return strRelativePath;
        }
        strSystemRootDir = DCFileSystemUtil.normalizePath(strSystemRootDir);
        if (null == strRelativePath || "".equals(strRelativePath)) {
            return strSystemRootDir;
        }
        strRelativePath = DCFileSystemUtil.normalizePath(strRelativePath);
        if (!strSystemRootDir.endsWith(FILE_SEPARATOR)) {
            strSystemRootDir = strSystemRootDir + '/';
        }
        String strAbsolutePath = strSystemRootDir + strRelativePath;
        return strAbsolutePath;
    }
}

