/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.common.util;

import com.huawei.dc.common.framework.utility.ConfigurationInfo;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.IOStreamClose;
import java.awt.AWTException;
import java.awt.Cursor;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.io.FileInputStream;
import java.io.Serializable;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import sun.security.action.GetPropertyAction;

public class DCCursor
implements Serializable {
    private static final long serialVersionUID = -6882612477460083331L;
    private static Boolean headless;
    private static final Hashtable DCCursors;
    private static final String DCCursorDirPrefix;
    private static final String DCCursorPropertiesFile;
    private static Properties DCCursorProperties;
    private static final String CursorDotPrefix = "Cursor.";
    private static final String DotFileSuffix = ".File";
    private static final String DotHotspotSuffix = ".HotSpot";
    private static final String DotNameSuffix = ".Name";

    private static String initCursorDir() {
        String localeDirectory = ConfigurationInfo.getInstance().getLocaleSpecficDirectory();
        return localeDirectory + "images" + "/";
    }

    private static boolean getHeadlessProperty() {
        if (null == headless) {
            String nm = AccessController.doPrivileged(new GetPropertyAction("java.awt.headless", "false"));
            headless = nm.equals("true") ? Boolean.TRUE : Boolean.FALSE;
        }
        return headless;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadDCCursorProperties() throws AWTException {
        Hashtable hashtable = DCCursors;
        synchronized (hashtable) {
            DCCursorProperties = new Properties();
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public Object run() throws Exception {
                        FileInputStream oFileInputStream = null;
                        try {
                            oFileInputStream = new FileInputStream(DCCursorPropertiesFile);
                            DCCursorProperties.load(oFileInputStream);
                        }
                        catch (Throwable throwable) {
                            IOStreamClose.closeInputStream(oFileInputStream);
                            throw throwable;
                        }
                        IOStreamClose.closeInputStream(oFileInputStream);
                        return null;
                    }
                });
            }
            catch (Exception e) {
                DCDebugTracer.trace("Exception: " + e.getClass() + " " + e.getMessage() + " occurred while loading: " + DCCursorPropertiesFile);
                throw new AWTException("Exception: " + e.getClass() + " " + e.getMessage() + " occurred while loading: " + DCCursorPropertiesFile);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Cursor getSystemCustomCursor(String name) throws AWTException, HeadlessException {
        if (DCCursor.getHeadlessProperty()) {
            throw new HeadlessException();
        }
        Cursor cursor = (Cursor)DCCursors.get(name);
        if (null != cursor) {
            return cursor;
        }
        Hashtable hashtable = DCCursors;
        synchronized (hashtable) {
            if (null == DCCursorProperties) {
                DCCursor.loadDCCursorProperties();
            }
        }
        String prefix = CursorDotPrefix + name;
        String key = prefix + DotFileSuffix;
        if (!DCCursorProperties.containsKey(key)) {
            DCDebugTracer.trace("Cursor.getSystemCustomCursor(" + name + ") returned null");
            return null;
        }
        String hotspot = DCCursorProperties.getProperty(prefix + DotHotspotSuffix);
        if (null == hotspot) {
            throw new AWTException("no hotspot property defined for cursor: " + name);
        }
        StringTokenizer st = new StringTokenizer(hotspot, ",");
        if (st.countTokens() != 2) {
            throw new AWTException("failed to parse hotspot property for cursor: " + name);
        }
        int xPoint = 0;
        int yPoint = 0;
        try {
            xPoint = Integer.valueOf(st.nextToken());
            yPoint = Integer.valueOf(st.nextToken());
        }
        catch (NumberFormatException nfe) {
            throw new AWTException("failed to parse hotspot property for cursor: " + name);
        }
        final String fileName = DCCursorProperties.getProperty(key);
        String localized = DCCursorProperties.getProperty(prefix + DotNameSuffix);
        if (null == localized) {
            localized = name;
        }
        try {
            final int x = xPoint;
            final int y = yPoint;
            final String flocalized = localized;
            cursor = (Cursor)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    Toolkit toolkit = Toolkit.getDefaultToolkit();
                    Image image = toolkit.getImage(DCCursorDirPrefix + fileName);
                    return toolkit.createCustomCursor(image, new Point(x, y), flocalized);
                }
            });
        }
        catch (Exception e) {
            throw new AWTException("Exception: " + e.getClass() + " " + e.getMessage() + " occurred while creating cursor " + name);
        }
        if (null != cursor) {
            DCCursors.put(name, cursor);
        }
        return cursor;
    }

    static {
        DCCursors = new Hashtable(1);
        DCCursorDirPrefix = DCCursor.initCursorDir();
        DCCursorPropertiesFile = DCCursorDirPrefix + "cursors.properties";
        DCCursorProperties = null;
    }
}

