/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.common.util;

import com.huawei.dc.common.controller.DeviceInfoManagerImpl;
import com.huawei.dc.common.controller.IDeviceInfoManager;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.ComboBoxWithToolTip;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.DCHelpForErrCodeUtil;
import com.huawei.dc.common.util.StringUtils;
import com.huawei.dc.deviceinfo.DeviceInfo;
import com.huawei.dc.deviceinfo.DeviceTypeInfo;
import com.huawei.dc.devicemanagement.deviceoperation.ITaskDeviceOperation;
import com.huawei.dc.devicemanagement.deviceoperation.LoadFileInfo;
import com.huawei.dc.devicemanagement.deviceoperation.LoadFileInfoListParam;
import com.huawei.dc.devicemanagement.model.ContentType;
import com.huawei.dc.framework.ErrorCodeReader;
import com.huawei.dc.taskmgmt.model.ITask;
import com.huawei.dc.taskmgmt.model.Resource;
import com.swimap.external.cbb.baseutil.CipherCommon;
import gnu.trove.THashSet;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.math.BigInteger;
import java.text.MessageFormat;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import javax.swing.ImageIcon;
import javax.swing.JTable;
import javax.swing.table.TableColumn;

public class DCCommonUtil {
    private static final String FDN_PREFIX = "NE=";
    private static final String GREEN_COLOR_STR = "<html><p color=\"4AB550\">{0}{1}{2}</p></html>";
    private static final String COLOR_STR_FOR_SUCCESS_MSG = "<html><p color=\"FF9900\">{0}{1}{2}</p></html>";
    private static final String HYPERLINK = "<html>{0}{1}<a href=\"\">{2}</a></html>";
    private static final String HYPERLINK_ONE = "<html><a href=\"\">{0}</a></html>";
    private static final int ICON_SPACE_HEIGHT = 2;
    public static final int MAXICON_HEIGHT = 16;
    public static final int MAXICON_WIDTH = 16;
    private static final String RED_COLOR_STR = "<html><p color=\"C4302D\">{0}{1}{2}</p></html>";
    private static final String RED_COLOR_STR_ONE = "<html><p color=\"C4302D\">{0}</p></html>";
    private static final String OVER_TIME_COLOR = "<html><p color=\"DE9522\">{0}{1}{2}</p></html>";
    private static final int SMALLICON_HEIGHT = 11;
    private static final int SMALLICON_WIDTH = 12;
    private static int ACTIVATE_DATABASE = 25;
    private static int RECOVER = 10;
    private static int RECOVER_FROM_CLIENT = 11;
    public static final int MAXICON_STACK_WIDTH = 23;
    public static final int MAXICON_STACK_HEIGHT = 15;
    static List<Integer> TL1_NE_TYPE_LIST = new ArrayList<Integer>();
    private static HashSet<String> m_oExtendForSpecialDevTypeLst;
    private static HashSet<String> m_oNGWDMandMSTPDevTypeLst;
    private static HashSet<String> m_oPTNandRTNDevTypeLst;

    private static HashSet<String> initConfDevTypeLst(String key) {
        HashSet<String> oDevTypeLst = new HashSet<String>();
        String sGroupList = ResourceManager.getInstance().getResString(key, "config");
        String[] sGroups = sGroupList.split("[|]");
        int iLen = sGroups.length;
        for (int i = 0; i < iLen; ++i) {
            oDevTypeLst.add(sGroups[i]);
        }
        return oDevTypeLst;
    }

    public static String[] breakPatchTargetVersion(String targetVer) {
        if (StringUtils.isNullOrEmptyStr(targetVer)) {
            return null;
        }
        int FIX_LENGTH = 2;
        boolean VER_INDEX = false;
        boolean PATCH_INDEX = true;
        String[] verInfo = new String[2];
        int index = targetVer.lastIndexOf("_");
        if (-1 != index) {
            verInfo[0] = targetVer.substring(0, index);
            verInfo[1] = targetVer.substring(index + "_".length(), targetVer.length());
        } else {
            verInfo[0] = targetVer;
            verInfo[1] = null;
        }
        return verInfo;
    }

    public static String convertByteArrayToStr(byte[] oData) {
        if (null == oData || 0 >= oData.length) {
            return "";
        }
        return new String(oData);
    }

    public static char[] convertByteArrayToChar(byte[] oData) {
        if (null == oData || 0 >= oData.length) {
            return "".toCharArray();
        }
        return CipherCommon.encodePlainText((byte[])oData);
    }

    public static String convertCharArrayToStr(char[] oData) {
        if (null == oData || 0 >= oData.length) {
            return "";
        }
        return String.valueOf(oData);
    }

    public static String convertDevIDToFDN(Integer devId) {
        return FDN_PREFIX + devId.toString();
    }

    public static Image getComposedImage(Image connImage, Image nodeImage, Color nodeColor, Color bgColor, int maxWidth, int maxHight) {
        BufferedImage tempBufImage = new BufferedImage(maxWidth, maxHight, 1);
        Graphics2D bufImageGraphic = (Graphics2D)tempBufImage.getGraphics();
        bufImageGraphic.setBackground(Color.RED);
        bufImageGraphic.clearRect(0, 0, maxWidth, maxHight);
        bufImageGraphic.drawImage(new ImageIcon(nodeImage).getImage(), 0, 2, maxWidth, maxHight, null, null);
        bufImageGraphic.drawImage(connImage, 0, 2, 12, 11, null, null);
        tempBufImage.flush();
        int c = tempBufImage.getRGB(1, 1);
        BufferedImage bufImage = new BufferedImage(maxWidth, maxHight, 6);
        for (int i = 0; i < maxWidth; ++i) {
            for (int j = 0; j < maxHight; ++j) {
                if (tempBufImage.getRGB(i, j) == c) {
                    bufImage.setRGB(i, j, c & 0xFFFFFF);
                    continue;
                }
                bufImage.setRGB(i, j, tempBufImage.getRGB(i, j));
            }
        }
        bufImage.flush();
        return bufImage;
    }

    public static Integer getConfigMaxNum(String key, Integer oDefaultValue) {
        Integer iConfigMaxNum = -1;
        try {
            String strCheckItemMaxNum = ResourceManager.getInstance().getResString(key, "config");
            iConfigMaxNum = Integer.valueOf(strCheckItemMaxNum);
        }
        catch (NumberFormatException nfe) {
            iConfigMaxNum = oDefaultValue;
        }
        return iConfigMaxNum;
    }

    public static String getFailureStr(String strOprName, int iErrorCode) {
        String strErrMsg = ErrorCodeReader.getInstance().getErrorDesc(BigInteger.valueOf(iErrorCode));
        if (995098636 == iErrorCode) {
            DCDebugTracer.trace("======strOprName:" + strOprName + ", iErrorCode:" + iErrorCode);
            return DCCommonUtil.getFailureStr(strOprName, strErrMsg);
        }
        if (DCHelpForErrCodeUtil.isShowHyperlink(iErrorCode)) {
            return DCCommonUtil.getHyperlinkStr(strOprName, strErrMsg);
        }
        if (989859230 == iErrorCode) {
            return DCCommonUtil.getFormatStr(OVER_TIME_COLOR, strOprName, strErrMsg);
        }
        return DCCommonUtil.getFailureStr(strOprName, strErrMsg);
    }

    public static String getFailureStr(String strOprName, String strDetails) {
        if (StringUtils.isNullOrEmptyStr(strOprName)) {
            return DCCommonUtil.getFormatStr(RED_COLOR_STR_ONE, strDetails);
        }
        return DCCommonUtil.getFormatStr(RED_COLOR_STR, strOprName, strDetails);
    }

    private static String getFormatStr(String strPattern, String sErrorInfo) {
        String[] strPara = new String[]{sErrorInfo};
        String strReturn = MessageFormat.format(strPattern, strPara);
        return strReturn;
    }

    private static String getFormatStr(String strPattern, String strOprName, String strDetails) {
        String[] strPara = new String[]{strOprName, " : ", strDetails};
        if (null == strOprName || "".equals(strOprName.trim())) {
            strPara = new String[]{"", "", strDetails};
        }
        String strReturn = MessageFormat.format(strPattern, strPara);
        return strReturn;
    }

    public static String getHyperlinkStr(String strOprName, String strDetails) {
        if (StringUtils.isNullOrEmptyStr(strOprName)) {
            return DCCommonUtil.getFormatStr(HYPERLINK_ONE, strDetails);
        }
        return DCCommonUtil.getFormatStr(HYPERLINK, strOprName, strDetails);
    }

    public static List<LoadFileInfo> getLoadFileInfo(LoadFileInfoListParam oLoadFileParam, int iFileSelectLevlel) {
        ArrayList<LoadFileInfo> fileLst = new ArrayList<LoadFileInfo>(0);
        List<LoadFileInfo> oAllFileInfo = oLoadFileParam.getLoadFileInfoList();
        LoadFileInfo oLoadFileInfo = null;
        int iSize = oAllFileInfo.size();
        boolean haveSomeFile = false;
        for (int i = 0; i < iSize; ++i) {
            oLoadFileInfo = oAllFileInfo.get(i);
            DeviceTypeInfo oDevTypeInfo = oLoadFileInfo.getDeviceTypeInfo();
            if (iFileSelectLevlel != oLoadFileInfo.getFileSelectionLevel()) continue;
            if (fileLst.size() == 0) {
                fileLst.add(oLoadFileInfo);
                continue;
            }
            for (LoadFileInfo oLoadFileInfoTemp : fileLst) {
                if (null == oLoadFileInfoTemp.getFileName() || null == oLoadFileInfo.getFileName()) continue;
                DeviceTypeInfo oTmpDevTypeInfo = oLoadFileInfoTemp.getDeviceTypeInfo();
                if (!oLoadFileInfoTemp.getFileName().equals(oLoadFileInfo.getFileName()) || (null != oDevTypeInfo || null != oTmpDevTypeInfo) && (null == oDevTypeInfo || null == oTmpDevTypeInfo || !oDevTypeInfo.equals(oTmpDevTypeInfo))) continue;
                haveSomeFile = true;
                break;
            }
            if (!haveSomeFile) {
                fileLst.add(oLoadFileInfo);
            }
            haveSomeFile = false;
        }
        return fileLst;
    }

    public static int getNEIDFormFDN(String FDN) {
        int iNEID = 0;
        String sFDN = Normalizer.normalize(FDN, Normalizer.Form.NFC);
        String[] sFNDArrs = sFDN.split(",");
        String sNEPrefix = FDN_PREFIX;
        String sNEID = "";
        for (String s : sFNDArrs) {
            if (null == s || !s.startsWith(FDN_PREFIX) || "".equals(sNEID = s.substring(sNEPrefix.length()))) continue;
            return Integer.parseInt(sNEID.trim());
        }
        return iNEID;
    }

    public static String getPuttyVer() {
        String puttyVersion = null;
        puttyVersion = "putty.exe";
        return puttyVersion;
    }

    public static String getSucessStr(String strOprName, String strDetails) {
        if ((ErrorCodeReader.getInstance().getErrorDesc(BigInteger.valueOf(1000344858L)).equals(strDetails) || ErrorCodeReader.getInstance().getErrorDesc(BigInteger.valueOf(1000344859L)).equals(strDetails)) && (ResourceManager.getInstance().getResString("LOG_FILTER_DIALOG_OPERATION_TYPE_" + ACTIVATE_DATABASE).equals(strOprName) || ResourceManager.getInstance().getResString("LOG_FILTER_DIALOG_OPERATION_TYPE_" + RECOVER).equals(strOprName) || ResourceManager.getInstance().getResString("LOG_FILTER_DIALOG_OPERATION_TYPE_" + RECOVER_FROM_CLIENT).equals(strOprName))) {
            return DCCommonUtil.getFormatStr(COLOR_STR_FOR_SUCCESS_MSG, strOprName, strDetails);
        }
        return DCCommonUtil.getFormatStr(GREEN_COLOR_STR, strOprName, strDetails);
    }

    public static boolean isContainsInCombox(ComboBoxWithToolTip oCombox, String oDestString) {
        boolean bContains = false;
        if (null == oCombox || oCombox.getItemCount() == 0) {
            return bContains;
        }
        String oValue = "";
        for (int i = 0; i < oCombox.getItemCount(); ++i) {
            oValue = oCombox.getItemAt(i).toString();
            if (!oDestString.equals(oValue)) continue;
            bContains = true;
            break;
        }
        return bContains;
    }

    public static boolean isForExtendSpecialDevType(List<DeviceTypeInfo> devTypeLst) {
        if (null == devTypeLst) {
            DCDebugTracer.trace("isForExtendSpecialDevType  devTypeLst is null");
            return false;
        }
        boolean isNorthAmericaDev = false;
        for (int j = 0; j < devTypeLst.size(); ++j) {
            DeviceTypeInfo tmp = devTypeLst.get(j);
            if (!DCCommonUtil.isForExtendSpecialDevType(String.valueOf(tmp.getDevTypeID()))) continue;
            isNorthAmericaDev = true;
            break;
        }
        return isNorthAmericaDev;
    }

    public static boolean isForExtendSpecialDevType(String devTypeStr) {
        if (null == devTypeStr) {
            DCDebugTracer.trace("m_oExtendForSpecialDevTypeLst is null");
            return false;
        }
        return m_oExtendForSpecialDevTypeLst.contains(devTypeStr);
    }

    public static boolean isHaveTargetFileType(List<LoadFileInfo> loadFileLst, int iFileType) {
        if (null == loadFileLst || loadFileLst.size() == 0) {
            return false;
        }
        boolean isFound = false;
        for (LoadFileInfo loadFileInfo : loadFileLst) {
            ContentType contentType = loadFileInfo.getContentType();
            if (null == contentType || iFileType != contentType.getContentTypeCode()) continue;
            isFound = true;
            break;
        }
        return isFound;
    }

    public static boolean isHaveTargetFileType(List<LoadFileInfo> loadFileLst, String strFileType) {
        if (null == loadFileLst || loadFileLst.size() == 0) {
            return false;
        }
        boolean isFound = false;
        for (LoadFileInfo loadFileInfo : loadFileLst) {
            ContentType contentType = loadFileInfo.getContentType();
            if (null == contentType || !strFileType.equals(contentType.getId())) continue;
            isFound = true;
            break;
        }
        return isFound;
    }

    public static boolean isOprSelected(ITask oTaskInfo, int iTaskOperationID) {
        boolean bFeasibilitySelected = false;
        List<ITaskDeviceOperation> oTaskOperLst = oTaskInfo.getSupportedOperation();
        ITaskDeviceOperation oTaskOperObj = null;
        for (int i = 0; i < oTaskOperLst.size(); ++i) {
            if (null == oTaskOperLst.get(i) || (oTaskOperObj = oTaskOperLst.get(i)).getOperationId() != iTaskOperationID) continue;
            bFeasibilitySelected = oTaskOperObj.isSelected();
            break;
        }
        return bFeasibilitySelected;
    }

    public static boolean isTL1Dev(DeviceTypeInfo oDeviceTypeInfo) {
        int iDevTypeID = oDeviceTypeInfo.getDevTypeID();
        return TL1_NE_TYPE_LIST.contains(iDevTypeID);
    }

    public static boolean isTL1Dev(List<DeviceInfo> oDeviceList) {
        if (null == oDeviceList || oDeviceList.isEmpty()) {
            return false;
        }
        boolean bIsNorthAmericaDevDevType = false;
        for (DeviceInfo oDeviceInfo : oDeviceList) {
            if (null == oDeviceInfo) continue;
            DeviceTypeInfo oTypeInfo = oDeviceInfo.getDeviceTypeInfo();
            if (null != oTypeInfo) {
                bIsNorthAmericaDevDevType = DCCommonUtil.isTL1Dev(oTypeInfo);
            }
            if (!bIsNorthAmericaDevDevType) continue;
            break;
        }
        return bIsNorthAmericaDevDevType;
    }

    public static boolean isIncludeTL1Device(ITask oTask) {
        THashSet<Resource> oResLst = oTask.getDeviceType().getResources();
        Iterator oResItr = oResLst.iterator();
        IDeviceInfoManager devInfoManger = DeviceInfoManagerImpl.getInstance();
        DeviceInfo devInfo = null;
        while (oResItr.hasNext()) {
            Resource oRes = (Resource)oResItr.next();
            devInfo = devInfoManger.getDevice(oRes.getDeviceID());
            if (4 != devInfo.getProtocol()) continue;
            return true;
        }
        return false;
    }

    public static void setPreferredColumnWidths(JTable oTable, double[] arrColumnWidthPercentage) {
        int i;
        Dimension oTableDim = oTable.getPreferredSize();
        double dTotle = 0.0;
        for (i = 0; i < oTable.getColumnModel().getColumnCount(); ++i) {
            dTotle += arrColumnWidthPercentage[i];
        }
        for (i = 0; i < oTable.getColumnModel().getColumnCount(); ++i) {
            TableColumn oColumn = oTable.getColumnModel().getColumn(i);
            oColumn.setPreferredWidth((int)((double)oTableDim.width * (arrColumnWidthPercentage[i] / dTotle)));
        }
    }

    public static String validateIPAddress(String strIPAddresses) {
        if (null == strIPAddresses || strIPAddresses.equalsIgnoreCase("")) {
            return null;
        }
        String[] strIPPartsArr = new String[4];
        String strSearchedIPAddresses = strIPAddresses.trim();
        int iCounter = 0;
        while (-1 != strSearchedIPAddresses.indexOf(".")) {
            if (iCounter >= 3) {
                return null;
            }
            int iIndex = strSearchedIPAddresses.indexOf(".");
            strIPPartsArr[iCounter] = strSearchedIPAddresses.substring(0, iIndex).trim();
            ++iCounter;
            strSearchedIPAddresses = strSearchedIPAddresses.substring(iIndex + 1).trim();
        }
        if (3 != iCounter) {
            return null;
        }
        strIPPartsArr[iCounter] = strSearchedIPAddresses;
        try {
            int[] iValue = new int[4];
            for (int i = 0; i < 4; ++i) {
                if (strIPPartsArr[i].equals("*")) continue;
                iValue[i] = Integer.parseInt(strIPPartsArr[i]);
                if (iValue[i] < 0 || iValue[i] > 255 || 0 == i && 0 == iValue[i]) {
                    throw new NumberFormatException();
                }
                strIPPartsArr[i] = String.valueOf(iValue[i]);
            }
            if (0 == iValue[0] || 223 < iValue[0]) {
                throw new NumberFormatException();
            }
        }
        catch (NumberFormatException ex) {
            return null;
        }
        return strIPPartsArr[0] + '.' + strIPPartsArr[1] + '.' + strIPPartsArr[2] + '.' + strIPPartsArr[3];
    }

    public static boolean isNGWDMandMSTPDevType(List<DeviceInfo> oDeviceList) {
        if (null == oDeviceList || oDeviceList.isEmpty()) {
            return false;
        }
        boolean bIsNorthAmericaDevDevType = false;
        for (DeviceInfo oDeviceInfo : oDeviceList) {
            if (null == oDeviceInfo) continue;
            DeviceTypeInfo oTypeInfo = oDeviceInfo.getDeviceTypeInfo();
            if (null != oTypeInfo) {
                bIsNorthAmericaDevDevType = DCCommonUtil.isNGWDMandMSTPDevType(oTypeInfo);
            }
            if (!bIsNorthAmericaDevDevType) continue;
            break;
        }
        return bIsNorthAmericaDevDevType;
    }

    public static boolean isNGWDMandMSTPDevType(DeviceInfo[] oDeviceList) {
        if (null == oDeviceList || oDeviceList.length == 0) {
            return false;
        }
        boolean bIsNorthAmericaDevDevType = false;
        for (DeviceInfo oDeviceInfo : oDeviceList) {
            if (null == oDeviceInfo) continue;
            DeviceTypeInfo oTypeInfo = oDeviceInfo.getDeviceTypeInfo();
            if (null != oTypeInfo) {
                bIsNorthAmericaDevDevType = DCCommonUtil.isNGWDMandMSTPDevType(oTypeInfo);
            }
            if (bIsNorthAmericaDevDevType) break;
        }
        return bIsNorthAmericaDevDevType;
    }

    public static boolean isNGWDMandMSTPDevType(DeviceTypeInfo devTypeInfo) {
        String devTypeStr = String.valueOf(devTypeInfo.getDevTypeID());
        if (null == devTypeStr) {
            DCDebugTracer.trace("m_oNGWDMandMSTPDevType devTypeStr ==> is null");
            return false;
        }
        return m_oNGWDMandMSTPDevTypeLst.contains(devTypeStr);
    }

    public static boolean isPTNandRTNDevType(List<DeviceInfo> oDeviceList) {
        if (null == oDeviceList || oDeviceList.isEmpty()) {
            return false;
        }
        boolean bIsNorthAmericaDevDevType = false;
        for (DeviceInfo oDeviceInfo : oDeviceList) {
            if (null == oDeviceInfo) continue;
            DeviceTypeInfo oTypeInfo = oDeviceInfo.getDeviceTypeInfo();
            if (null != oTypeInfo) {
                bIsNorthAmericaDevDevType = DCCommonUtil.isPTNandRTNDevType(oTypeInfo);
            }
            if (!bIsNorthAmericaDevDevType) continue;
            break;
        }
        return bIsNorthAmericaDevDevType;
    }

    public static boolean isPTNandRTNDevType(DeviceTypeInfo devTypeInfo) {
        String devTypeStr = String.valueOf(devTypeInfo.getDevTypeID());
        if (null == devTypeStr) {
            DCDebugTracer.trace("isPTNandRTNDevType =>devTypeStr is null");
            return false;
        }
        return m_oPTNandRTNDevTypeLst.contains(devTypeStr);
    }

    private DCCommonUtil() {
    }

    public static boolean isShowQueryBtnForTask(int iTaskTypeId, int iDevTypeId) {
        if (5 == iTaskTypeId || iTaskTypeId == 13 || 4 == iTaskTypeId) {
            return true;
        }
        if (0 != iTaskTypeId && 1 != iTaskTypeId) {
            return false;
        }
        if (-1 == iDevTypeId) {
            DeviceTypeInfo[] arrDeviceTypes = DCFrameWorkUtil.getIsSingleClient() ? DeviceInfoManagerImpl.getInstance().getAddedDeviceTypes() : DeviceInfoManagerImpl.getInstance().getExistDeviceTypes();
            if (null != arrDeviceTypes && 0 < arrDeviceTypes.length) {
                for (DeviceTypeInfo oDevTypeInfo : arrDeviceTypes) {
                    if (!DCCommonUtil.isCheckMainAndStandbyBoard(oDevTypeInfo.getDevTypeID())) continue;
                    return true;
                }
            }
        } else if (DCCommonUtil.isCheckMainAndStandbyBoard(iDevTypeId)) {
            return true;
        }
        return false;
    }

    public static boolean isCheckMainAndStandbyBoard(int iDevTypeId) {
        return 0 <= "1332;".indexOf(iDevTypeId + ";") || 0 <= "1342;".indexOf(iDevTypeId + ";");
    }

    public static boolean isContainsDevTypeID(ITask oTask, int iDevTypeID) {
        List<DeviceTypeInfo> oDevTypeLst = oTask.getDeviceTypeLst();
        for (DeviceTypeInfo oDevTypeInfo : oDevTypeLst) {
            if (null != oDevTypeInfo && oDevTypeInfo.getDevTypeID() == iDevTypeID) {
                return true;
            }
            if (iDevTypeID != 1332 || oDevTypeInfo.getDevTypeID() != 1342) continue;
            return true;
        }
        return false;
    }

    public static long convertStringtoLong(String strDevIPAddress) {
        long lIpResult = 0L;
        long lTemp = 0L;
        int iStringLength = strDevIPAddress.length();
        for (int i = 0; i < iStringLength; ++i) {
            char chCurrentLocation = strDevIPAddress.charAt(i);
            if (chCurrentLocation == '.') {
                lIpResult |= lTemp;
                lIpResult <<= 8;
                lTemp = 0L;
                continue;
            }
            lTemp = lTemp * 10L + (long)(chCurrentLocation - 48);
        }
        return lIpResult += lTemp;
    }

    public static boolean isInputLegally(String strInput) {
        return !Pattern.matches("[0-9A-Za-z@.]+", strInput);
    }

    public static boolean isInputLegally(String[] strInput) {
        int i = 0;
        if (i < strInput.length) {
            return !Pattern.matches("[0-9A-Za-z@.]+", strInput[i]);
        }
        return false;
    }

    static {
        TL1_NE_TYPE_LIST.add(1975);
        TL1_NE_TYPE_LIST.add(1985);
        TL1_NE_TYPE_LIST.add(2017);
        TL1_NE_TYPE_LIST.add(2019);
        TL1_NE_TYPE_LIST.add(2024);
        TL1_NE_TYPE_LIST.add(2025);
        TL1_NE_TYPE_LIST.add(2026);
        TL1_NE_TYPE_LIST.add(2043);
        m_oExtendForSpecialDevTypeLst = DCCommonUtil.initConfDevTypeLst("EXTEND_CHECK_SPECIAL_DEVICE");
        m_oNGWDMandMSTPDevTypeLst = DCCommonUtil.initConfDevTypeLst("NGWDM_MSTP_Series");
        m_oPTNandRTNDevTypeLst = DCCommonUtil.initConfDevTypeLst("PTN_RTN_Series");
    }
}

