/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.common.util;

import java.awt.event.ActionListener;
import java.awt.event.ComponentListener;
import java.awt.event.KeyListener;
import java.awt.event.MouseListener;
import java.awt.event.WindowListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;

public class DCCleanupUtil {
    public static void cleanupComponent(JDialog oDialog) {
        DCCleanupUtil.cleanUpDialog(oDialog);
    }

    public static void cleanupComponent(JComponent oComponent) {
        if (oComponent instanceof JButton) {
            DCCleanupUtil.cleanUpButton((JButton)oComponent);
        } else if (oComponent instanceof JPanel) {
            DCCleanupUtil.cleanUpPanel((JPanel)oComponent);
        }
    }

    private static void cleanUpDialog(JDialog oDialog) {
        if (null == oDialog) {
            return;
        }
        WindowListener[] oListeners = oDialog.getWindowListeners();
        for (int i = 0; i < oListeners.length; ++i) {
            oDialog.removeWindowListener(oListeners[i]);
        }
        MouseListener[] oMouseListeners = oDialog.getMouseListeners();
        for (int i = 0; i < oMouseListeners.length; ++i) {
            oDialog.removeMouseListener(oMouseListeners[i]);
        }
        KeyListener[] oKeyListeners = oDialog.getKeyListeners();
        for (int i = 0; i < oKeyListeners.length; ++i) {
            oDialog.removeKeyListener(oKeyListeners[i]);
        }
        oDialog.removeAll();
    }

    private static void cleanUpButton(JButton oButton) {
        if (null == oButton) {
            return;
        }
        ActionListener[] oListeners = oButton.getActionListeners();
        for (int i = 0; i < oListeners.length; ++i) {
            oButton.removeActionListener(oListeners[i]);
        }
        MouseListener[] oMouseListeners = oButton.getMouseListeners();
        for (int i = 0; i < oMouseListeners.length; ++i) {
            oButton.removeMouseListener(oMouseListeners[i]);
        }
        KeyListener[] oKeyListeners = oButton.getKeyListeners();
        for (int i = 0; i < oKeyListeners.length; ++i) {
            oButton.removeKeyListener(oKeyListeners[i]);
        }
        oButton.removeAll();
    }

    public static void cleanUpPanel(JPanel oPanel) {
        if (null == oPanel) {
            return;
        }
        MouseListener[] oMouseListeners = oPanel.getMouseListeners();
        for (int i = 0; i < oMouseListeners.length; ++i) {
            oPanel.removeMouseListener(oMouseListeners[i]);
        }
        ComponentListener[] oComponentListeners = oPanel.getComponentListeners();
        for (int i = 0; i < oComponentListeners.length; ++i) {
            oPanel.removeComponentListener(oComponentListeners[i]);
        }
        KeyListener[] oKeyListeners = oPanel.getKeyListeners();
        for (int i = 0; i < oKeyListeners.length; ++i) {
            oPanel.removeKeyListener(oKeyListeners[i]);
        }
        oPanel.removeAll();
    }
}

