/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.common.util;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.event.ListDataEvent;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.plaf.basic.BasicComboBoxRenderer;

public class ComboBoxWithToolTip
extends JComboBox {
    private static final long serialVersionUID = 5919402516190833138L;
    private int oldSelected_ComboBox = -1;

    public ComboBoxWithToolTip() {
        this.addToolTip();
        this.setRenderer(new CustomComboBoxRenderer());
    }

    public ComboBoxWithToolTip(Object[] items) {
        super(items);
        this.addToolTip();
        this.setRenderer(new CustomComboBoxRenderer());
    }

    public ComboBoxWithToolTip(ComboBoxModel aModel) {
        super(aModel);
        this.addToolTip();
        this.setRenderer(new CustomComboBoxRenderer());
    }

    @Override
    public void intervalAdded(ListDataEvent e) {
        this.contentsChanged(e);
    }

    @Override
    public void intervalRemoved(ListDataEvent e) {
        this.contentsChanged(e);
    }

    private void addToolTip() {
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getSource() instanceof JComboBox) {
                    Object selectedItem = ((JComboBox)e.getSource()).getSelectedItem();
                    if (null != selectedItem) {
                        if ("".equals(selectedItem.toString().intern())) {
                            ComboBoxWithToolTip.this.setToolTipText(null);
                        } else {
                            ComboBoxWithToolTip.this.setToolTipText(selectedItem.toString());
                        }
                    } else {
                        ComboBoxWithToolTip.this.setToolTipText(null);
                    }
                }
            }
        });
        this.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                ComboBoxWithToolTip.this.setSelectedItem(ComboBoxWithToolTip.this.dataModel.getSelectedItem());
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
            }
        });
    }

    @Override
    public void setSelectedIndex(int anIndex) {
        this.oldSelected_ComboBox = this.getSelectedIndex();
        int size = this.getModel().getSize();
        if (anIndex == -1) {
            this.setSelectedItem(null);
        } else {
            if (anIndex < -1 || anIndex >= size) {
                throw new IllegalArgumentException("setSelectedIndex: " + anIndex + " out of bounds");
            }
            this.setSelectedItem(this.dataModel.getElementAt(anIndex));
        }
    }

    public int getOldSelectIndex() {
        return this.oldSelected_ComboBox;
    }

    public int getSelectVerIndex(String strSelectVer) {
        for (int i = 0; i < this.dataModel.getSize(); ++i) {
            Object oObject = this.dataModel.getElementAt(i);
            if (null == oObject || !oObject.toString().equals(strSelectVer)) continue;
            return i;
        }
        return this.oldSelected_ComboBox;
    }

    public void setSelectVerForSAM(int index) {
        this.oldSelected_ComboBox = index;
    }

    class CustomComboBoxRenderer
    extends BasicComboBoxRenderer {
        private static final long serialVersionUID = 2427243253926985130L;

        CustomComboBoxRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (null != list) {
                if (isSelected) {
                    this.setBackground(list.getSelectionBackground());
                    this.setForeground(list.getSelectionForeground());
                    if (index > -1) {
                        if (null != value) {
                            list.setToolTipText(value.toString());
                        }
                    } else {
                        list.setToolTipText(null);
                    }
                } else {
                    this.setBackground(list.getBackground());
                    this.setForeground(list.getForeground());
                }
                if (null != value) {
                    if ("".equals(value.toString().intern())) {
                        list.setToolTipText(null);
                    } else {
                        list.setToolTipText(value.toString());
                    }
                }
                this.setFont(list.getFont());
            }
            this.setText(value == null ? "" : value.toString());
            return this;
        }
    }
}

