/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.common.util;

import com.huawei.dc.common.components.DCFilePathTextField;
import com.huawei.dc.common.util.DCDebugTracer;
import java.awt.Toolkit;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.PlainDocument;

public class BoundedNumberTextField
extends DCFilePathTextField
implements FocusListener {
    private static final long serialVersionUID = -1601980108858693158L;
    protected boolean bAlarm = true;
    protected int maxDigits = 19;
    protected long[][] numRange = null;
    protected long min = 0L;
    protected long max = 0L;
    private boolean isLocked = false;
    private String prevString = null;
    private boolean isDirectInsert = false;
    private boolean actualGetText = false;

    public BoundedNumberTextField(int columns, long[][] numberRange) {
        super(columns);
        this.setDocument(new NumberDocument(this));
        this.setRange(numberRange);
        this.maxDigits = this.min >= 0L ? 19 : 20;
        this.addFocusListener(this);
    }

    public BoundedNumberTextField(long[][] numberRange) {
        this(0, numberRange);
    }

    @Override
    public synchronized void focusLost(FocusEvent e) {
        if (!this.isLocked) {
            long tempNumber = 0L;
            this.actualGetText = true;
            String text = this.getText();
            this.actualGetText = true;
            boolean valid = false;
            if (text.length() == 0) {
                tempNumber = this.min;
            } else {
                try {
                    tempNumber = Long.parseLong(text);
                    valid = this.isNumberValid(tempNumber);
                }
                catch (Exception ex) {
                    tempNumber = this.min;
                }
            }
            if (!valid) {
                this.isLocked = true;
                if (this.bAlarm) {
                    Toolkit.getDefaultToolkit().beep();
                }
                this.isDirectInsert = true;
                this.setText("" + this.getClosestValidNumber(tempNumber));
                this.isDirectInsert = false;
            }
        }
    }

    @Override
    public void focusGained(FocusEvent e) {
        this.isLocked = false;
    }

    public long getValue() {
        long value;
        String strValue = this.getText();
        value = strValue.length() == 0 ? this.min : (strValue.equals("-") ? 0L : ((value = Long.parseLong(strValue)) < this.min ? this.min : (value > this.max ? this.max : value)));
        return value;
    }

    public void setRange(long[][] numRange) {
        this.numRange = numRange;
        this.min = Long.MAX_VALUE;
        this.max = Long.MIN_VALUE;
        for (int i = 0; i < numRange.length; ++i) {
            if (numRange[i][0] < this.min) {
                this.min = numRange[i][0];
            }
            if (numRange[i][1] <= this.max) continue;
            this.max = numRange[i][1];
        }
    }

    public long getMin() {
        return this.min;
    }

    public long getMax() {
        return this.max;
    }

    public long[][] getRange() {
        return this.numRange;
    }

    public void setAlarm(boolean bAlarm) {
        this.bAlarm = bAlarm;
    }

    @Override
    public synchronized String getText() {
        String text = super.getPath();
        if (!this.actualGetText) {
            if (text.length() == 0) {
                text = "" + this.min;
            } else {
                try {
                    long value = Long.parseLong(text);
                    if (!this.isNumberValid(value)) {
                        text = "" + this.getClosestValidNumber(value);
                    }
                }
                catch (Exception e) {
                    text = "" + this.min;
                }
            }
        }
        return text;
    }

    protected boolean isNumberValid(long number) {
        boolean validity = false;
        for (int i = 0; i < this.numRange.length; ++i) {
            if (number < this.numRange[i][0] || number > this.numRange[i][1]) continue;
            validity = true;
            break;
        }
        return validity;
    }

    protected boolean isNumberPartlyValid(long number) {
        boolean validity = false;
        int div = 1;
        while (!validity && this.max / (long)div > 0L) {
            for (int i = 0; i < this.numRange.length; ++i) {
                if (number < this.numRange[i][0] / (long)div || number > this.numRange[i][1] / (long)div) continue;
                validity = true;
                break;
            }
            div *= 10;
        }
        return validity;
    }

    protected long getClosestValidNumber(long number) {
        long closeNumber = this.min;
        long diff = number - closeNumber;
        long tempDiff = 0L;
        for (int i = 0; i < this.numRange.length; ++i) {
            for (int j = 0; j < this.numRange[i].length; ++j) {
                tempDiff = number - this.numRange[i][j];
                if (tempDiff < 0L) {
                    tempDiff *= -1L;
                }
                if (tempDiff >= diff) continue;
                closeNumber = this.numRange[i][j];
                diff = number - closeNumber;
            }
        }
        return closeNumber;
    }

    class NumberDocument
    extends PlainDocument {
        private static final long serialVersionUID = -9192241886881245809L;
        private JTextComponent textComponent;
        private int ct = 0;

        public NumberDocument(JTextComponent tc) {
            this.textComponent = tc;
        }

        @Override
        public synchronized void insertString(int offset, String s, AttributeSet attributeSet) throws BadLocationException {
            s = s.trim();
            BoundedNumberTextField.this.actualGetText = true;
            BoundedNumberTextField.this.prevString = this.textComponent.getText().trim();
            BoundedNumberTextField.this.actualGetText = false;
            String tempString = null;
            if (BoundedNumberTextField.this.isDirectInsert) {
                super.insertString(offset, s, attributeSet);
            } else if (!(s.equals("-") && BoundedNumberTextField.this.min >= 0L || BoundedNumberTextField.this.prevString.length() + s.length() > BoundedNumberTextField.this.maxDigits)) {
                if (offset == 0) {
                    if (!s.equals("-") || BoundedNumberTextField.this.prevString.length() != 0) {
                        tempString = s + BoundedNumberTextField.this.prevString;
                    }
                } else {
                    tempString = offset > 0 && offset < BoundedNumberTextField.this.prevString.length() ? BoundedNumberTextField.this.prevString.substring(0, offset) + s + BoundedNumberTextField.this.prevString.substring(offset, BoundedNumberTextField.this.prevString.length()) : BoundedNumberTextField.this.prevString + s;
                }
                try {
                    if (tempString != null && !tempString.startsWith("00")) {
                        Long.parseLong(tempString);
                        super.insertString(offset, s, attributeSet);
                        BoundedNumberTextField.this.actualGetText = true;
                        tempString = this.textComponent.getText();
                        BoundedNumberTextField.this.actualGetText = false;
                        if (!(s.equals("-") && tempString.length() == 1 || Long.parseLong(tempString) <= BoundedNumberTextField.this.max)) {
                            super.remove(offset, 1);
                            if (BoundedNumberTextField.this.bAlarm && this.ct == 0) {
                                ++this.ct;
                                Toolkit.getDefaultToolkit().beep();
                                --this.ct;
                            }
                        }
                    }
                }
                catch (Exception ex) {
                    DCDebugTracer.trace(ex);
                }
            }
        }
    }
}

