/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.common.tree;

import com.huawei.dc.common.components.treetable.model.ISelectableNodeInfo;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.tree.DeviceNodeInfo;
import com.huawei.dc.common.tree.SubMapNodeInfo;
import com.huawei.dc.deviceinfo.DeviceTypeInfo;
import com.huawei.dc.devicemanagement.model.deviceinfo.DeviceInformation;
import com.huawei.dc.devicemanagement.model.deviceinfo.FrameInformation;
import com.huawei.dc.devicemanagement.model.deviceinfo.SlotInformation;
import com.huawei.dc.devicemanagement.model.deviceinfo.SubslotInformation;
import com.huawei.dc.taskmgmt.model.Resource;
import javax.swing.ImageIcon;
import javax.swing.UIManager;

public class TreeNodeInfo
implements ISelectableNodeInfo,
Comparable {
    public DeviceTypeInfo m_oDevType = null;
    public DeviceNodeInfo m_oDevInfo = null;
    public DeviceInformation m_oDeviceInfo = null;
    public SlotInformation m_oSlotInfo = null;
    public SubslotInformation m_oSubslotInfo = null;
    public FrameInformation m_oFrameNodeInfo = null;
    public SubMapNodeInfo m_oSubMapNodeInfo = null;
    public String m_strDeviceVersion = "";
    public String m_rootNode = "";
    public int m_iNodeType = -1;
    public String m_nodeName = null;
    private ImageIcon image = null;
    private int m_nodeSelectedState = 2;
    private boolean m_bEnabled = true;
    private boolean m_bIsBoardTreeNode;
    private int allDevTypeId = -1;
    private int allDevTypeVersionId = -1;
    private boolean m_bIsNodeSelectable = true;
    private String strOLTParentSubMapID = "";
    private String strOLTParentSubMapName = "";
    private String m_BoardType = null;
    private boolean m_bIsVisible = true;

    public String getBoardType() {
        return this.m_BoardType;
    }

    public boolean isVisible() {
        return this.m_bIsVisible;
    }

    public void setVisible(boolean isVisible) {
        this.m_bIsVisible = isVisible;
    }

    public boolean isBoardTreeNode() {
        return this.m_bIsBoardTreeNode;
    }

    public void setBoardTreeNode(boolean strIsBoardTreeNode) {
        this.m_bIsBoardTreeNode = strIsBoardTreeNode;
    }

    public TreeNodeInfo(DeviceTypeInfo deviceType) {
        this.m_oDevType = deviceType;
        this.m_nodeName = this.m_oDevType.toString();
        this.m_iNodeType = deviceType.getDevTypeID() == this.allDevTypeId && deviceType.getDevTypeVersionId() == this.allDevTypeVersionId ? 9 : 1;
    }

    public TreeNodeInfo(DeviceTypeInfo deviceType, String strBoardType) {
        this(deviceType);
        this.m_BoardType = strBoardType;
    }

    public TreeNodeInfo(String strName, boolean isRootNode) {
        if (!isRootNode) {
            this.m_nodeName = this.m_strDeviceVersion = strName;
            this.m_iNodeType = 2;
        } else {
            this.m_nodeName = this.m_rootNode = strName;
            this.m_iNodeType = 3;
        }
    }

    public TreeNodeInfo(String strName, DeviceTypeInfo oDeviceTypeInfo, String parentSubMapID, String parentSubMapName) {
        this.m_strDeviceVersion = strName;
        this.m_oDevType = oDeviceTypeInfo;
        if ("".equals(this.m_strDeviceVersion)) {
            this.m_strDeviceVersion = ResourceManager.getInstance().getResString("UNKNOWN_VERSION");
        }
        this.m_nodeName = this.m_strDeviceVersion;
        this.strOLTParentSubMapID = parentSubMapID;
        this.strOLTParentSubMapName = parentSubMapName;
        this.m_iNodeType = 10;
    }

    public TreeNodeInfo(String strName, DeviceTypeInfo oDeviceTypeInfo, String parentSubMapID, String parentSubMapName, String strBoardType) {
        this.m_strDeviceVersion = strName;
        this.m_oDevType = oDeviceTypeInfo;
        if ("".equals(this.m_strDeviceVersion)) {
            this.m_strDeviceVersion = ResourceManager.getInstance().getResString("UNKNOWN_VERSION");
        }
        this.m_nodeName = this.m_strDeviceVersion;
        this.strOLTParentSubMapID = parentSubMapID;
        this.strOLTParentSubMapName = parentSubMapName;
        this.m_iNodeType = 10;
        this.m_BoardType = strBoardType;
    }

    public TreeNodeInfo(String strName, DeviceTypeInfo oDeviceTypeInfo) {
        this.m_strDeviceVersion = strName;
        this.m_oDevType = oDeviceTypeInfo;
        this.m_nodeName = this.m_strDeviceVersion;
        this.m_iNodeType = 2;
    }

    public TreeNodeInfo(String strName, String strBoardType, DeviceTypeInfo oDeviceTypeInfo) {
        this.m_strDeviceVersion = strName;
        this.m_oDevType = oDeviceTypeInfo;
        this.m_nodeName = this.m_strDeviceVersion;
        this.m_iNodeType = 2;
        this.m_BoardType = strBoardType;
    }

    public TreeNodeInfo(DeviceNodeInfo deviceInfo) {
        this.m_oDevInfo = deviceInfo;
        this.m_nodeName = this.m_oDevInfo.m_strDeviceName + "(" + this.m_oDevInfo.m_strDeviceIP + ")";
        this.m_iNodeType = 4;
    }

    public TreeNodeInfo(DeviceNodeInfo deviceInfo, String boardType) {
        this.m_oDevInfo = deviceInfo;
        this.m_nodeName = this.m_oDevInfo.m_strDeviceName + "(" + this.m_oDevInfo.m_strDeviceIP + ")";
        this.m_iNodeType = 4;
        this.m_BoardType = boardType;
    }

    public TreeNodeInfo(SubMapNodeInfo oSubMapInfo, String boardType) {
        this.m_oSubMapNodeInfo = oSubMapInfo;
        this.m_nodeName = this.m_oSubMapNodeInfo.m_submapName;
        this.m_iNodeType = 0;
        this.m_BoardType = boardType;
    }

    public TreeNodeInfo(SubMapNodeInfo oSubMapInfo) {
        this.m_oSubMapNodeInfo = oSubMapInfo;
        this.m_nodeName = this.m_oSubMapNodeInfo.m_submapName;
        this.m_iNodeType = 0;
    }

    public TreeNodeInfo(DeviceInformation oDeviceInfo) {
        this.m_oDeviceInfo = oDeviceInfo;
        Resource oResource = oDeviceInfo.getResource();
        this.m_nodeName = oResource.getDeviceName() + '(' + oResource.getDeviceIP() + ')';
        this.m_iNodeType = 8;
    }

    public TreeNodeInfo(FrameInformation oFrameInfo) {
        this.m_oFrameNodeInfo = oFrameInfo;
        this.m_nodeName = String.valueOf(oFrameInfo.getFrameId());
        this.m_iNodeType = 5;
    }

    public TreeNodeInfo(SlotInformation oBoardInfo) {
        this.m_oSlotInfo = oBoardInfo;
        this.m_nodeName = String.valueOf(oBoardInfo.getBoardId());
        this.m_iNodeType = 6;
    }

    public TreeNodeInfo(SubslotInformation oSubSlotInfo) {
        this.m_oSubslotInfo = oSubSlotInfo;
        this.m_nodeName = String.valueOf(this.m_oSubslotInfo.getSlotId());
        this.m_iNodeType = 7;
    }

    public void setSelected(int typeOfSelection) {
        if (this.m_bIsNodeSelectable && this.isVisible()) {
            this.m_nodeSelectedState = typeOfSelection;
        }
    }

    public void setSelected(int typeOfSelection, boolean isCheckVisible) {
        if (!isCheckVisible) {
            this.m_nodeSelectedState = typeOfSelection;
        } else {
            this.setSelected(typeOfSelection);
        }
    }

    public DeviceTypeInfo getDeviceTypeInfo() {
        return this.m_oDevType;
    }

    public String getVersion() {
        return this.m_strDeviceVersion;
    }

    public void setVersion(String strVersion) {
        this.m_strDeviceVersion = strVersion;
    }

    public ImageIcon getImage() {
        switch (this.m_nodeSelectedState) {
            case 0: {
                this.image = ResourceManager.getInstance().getImage("all.gif");
                break;
            }
            case 1: {
                this.image = ResourceManager.getInstance().getImage("part.gif");
                break;
            }
            case 2: {
                this.image = (ImageIcon)UIManager.getIcon("");
                break;
            }
        }
        return this.image;
    }

    public int getSelectedState() {
        return this.m_nodeSelectedState;
    }

    public void setEnabled(boolean bEnabled) {
        this.m_bEnabled = bEnabled;
    }

    public boolean isEnabled() {
        return this.m_bEnabled;
    }

    public String toString() {
        return this.m_nodeName;
    }

    public void setIcon(ImageIcon resultIcon) {
        this.image = resultIcon;
    }

    public void updateNodeName(String strUpdatedNodeName) {
        this.m_nodeName = strUpdatedNodeName;
    }

    public String getDevIP() {
        if (null != this.m_oDevInfo) {
            return this.m_oDevInfo.m_strDeviceIP;
        }
        return "";
    }

    public int getDevID() {
        if (null != this.m_oDevInfo) {
            return this.m_oDevInfo.m_iDeviceID;
        }
        return -1;
    }

    public void setVersionName(String strVersionName) {
        this.m_nodeName = strVersionName;
    }

    @Override
    public boolean isSelected() {
        return 0 == this.m_iNodeType || 1 == this.m_iNodeType;
    }

    @Override
    public void setSelected(boolean isSelected) {
        this.m_iNodeType = isSelected ? 0 : 2;
    }

    public boolean isNodeSelectable() {
        return this.m_bIsNodeSelectable;
    }

    public void setNodeSelectable(boolean bNodeSelectable) {
        this.m_bIsNodeSelectable = bNodeSelectable;
    }

    public String getStrOLTParentSubMapID() {
        return this.strOLTParentSubMapID;
    }

    public void setStrOLTParentSubMapID(String strOLTParentSubMapID) {
        this.strOLTParentSubMapID = strOLTParentSubMapID;
    }

    public String getStrOLTParentSubMapName() {
        return this.strOLTParentSubMapName;
    }

    public void setStrOLTParentSubMapName(String strOLTParentSubMapName) {
        this.strOLTParentSubMapName = strOLTParentSubMapName;
    }

    public int compareTo(Object arg0) {
        if (!(arg0 instanceof TreeNodeInfo)) {
            return 0;
        }
        switch (this.m_iNodeType) {
            case 1: 
            case 9: {
                return this.m_oDevType.compareTo(((TreeNodeInfo)arg0).getDeviceTypeInfo());
            }
            case 2: {
                if (null == this.m_strDeviceVersion) {
                    this.m_strDeviceVersion = "";
                }
                return this.m_strDeviceVersion.compareTo(((TreeNodeInfo)arg0).getVersion());
            }
        }
        return 0;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.m_iNodeType;
        result = 31 * result + (this.m_nodeName == null ? 0 : this.m_nodeName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TreeNodeInfo other = (TreeNodeInfo)obj;
        if (this.m_iNodeType != other.m_iNodeType) {
            return false;
        }
        if (this.m_nodeName == null) {
            if (other.m_nodeName != null) {
                return false;
            }
        } else {
            if (!this.m_nodeName.equals(other.m_nodeName)) {
                return false;
            }
            if (this.m_oSubMapNodeInfo != null && other.m_oSubMapNodeInfo != null && this.m_oSubMapNodeInfo.m_submapId != other.m_oSubMapNodeInfo.m_submapId) {
                return false;
            }
        }
        return true;
    }
}

