/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.common.regionalxml;

import com.huawei.dc.common.util.DCDebugTracer;
import com.swimap.iview.commstyle.commini.AreaDescContainer;
import com.swimap.iview.commstyle.commini.CommStyleInfo;
import com.swimap.iview.commstyle.commini.DescContainer;
import com.swimap.iview.commstyle.commini.xmlbind.PARA;
import com.swimap.iview.commstyle.commini.xmlimpl.write.XmlUtil;
import com.swimap.iview.util.format.ValueNamePair;
import java.util.ArrayList;
import java.util.Locale;

public class XMLConfig {
    public static final int INVALIDVALUE = -255;
    private PARA curDateSeparateSymbol;
    private PARA curDateShowFormat;
    private PARA curShowZone;
    private PARA curShowDST;
    private PARA curTimeFormat;
    private PARA curTimeAmFormat;
    private PARA curTimePmFormat;
    private ArrayList dateSeparateSymbolList;
    private ArrayList dateShowFormatList;
    private ArrayList timeFormatList;
    private ArrayList timeAmFormatList;
    private ArrayList timePmFormatList;
    private static final String TIMESETTING = "TimeSetting";
    private static final String TIMEFORMAT = "TimeFormat";
    private static final String TIMEAMFORMAT = "AmFormat";
    private static final String TIMEPMFORMAT = "PmFormat";
    private static final String DATESETTING = "DateSetting";
    private static final String DATESEPARATESYMBOL = "DateSeparateSymbol";
    private static final String DATESHOWFORMAT = "DateShowFormat";
    private static final String ZONEDSTSETTING = "ZoneDSTSetting";
    private static final String SHOWDST = "ShowDST";
    private static final String SHOWZONE = "ShowZone";
    private static final String REGIONCONGISETTING = "RegionConfigSetting";
    private static final String SUPPORTZONEDST = "SupportZoneDST";
    private static final String SUPPORTDST = "SupportDST";
    private static final String SUPPORTZONE = "SupportZone";
    private static final String REGIONDATAACCESS = "RegionDataAccess";
    private static final String CLASS = "Class";
    private boolean isSupportZone = false;
    private boolean isSupportDST = false;
    private String regionDataAccessImpl = null;
    private static String dateSeparator = "-";

    public XMLConfig(CommStyleInfo info, boolean isEncoding) {
        if (!isEncoding) {
            XmlUtil.setEncoding((String)"iso-8859-1");
        } else {
            XmlUtil.setEncoding((String)"UTF-8");
        }
        try {
            this.read(info);
        }
        catch (Exception ex) {
            DCDebugTracer.trace(ex);
        }
    }

    private void read(CommStyleInfo _info) {
        int i;
        AreaDescContainer area;
        block6: {
            Locale locale;
            AreaDescContainer[] areas;
            block5: {
                if (_info == null) {
                    return;
                }
                areas = _info.getAreaDescContainer();
                area = new AreaDescContainer();
                locale = Locale.getDefault();
                if (areas.length != 1) break block5;
                area = areas[0];
                if (locale.getLanguage().equals(area.getAreaName().substring(0, 2))) break block6;
                area.setAreaName(locale.getLanguage() + '_' + locale.getCountry());
                break block6;
            }
            String strLangCountry = locale.getLanguage() + "_" + locale.getCountry();
            for (i = 0; i < areas.length; ++i) {
                if (!areas[i].getAreaName().equals(strLangCountry)) continue;
                area = areas[i];
                break;
            }
        }
        DescContainer[] desc = area.getDescContainer();
        for (i = 0; i < desc.length; ++i) {
            if (desc[i].getDescName().equals(TIMESETTING)) {
                this.readTimeSetting(desc[i]);
                continue;
            }
            if (desc[i].getDescName().equals(DATESETTING)) {
                this.readDateSetting(desc[i]);
                continue;
            }
            if (!desc[i].getDescName().equals(ZONEDSTSETTING)) continue;
            this.readZoneDSTSetting(desc[i]);
        }
    }

    void readRegionConfigSetting(CommStyleInfo info) {
        if (info == null) {
            throw new IllegalArgumentException("CommStyleInfo cannot be null.");
        }
        AreaDescContainer[] areas = info.getAreaDescContainer();
        for (int i = 0; i < areas.length; ++i) {
            if (!REGIONCONGISETTING.equals(areas[i].getAreaName())) continue;
            DescContainer zoneDSTDesc = areas[i].getDescContainer(SUPPORTZONEDST);
            this.isSupportDST = "true".equals(zoneDSTDesc.getParasItemValue(SUPPORTDST));
            this.isSupportZone = "true".equals(zoneDSTDesc.getParasItemValue(SUPPORTZONE));
            DescContainer dataAccessDesc = areas[i].getDescContainer(REGIONDATAACCESS);
            this.regionDataAccessImpl = dataAccessDesc.getParasItemValue(CLASS);
        }
    }

    private void readTimeSetting(DescContainer _desc) {
        DescContainer[] descs = _desc.getDescContainer();
        for (int i = 0; i < descs.length; ++i) {
            if (descs[i].getDescName().equals(TIMEFORMAT)) {
                this.timeFormatList = descs[i].getPARAS().getPARAArrayList();
                this.curTimeFormat = (PARA)this.timeFormatList.get(0);
                continue;
            }
            if (descs[i].getDescName().equals(TIMEAMFORMAT)) {
                this.timeAmFormatList = descs[i].getPARAS().getPARAArrayList();
                this.curTimeAmFormat = (PARA)this.timeAmFormatList.get(0);
                continue;
            }
            if (!descs[i].getDescName().equals(TIMEPMFORMAT)) continue;
            this.timePmFormatList = descs[i].getPARAS().getPARAArrayList();
            this.curTimePmFormat = (PARA)this.timePmFormatList.get(0);
        }
    }

    private void readDateSetting(DescContainer _desc) {
        DescContainer[] descs = _desc.getDescContainer();
        for (int i = 0; i < descs.length; ++i) {
            if (descs[i].getDescName().equals(DATESEPARATESYMBOL)) {
                this.dateSeparateSymbolList = descs[i].getPARAS().getPARAArrayList();
                this.curDateSeparateSymbol = (PARA)this.dateSeparateSymbolList.get(0);
                continue;
            }
            if (!descs[i].getDescName().equals(DATESHOWFORMAT)) continue;
            this.dateShowFormatList = descs[i].getPARAS().getPARAArrayList();
            this.curDateShowFormat = (PARA)this.dateShowFormatList.get(0);
        }
    }

    private void readZoneDSTSetting(DescContainer _desc) {
        PARA[] allPara = _desc.getPARAS().getPARA();
        for (int i = 0; i < allPara.length; ++i) {
            if (allPara[i].getName().equals(SHOWZONE)) {
                this.curShowZone = allPara[i];
                continue;
            }
            if (!allPara[i].getName().equals(SHOWDST)) continue;
            this.curShowDST = allPara[i];
        }
    }

    String getRegionDataAccessImpl() {
        return this.regionDataAccessImpl;
    }

    private ValueNamePair getValueNamePairWithPARA(PARA para) {
        try {
            int value = Integer.parseInt(para.getValue());
            return new ValueNamePairExt(value, para.getName());
        }
        catch (Exception e) {
            return new ValueNamePairExt(-255, "");
        }
    }

    public ValueNamePair getCurDateSeparateSymbol() {
        return this.getValueNamePairWithPARA(this.curDateSeparateSymbol);
    }

    public ValueNamePair getCurDateShowFormat() {
        return this.getValueNamePairWithPARA(this.curDateShowFormat);
    }

    public ValueNamePair getCurTimeAmFormat() {
        return this.getValueNamePairWithPARA(this.curTimeAmFormat);
    }

    public ValueNamePair getCurTimePmFormat() {
        return this.getValueNamePairWithPARA(this.curTimePmFormat);
    }

    public ValueNamePair getCurTimeFormat() {
        return this.getValueNamePairWithPARA(this.curTimeFormat);
    }

    public ValueNamePair getCurShowZone() {
        return this.getValueNamePairWithPARA(this.curShowZone);
    }

    public ValueNamePair getCurShowDST() {
        return this.getValueNamePairWithPARA(this.curShowDST);
    }

    public static boolean isValid(ValueNamePair pair) {
        boolean valid = false;
        if (pair != null && pair.getName() != null && pair.getValue() != -255) {
            valid = true;
        }
        return valid;
    }

    boolean isSupportZone() {
        return this.isSupportZone;
    }

    boolean isSupportDST() {
        return this.isSupportDST;
    }

    private class ValueNamePairExt
    extends ValueNamePair {
        public ValueNamePairExt(int value, String name) {
            super(value, name);
        }

        public String toString() {
            String desc = super.toString();
            if (desc.indexOf("$") != -1) {
                desc = desc.replaceAll("[$]", dateSeparator);
            }
            return desc;
        }
    }
}

