/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.common.regionalxml;

import com.huawei.dc.common.regionalxml.DefaultImpl;
import com.huawei.dc.common.regionalxml.IRegionDataAccess;
import com.huawei.dc.common.regionalxml.XMLConfig;
import com.swimap.iview.commstyle.commini.CommStyleInfo;
import com.swimap.iview.commstyle.commini.CommStyleManager;

public final class DataSource {
    private IRegionDataAccess dataAccess = null;
    private XMLConfig regionXMLConfig;
    private XMLConfig userSettingXMLConfig;
    public static final String REGION_XML_FILENAME = "conf/mainfrm/regionconfig";
    public static final String REGION_CONFIG_SETTING_FILENAME = "conf/mainfrm/regionconfigsetting";
    public static final String REGION_CONFIG_SETTING_USER = "conf/general/regionconfig_server";
    private static DataSource instance;

    private DataSource() {
        CommStyleInfo regionConfigSettingInfo = CommStyleManager.getInstance().getCommonStyleFile(REGION_CONFIG_SETTING_FILENAME);
        if (regionConfigSettingInfo != null) {
            CommStyleInfo regiondataInfo = CommStyleManager.getInstance().getCommonStyleFile(REGION_XML_FILENAME);
            this.regionXMLConfig = new XMLConfig(regiondataInfo, true);
            this.regionXMLConfig.readRegionConfigSetting(regionConfigSettingInfo);
            this.initRegionDataAccess();
            this.loadUserData();
        } else {
            CommStyleInfo regionConfigSettingInfo1 = CommStyleManager.getInstance().getCommonStyleFile(REGION_CONFIG_SETTING_USER);
            this.userSettingXMLConfig = new XMLConfig(regionConfigSettingInfo1, true);
        }
    }

    public void loadUserData() {
        CommStyleInfo usersettingInfo = this.dataAccess.read();
        this.userSettingXMLConfig = new XMLConfig(usersettingInfo, false);
    }

    private void initRegionDataAccess() {
        String filename = this.regionXMLConfig.getRegionDataAccessImpl();
        try {
            Class<?> klass = Class.forName(filename);
            Object obj = klass.newInstance();
            this.dataAccess = (IRegionDataAccess)obj;
        }
        catch (Exception e) {
            this.dataAccess = new DefaultImpl();
        }
    }

    public XMLConfig getRegionXMLConfig() {
        return this.regionXMLConfig;
    }

    public XMLConfig getUserSettingXMLConfig() {
        return this.userSettingXMLConfig;
    }

    public boolean isSupportZone() {
        if (null == this.regionXMLConfig) {
            return false;
        }
        return this.regionXMLConfig.isSupportZone();
    }

    public boolean isSupportDST() {
        if (null == this.regionXMLConfig) {
            return false;
        }
        return this.regionXMLConfig.isSupportDST();
    }

    public static synchronized DataSource getInstance() {
        if (instance == null) {
            instance = new DataSource();
        }
        return instance;
    }

    private void clean() {
        this.dataAccess = null;
        this.regionXMLConfig = null;
        this.userSettingXMLConfig = null;
    }

    public static synchronized void disposeInstance() {
        if (null != instance) {
            instance.clean();
        }
        instance = null;
    }
}

