/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.common.framework.utility.print.tools;

import com.huawei.dc.common.framework.utility.print.FormatCalculator;
import com.huawei.dc.common.framework.utility.print.SavePrintable;
import com.huawei.dc.common.framework.utility.print.tools.AbstractSaveImpl;
import com.huawei.dc.common.framework.utility.print.tools.HTMLSaveImpl;
import com.huawei.dc.common.util.DCDebugTracer;
import java.awt.print.PrinterException;
import java.util.Collection;
import java.util.ResourceBundle;

public class TablePrintable {
    static ResourceBundle res = ResourceBundle.getBundle("com.huawei.dc.common.framework.utility.print.Res");
    private FormatCalculator m_oFormatCalculator;
    private SavePrintable m_oSavePrintable;

    public TablePrintable(String title, String userName, String summary, String[] tableHeaders, Collection sourceData, int totalRowCount, int totalDeviceCount) {
        this.m_oFormatCalculator = new FormatCalculator(title, userName, summary, tableHeaders, null, sourceData, totalRowCount, true, totalDeviceCount);
        this.m_oFormatCalculator.setTablePrintable(this);
    }

    public TablePrintable(String title, String userName, String summary, String[] tableHeaders, int[] columnWidthProportion, Collection sourceData, int totalRowCount, boolean isSave) {
        this.m_oFormatCalculator = new FormatCalculator(title, userName, summary, tableHeaders, null, sourceData, totalRowCount, isSave);
        this.m_oFormatCalculator.setTablePrintable(this);
    }

    public TablePrintable(String title, String userName, String summary, String[] tableHeaders, Collection sourceData, int totalRowCount, boolean isSave, int totalDeviceCount) {
        this.m_oFormatCalculator = new FormatCalculator(title, userName, summary, tableHeaders, null, sourceData, totalRowCount, isSave, totalDeviceCount);
        this.m_oFormatCalculator.setTablePrintable(this);
    }

    public FormatCalculator getFormatCalculator() {
        return this.m_oFormatCalculator;
    }

    public int getPageCount() {
        return this.m_oFormatCalculator.getPageCount();
    }

    public void append(Collection sourceData, boolean formerDataDeleteEnabled) throws PrinterException {
        int waitingTime = 0;
        while (this.m_oSavePrintable == null) {
            try {
                Thread.sleep(1000L);
                DCDebugTracer.trace("TablePrintable --- append ---- waitingTime = " + ++waitingTime);
                DCDebugTracer.trace("\n");
            }
            catch (InterruptedException e) {
                DCDebugTracer.trace(e);
            }
            if (waitingTime <= 6000) continue;
            return;
        }
        this.m_oSavePrintable.getFormatCalculator().append(sourceData);
    }

    public void setDataOver(boolean bOver) {
        this.m_oSavePrintable.setDataOver(bOver);
    }

    public void setImplRef(SavePrintable implRef) {
        this.m_oSavePrintable = implRef;
        if (implRef instanceof HTMLSaveImpl) {
            ((HTMLSaveImpl)implRef).formatCalculator.setIsHtml(true);
        }
        if (implRef instanceof AbstractSaveImpl) {
            ((AbstractSaveImpl)implRef).formatCalculator.init();
        }
    }

    public boolean isOver() {
        if (this.m_oSavePrintable == null) {
            return false;
        }
        return this.getImplRef().isOver();
    }

    public SavePrintable getImplRef() {
        return this.m_oSavePrintable;
    }
}

