/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.common.framework.utility.print.tools;

import com.huawei.dc.common.framework.utility.print.FormatCalculator;
import com.huawei.dc.common.framework.utility.print.PrintSupportor;
import com.huawei.dc.common.framework.utility.print.PrintableTool;
import com.huawei.dc.common.framework.utility.print.SavePrintable;
import com.huawei.dc.common.util.DCDebugTracer;
import gnu.trove.TIntHashSet;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.print.PageFormat;
import java.util.LinkedList;

public class TablePrintImpl
extends PrintableTool
implements SavePrintable {
    private FormatCalculator m_oFormatCalculator;
    private boolean m_bFirstForRealTimePrint = false;
    private LinkedList m_lstSourceData = new LinkedList();
    private boolean m_flagForCheck = true;
    private TIntHashSet m_oHashSet = new TIntHashSet();

    public TablePrintImpl(boolean bRealTimePrint, FormatCalculator formatCalculator) {
        super(formatCalculator.getTitle(), formatCalculator.getUserName());
        this.m_oFormatCalculator = formatCalculator;
        if (bRealTimePrint) {
            this.setHeadInfoEnabled(false);
            this.m_oFormatCalculator.setBRealTimePrint(true);
        }
    }

    @Override
    public boolean isOver() {
        return this.isDataOver();
    }

    @Override
    public FormatCalculator getFormatCalculator() {
        return this.m_oFormatCalculator;
    }

    @Override
    protected void drawPage(Graphics2D g, PageFormat pageFormat, int pageIndex) {
        if (this.m_flagForCheck) {
            this.m_oFormatCalculator.setPageFormatWithCompute(pageFormat);
            if (this.m_bFirstForRealTimePrint && this.m_oFormatCalculator.getTablePageHashMap().size() > 1) {
                int lastPageRowCount = this.m_oFormatCalculator.getLastPageRowCount();
                this.m_lstSourceData.clear();
                int size = this.m_oFormatCalculator.getSourceDataArrayList().size();
                if (lastPageRowCount < this.m_oFormatCalculator.getSourceDataArrayList().size()) {
                    this.m_oFormatCalculator.getTablePageHashMap().remove(this.m_oFormatCalculator.getTablePageHashMap().size() - 1);
                    for (int i = size - lastPageRowCount; i < size; ++i) {
                        this.m_lstSourceData.add(this.m_oFormatCalculator.getSourceDataArrayList().get(i));
                    }
                }
            }
            this.m_flagForCheck = false;
        }
        this.drawTableInfo(g, pageFormat, pageIndex);
    }

    private void drawTableInfo(Graphics2D g, PageFormat pageFormat, int tablePageIndex) {
        int pageRowCount;
        if (!this.m_oFormatCalculator.isBRealTimePrint()) {
            while (tablePageIndex == this.m_oFormatCalculator.getTablePageHashMap().size() - 1 && !this.m_oFormatCalculator.isComputeOver()) {
                if (this.isDataOver()) {
                    return;
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    DCDebugTracer.trace(e);
                }
            }
        }
        int counter = 0;
        while (tablePageIndex > this.m_oFormatCalculator.getTablePageHashMap().size() - 1 && counter <= 30) {
            try {
                Thread.sleep(2000L);
                DCDebugTracer.trace(" tablePageIndex > formatCalculator.getTablePageHashMap().size() -1 : tablePageIndex =  " + tablePageIndex + " formatCalculator.getTablePageHashMap().size() = " + this.m_oFormatCalculator.getTablePageHashMap().size() + "counter = " + ++counter);
            }
            catch (InterruptedException ex) {
                DCDebugTracer.trace(ex);
            }
        }
        if (tablePageIndex > this.m_oFormatCalculator.getTablePageHashMap().size() - 1) {
            this.setDataOver(true);
            DCDebugTracer.trace("There has setDataOver in print module!!! tablePageIndex =  " + tablePageIndex + " formatCalculator.getTablePageHashMap().size() = " + this.m_oFormatCalculator.getTablePageHashMap().size());
            return;
        }
        int startingY = this.getHeadHeight() + 10 + PrintableTool.getFontHeight(FormatCalculator.TableHeaderFont) * 3;
        if (this.m_oFormatCalculator.getSummaryPageCount() > 0) {
            if (tablePageIndex < this.m_oFormatCalculator.getSummaryPageCount() - 1) {
                this.drawSummaryInfo(g, pageFormat, tablePageIndex);
                return;
            }
            if (tablePageIndex == this.m_oFormatCalculator.getSummaryPageCount() - 1) {
                this.drawSummaryInfo(g, pageFormat, tablePageIndex);
                startingY = this.m_oFormatCalculator.getSummaryLastPrintingY();
                this.drawTotalRecordLabel(g, startingY);
                startingY += PrintableTool.getFontHeight(FormatCalculator.TableHeaderFont) * 3;
            }
        } else if (!this.m_oFormatCalculator.isBRealTimePrint()) {
            startingY = this.getHeadHeight() + 10;
            this.drawTotalRecordLabel(g, startingY);
            startingY += PrintableTool.getFontHeight(FormatCalculator.TableHeaderFont) * 3;
        }
        if ((pageRowCount = ((Integer)this.m_oFormatCalculator.getTablePageHashMap().get(tablePageIndex)).intValue()) <= 0) {
            return;
        }
        this.drawHeaderInfo(g, pageFormat, startingY);
        startingY += this.m_oFormatCalculator.getTableHeaderHeight();
        int rowIndex = 0;
        for (int i = 0; i < tablePageIndex; ++i) {
            Integer pageCountValue = (Integer)this.m_oFormatCalculator.getTablePageHashMap().get(i);
            rowIndex += pageCountValue.intValue();
        }
        this.drawTextInfo(g, pageFormat, rowIndex, pageRowCount, startingY);
        Integer integer = rowIndex;
        if (this.m_oHashSet.contains(integer.intValue())) {
            this.m_oFormatCalculator.setLastPrintedRowIndex(rowIndex);
            this.m_oHashSet.remove(integer.intValue());
        } else {
            this.m_oHashSet.add(integer.intValue());
        }
    }

    private void drawHeaderInfo(Graphics2D g, PageFormat pageFormat, int startingY) {
        g.setFont(FormatCalculator.TableHeaderFont);
        int leftColumnLineX = 0;
        g.drawLine(0, startingY, (int)pageFormat.getImageableWidth(), startingY);
        int column = 0;
        for (LinkedList cellLinkedList : this.m_oFormatCalculator.getAnalyzedTableHeaderLinkedList()) {
            int cellRow = 1;
            for (String tableHeaderRow : cellLinkedList) {
                g.drawString(tableHeaderRow, leftColumnLineX + 2, startingY + 3 + PrintableTool.getFontHeight(FormatCalculator.TableHeaderFont) * cellRow - PrintableTool.getFontDescent(FormatCalculator.TableHeaderFont));
                ++cellRow;
            }
            g.drawLine(leftColumnLineX, startingY, leftColumnLineX, startingY + this.m_oFormatCalculator.getTableHeaderHeight());
            leftColumnLineX += this.m_oFormatCalculator.getColumnWidths()[column++];
        }
        g.drawLine((int)pageFormat.getImageableWidth(), startingY, (int)pageFormat.getImageableWidth(), startingY + this.m_oFormatCalculator.getTableHeaderHeight());
    }

    private void drawTextInfo(Graphics2D g, PageFormat pageFormat, int rowIndex, int pageRowCount, int startingY) {
        int realRowIndex = rowIndex;
        g.setFont(FormatCalculator.DataFont);
        int analyzedDataStartingY = startingY;
        int columnCount = this.m_oFormatCalculator.getTableHeaders().length;
        for (int i = 0; i < pageRowCount; ++i) {
            int leftColumnLineX = 0;
            int rowHeight = this.m_oFormatCalculator.calculateRowHeight(realRowIndex, (int)pageFormat.getImageableHeight());
            g.drawLine(0, analyzedDataStartingY, (int)pageFormat.getImageableWidth(), analyzedDataStartingY);
            LinkedList rowLinkedList = this.m_oFormatCalculator.getAnalyzedRowLinkList(realRowIndex);
            for (int j = 0; j < columnCount; ++j) {
                int lineTextSize;
                LinkedList cellLinkedList = (LinkedList)rowLinkedList.get(j);
                int middleY = analyzedDataStartingY + rowHeight / 2;
                int n = lineTextSize = cellLinkedList.size() < 0 ? 0 : cellLinkedList.size();
                if ((lineTextSize & 1) == 1) {
                    middleY = analyzedDataStartingY + (rowHeight + PrintableTool.getFontHeight(FormatCalculator.DataFont)) / 2;
                }
                int textStartingY = middleY - PrintableTool.getFontHeight(FormatCalculator.DataFont) * (lineTextSize - 1) / 2 - PrintableTool.getFontDescent(FormatCalculator.DataFont);
                for (String lineText : cellLinkedList) {
                    g.drawString(lineText, leftColumnLineX + 2, textStartingY);
                    textStartingY += PrintableTool.getFontHeight(FormatCalculator.DataFont);
                }
                g.drawLine(leftColumnLineX, analyzedDataStartingY, leftColumnLineX, analyzedDataStartingY + rowHeight);
                leftColumnLineX += this.m_oFormatCalculator.getColumnWidths()[j];
            }
            g.drawLine((int)pageFormat.getImageableWidth(), analyzedDataStartingY, (int)pageFormat.getImageableWidth(), analyzedDataStartingY + rowHeight);
            analyzedDataStartingY += rowHeight;
            ++realRowIndex;
        }
        g.drawLine(0, analyzedDataStartingY, (int)pageFormat.getImageableWidth(), analyzedDataStartingY);
    }

    private void drawTotalRecordLabel(Graphics2D g, int startingY) {
        g.setFont(FormatCalculator.DataFont);
        String totalRecordLabel = PrintSupportor.res.getString("Total") + this.m_oFormatCalculator.getTotalDeviceCount() + " " + PrintSupportor.res.getString("Device(s)");
        g.drawString(totalRecordLabel, 1, startingY + PrintableTool.getFontHeight(FormatCalculator.TableHeaderFont) * 2 - PrintableTool.getFontDescent(FormatCalculator.TableHeaderFont));
    }

    private void drawSummaryInfo(Graphics2D g, PageFormat pf, int pageIndex) {
        int pageHeight = (int)pf.getImageableHeight();
        int oneLineHeight = PrintableTool.getFontHeight(FormatCalculator.DataFont);
        int onePageCapacityLineCount = (pageHeight - this.getHeadHeight()) / PrintableTool.getFontHeight(FormatCalculator.DataFont) - 1;
        int offsetLineIndex = onePageCapacityLineCount * pageIndex;
        int pageLineCount = 0;
        pageLineCount = this.m_oFormatCalculator.getSummaryLineList().size() - offsetLineIndex > onePageCapacityLineCount ? onePageCapacityLineCount : this.m_oFormatCalculator.getSummaryLineList().size() - offsetLineIndex;
        g.setFont(FormatCalculator.DataFont);
        FontMetrics fm = g.getFontMetrics(FormatCalculator.DataFont);
        double textCapacityWidth = pf.getImageableWidth() - 2.0;
        double printingY = this.getHeadHeight() + oneLineHeight / 2 - PrintableTool.getFontDescent(FormatCalculator.DataFont);
        for (int i = 0; i < pageLineCount; ++i) {
            String lineText = (String)this.m_oFormatCalculator.getSummaryLineList().get(offsetLineIndex + i);
            printingY += (double)oneLineHeight;
            double lineWidth = g.getFontMetrics().stringWidth(lineText);
            while (lineWidth > textCapacityWidth) {
                lineText = lineText.substring(0, lineText.length() - 1);
                lineWidth = fm.stringWidth(lineText);
            }
            g.drawString(lineText, 2, (int)printingY);
        }
    }

    @Override
    public int getPageCount() {
        return this.m_oFormatCalculator.getPageCount();
    }

    public boolean isBFirstForRealTimePrint() {
        return this.m_bFirstForRealTimePrint;
    }

    public void setBFirstForRealTimePrint(boolean bFirstForRealTimePrint) {
        this.m_bFirstForRealTimePrint = bFirstForRealTimePrint;
    }

    public LinkedList getLastPageDataForFirstRealTimePrint() {
        return this.m_lstSourceData;
    }

    public void reset() {
        this.m_flagForCheck = true;
        this.m_lstSourceData.clear();
        this.m_bFirstForRealTimePrint = false;
        this.getFormatCalculator().reset();
        this.m_oHashSet.clear();
    }
}

