/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.common.framework.utility.print.tools;

import com.huawei.dc.common.framework.utility.print.FormatCalculator;
import com.huawei.dc.common.framework.utility.print.PrintSupportor;
import com.huawei.dc.common.framework.utility.print.tools.AbstractSaveImpl;
import com.huawei.dc.common.util.DCDebugTracer;
import java.io.BufferedWriter;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;

public class TXTSaveImpl
extends AbstractSaveImpl {
    public TXTSaveImpl(FormatCalculator _formatCalculator) {
        super(_formatCalculator);
    }

    @Override
    public void write(BufferedWriter out) throws IOException {
        out.write(FormatCalculator.lineChanger);
        out.write(FormatCalculator.lineChanger);
        out.write(PrintSupportor.res.getString("Total"));
        out.write(Integer.toString(this.formatCalculator.getTotalDeviceCount()) + " ");
        out.write(PrintSupportor.res.getString("Device(s)"));
        out.write(FormatCalculator.lineChanger);
        out.write(FormatCalculator.lineChanger);
        this.writeHeader(out);
        this.writeData(out);
        out.write(FormatCalculator.lineChanger);
        out.write(FormatCalculator.lineChanger);
    }

    @Override
    public void writeTitle(BufferedWriter out) throws IOException {
        String separatorLine = this.formatCalculator.getTxtSeparatorLine();
        int titleWidth = FormatCalculator.getTxtTextWidth(this.formatCalculator.getTitle());
        out.write(FormatCalculator.getTxtBlackText((separatorLine.length() - titleWidth) / 2));
        out.write(this.formatCalculator.getTitle());
    }

    @Override
    public void writeExtraInfo(BufferedWriter out) throws IOException {
        out.write(FormatCalculator.lineChanger);
        int titleWidth = FormatCalculator.getTxtTextWidth(this.formatCalculator.getTitle());
        String separatorLine = this.formatCalculator.getTxtSeparatorLine();
        out.write(FormatCalculator.getTxtBlackText((separatorLine.length() - titleWidth) / 2));
        out.write(FormatCalculator.lineChanger);
        StringBuffer extraInfoBuffer = new StringBuffer(PrintSupportor.res.getString("saveTime"));
        String str = this.formatCalculator.getTime() + "    ";
        extraInfoBuffer.append(str);
        extraInfoBuffer.append(PrintSupportor.res.getString("userName"));
        extraInfoBuffer.append(this.formatCalculator.getUserName());
        String extraInfoText = extraInfoBuffer.toString();
        int infoWidth = FormatCalculator.getTxtTextWidth(extraInfoText);
        out.write(FormatCalculator.getTxtBlackText((separatorLine.length() - infoWidth) / 2));
        out.write(extraInfoText);
        out.write(FormatCalculator.getTxtBlackText((separatorLine.length() - infoWidth) / 2));
        out.write(FormatCalculator.lineChanger);
        out.write(FormatCalculator.lineChanger);
        if (this.formatCalculator.getSummary().length() > 0) {
            String[] summaryLineArray = this.formatCalculator.getSummaryLines();
            for (int i = 0; i < summaryLineArray.length; ++i) {
                out.write(summaryLineArray[i]);
                out.write(FormatCalculator.lineChanger);
            }
        }
    }

    protected void writeHeader(BufferedWriter out) throws IOException {
        this.writeSeparatorLine(out);
        LinkedList rowDataLinkedList = this.formatCalculator.getAnalyzeHeadData();
        int cellLineCount = 0;
        for (LinkedList cellDataLinkedList : rowDataLinkedList) {
            if (cellLineCount >= cellDataLinkedList.size()) continue;
            cellLineCount = cellDataLinkedList.size();
        }
        for (int j = 0; j < cellLineCount; ++j) {
            Iterator columnIterator = rowDataLinkedList.iterator();
            StringBuffer buff = new StringBuffer();
            for (int columnIndex = 0; columnIndex < this.formatCalculator.getColumnWidths().length; ++columnIndex) {
                if (columnIndex == 0) {
                    buff.append('|');
                }
                buff.append("  ");
                LinkedList cellDataLinkedList = null;
                cellDataLinkedList = (LinkedList)columnIterator.next();
                int columnWidth = this.formatCalculator.getColumnWidths()[columnIndex];
                if (j < cellDataLinkedList.size()) {
                    String lineText = (String)cellDataLinkedList.get(j);
                    buff.append(lineText);
                    buff.append(FormatCalculator.getTxtBlackText(columnWidth - FormatCalculator.getTxtTextWidth(lineText)));
                } else {
                    buff.append(FormatCalculator.getTxtBlackText(columnWidth));
                }
                buff.append("  ");
                buff.append('|');
            }
            buff.append(FormatCalculator.lineChanger);
            out.write(buff.toString());
            out.flush();
        }
        this.writeSeparatorLine(out);
    }

    protected void writeData(BufferedWriter out) throws IOException {
        for (int i = 0; i < this.formatCalculator.getTotalRowCount() - 1; ++i) {
            int realRowIndex = -1;
            while (!(this.isOver() || (realRowIndex = i) >= 0 && realRowIndex < this.formatCalculator.getAnalyzedRowCount())) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    DCDebugTracer.trace(e);
                }
            }
            if (this.isOver()) {
                return;
            }
            LinkedList rowDataLinkedList = this.formatCalculator.getAnalyzedRowLinkList(realRowIndex);
            int cellLineCount = 0;
            for (LinkedList cellDataLinkedList : rowDataLinkedList) {
                if (cellLineCount >= cellDataLinkedList.size()) continue;
                cellLineCount = cellDataLinkedList.size();
            }
            for (int j = 0; j < cellLineCount; ++j) {
                Iterator columnIterator = rowDataLinkedList.iterator();
                StringBuffer buff = new StringBuffer();
                for (int columnIndex = 0; columnIndex < this.formatCalculator.getColumnWidths().length; ++columnIndex) {
                    if (columnIndex == 0) {
                        buff.append('|');
                    }
                    buff.append("  ");
                    LinkedList cellDataLinkedList = null;
                    cellDataLinkedList = (LinkedList)columnIterator.next();
                    int columnWidth = this.formatCalculator.getColumnWidths()[columnIndex];
                    if (j < cellDataLinkedList.size()) {
                        String lineText = (String)cellDataLinkedList.get(j);
                        buff.append(lineText);
                        buff.append(FormatCalculator.getTxtBlackText(columnWidth - FormatCalculator.getTxtTextWidth(lineText)));
                    } else {
                        buff.append(FormatCalculator.getTxtBlackText(columnWidth));
                    }
                    buff.append("  ");
                    buff.append('|');
                }
                buff.append(FormatCalculator.lineChanger);
                out.write(buff.toString());
                out.flush();
            }
            this.writeSeparatorLine(out);
            this.formatCalculator.setLastPrintedRowIndex(i);
        }
    }

    protected void writeSeparatorLine(BufferedWriter out) throws IOException {
        String separatorLine = this.formatCalculator.getTxtSeparatorLine();
        out.write(separatorLine);
        out.write(FormatCalculator.lineChanger);
    }
}

