/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.common.framework.utility.print.tools;

import com.huawei.dc.common.framework.utility.print.FormatCalculator;
import com.huawei.dc.common.framework.utility.print.PrintSupportor;
import com.huawei.dc.common.framework.utility.print.tools.AbstractSaveImpl;
import com.huawei.dc.common.util.DCDebugTracer;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.StringReader;
import java.util.Iterator;
import java.util.LinkedList;

public class HTMLSaveImpl
extends AbstractSaveImpl {
    public HTMLSaveImpl(FormatCalculator _formatCalculator) {
        super(_formatCalculator);
    }

    @Override
    public void write(BufferedWriter out) throws IOException {
        out.write(PrintSupportor.res.getString("Total"));
        out.write(Integer.toString(this.formatCalculator.getTotalDeviceCount()) + " ");
        out.write(PrintSupportor.res.getString("Device(s)"));
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        out.write("<TABLE BORDER=\"2\" CELLSPACING=\"0\" CELLPADDING=\"5\"    WIDTH=\"" + (screenSize.width - 50) + "\">");
        out.write("\r\n");
        this.writeTableHeaders(out);
        this.writeToHtml(out);
        out.write("</TABLE>");
        out.write("<BR>");
        out.write("<BR>");
        out.write("\r\n");
        out.write("</BODY>");
        out.write("\r\n");
        out.write("</HTML>");
        out.write("\r\n");
    }

    @Override
    public void writeTitle(BufferedWriter out) throws IOException {
        out.write("<HTML>");
        out.write("\r\n");
        out.write("<HEAD>");
        out.write("\r\n");
        out.write("<TITLE>");
        out.write("\r\n");
        out.write("\r\n");
        out.write("</TITLE>");
        out.write("\r\n");
        out.write("</HEAD>");
        out.write("\r\n");
        out.write("<BODY>");
        out.write("<h1 align=\"center\">");
        out.write(this.formatCalculator.getTitle());
        out.write("</h1><BR>");
    }

    @Override
    public void writeExtraInfo(BufferedWriter out) throws IOException {
        out.write("<pre>");
        out.write(PrintSupportor.res.getString("saveTime"));
        out.write(this.formatCalculator.getTime());
        out.write("<BR>");
        out.write(PrintSupportor.res.getString("userName"));
        out.write(this.formatCalculator.getUserName());
        out.write("</pre>");
        out.write("<BR>");
        out.write("<BR>");
        BufferedReader br = new BufferedReader(new StringReader(this.formatCalculator.getSummary()));
        String lineText = null;
        while ((lineText = br.readLine()) != null) {
            out.write(lineText);
            out.write("\r\n");
            out.write("<BR>");
        }
        out.write("\r\n");
    }

    private void writeTableHeaders(BufferedWriter out) throws IOException {
        out.write("<TR>");
        out.write("\r\n");
        String[] tableHeaders = this.formatCalculator.getTableHeaders();
        for (int i = 0; i < tableHeaders.length; ++i) {
            out.write("<TD \" ALIGN=\"CENTER\">");
            out.write("\r\n");
            out.write(tableHeaders[i]);
            out.write("\r\n");
            out.write("<BR>");
            out.write("</TD>");
            out.write("\r\n");
        }
        out.write("</TR>");
        out.write("\r\n");
    }

    private void writeToHtml(BufferedWriter out) throws IOException {
        for (int i = 0; i < this.formatCalculator.getTotalRowCount() - 1; ++i) {
            StringBuffer buff = new StringBuffer();
            buff.append("<TR>");
            buff.append("\r\n");
            int realRowIndex = -1;
            while (!(this.isOver() || (realRowIndex = i) >= 0 && realRowIndex < this.formatCalculator.getAnalyzedRowCount())) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    DCDebugTracer.trace(e);
                }
            }
            if (this.isOver()) {
                return;
            }
            LinkedList rowDataLinkedList = this.formatCalculator.getAnalyzedRowLinkList(realRowIndex);
            Iterator columnIterator = rowDataLinkedList.iterator();
            while (columnIterator.hasNext()) {
                buff.append("<TD \" ALIGN=\"LEFT\">");
                buff.append("\r\n");
                LinkedList cellDataLinkedList = (LinkedList)columnIterator.next();
                if (cellDataLinkedList.size() == 0) {
                    buff.append("-");
                    buff.append("\r\n");
                    buff.append("<BR>");
                } else {
                    Iterator cellLineIterator = cellDataLinkedList.iterator();
                    while (cellLineIterator.hasNext()) {
                        String cellLineText = this.replaceChar((String)cellLineIterator.next());
                        buff.append(cellLineText);
                        buff.append("\r\n");
                        buff.append("<BR>");
                    }
                }
                buff.append("</TD>");
                buff.append("\r\n");
            }
            buff.append("</TR>");
            buff.append("\r\n");
            out.write(buff.toString());
            out.flush();
            this.formatCalculator.setLastPrintedRowIndex(i);
        }
    }

    private String replaceChar(String cellLineText) {
        String covert1 = cellLineText.replaceAll("<", "&lt;");
        String covert2 = covert1.replaceAll(">", "&gt;");
        return covert2;
    }
}

