/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.common.framework.utility.print.tools;

import com.huawei.dc.common.framework.utility.print.FormatCalculator;
import com.huawei.dc.common.framework.utility.print.PrintSupportor;
import com.huawei.dc.common.framework.utility.print.tools.TXTSaveImpl;
import com.huawei.dc.common.util.DCDebugTracer;
import java.io.BufferedWriter;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;

public class CSVSaveImpl
extends TXTSaveImpl {
    public CSVSaveImpl(FormatCalculator formatCalculator) {
        super(formatCalculator.getCsvFormatCalculator());
    }

    @Override
    public void writeTitle(BufferedWriter out) throws IOException {
        out.write(this.formatCalculator.getTitle());
        out.write(FormatCalculator.lineChanger);
    }

    @Override
    public void writeExtraInfo(BufferedWriter out) throws IOException {
        StringBuffer extraInfoBuffer1 = new StringBuffer(PrintSupportor.res.getString("saveTime"));
        extraInfoBuffer1.append(this.formatCalculator.getTime());
        out.write(extraInfoBuffer1.toString());
        out.write(FormatCalculator.lineChanger);
        StringBuffer extraInfoBuffer2 = new StringBuffer(PrintSupportor.res.getString("userName").trim());
        extraInfoBuffer2.append(this.formatCalculator.getUserName().trim());
        out.write(extraInfoBuffer2.toString());
        out.write(FormatCalculator.lineChanger);
        out.write("\"" + this.formatCalculator.getSummary() + "\"");
        out.write(System.getProperty("line.separator"));
    }

    @Override
    protected void writeHeader(BufferedWriter out) throws IOException {
        int[] columnWidthArray = this.formatCalculator.getTxtColumnWidths();
        String[] tableHeaders = this.formatCalculator.getTableHeaders();
        for (int i = 0; i < columnWidthArray.length; ++i) {
            String ss = tableHeaders[i];
            ss = ss.replaceAll("\n", "");
            ss = ss.replaceAll("\r", "");
            out.write(ss);
            if (i == columnWidthArray.length - 1) continue;
            out.write(44);
        }
        out.write(FormatCalculator.lineChanger);
    }

    @Override
    protected void writeData(BufferedWriter out) throws IOException {
        for (int i = 0; i < this.formatCalculator.getTotalRowCount() - 1; ++i) {
            int realRowIndex = -1;
            while (!(this.isOver() || (realRowIndex = i) >= 0 && realRowIndex < this.formatCalculator.getAnalyzedRowCount())) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    DCDebugTracer.trace(e);
                }
            }
            if (this.isOver()) {
                return;
            }
            LinkedList rowDataLinkedList = this.formatCalculator.getAnalyzedRowLinkList(realRowIndex);
            int cellLineCount = 0;
            for (LinkedList cellDataLinkedList : rowDataLinkedList) {
                if (cellLineCount >= cellDataLinkedList.size()) continue;
                cellLineCount = cellDataLinkedList.size();
            }
            for (int j = 0; j < cellLineCount; ++j) {
                Iterator columnIterator = rowDataLinkedList.iterator();
                StringBuffer buff = new StringBuffer();
                for (int columnIndex = 0; columnIndex < this.formatCalculator.getTableHeaders().length; ++columnIndex) {
                    LinkedList cellDataLinkedList = (LinkedList)columnIterator.next();
                    if (j < cellDataLinkedList.size()) {
                        String lineText = (String)cellDataLinkedList.get(j);
                        buff.append(lineText);
                    }
                    if (columnIndex == this.formatCalculator.getColumnWidths().length - 1) continue;
                    buff.append(',');
                }
                buff.append(FormatCalculator.lineChanger);
                out.write(buff.toString());
                out.flush();
            }
            this.formatCalculator.setLastPrintedRowIndex(i);
        }
    }
}

