/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.common.framework.utility.print;

import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.DCTimeDateFormat;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.util.Calendar;
import java.util.ResourceBundle;
import java.util.StringTokenizer;

public abstract class PrintableTool
implements Printable,
Cloneable {
    static ResourceBundle res = ResourceBundle.getBundle("com.huawei.dc.common.framework.utility.print.Res");
    protected static final Graphics2D standardGraphics = new BufferedImage(10, 10, 2).createGraphics();
    protected static final Font headFont = new Font("Dialog", 1, 12);
    private boolean m_bDataOver = false;
    protected String title = null;
    protected String userName = null;
    protected boolean headInfoEnabled = false;
    protected boolean areaBoxEnabled = false;
    private static int m_iHeaderBorderHeight = 2;
    private static boolean isFirstPreview = true;
    protected String printTimeText;

    public PrintableTool() {
        Calendar cal = Calendar.getInstance();
        DCTimeDateFormat backupTimeFormat = new DCTimeDateFormat(cal);
        this.printTimeText = backupTimeFormat.toString();
    }

    public PrintableTool(String title, String userName) {
        Calendar cal = Calendar.getInstance();
        DCTimeDateFormat printTimeFormat = new DCTimeDateFormat(cal);
        this.printTimeText = printTimeFormat.toString();
        this.title = title;
        this.userName = userName;
        this.headInfoEnabled = true;
    }

    @Override
    public int print(Graphics g, PageFormat pageFormat, int pageIndex) {
        if (pageIndex < 0 || pageIndex >= this.getPageCount() || this.isDataOver()) {
            return 1;
        }
        Graphics2D g2 = (Graphics2D)g;
        double toX = pageFormat.getImageableX();
        double toY = pageFormat.getImageableY();
        g2.translate(toX, toY);
        this.printLines(g2, pageFormat);
        if (this.headInfoEnabled) {
            this.drawHeadInfo(g2, pageFormat, pageIndex);
        }
        if (this.areaBoxEnabled) {
            this.drawAreaBox(g2, pageFormat, pageIndex);
        }
        this.drawPage(g2, pageFormat, pageIndex);
        g2.translate(-toX, -toY);
        return 0;
    }

    public boolean isDataOver() {
        return this.m_bDataOver;
    }

    public void setDataOver(boolean dataOver) {
        this.m_bDataOver = dataOver;
    }

    public boolean isHeadInfoEnabled() {
        return this.headInfoEnabled;
    }

    public void setHeadInfoEnabled(boolean headInfoEnabled) {
        this.headInfoEnabled = headInfoEnabled;
    }

    public boolean isAreaBoxEnabled() {
        return this.areaBoxEnabled;
    }

    public void setAreaBoxEnabled(boolean areaBoxEnabled) {
        this.areaBoxEnabled = areaBoxEnabled;
    }

    public abstract int getPageCount();

    protected abstract void drawPage(Graphics2D var1, PageFormat var2, int var3);

    protected void drawHeadInfo(Graphics2D g, PageFormat pf, int pageIndex) {
        isFirstPreview = false;
        g.getTransform();
        int headFontHeight = PrintableTool.getFontHeight(headFont);
        int headFontDescent = PrintableTool.getFontDescent(headFont);
        int imageableWidth = (int)pf.getImageableWidth();
        g.setFont(headFont);
        this.title = this.title != null && !this.title.equals("") ? this.title : "(untitled)";
        this.userName = this.userName != null && !this.userName.equals("") ? this.userName : "(unknown user)";
        g.setPaint(Color.black);
        FontMetrics fm = g.getFontMetrics(headFont);
        int titleWidth = fm.stringWidth(this.title);
        int titleStartX = (imageableWidth - titleWidth) / 2;
        g.drawString(this.title, titleStartX, headFontHeight - headFontDescent + 3);
        StringBuffer extraInfoBuffer = new StringBuffer(res.getString("printTime"));
        extraInfoBuffer.append(this.printTimeText);
        extraInfoBuffer.append("\n");
        extraInfoBuffer.append(res.getString("userName"));
        extraInfoBuffer.append(this.userName);
        extraInfoBuffer.append("\n");
        extraInfoBuffer.append(res.getString("currentPage"));
        extraInfoBuffer.append(pageIndex + 1);
        String extraInfoText = extraInfoBuffer.toString();
        StringTokenizer infoAboutRectangleHeight = new StringTokenizer(extraInfoText, "\n");
        int k = 1;
        while (infoAboutRectangleHeight.hasMoreElements()) {
            infoAboutRectangleHeight.nextToken();
            ++k;
        }
        int infoWidth = fm.stringWidth(extraInfoText);
        int infoStartX = (imageableWidth - infoWidth) / 2;
        if (infoWidth / imageableWidth > 0) {
            String token;
            m_iHeaderBorderHeight = k - 1;
            g.draw(new Rectangle2D.Double(0.0, 0.0, imageableWidth, this.getHeadHeight()));
            infoStartX = 0;
            StringBuffer extraInfoBuffer_Time_User = new StringBuffer(res.getString("printTime"));
            extraInfoBuffer_Time_User.append(this.printTimeText);
            extraInfoBuffer_Time_User.append(res.getString("userName"));
            extraInfoBuffer_Time_User.append(this.userName);
            StringBuffer extraInfoBuffer_Page = new StringBuffer(res.getString("currentPage"));
            extraInfoBuffer_Page.append(pageIndex + 1);
            String extraInfoTextTime_User = extraInfoBuffer_Time_User.toString();
            int infoWidth1 = imageableWidth - 20;
            int infoStartX1 = (imageableWidth - infoWidth1) / 2;
            String extraInfoTextPage = extraInfoBuffer_Page.toString();
            int infoWidth2 = fm.stringWidth(extraInfoTextPage);
            int infoStartX2 = (imageableWidth - infoWidth2) / 2;
            StringTokenizer extraPageInfo = new StringTokenizer(extraInfoTextTime_User, "\n");
            int i = 0;
            while (extraPageInfo.hasMoreElements()) {
                token = extraPageInfo.nextToken();
                g.drawString(token, infoStartX1, headFontHeight * 2 - headFontDescent + 3 + i * 15);
                ++i;
            }
            extraPageInfo = new StringTokenizer(extraInfoTextPage, "\n");
            while (extraPageInfo.hasMoreElements()) {
                token = extraPageInfo.nextToken();
                g.drawString(token, infoStartX2, headFontHeight * 2 - headFontDescent + 3 + i * 15);
                ++i;
            }
            return;
        }
        m_iHeaderBorderHeight = k;
        g.draw(new Rectangle2D.Double(0.0, 0.0, imageableWidth, this.getHeadHeight()));
        StringTokenizer extraPageInfo = new StringTokenizer(extraInfoText, "\n");
        int i = 0;
        while (extraPageInfo.hasMoreElements()) {
            String token = extraPageInfo.nextToken();
            g.drawString(token, infoStartX, headFontHeight * 2 - headFontDescent + 3 + i * 15);
            ++i;
        }
    }

    protected void drawAreaBox(Graphics2D g, PageFormat pf, int pageIndex) {
        g.getTransform();
        double imageableWidth = pf.getImageableWidth();
        double imageableHeight = pf.getImageableHeight();
        g.draw(new Rectangle2D.Double(0.0, 0.0, imageableWidth, imageableHeight));
    }

    protected int getHeadHeight() {
        if (this.headInfoEnabled) {
            return PrintableTool.getFontHeight(headFont) * m_iHeaderBorderHeight + 6;
        }
        return 0;
    }

    public static int getHeadHeight(boolean headInfoEnabled) {
        if (isFirstPreview) {
            StringBuffer extraInfoBuffer = new StringBuffer(res.getString("printTime"));
            extraInfoBuffer.append("\n");
            extraInfoBuffer.append(res.getString("userName"));
            extraInfoBuffer.append("\n");
            extraInfoBuffer.append(res.getString("currentPage"));
            String extraInfoText = extraInfoBuffer.toString();
            StringTokenizer infoAboutRectangleHeight = new StringTokenizer(extraInfoText, "\n");
            int k = 1;
            while (infoAboutRectangleHeight.hasMoreElements()) {
                infoAboutRectangleHeight.nextToken();
                ++k;
            }
            m_iHeaderBorderHeight = k;
        }
        if (headInfoEnabled) {
            return PrintableTool.getFontHeight(headFont) * m_iHeaderBorderHeight + 6;
        }
        return 0;
    }

    protected static int getCharsWidth(char[] chars, int offset, int length, Font font) {
        FontMetrics fm = standardGraphics.getFontMetrics(font);
        int charsWidth = fm.charsWidth(chars, offset, length);
        return charsWidth;
    }

    protected static int getTextWidth(String text, Font font) {
        FontMetrics fm = standardGraphics.getFontMetrics(font);
        return fm.stringWidth(text);
    }

    protected static int getFontHeight(Font font) {
        FontMetrics fm = standardGraphics.getFontMetrics(font);
        return fm.getHeight();
    }

    protected static int getFontDescent(Font font) {
        FontMetrics fm = standardGraphics.getFontMetrics(font);
        return fm.getDescent();
    }

    public Object clone() {
        try {
            return (PrintableTool)super.clone();
        }
        catch (CloneNotSupportedException e) {
            DCDebugTracer.trace(e);
            return this;
        }
    }

    public void setScale(double scale) {
        standardGraphics.scale(scale, scale);
    }

    private void printLines(Graphics2D g, PageFormat pf) {
        double c = 36.0;
        double d = 20.0;
        double w = pf.getImageableWidth();
        double h = pf.getImageableHeight();
        g.setPaint(Color.black);
        g.draw(new Line2D.Double(-d, -d, -d, c - d));
        g.draw(new Line2D.Double(-d, -d, c - d, -d));
        g.draw(new Line2D.Double(w + d, -d, w + d, c - d));
        g.draw(new Line2D.Double(w + d, -d, w - c + d, -d));
        g.draw(new Line2D.Double(-d, h + d, -d, h - c + d));
        g.draw(new Line2D.Double(-d, h + d, c - d, h + d));
        g.draw(new Line2D.Double(w + d, h + d, w + d, h - c + d));
        g.draw(new Line2D.Double(w + d, h + d, w - c + d, h + d));
    }

    public String getTitle() {
        return this.title;
    }
}

