/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.common.framework.utility.print;

import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.framework.utility.print.PrintableTool;
import com.huawei.dc.common.util.DCOptionPane;
import java.awt.Component;
import java.awt.print.Printable;
import java.awt.print.PrinterJob;
import java.util.ResourceBundle;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.swing.SwingUtilities;

class PrintThread
extends Thread {
    static ResourceBundle res = ResourceBundle.getBundle("com.huawei.dc.common.framework.utility.print.Res");
    private Component m_oWindow = null;
    private PrinterJob m_oPrinterJob = null;
    private PrintRequestAttributeSet m_oAttributeSet = null;
    private PrintableTool m_oPrintable = null;

    PrintThread(Component window, PrinterJob printerJob, PrintRequestAttributeSet attributeSet) {
        this.m_oWindow = window;
        this.m_oPrinterJob = printerJob;
        this.m_oAttributeSet = attributeSet;
    }

    PrintThread(Component window, PrinterJob printerJob, PrintRequestAttributeSet attributeSet, Object obj) {
        this.m_oWindow = window;
        this.m_oPrinterJob = printerJob;
        this.m_oAttributeSet = attributeSet;
        if (obj instanceof Printable && obj instanceof PrintableTool) {
            this.m_oPrintable = (PrintableTool)obj;
        }
    }

    @Override
    public void run() {
        try {
            this.m_oPrinterJob.print(this.m_oAttributeSet);
        }
        catch (Exception e) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    DCOptionPane.showMessageDialog(PrintThread.this.m_oWindow, res.getString("PrintExit"), ResourceManager.getInstance().getResString("DEVICE_VERSION_PRINT_BTN"), 0);
                }
            });
        }
        if (this.m_oPrintable != null) {
            this.m_oPrintable.setDataOver(true);
        }
    }
}

