/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.common.framework.utility.print;

import com.huawei.dc.common.components.dialog.DCModalDialog;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.framework.utility.print.FileSavingThread;
import com.huawei.dc.common.framework.utility.print.PageableTool;
import com.huawei.dc.common.framework.utility.print.PreviewDialog;
import com.huawei.dc.common.framework.utility.print.PreviewInPanel;
import com.huawei.dc.common.framework.utility.print.PrintServiceUI;
import com.huawei.dc.common.framework.utility.print.PrintThread;
import com.huawei.dc.common.framework.utility.print.PrintableTool;
import com.huawei.dc.common.framework.utility.print.ScriptObject;
import com.huawei.dc.common.framework.utility.print.ScriptObjectFactory;
import com.huawei.dc.common.framework.utility.print.tools.TablePrintImpl;
import com.huawei.dc.common.framework.utility.print.tools.TablePrintable;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.DCOptionPane;
import com.huawei.dc.common.util.IOStreamClose;
import com.swimap.iview.commstyle.resource.ResourceMng;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Window;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Printable;
import java.awt.print.PrinterJob;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.util.ResourceBundle;
import javax.print.DocFlavor;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.attribute.Attribute;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.standard.MediaPrintableArea;
import javax.print.attribute.standard.OrientationRequested;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class PrintSupportor {
    private static boolean isCheckFileNameAndType = true;
    private static int orientationOfPaper = 0;
    public static final ResourceBundle res = ResourceBundle.getBundle("com.huawei.dc.common.framework.utility.print.Res");
    protected static final PrintRequestAttributeSet printRequestAttributeSet = new HashPrintRequestAttributeSet();
    private static PageFormat pageFormat = new PageFormat();
    private static PreviewDialog previewDialog = null;
    private static double m_screenScale = 0.7348484848485;
    private static boolean m_isFileSelection = false;

    public static void preview(Window window, TablePrintable tablePrintable, int pageCount) {
        TablePrintImpl tablePrintImpl = new TablePrintImpl(false, tablePrintable.getFormatCalculator());
        tablePrintable.setImplRef(tablePrintImpl);
        tablePrintImpl.getFormatCalculator().setPageFormatWithCompute(pageFormat);
        PrintSupportor.preview(window, tablePrintImpl, pageCount);
    }

    public static void preview(Window mainWindow, Printable printable, int pageCount) {
        if (printable instanceof PrintableTool) {
            PrintableTool tool = (PrintableTool)printable;
            tool = (PrintableTool)tool.clone();
            tool.setScale(m_screenScale);
            printable = tool;
            pageCount = ((PrintableTool)printable).getPageCount();
        }
        PageableTool pageableTool = new PageableTool();
        pageableTool.append(printable, PrintSupportor.getPageFormat(), pageCount);
        PrintSupportor.preview(mainWindow, pageableTool);
    }

    public static void preview(Component mainWindow, Pageable pageable) {
        if (!PrintSupportor.isImageableWidthAndHeight()) {
            return;
        }
        if (pageable.getNumberOfPages() == 0) {
            DCOptionPane.showMessageDialog(mainWindow, res.getString("EmptyPage"), ResourceManager.getInstance().getResString("PREVIEW"), 0);
            return;
        }
        if (previewDialog != null && previewDialog.isVisible()) {
            previewDialog.closeWindow();
        }
        if (mainWindow instanceof Frame) {
            previewDialog = new PreviewDialog((Frame)mainWindow, pageable);
        } else if (mainWindow instanceof DCModalDialog) {
            previewDialog = new PreviewDialog((DCModalDialog)((Object)mainWindow), pageable);
        } else {
            mainWindow = new Frame();
            previewDialog = new PreviewDialog((Frame)mainWindow, pageable);
        }
        previewDialog.setVisible(true);
    }

    public static JPanel preview(Window mainWindow, JPanel mainPanel, TablePrintable tablePrintable, int pageCount) {
        TablePrintImpl tablePrintImpl = new TablePrintImpl(false, tablePrintable.getFormatCalculator());
        tablePrintable.setImplRef(tablePrintImpl);
        tablePrintImpl.getFormatCalculator().setPageFormatWithCompute(pageFormat);
        return PrintSupportor.preview(mainWindow, mainPanel, tablePrintImpl, pageCount);
    }

    public static JPanel preview(Window mainWindow, JPanel mainPanel, Printable printable, int pageCount) {
        if (printable instanceof PrintableTool) {
            PrintableTool tool = (PrintableTool)printable;
            tool = (PrintableTool)tool.clone();
            tool.setScale(m_screenScale);
            printable = tool;
            pageCount = ((PrintableTool)printable).getPageCount();
        }
        PageableTool pageableTool = new PageableTool();
        pageableTool.append(printable, PrintSupportor.getPageFormat(), pageCount);
        return PrintSupportor.preview(mainWindow, mainPanel, pageableTool);
    }

    public static JPanel preview(Window mainWindow, JPanel mainPanel, Pageable pageable) {
        if (!PrintSupportor.isImageableWidthAndHeight()) {
            return null;
        }
        if (pageable.getNumberOfPages() == 0) {
            DCOptionPane.showMessageDialog((Component)mainWindow, res.getString("EmptyPage"), ResourceManager.getInstance().getResString("PREVIEW"), 0);
            return null;
        }
        return new PreviewInPanel(mainWindow, pageable);
    }

    public static void printFile(Window mainFrame, String fileName) {
        ScriptObject scriptObject = null;
        try {
            scriptObject = ScriptObjectFactory.getScriptObject(fileName);
        }
        catch (Exception e) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), res.getString("checkFileValid"), ResourceManager.getInstance().getResString("DEVICE_VERSION_PRINT_BTN"), 1);
                }
            });
            return;
        }
        DocFlavor docFlavor = scriptObject.getDocFlavor();
        Object printData = scriptObject.getPrintData();
        PrintSupportor.isPrintable(mainFrame, printData, docFlavor, -1);
    }

    public static boolean saveToFile(Window window, String fileName, TablePrintable tablePrintable, String fileType) {
        m_isFileSelection = false;
        if (!PrintSupportor.isValidFileNameAndType(window, fileName, fileType)) {
            return false;
        }
        return PrintSupportor.saveToFileNoCheck(window, fileName, tablePrintable, fileType);
    }

    public static boolean saveToFileNoCheck(Window window, String fileName, TablePrintable tablePrintable, String fileType) {
        if (tablePrintable == null) {
            return false;
        }
        FileSavingThread thread = new FileSavingThread(window, fileName, tablePrintable, fileType);
        thread.start();
        return true;
    }

    public static boolean saveToFile(Window window, String fileName, TablePrintable tablePrintable, String fileType, String userEncoding) {
        m_isFileSelection = false;
        if (!PrintSupportor.isValidFileNameAndType(window, fileName, fileType)) {
            return false;
        }
        return PrintSupportor.saveToFileNoCheck(window, fileName, tablePrintable, fileType, userEncoding);
    }

    public static boolean saveToFileNoCheck(Window window, String fileName, TablePrintable tablePrintable, String fileType, String userEncoding) {
        if (tablePrintable == null) {
            return false;
        }
        FileSavingThread thread = new FileSavingThread(window, fileName, tablePrintable, fileType, userEncoding);
        thread.start();
        return true;
    }

    public static boolean saveToFile(Window window, String fileName, TablePrintable[] tablePrintables, String fileType) {
        m_isFileSelection = false;
        if (!PrintSupportor.isValidFileNameAndType(window, fileName, fileType)) {
            return false;
        }
        return PrintSupportor.saveToFileNoCheck(window, fileName, tablePrintables, fileType);
    }

    public static boolean saveToFileNoCheck(Window window, String fileName, TablePrintable[] tablePrintables, String fileType) {
        FileSavingThread thread = new FileSavingThread(window, fileName, tablePrintables, fileType);
        thread.start();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isValidFileNameAndType(Component window, String fileName, String fileType) {
        if (isCheckFileNameAndType) {
            String fileNameIgnoreCase = fileName.toLowerCase(ResourceMng.getInstance().getLocale());
            if (fileType.equals("html")) {
                if (!fileNameIgnoreCase.endsWith(".html") && !fileNameIgnoreCase.endsWith(".htm")) {
                    fileName = fileName + ".html";
                }
            } else if (fileType.equals("htm")) {
                if (!fileNameIgnoreCase.endsWith(".htm")) {
                    fileName = fileName + ".htm";
                }
            } else if (fileType.equals("txt")) {
                if (!fileNameIgnoreCase.endsWith(".txt")) {
                    fileName = fileName + ".txt";
                }
            } else if (fileType.equals("csv")) {
                if (!fileNameIgnoreCase.endsWith(".csv")) {
                    fileName = fileName + ".csv";
                }
            } else if (fileType.equals("xls")) {
                if (!fileNameIgnoreCase.endsWith(".xls")) {
                    fileName = fileName + ".xls";
                }
            } else if (fileType.equals("xml") && !fileNameIgnoreCase.endsWith(".xml")) {
                fileName = fileName + ".xml";
            }
            if (!PrintSupportor.isFileNameValid(fileName)) {
                DCOptionPane.showMessageDialog(window, res.getString("FILENAME_ERROR"), ResourceManager.getInstance().getResString("DEVICE_VERSION_SAVE_BTN"), 0);
                return false;
            }
            File file = new File(fileName);
            if (m_isFileSelection) {
                return true;
            }
            if (file.exists() && !m_isFileSelection) {
                file.canExecute();
                if (file.canWrite()) {
                    int option = DCOptionPane.showConfirmDialog(window, res.getString("coverFile"), res.getString("confirmTitle"), 0);
                    if (option != 0) {
                        return false;
                    }
                } else {
                    DCOptionPane.showMessageDialog(window, res.getString("readOnly"), ResourceManager.getInstance().getResString("DEVICE_VERSION_SAVE_BTN"), 0);
                    return false;
                }
            }
            BufferedWriter oBufferedWriter = null;
            FileWriter oFileWriter = null;
            try {
                if (file.getParentFile() != null && !file.getParentFile().mkdir()) {
                    DCDebugTracer.trace("DC::PrintSupportor.isValidFileNameAndType(fail to make dir < " + file.getParentFile() + ">)");
                }
                oFileWriter = new FileWriter(file);
                oBufferedWriter = new BufferedWriter(oFileWriter);
            }
            catch (Exception e) {
                boolean bl;
                try {
                    DCDebugTracer.trace("gaozhongxuan4" + e);
                    DCOptionPane.showMessageDialog(window, res.getString("SAVE_EXIT"), ResourceManager.getInstance().getResString("DEVICE_VERSION_SAVE_BTN"), 0);
                    bl = false;
                }
                catch (Throwable throwable) {
                    IOStreamClose.closeWriter(oFileWriter);
                    IOStreamClose.closeWriter(oBufferedWriter);
                    throw throwable;
                }
                IOStreamClose.closeWriter(oFileWriter);
                IOStreamClose.closeWriter(oBufferedWriter);
                return bl;
            }
            IOStreamClose.closeWriter(oFileWriter);
            IOStreamClose.closeWriter(oBufferedWriter);
        }
        isCheckFileNameAndType = true;
        return true;
    }

    public static void setupPage() {
        PrinterJob job = PrinterJob.getPrinterJob();
        PageFormat pf = job.pageDialog(printRequestAttributeSet);
        Attribute[] att = printRequestAttributeSet.toArray();
        for (int i = 0; i < att.length; ++i) {
            if (!(att[i] instanceof OrientationRequested)) continue;
            OrientationRequested or = (OrientationRequested)att[i];
            orientationOfPaper = or.getValue() % 3;
        }
        if (pf != null) {
            pageFormat = pf;
        }
    }

    public static boolean print(Window window, Printable printable, int pageCount) {
        PageableTool pageableTool = new PageableTool();
        pageableTool.append(printable, PrintSupportor.getPageFormat(), pageCount);
        return PrintSupportor.print(window, pageableTool);
    }

    public static boolean print(Window window, TablePrintable tablePrintable, int pageCount) {
        TablePrintImpl tablePrintImpl = new TablePrintImpl(false, tablePrintable.getFormatCalculator());
        tablePrintable.setImplRef(tablePrintImpl);
        return PrintSupportor.print(window, tablePrintImpl, pageCount);
    }

    public static boolean print(Component window, Pageable pageable) {
        DocFlavor.SERVICE_FORMATTED docFlavor = DocFlavor.SERVICE_FORMATTED.PAGEABLE;
        int numberOfPages = pageable.getNumberOfPages();
        if (numberOfPages == 0) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), res.getString("EmptyPage"), ResourceManager.getInstance().getResString("DEVICE_VERSION_PRINT_BTN"), 0);
                }
            });
            return false;
        }
        return PrintSupportor.isPrintable(window, pageable, docFlavor, numberOfPages);
    }

    private static boolean isPrintable(Component window, Object printData, DocFlavor docFlavor, int numberOfPages) {
        Printable obj;
        HashPrintRequestAttributeSet attributeSet = new HashPrintRequestAttributeSet();
        PrintService[] printServices = null;
        try {
            printServices = PrintServiceLookup.lookupPrintServices(docFlavor, attributeSet);
        }
        catch (Exception e) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), res.getString("ZeroPrinter"), ResourceManager.getInstance().getResString("DEVICE_VERSION_PRINT_BTN"), 1);
                }
            });
            return false;
        }
        if (printServices.length == 0) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), res.getString("ZeroPrinter"), ResourceManager.getInstance().getResString("DEVICE_VERSION_PRINT_BTN"), 1);
                }
            });
            return false;
        }
        Attribute[] attributes = printRequestAttributeSet.toArray();
        for (int i = 0; i < attributes.length; ++i) {
            attributeSet.add(attributes[i]);
        }
        PrinterJob printerJob = PrinterJob.getPrinterJob();
        PrintService printService = PrintServiceUI.printDialog(null, 100, 100, printServices, printServices[printServices.length - 1], docFlavor, attributeSet);
        if (printService == null) {
            return false;
        }
        try {
            printerJob.setPrintService(printService);
            PrintSupportor.modifyAttributeSet(attributeSet);
        }
        catch (Exception e) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), res.getString("ZeroPrinter"), ResourceManager.getInstance().getResString("DEVICE_VERSION_PRINT_BTN"), 1);
                }
            });
            return false;
        }
        if (previewDialog != null && previewDialog.isVisible()) {
            previewDialog.closeWindow();
        }
        if ((obj = ((PageableTool)printData).getPrintable(0)) instanceof Printable) {
            if (obj instanceof TablePrintImpl) {
                TablePrintImpl tablePrintImpl = (TablePrintImpl)obj;
                tablePrintImpl.reset();
            }
            printerJob.setPrintable(obj, pageFormat);
        }
        PrintThread thread = new PrintThread(window, printerJob, attributeSet, obj);
        thread.start();
        return true;
    }

    public static PageFormat getPageFormat() {
        return (PageFormat)pageFormat.clone();
    }

    private static boolean isImageableWidthAndHeight() {
        PageFormat pageFormat = PrinterJob.getPrinterJob().defaultPage();
        int imageableWidth = (int)pageFormat.getImageableWidth();
        int imageableHeight = (int)pageFormat.getImageableHeight();
        return imageableWidth != 0 && imageableHeight != 0;
    }

    private PrintSupportor() {
    }

    public static boolean isFileNameValid(String fileName) {
        File file = new File(fileName);
        fileName = file.getName();
        String[] illegalChar = new String[]{":", "/", "\"", "<", ">", "|", "?", "*"};
        for (int i = 0; i < illegalChar.length; ++i) {
            if (fileName.indexOf(illegalChar[i]) == -1) continue;
            return false;
        }
        return true;
    }

    public static void modifyAttributeSet(PrintRequestAttributeSet attributeSet) {
        if (attributeSet instanceof HashPrintRequestAttributeSet) {
            HashPrintRequestAttributeSet set = (HashPrintRequestAttributeSet)attributeSet;
            MediaPrintableArea mediaPrintableArea = (MediaPrintableArea)set.get(MediaPrintableArea.class);
            int units = 1;
            float x = mediaPrintableArea.getX(units);
            float y = mediaPrintableArea.getY(units);
            float w = mediaPrintableArea.getWidth(units);
            float h = mediaPrintableArea.getHeight(units);
            if (y > 25400.0f) {
                h += y - 25400.0f;
                y = 25400.0f;
            }
            if (x > 19000.0f) {
                w += x - 19000.0f;
                x = 19000.0f;
            }
            MediaPrintableArea myMediaPrintableArea = new MediaPrintableArea(x, y, w, h, units);
            set.remove(mediaPrintableArea);
            set.add(myMediaPrintableArea);
            return;
        }
    }

    public static int getOrientationOfPaper() {
        return orientationOfPaper;
    }

    public static void setIsCheckFileNameAndType(boolean blCheckFileNameAndType) {
        isCheckFileNameAndType = blCheckFileNameAndType;
    }

    public static void setIsFileSelection(boolean bIsFileSelection) {
        m_isFileSelection = bIsFileSelection;
    }

    public static void setScreenSize(double screenScale) {
        m_screenScale = screenScale;
    }
}

