/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.common.framework.utility.print;

import com.huawei.dc.common.util.DCDebugTracer;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.print.PrinterJob;
import javax.print.DocFlavor;
import javax.print.PrintService;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.standard.Destination;
import sun.print.SunAlternateMedia;

public class PrintServiceUI {
    public static PrintService printDialog(GraphicsConfiguration gc, int x, int y, PrintService[] services, PrintService defaultService, DocFlavor flavor, PrintRequestAttributeSet attributes) throws HeadlessException {
        PrinterJob printerJob;
        int defaultIndex = -1;
        if (GraphicsEnvironment.isHeadless()) {
            throw new HeadlessException();
        }
        if (services == null || services.length == 0) {
            throw new IllegalArgumentException("services must be non-null and non-empty");
        }
        if (attributes == null) {
            throw new IllegalArgumentException("attributes must be non-null");
        }
        if (defaultService != null) {
            for (int i = 0; i < services.length; ++i) {
                if (!((Object)services[i]).equals(defaultService)) continue;
                defaultIndex = i;
                break;
            }
            if (defaultIndex < 0) {
                throw new IllegalArgumentException("services must contain defaultService");
            }
        } else {
            defaultIndex = 0;
        }
        if ((printerJob = PrinterJob.getPrinterJob()).printDialog(attributes)) {
            try {
                Class<Destination> dstCategory = Destination.class;
                Class<SunAlternateMedia> amCategory = SunAlternateMedia.class;
                if (attributes.containsKey(dstCategory) && !attributes.containsKey(dstCategory)) {
                    attributes.remove(dstCategory);
                }
                if (attributes.containsKey(amCategory) && !attributes.containsKey(amCategory)) {
                    attributes.remove(amCategory);
                }
                attributes.addAll(attributes);
                return printerJob.getPrintService();
            }
            catch (Exception ex) {
                DCDebugTracer.trace(ex);
            }
        }
        return null;
    }
}

