/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.common.framework.utility.print;

import com.huawei.dc.common.framework.utility.print.PrintSupportor;
import com.huawei.dc.common.util.DCDebugTracer;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import javax.swing.JPanel;

class PreviewPanel
extends JPanel {
    private static final long serialVersionUID = 8870697022811327859L;
    private int leftBoundary;
    private int rightBoundary;
    private int topBoundary;
    private int bottomBoundary;
    private Pageable m_oPageable = null;
    private int m_currentPage = 0;

    PreviewPanel(Pageable pageable) {
        this.m_oPageable = pageable;
        Color background = new Color(128, 128, 128);
        this.setBackground(background);
    }

    @Override
    public void paintComponent(Graphics g) {
        double offY;
        double offX;
        double scale;
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        PageFormat p = null;
        try {
            p = this.m_oPageable.getPageFormat(this.m_currentPage);
        }
        catch (Exception e) {
            DCDebugTracer.trace(e);
            return;
        }
        double px = p.getWidth();
        double py = p.getHeight();
        double sx = this.getWidth() - 1;
        double sy = this.getHeight() - 21;
        if (px / py < sx / sy) {
            scale = sy / py;
            offX = 0.5 * (sx - scale * px);
            offY = 10.0;
        } else {
            scale = sx / px;
            offX = 0.0;
            offY = 0.5 * (sy - scale * py) + 10.0;
        }
        g2.translate(offX, offY);
        this.leftBoundary = (int)offX;
        this.topBoundary = (int)offY;
        g2.scale(scale, scale);
        PrintSupportor.setScreenSize(scale);
        Rectangle2D.Double page = new Rectangle2D.Double(0.0, 0.0, px, py);
        this.rightBoundary = this.leftBoundary + (int)(px * scale);
        this.bottomBoundary = this.topBoundary + (int)(py * scale);
        g2.setPaint(Color.white);
        g2.fill(page);
        g2.setPaint(Color.black);
        g2.draw(page);
        Printable printable = this.m_oPageable.getPrintable(this.m_currentPage);
        try {
            printable.print(g2, p, this.m_currentPage);
        }
        catch (PrinterException e) {
            g2.draw(new Line2D.Double(0.0, 0.0, px, py));
            g2.draw(new Line2D.Double(0.0, px, 0.0, py));
        }
        g2.scale(1.0 / scale, 1.0 / scale);
        g2.translate(-offX, -offY);
    }

    public void flipPage(int count) {
        int newPage = this.m_currentPage + count;
        if (0 <= newPage && newPage < this.m_oPageable.getNumberOfPages()) {
            this.m_currentPage = newPage;
            this.repaint();
        }
    }

    public boolean hasNext() {
        return this.m_currentPage != this.m_oPageable.getNumberOfPages() - 1;
    }

    public boolean hasPrevious() {
        return this.m_currentPage != 0;
    }

    public void setCurrentPage(int currentPage) {
        if (0 <= currentPage && currentPage < this.m_oPageable.getNumberOfPages()) {
            this.m_currentPage = currentPage;
            this.repaint();
        }
    }

    public int getCurrentPage() {
        return this.m_currentPage;
    }

    public int getLeftBoundary() {
        return this.leftBoundary;
    }

    public int getRightBoundary() {
        return this.rightBoundary;
    }

    public int getTopBoundary() {
        return this.topBoundary;
    }

    public int getBottomBoundary() {
        return this.bottomBoundary;
    }
}

