/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.common.framework.utility.print;

import com.huawei.dc.common.PreviewInDialog;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.print.PageableTool;
import com.huawei.dc.common.framework.utility.print.PreviewPanel;
import com.huawei.dc.common.framework.utility.print.PrintSupportor;
import com.huawei.dc.common.framework.utility.print.PrintableTool;
import com.huawei.dc.common.util.DCCursor;
import com.huawei.dc.common.util.DCDebugTracer;
import java.awt.AWTException;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Printable;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class PreviewInPanel
extends JPanel {
    private static final long serialVersionUID = -1867039788429419748L;
    private Dimension currentSize = null;
    private Dimension defaultSize = null;
    private boolean isMagnify = false;
    private double inchesPerMillimeter = 0.0394;
    private double widthInPoints = this.inchesPerMillimeter * 210.0 * 72.0 * 1.4;
    private double heightInPoints = this.inchesPerMillimeter * 297.0 * 72.0 * 1.4;
    private Dimension landscapeSize = new Dimension((int)this.heightInPoints, (int)this.widthInPoints);
    private Dimension portraitSize = new Dimension((int)this.widthInPoints, (int)this.heightInPoints);
    static ResourceBundle res = ResourceBundle.getBundle("com.huawei.dc.common.framework.utility.print.Res");
    private Window m_oParentWindow;
    private PreviewPanel m_oPreviewPanel;
    private JLabel m_textLabel;
    private JTextField textPageNumber;
    private JButton goToButton;
    private JButton m_nextButton;
    private JButton m_previousButton;
    private JButton m_printButton;
    private JButton m_closeButton;
    private Pageable m_oPageable;
    private GoToAcitonListener m_oGoToActionListener;
    private transient ActionListener m_oNextActionListener;
    private transient ActionListener m_oPreviousActionListener;
    private transient ActionListener m_oPrintActionListener;
    private transient ActionListener m_oCloseActionListener;
    private PreviewInPanel myPreviewPanel = null;

    PreviewInPanel(Window parentWindow, Pageable pageable) {
        this.setLayout(new BorderLayout());
        this.m_oParentWindow = null;
        this.m_oPreviewPanel = null;
        this.myPreviewPanel = this;
        this.m_textLabel = new JLabel();
        this.textPageNumber = new JTextField(4);
        this.textPageNumber.setDocument(new NumericDocument());
        this.goToButton = new JButton();
        this.m_nextButton = new JButton();
        this.m_previousButton = new JButton();
        this.m_printButton = new JButton();
        this.m_closeButton = new JButton();
        this.m_oPageable = null;
        this.m_oGoToActionListener = new GoToAcitonListener();
        this.m_oNextActionListener = new NextActionListener();
        this.m_oPreviousActionListener = new PreviousActionListener();
        this.m_oPrintActionListener = new PrintActionListener();
        this.m_oParentWindow = parentWindow;
        this.m_oCloseActionListener = new CloseActionListener(this.m_oParentWindow);
        this.m_oPageable = pageable;
        this.m_oPreviewPanel = new PreviewPanel(pageable);
        final JScrollPane scrollPane = new JScrollPane(this.m_oPreviewPanel);
        scrollPane.setVerticalScrollBarPolicy(20);
        scrollPane.setHorizontalScrollBarPolicy(30);
        this.add((Component)scrollPane, "Center");
        this.add((Component)this.getControlPanel(), "North");
        this.add((Component)this.getButtonsPanel(), "South");
        this.currentSize = this.defaultSize = this.m_oPreviewPanel.getSize();
        this.m_oPreviewPanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent me) {
                if (me.getX() > PreviewInPanel.this.m_oPreviewPanel.getLeftBoundary() && me.getX() < PreviewInPanel.this.m_oPreviewPanel.getRightBoundary() && me.getY() > PreviewInPanel.this.m_oPreviewPanel.getTopBoundary() && me.getY() < PreviewInPanel.this.m_oPreviewPanel.getBottomBoundary()) {
                    if (PrintSupportor.getOrientationOfPaper() == 0) {
                        PreviewInPanel.this.currentSize = PreviewInPanel.this.portraitSize;
                    } else {
                        PreviewInPanel.this.currentSize = PreviewInPanel.this.landscapeSize;
                    }
                    if (PreviewInPanel.this.isMagnify) {
                        PreviewInPanel.this.currentSize = PreviewInPanel.this.defaultSize;
                    }
                    PreviewInPanel.this.m_oPreviewPanel.setMaximumSize(PreviewInPanel.this.currentSize);
                    PreviewInPanel.this.m_oPreviewPanel.setMinimumSize(PreviewInPanel.this.currentSize);
                    PreviewInPanel.this.m_oPreviewPanel.setPreferredSize(PreviewInPanel.this.currentSize);
                    PreviewInPanel.this.isMagnify = !PreviewInPanel.this.isMagnify;
                    PreviewInPanel.this.setCursor(PreviewInPanel.this.isMagnify);
                    scrollPane.updateUI();
                }
            }

            @Override
            public void mouseEntered(MouseEvent me) {
                if (me.getX() > PreviewInPanel.this.m_oPreviewPanel.getLeftBoundary() && me.getX() < PreviewInPanel.this.m_oPreviewPanel.getRightBoundary() && me.getY() > PreviewInPanel.this.m_oPreviewPanel.getTopBoundary() && me.getY() < PreviewInPanel.this.m_oPreviewPanel.getBottomBoundary()) {
                    PreviewInPanel.this.setCursor(PreviewInPanel.this.isMagnify);
                } else {
                    DCFrameWorkUtil.setCursor(PreviewInPanel.this.m_oPreviewPanel, Cursor.getPredefinedCursor(0));
                }
            }

            @Override
            public void mouseExited(MouseEvent ee) {
                DCFrameWorkUtil.setCursor(PreviewInPanel.this.m_oPreviewPanel, Cursor.getPredefinedCursor(0));
            }
        });
        this.m_oPreviewPanel.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent me) {
                if (me.getX() > PreviewInPanel.this.m_oPreviewPanel.getLeftBoundary() && me.getX() < PreviewInPanel.this.m_oPreviewPanel.getRightBoundary() && me.getY() > PreviewInPanel.this.m_oPreviewPanel.getTopBoundary() && me.getY() < PreviewInPanel.this.m_oPreviewPanel.getBottomBoundary()) {
                    PreviewInPanel.this.setCursor(PreviewInPanel.this.isMagnify);
                } else {
                    DCFrameWorkUtil.setCursor(PreviewInPanel.this.m_oPreviewPanel, Cursor.getPredefinedCursor(0));
                }
            }
        });
        KeyStroke pageUpKeyStroke = KeyStroke.getKeyStroke(33, 0, true);
        this.registerKeyboardAction(this.m_oPreviousActionListener, pageUpKeyStroke, 2);
        KeyStroke pageDownKeyStroke = KeyStroke.getKeyStroke(34, 0, true);
        this.registerKeyboardAction(this.m_oNextActionListener, pageDownKeyStroke, 2);
    }

    JPanel getControlPanel() {
        JPanel controlPanel = new JPanel();
        controlPanel.setLayout(new FlowLayout(1, 5, 5));
        controlPanel.setBorder(BorderFactory.createEtchedBorder());
        String text = this.getPageText();
        this.m_textLabel.setText(text);
        this.m_textLabel.setForeground(Color.black);
        controlPanel.add(this.m_textLabel);
        this.textPageNumber.addActionListener(this.m_oGoToActionListener);
        controlPanel.add(this.textPageNumber);
        String goToText = res.getString("GO_TO");
        this.goToButton.setText(goToText);
        this.goToButton.addActionListener(this.m_oGoToActionListener);
        this.goToButton.setMnemonic('G');
        controlPanel.add(this.goToButton);
        return controlPanel;
    }

    JPanel getButtonsPanel() {
        JPanel controlPanel = new JPanel();
        controlPanel.setLayout(new FlowLayout(1, 5, 5));
        controlPanel.setBorder(BorderFactory.createEtchedBorder());
        controlPanel.add(Box.createHorizontalStrut(20));
        controlPanel.add(Box.createHorizontalStrut(20));
        String previousText = res.getString("previous");
        this.m_previousButton.setText(previousText);
        this.m_previousButton.addActionListener(this.m_oPreviousActionListener);
        this.m_previousButton.setMnemonic('P');
        controlPanel.add(this.m_previousButton);
        String nextText = res.getString("next");
        this.m_nextButton.setText(nextText);
        this.m_nextButton.addActionListener(this.m_oNextActionListener);
        this.m_nextButton.setMnemonic('N');
        controlPanel.add(this.m_nextButton);
        controlPanel.add(Box.createHorizontalStrut(20));
        String printText = res.getString("print");
        this.m_printButton.setText(printText);
        this.m_printButton.addActionListener(this.m_oPrintActionListener);
        this.m_printButton.setMnemonic('R');
        controlPanel.add(this.m_printButton);
        controlPanel.add(Box.createHorizontalStrut(10));
        String closeText = res.getString("close");
        this.m_closeButton.setText(closeText);
        this.m_closeButton.addActionListener(this.m_oCloseActionListener);
        this.m_closeButton.setMnemonic('C');
        KeyStroke escapeKeyStroke = KeyStroke.getKeyStroke(27, 0, true);
        this.m_closeButton.registerKeyboardAction(this.m_oCloseActionListener, escapeKeyStroke, 2);
        controlPanel.add(this.m_closeButton);
        Dimension buttonSize = new Dimension(this.m_previousButton.getPreferredSize().width + 2, 21);
        this.goToButton.setPreferredSize(buttonSize);
        this.m_nextButton.setPreferredSize(buttonSize);
        this.m_previousButton.setPreferredSize(buttonSize);
        this.m_printButton.setPreferredSize(buttonSize);
        this.m_closeButton.setPreferredSize(buttonSize);
        if (!this.m_oPreviewPanel.hasNext()) {
            this.m_nextButton.setEnabled(false);
        }
        if (!this.m_oPreviewPanel.hasPrevious()) {
            this.m_previousButton.setEnabled(false);
        }
        return controlPanel;
    }

    private String getPageText() {
        StringBuffer textBuffer = new StringBuffer(res.getString("TotalPages"));
        textBuffer.append(": ");
        textBuffer.append(this.m_oPageable.getNumberOfPages());
        textBuffer.append(" , ");
        textBuffer.append(res.getString("CurrentPage"));
        textBuffer.append(": ");
        textBuffer.append(this.m_oPreviewPanel.getCurrentPage() + 1);
        String str = ", " + res.getString("POS_PAGE");
        textBuffer.append(str);
        return textBuffer.toString();
    }

    public void setCursor(boolean blMagnify) {
        try {
            if (blMagnify) {
                DCFrameWorkUtil.setCursor(this.m_oPreviewPanel, DCCursor.getSystemCustomCursor("ZoomOut.24x24"));
            } else {
                DCFrameWorkUtil.setCursor(this.m_oPreviewPanel, DCCursor.getSystemCustomCursor("ZoomIn.24x24"));
            }
        }
        catch (AWTException e) {
            DCDebugTracer.trace(e);
        }
    }

    class NumericDocument
    extends PlainDocument {
        private static final long serialVersionUID = -3926880529278656453L;

        @Override
        public void insertString(int offset, String s, AttributeSet attributeSet) throws BadLocationException {
            try {
                StringBuffer sb = new StringBuffer(PreviewInPanel.this.textPageNumber.getText());
                sb.insert(offset, s);
                String strValue = sb.toString().trim();
                int val = Integer.parseInt(strValue);
                int max = PreviewInPanel.this.m_oPageable.getNumberOfPages();
                if (val <= max && val >= 1) {
                    super.insertString(offset, s, attributeSet);
                }
            }
            catch (NumberFormatException e) {
                return;
            }
        }
    }

    class NextActionListener
    implements ActionListener {
        private final PreviewInPanel m_previewPanel;

        @Override
        public void actionPerformed(ActionEvent e) {
            this.m_previewPanel.m_oPreviewPanel.flipPage(1);
            if (!this.m_previewPanel.m_oPreviewPanel.hasNext()) {
                this.m_previewPanel.m_nextButton.setEnabled(false);
            }
            this.m_previewPanel.m_previousButton.setEnabled(true);
            String text = this.m_previewPanel.getPageText();
            this.m_previewPanel.m_textLabel.setText(text);
        }

        NextActionListener() {
            this.m_previewPanel = PreviewInPanel.this.myPreviewPanel;
        }
    }

    class PreviousActionListener
    implements ActionListener {
        private final PreviewInPanel m_previewPanel;

        @Override
        public void actionPerformed(ActionEvent e) {
            this.m_previewPanel.m_oPreviewPanel.flipPage(-1);
            if (!this.m_previewPanel.m_oPreviewPanel.hasPrevious()) {
                this.m_previewPanel.m_previousButton.setEnabled(false);
            }
            this.m_previewPanel.m_nextButton.setEnabled(true);
            String text = this.m_previewPanel.getPageText();
            this.m_previewPanel.m_textLabel.setText(text);
        }

        PreviousActionListener() {
            this.m_previewPanel = PreviewInPanel.this.myPreviewPanel;
        }
    }

    class PrintActionListener
    implements ActionListener {
        private final PreviewInPanel m_previewPanel;

        @Override
        public void actionPerformed(ActionEvent e) {
            PageableTool pageableTool = new PageableTool();
            int pageCount = 1;
            Printable printable = this.m_previewPanel.m_oPageable.getPrintable(0);
            PageFormat pageFormat = this.m_previewPanel.m_oPageable.getPageFormat(0);
            for (int i = 1; i < this.m_previewPanel.m_oPageable.getNumberOfPages(); ++i) {
                Printable otherPrintable = this.m_previewPanel.m_oPageable.getPrintable(i);
                if (printable == otherPrintable) {
                    ++pageCount;
                    continue;
                }
                this.setPageableTool(pageableTool, printable, pageFormat, pageCount);
                pageCount = 1;
                printable = otherPrintable;
                pageFormat = this.m_previewPanel.m_oPageable.getPageFormat(i);
            }
            this.setPageableTool(pageableTool, printable, pageFormat, pageCount);
            PrintSupportor.print(this.m_previewPanel.m_oParentWindow, pageableTool);
            Thread thread = new Thread(){

                @Override
                public void run() {
                    try {
                        Thread.sleep(3000L);
                    }
                    catch (Exception e) {
                        DCDebugTracer.trace(e);
                    }
                }
            };
            thread.start();
        }

        private void setPageableTool(PageableTool pageableTool, Printable printable, PageFormat pageFormat, int pageCount) {
            if (printable instanceof PrintableTool) {
                PrintableTool tool = (PrintableTool)printable;
                PrintableTool clonedTool = (PrintableTool)tool.clone();
                pageableTool.append(clonedTool, pageFormat, pageCount);
            } else {
                pageableTool.append(printable, pageFormat, pageCount);
            }
        }

        PrintActionListener() {
            this.m_previewPanel = PreviewInPanel.this.myPreviewPanel;
        }
    }

    class CloseActionListener
    implements ActionListener {
        private Component m_ParentWindow = null;

        @Override
        public void actionPerformed(ActionEvent e) {
            ((PreviewInDialog)((Object)this.m_ParentWindow)).closeDialog();
        }

        CloseActionListener(Component window) {
            this.m_ParentWindow = window;
        }
    }

    class GoToAcitonListener
    implements ActionListener {
        private final PreviewInPanel m_previewPanel;

        @Override
        public void actionPerformed(ActionEvent e) {
            this.m_previewPanel.m_oPreviewPanel.setCurrentPage(Integer.parseInt(PreviewInPanel.this.textPageNumber.getText()) - 1);
            this.m_previewPanel.m_previousButton.setEnabled(true);
            this.m_previewPanel.m_nextButton.setEnabled(true);
            if (!this.m_previewPanel.m_oPreviewPanel.hasPrevious()) {
                this.m_previewPanel.m_previousButton.setEnabled(false);
            }
            if (!this.m_previewPanel.m_oPreviewPanel.hasNext()) {
                this.m_previewPanel.m_nextButton.setEnabled(false);
            }
            String text = this.m_previewPanel.getPageText();
            this.m_previewPanel.m_textLabel.setText(text);
        }

        GoToAcitonListener() {
            this.m_previewPanel = PreviewInPanel.this.myPreviewPanel;
        }
    }
}

