/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.common.framework.utility.print;

import com.huawei.dc.common.components.dialog.DCModalDialog;
import com.huawei.dc.common.framework.utility.print.PageableTool;
import com.huawei.dc.common.framework.utility.print.PreviewPanel;
import com.huawei.dc.common.framework.utility.print.PrintSupportor;
import com.huawei.dc.common.framework.utility.print.PrintableTool;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.DCHelpManager;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Printable;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;

public class PreviewDialog
extends DCModalDialog {
    private static final long serialVersionUID = 4078917094141115519L;
    private Dimension defaultSize = null;
    private boolean isMagnify = false;
    private double inchesPerMillimeter = 0.0394;
    private double widthInPoints = this.inchesPerMillimeter * 210.0 * 72.0 * 1.5;
    private double heightInPoints = this.inchesPerMillimeter * 297.0 * 72.0 * 1.5;
    private Dimension landscapeSize = new Dimension((int)this.heightInPoints, (int)this.widthInPoints);
    private Dimension portraitSize = new Dimension((int)this.widthInPoints, (int)this.heightInPoints);
    static ResourceBundle res = ResourceBundle.getBundle("com.huawei.dc.common.framework.utility.print.Res");
    private Component m_oParentWindow;
    private PreviewPanel m_oPreviewPanel;
    private JLabel m_textLabel;
    private JButton m_nextButton;
    private JButton m_previousButton;
    private JButton m_printButton;
    private JButton m_closeButton;
    private Pageable m_oPageable;
    private ActionListener m_oNextActionListener;
    private ActionListener m_oPreviousActionListener;
    private ActionListener m_oPrintActionListener;
    private ActionListener m_oCloseActionListener;
    private PreviewDialog myPreviewDialog = null;

    PreviewDialog(Frame parentWindow, Pageable pageable) {
        super(parentWindow, res.getString("Print_Preview"), true);
        this.m_oParentWindow = parentWindow;
        this.initiliseDialog(pageable);
    }

    PreviewDialog(DCModalDialog parentWindow, Pageable pageable) {
        super(parentWindow, res.getString("Print_Preview"), true);
        this.m_oParentWindow = parentWindow;
        this.initiliseDialog(pageable);
    }

    private void initiliseDialog(Pageable pageable) {
        this.m_oParentWindow = null;
        this.m_oPreviewPanel = null;
        this.myPreviewDialog = this;
        this.m_textLabel = new JLabel();
        this.m_nextButton = new JButton();
        this.m_previousButton = new JButton();
        this.m_printButton = new JButton();
        this.m_closeButton = new JButton();
        this.m_oPageable = null;
        this.m_oNextActionListener = new NextActionListener();
        this.m_oPreviousActionListener = new PreviousActionListener();
        this.m_oPrintActionListener = new PrintActionListener();
        this.m_oCloseActionListener = new CloseActionListener();
        DCHelpManager.getInstance().enableF1HelpKey(this.getRootPane(), "iVIEW.topo.preview");
        this.m_oPageable = pageable;
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        this.m_oPreviewPanel = new PreviewPanel(pageable);
        container.add((Component)this.m_oPreviewPanel, "Center");
        final JScrollPane scrollPane = new JScrollPane(this.m_oPreviewPanel);
        scrollPane.setVerticalScrollBarPolicy(20);
        scrollPane.setHorizontalScrollBarPolicy(30);
        container.add((Component)scrollPane, "Center");
        container.add((Component)this.getControlPanel(), "South");
        this.defaultSize = this.m_oPreviewPanel.getSize();
        this.m_oPreviewPanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent me) {
                if (2 == me.getClickCount()) {
                    Dimension currentSize = null;
                    currentSize = PrintSupportor.getOrientationOfPaper() == 0 ? PreviewDialog.this.portraitSize : PreviewDialog.this.landscapeSize;
                    if (PreviewDialog.this.isMagnify) {
                        currentSize = PreviewDialog.this.defaultSize;
                    }
                    PreviewDialog.this.m_oPreviewPanel.setMaximumSize(currentSize);
                    PreviewDialog.this.m_oPreviewPanel.setMinimumSize(currentSize);
                    PreviewDialog.this.m_oPreviewPanel.setPreferredSize(currentSize);
                    PreviewDialog.this.isMagnify = !PreviewDialog.this.isMagnify;
                    scrollPane.updateUI();
                }
            }
        });
        this.setSize(650, 600);
        this.setResizable(false);
        this.setDefaultCloseOperation(2);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((screenSize.width - this.getWidth()) / 2, (screenSize.height - this.getHeight()) / 2);
    }

    @Override
    protected void closeDialog() {
        this.closeThisWindow();
    }

    JPanel getControlPanel() {
        JPanel controlPanel = new JPanel();
        controlPanel.setLayout(new FlowLayout(1, 5, 5));
        controlPanel.setBorder(BorderFactory.createEtchedBorder());
        String text = this.getPageText();
        this.m_textLabel.setText(text);
        this.m_textLabel.setForeground(Color.black);
        controlPanel.add(this.m_textLabel);
        String nextText = res.getString("next");
        this.m_nextButton.setText(nextText);
        this.m_nextButton.addActionListener(this.m_oNextActionListener);
        this.m_nextButton.setMnemonic('N');
        controlPanel.add(this.m_nextButton);
        String previousText = res.getString("previous");
        this.m_previousButton.setText(previousText);
        this.m_previousButton.addActionListener(this.m_oPreviousActionListener);
        this.m_previousButton.setMnemonic('P');
        controlPanel.add(this.m_previousButton);
        controlPanel.add(Box.createHorizontalStrut(20));
        String printText = res.getString("print");
        this.m_printButton.setText(printText);
        this.m_printButton.addActionListener(this.m_oPrintActionListener);
        this.m_printButton.setMnemonic('R');
        controlPanel.add(this.m_printButton);
        controlPanel.add(Box.createHorizontalStrut(10));
        String closeText = res.getString("close");
        this.m_closeButton.setText(closeText);
        this.m_closeButton.addActionListener(this.m_oCloseActionListener);
        this.m_closeButton.setMnemonic('C');
        KeyStroke escapeKeyStroke = KeyStroke.getKeyStroke(27, 0, true);
        this.m_closeButton.registerKeyboardAction(this.m_oCloseActionListener, escapeKeyStroke, 2);
        controlPanel.add(this.m_closeButton);
        Dimension buttonSize = new Dimension(this.m_previousButton.getPreferredSize().width + 2, 21);
        this.m_nextButton.setPreferredSize(buttonSize);
        this.m_previousButton.setPreferredSize(buttonSize);
        this.m_printButton.setPreferredSize(buttonSize);
        this.m_closeButton.setPreferredSize(buttonSize);
        if (!this.m_oPreviewPanel.hasNext()) {
            this.m_nextButton.setEnabled(false);
        }
        if (!this.m_oPreviewPanel.hasPrevious()) {
            this.m_previousButton.setEnabled(false);
        }
        return controlPanel;
    }

    void closeThisWindow() {
        this.m_nextButton.removeActionListener(this.m_oNextActionListener);
        this.m_previousButton.removeActionListener(this.m_oPreviousActionListener);
        this.m_printButton.removeActionListener(this.m_oPrintActionListener);
        this.m_closeButton.removeActionListener(this.m_oCloseActionListener);
        KeyStroke escapeKeyStroke = KeyStroke.getKeyStroke(27, 0, true);
        this.m_closeButton.unregisterKeyboardAction(escapeKeyStroke);
        this.m_oNextActionListener = null;
        this.m_oPreviousActionListener = null;
        this.m_oPrintActionListener = null;
        this.m_oCloseActionListener = null;
        this.setVisible(false);
        this.dispose();
    }

    private String getPageText() {
        StringBuffer textBuffer = new StringBuffer(res.getString("TotalPages"));
        textBuffer.append(": ");
        textBuffer.append(this.m_oPageable.getNumberOfPages());
        textBuffer.append(" , ");
        textBuffer.append(res.getString("CurrentPage"));
        textBuffer.append(": ");
        textBuffer.append(this.m_oPreviewPanel.getCurrentPage() + 1);
        return textBuffer.toString();
    }

    @Override
    protected String getCurrentContext() {
        return null;
    }

    class NextActionListener
    implements ActionListener {
        private final PreviewDialog m_previewDialog;

        @Override
        public void actionPerformed(ActionEvent e) {
            this.m_previewDialog.m_oPreviewPanel.flipPage(1);
            if (!this.m_previewDialog.m_oPreviewPanel.hasNext()) {
                this.m_previewDialog.m_nextButton.setEnabled(false);
            }
            this.m_previewDialog.m_previousButton.setEnabled(true);
            String text = this.m_previewDialog.getPageText();
            this.m_previewDialog.m_textLabel.setText(text);
        }

        NextActionListener() {
            this.m_previewDialog = PreviewDialog.this.myPreviewDialog;
        }
    }

    class PreviousActionListener
    implements ActionListener {
        private final PreviewDialog m_previewDialog;

        @Override
        public void actionPerformed(ActionEvent e) {
            this.m_previewDialog.m_oPreviewPanel.flipPage(-1);
            if (!this.m_previewDialog.m_oPreviewPanel.hasPrevious()) {
                this.m_previewDialog.m_previousButton.setEnabled(false);
            }
            this.m_previewDialog.m_nextButton.setEnabled(true);
            String text = this.m_previewDialog.getPageText();
            this.m_previewDialog.m_textLabel.setText(text);
        }

        PreviousActionListener() {
            this.m_previewDialog = PreviewDialog.this.myPreviewDialog;
        }
    }

    class PrintActionListener
    implements ActionListener {
        private final PreviewDialog m_previewDialog;

        @Override
        public void actionPerformed(ActionEvent e) {
            PageableTool pageableTool = new PageableTool();
            int pageCount = 1;
            Printable printable = this.m_previewDialog.m_oPageable.getPrintable(0);
            PageFormat pageFormat = this.m_previewDialog.m_oPageable.getPageFormat(0);
            for (int i = 1; i < this.m_previewDialog.m_oPageable.getNumberOfPages(); ++i) {
                Printable otherPrintable = this.m_previewDialog.m_oPageable.getPrintable(i);
                if (printable == otherPrintable) {
                    ++pageCount;
                    continue;
                }
                this.setPageableTool(pageableTool, printable, pageFormat, pageCount);
                pageCount = 1;
                printable = otherPrintable;
                pageFormat = this.m_previewDialog.m_oPageable.getPageFormat(i);
            }
            this.setPageableTool(pageableTool, printable, pageFormat, pageCount);
            PrintSupportor.print(this.m_previewDialog.m_oParentWindow, pageableTool);
            this.m_previewDialog.m_printButton.setEnabled(false);
            Thread thread = new Thread(){

                @Override
                public void run() {
                    try {
                        Thread.sleep(3000L);
                    }
                    catch (Exception e) {
                        DCDebugTracer.trace(e);
                    }
                }
            };
            thread.start();
        }

        private void setPageableTool(PageableTool pageableTool, Printable printable, PageFormat pageFormat, int pageCount) {
            if (printable instanceof PrintableTool) {
                PrintableTool tool = (PrintableTool)printable;
                PrintableTool clonedTool = (PrintableTool)tool.clone();
                pageableTool.append(clonedTool, pageFormat, pageCount);
            } else {
                pageableTool.append(printable, pageFormat, pageCount);
            }
        }

        PrintActionListener() {
            this.m_previewDialog = PreviewDialog.this.myPreviewDialog;
        }
    }

    class CloseActionListener
    implements ActionListener {
        private final PreviewDialog m_previewDialog;

        @Override
        public void actionPerformed(ActionEvent e) {
            this.m_previewDialog.closeWindow();
        }

        CloseActionListener() {
            this.m_previewDialog = PreviewDialog.this.myPreviewDialog;
        }
    }
}

