/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.common.framework.utility.print;

import com.huawei.dc.common.framework.utility.print.PrintableTool;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Printable;
import java.util.Iterator;
import java.util.LinkedList;

public class PageableTool
implements Pageable {
    private LinkedList m_lstBookPage = new LinkedList();

    @Override
    public int getNumberOfPages() {
        int totalPageCount = 0;
        for (BookPage bookPage : this.m_lstBookPage) {
            totalPageCount += bookPage.getPageCount();
        }
        return totalPageCount;
    }

    @Override
    public PageFormat getPageFormat(int pageIndex) {
        BookPage bookPage = this.getBookPage(pageIndex);
        return bookPage.getPageFormat();
    }

    @Override
    public Printable getPrintable(int pageIndex) {
        BookPage bookPage = this.getBookPage(pageIndex);
        return bookPage.getPrintable();
    }

    public void append(Printable printable, PageFormat pageFormat, int pageCount) {
        BookPage bookPage = new BookPage(printable, pageFormat, pageCount);
        this.m_lstBookPage.add(bookPage);
    }

    private BookPage getBookPage(int pageIndex) {
        int totalPageCount = this.getNumberOfPages();
        if (pageIndex < 0) {
            pageIndex = 0;
        } else if (pageIndex >= totalPageCount) {
            pageIndex = totalPageCount - 1;
        }
        BookPage bookPage = null;
        int summingPageCount = 0;
        Iterator iterator = this.m_lstBookPage.iterator();
        while (iterator.hasNext() && pageIndex >= (summingPageCount += (bookPage = (BookPage)iterator.next()).getPageCount())) {
        }
        return bookPage;
    }

    private static class BookPage {
        private Printable m_printable = null;
        private PageFormat m_pageFormat = null;
        private int m_iPageCount = 0;

        Printable getPrintable() {
            return this.m_printable;
        }

        PageFormat getPageFormat() {
            return this.m_pageFormat;
        }

        int getPageCount() {
            if (this.m_printable instanceof PrintableTool) {
                PrintableTool printableTool = (PrintableTool)this.m_printable;
                return printableTool.getPageCount();
            }
            return this.m_iPageCount;
        }

        BookPage(Printable printable, PageFormat pageFormat, int pageCount) {
            this.m_printable = printable;
            this.m_pageFormat = pageFormat;
            this.m_iPageCount = pageCount;
        }
    }
}

