/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.common.framework.utility.print;

import com.huawei.dc.common.framework.utility.print.PrintableTool;
import com.huawei.dc.common.framework.utility.print.tools.TablePrintable;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.DCTimeDateFormat;
import com.huawei.dc.common.util.DCTimeDateUtil;
import java.awt.Font;
import java.awt.print.PageFormat;
import java.awt.print.PrinterException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.StringTokenizer;

public class FormatCalculator {
    public static final String lineChanger = System.getProperty("line.separator");
    public static final Font TableHeaderFont = new Font("Dialog", 1, 8);
    public static final Font DataFont = new Font("Dialog", 0, 8);
    public static final char TXTSeparatorChar = '|';
    public static final int MAX_PAGE_COUNT = 500000;
    public static final int ROW_DIVIDER_HEIGHT = 3;
    public static final int COLUMN_DIVIDER_WIDTH = 2;
    public static final int MARGIN_WIDTH = 2;
    private String[] m_strtableHeaders;
    private String m_strTitle;
    private String m_strUserName;
    private String m_strSummary;
    private Collection m_collSourceData;
    private ArrayList m_arlstlineLinkedList;
    private int m_iTotalPageCount = 0;
    private int m_iTotalRowCount;
    private int totalDeviceCount;
    private int[] m_icolumnWidthProportion;
    private boolean m_bIsSave = true;
    private boolean m_bIsHtml = false;
    private boolean m_bRealTimePrint = false;
    private ArrayList m_arrlstcollSourceData;
    private boolean m_bFlagForCheck = false;
    private LinkedList m_lstRowLinkedLst = new LinkedList();
    private int m_iLstPrintedRowIndex;
    private int m_iInitialSpace = 0;
    private boolean m_bIsComputeOver = false;
    private HashMap m_oPageIndexHashMap = new HashMap();
    private LinkedList m_lstTableHeaderLst = new LinkedList();
    private LinkedList m_lstHeadDataLst = new LinkedList();
    private PageFormat m_oPageFormat;
    private int m_iTotalRemovedRowCount = 0;
    private CSVFormatCalculator m_oCSVFormatCalculator;
    private TablePrintable m_oTablePrintable = null;

    public FormatCalculator(String title, String userName, String summary, String[] tableHeaders, int[] columnWidthProportion, Collection sourceData, int totalRowCount, boolean isSave) {
        this.m_strTitle = title != null ? title : "";
        this.m_strUserName = userName != null ? userName : "";
        this.m_strSummary = summary != null ? summary : "";
        this.m_strtableHeaders = tableHeaders;
        this.m_icolumnWidthProportion = columnWidthProportion;
        this.m_iTotalRowCount = totalRowCount;
        this.m_bIsSave = isSave;
        this.m_collSourceData = sourceData;
        this.initializeCollSourceDataArrLst();
    }

    public FormatCalculator(String title, String userName, String summary, String[] tableHeaders, int[] columnWidthProportion, Collection sourceData, int totalRowCount, boolean isSave, int totalDeviceCount) {
        this.m_strTitle = title != null ? title : "";
        this.m_strUserName = userName != null ? userName : "";
        this.m_strSummary = summary != null ? summary : "";
        this.m_strtableHeaders = tableHeaders;
        this.m_icolumnWidthProportion = columnWidthProportion;
        this.m_iTotalRowCount = totalRowCount;
        this.totalDeviceCount = totalDeviceCount;
        this.m_bIsSave = isSave;
        this.m_collSourceData = sourceData;
        this.initializeCollSourceDataArrLst();
    }

    public void init() {
        if (this.m_bIsSave) {
            this.m_oPageFormat = new PageFormat();
            if (this.m_icolumnWidthProportion == null) {
                this.getColumnWidth(this.m_oPageFormat);
            }
        }
        if (this.m_oPageFormat != null && !this.m_bFlagForCheck) {
            this.setDetails(this.m_arrlstcollSourceData, this.m_oPageFormat);
            this.m_bFlagForCheck = true;
        }
    }

    private void initializeCollSourceDataArrLst() {
        if (this.m_collSourceData == null || this.m_collSourceData.size() <= 0) {
            return;
        }
        this.m_arrlstcollSourceData = new ArrayList(this.m_collSourceData.size());
        for (Collection rowCollection : this.m_collSourceData) {
            ArrayList rowDataArrayList = new ArrayList(rowCollection.size());
            Iterator columnIterator = rowCollection.iterator();
            while (columnIterator.hasNext()) {
                rowDataArrayList.add(columnIterator.next());
            }
            this.m_arrlstcollSourceData.add(rowDataArrayList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void append(Collection sourceData) throws PrinterException {
        int waitingTime = 0;
        while (!(this.m_lstRowLinkedLst.size() <= 500 && this.m_oPageFormat != null || this.m_oTablePrintable.isOver())) {
            try {
                Thread.sleep(1000L);
                DCDebugTracer.trace("append ---- waitingTime = " + ++waitingTime);
                DCDebugTracer.trace("append ---- lastPrintedRowIndex = " + this.m_iLstPrintedRowIndex);
                DCDebugTracer.trace("append ---- analyzedRowLinkedList.size()  = " + this.m_lstRowLinkedLst.size());
            }
            catch (InterruptedException e) {
                DCDebugTracer.trace(e);
            }
            LinkedList linkedList = this.m_lstRowLinkedLst;
            synchronized (linkedList) {
                this.setTotalRemovedRow();
            }
        }
        this.setDetails(sourceData, this.m_oPageFormat);
    }

    private void setTotalRemovedRow() {
        DCDebugTracer.trace("lastPrintedRowIndex(begin) = " + this.m_iLstPrintedRowIndex);
        DCDebugTracer.trace("totalRemovedRowCount(begin) = " + this.m_iTotalRemovedRowCount);
        if (this.m_iLstPrintedRowIndex <= this.m_iTotalRemovedRowCount) {
            return;
        }
        int endIndex = this.m_iLstPrintedRowIndex - this.m_iTotalRemovedRowCount;
        Iterator removedRowIterator = this.m_lstRowLinkedLst.iterator();
        for (int index = 0; index <= endIndex; ++index) {
            removedRowIterator.next();
            removedRowIterator.remove();
        }
        this.m_iTotalRemovedRowCount = this.m_iTotalRemovedRowCount + endIndex + 1;
        DCDebugTracer.trace("totalRemovedRowCount(end) = " + this.m_iTotalRemovedRowCount);
        DCDebugTracer.trace("analyzedRowLinkedList.size()(end)  = " + this.m_lstRowLinkedLst.size());
    }

    private void getColumnWidth(PageFormat pageFormat) {
        this.m_icolumnWidthProportion = new int[this.m_strtableHeaders.length];
        for (int i = 0; i < this.m_strtableHeaders.length; ++i) {
            int width;
            this.m_icolumnWidthProportion[i] = this.m_bIsSave ? ((width = this.getMaxWidth(this.m_strtableHeaders[i])) < 15 ? 15 : width) : (int)(pageFormat.getImageableWidth() / (double)this.m_strtableHeaders.length);
        }
    }

    private int getMaxWidth(String lineText) {
        int maxWidth = 0;
        StringTokenizer st = new StringTokenizer(lineText, "\n");
        while (st.hasMoreTokens()) {
            int width = FormatCalculator.getTxtTextWidth(st.nextToken());
            if (width <= maxWidth) continue;
            maxWidth = width;
        }
        return maxWidth;
    }

    private synchronized void setDetails(Collection data, PageFormat pageFormat) {
        if (this.m_icolumnWidthProportion == null) {
            this.getColumnWidth(pageFormat);
        }
        if (data == null || data.size() == 0) {
            return;
        }
        int dataSize = data.size();
        if (dataSize <= 0) {
            return;
        }
        if (this.getAnalyzedRowCount() + dataSize > this.m_iTotalRowCount) {
            dataSize = this.m_iTotalRowCount - this.getAnalyzedRowCount();
        }
        if (dataSize <= 0) {
            return;
        }
        Iterator iterator = data.iterator();
        for (int rowIndex = 0; rowIndex < dataSize; ++rowIndex) {
            Collection rowData = (Collection)iterator.next();
            LinkedList rowLinkedList = new LinkedList();
            int columnIndex = 0;
            Iterator columnIterator = rowData.iterator();
            while (columnIterator.hasNext()) {
                LinkedList<String> cellLinkedList = new LinkedList<String>();
                Object objData = columnIterator.next();
                String cellData = "";
                if (objData instanceof String) {
                    cellData = (String)objData;
                } else if (objData instanceof DCTimeDateFormat) {
                    cellData = ((DCTimeDateFormat)objData).toString();
                }
                String string = cellData = cellData != null && !cellData.equals("") ? cellData : "-";
                if (this.m_bIsHtml) {
                    cellLinkedList.add(cellData);
                } else {
                    this.analyzeCellData(cellData, cellLinkedList, columnIndex);
                }
                rowLinkedList.add(cellLinkedList);
                ++columnIndex;
            }
            this.m_lstRowLinkedLst.add(rowLinkedList);
        }
        if (!this.m_bIsSave) {
            int startingPageIndex = this.m_oPageIndexHashMap.size();
            if (startingPageIndex > 0 && this.m_iInitialSpace > 0) {
                --startingPageIndex;
            }
            this.initializeMapValue(startingPageIndex, this.getAnalyzedRowCount() - dataSize, pageFormat);
        }
        if (this.getAnalyzedRowCount() == this.m_iTotalRowCount) {
            this.m_bIsComputeOver = true;
        }
    }

    protected void analyzeCellData(String cellData, LinkedList cellLinkedList, int column) {
        int textCapacityWidth = this.m_icolumnWidthProportion[column] - 2;
        cellData = cellData.replaceAll("\n", "");
        cellData = cellData.replaceAll("\r", "");
        StringTokenizer st = new StringTokenizer(cellData, " ");
        String tmpStr = cellData.trim();
        int index = cellData.indexOf(tmpStr);
        if (st.hasMoreElements()) {
            String str = st.nextToken();
            this.divideBySeperator(st, str, cellLinkedList, textCapacityWidth, index);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void divideBySeperator(StringTokenizer st, String str, LinkedList cellLinkedList, int textCapacityWidth, int iSpaceCount) {
        if (str == null) {
            return;
        }
        if (this.isTxtWidthGreaterThanCapacity(str, textCapacityWidth)) {
            String sub = this.getLineText(str, cellLinkedList, textCapacityWidth);
            if (st.hasMoreElements()) {
                this.divideBySeperator(st, sub + " " + st.nextToken(), cellLinkedList, textCapacityWidth, iSpaceCount);
                return;
            }
            if (sub.length() <= 0) return;
            cellLinkedList.add(sub);
            return;
        }
        if (st.hasMoreElements()) {
            String nextStr = st.nextToken();
            if (this.isTxtWidthGreaterThanCapacity(nextStr, textCapacityWidth)) {
                cellLinkedList.add(str);
                String sub = this.getLineText(nextStr, cellLinkedList, textCapacityWidth);
                if (st.hasMoreElements()) {
                    this.divideBySeperator(st, sub + " " + st.nextToken(), cellLinkedList, textCapacityWidth, iSpaceCount);
                    return;
                }
                if (sub.length() <= 0) return;
                cellLinkedList.add(sub);
                return;
            }
            String str2 = str + " " + nextStr;
            if (this.isTxtWidthGreaterThanCapacity(str2, textCapacityWidth)) {
                cellLinkedList.add(str);
                this.divideBySeperator(st, nextStr, cellLinkedList, textCapacityWidth, iSpaceCount);
                return;
            }
            this.divideBySeperator(st, str2, cellLinkedList, textCapacityWidth, iSpaceCount);
            return;
        }
        int i = 0;
        while (true) {
            if (i >= iSpaceCount) {
                cellLinkedList.add(str);
                return;
            }
            str = " " + str;
            ++i;
        }
    }

    private String getLineText(String str, LinkedList cellLinkedList, int textCapacityWidth) {
        int stepDelta;
        char[] chars = str.toCharArray();
        int offsetIndex = 0;
        while ((stepDelta = chars.length - offsetIndex) > 0) {
            if (this.m_bIsSave) {
                while (FormatCalculator.getTxtTextWidth(new String(chars, offsetIndex, stepDelta).trim()) > textCapacityWidth) {
                    --stepDelta;
                }
            } else {
                while (PrintableTool.getCharsWidth(chars, offsetIndex, stepDelta, TableHeaderFont) > textCapacityWidth) {
                    --stepDelta;
                }
            }
            String oneLineText = new String(chars, offsetIndex, stepDelta).trim();
            if (chars.length - (offsetIndex += stepDelta) <= 0) {
                if (this.isCapacityGreaterThanTxtWidth(oneLineText, textCapacityWidth)) {
                    return oneLineText;
                }
                cellLinkedList.add(oneLineText);
                continue;
            }
            cellLinkedList.add(oneLineText);
        }
        return "";
    }

    private boolean isTxtWidthGreaterThanCapacity(String str, int textCapacityWidth) {
        if (this.m_bIsSave) {
            return FormatCalculator.getTxtTextWidth(str) > textCapacityWidth;
        }
        return PrintableTool.getTextWidth(str, TableHeaderFont) > textCapacityWidth;
    }

    private boolean isCapacityGreaterThanTxtWidth(String str, int textCapacityWidth) {
        if (this.m_bIsSave) {
            return FormatCalculator.getTxtTextWidth(str) < textCapacityWidth;
        }
        return PrintableTool.getTextWidth(str, TableHeaderFont) < textCapacityWidth;
    }

    private void initializeMapValue(int pageIndex, int rowIndex, PageFormat pageFormat) {
        if (pageIndex < this.getSummaryPageCount() - 1) {
            this.m_oPageIndexHashMap.put(pageIndex, 0);
            return;
        }
        if (pageIndex == this.getSummaryPageCount() - 1) {
            this.m_iInitialSpace = this.m_iInitialSpace + this.getSummaryLastPrintingY() + 10;
        }
        int pageHeight = (int)pageFormat.getImageableHeight() - this.getHeight();
        int startingRowIndex = rowIndex;
        int rowHeight = this.calculateRowHeight(rowIndex, pageHeight);
        while (this.m_iInitialSpace + rowHeight <= pageHeight) {
            this.m_iInitialSpace += rowHeight;
            if (++rowIndex == this.getAnalyzedRowCount()) break;
            rowHeight = this.calculateRowHeight(rowIndex, pageHeight);
        }
        if (this.m_iInitialSpace + rowHeight > pageHeight) {
            this.m_iInitialSpace = 0;
        }
        int pageRowCount = rowIndex - startingRowIndex;
        Integer pageIndexKey = pageIndex;
        Integer oldPageCountValue = (Integer)this.m_oPageIndexHashMap.get(pageIndexKey);
        if (oldPageCountValue != null) {
            pageRowCount += oldPageCountValue.intValue();
        }
        this.m_oPageIndexHashMap.put(pageIndexKey, pageRowCount);
        if (rowIndex == this.getAnalyzedRowCount()) {
            return;
        }
        this.initializeMapValue(pageIndex + 1, rowIndex, pageFormat);
    }

    private int getHeight() {
        int tableHeaderHeight = PrintableTool.getFontHeight(TableHeaderFont) * 3 + this.getTableHeaderHeight();
        int height = PrintableTool.getHeadHeight(!this.m_bRealTimePrint) + 10 + tableHeaderHeight;
        return height;
    }

    public int calculateRowHeight(int rowIndex, int pageHeight) {
        LinkedList rowLinkedList = this.getAnalyzedRowLinkList(rowIndex);
        int columnCount = this.getTableHeaders().length;
        LinkedList maxLineCountCellLinkedList = (LinkedList)rowLinkedList.get(0);
        for (int i = 1; i < columnCount; ++i) {
            LinkedList cellLinkedList = (LinkedList)rowLinkedList.get(i);
            if (cellLinkedList.size() <= maxLineCountCellLinkedList.size()) continue;
            maxLineCountCellLinkedList = cellLinkedList;
        }
        int maxLineCount = maxLineCountCellLinkedList.size();
        int rowHeight = PrintableTool.getFontHeight(DataFont) * maxLineCount + 6;
        return rowHeight;
    }

    public LinkedList getAnalyzeHeadData() {
        if (this.m_lstHeadDataLst.size() == 0) {
            for (int i = 0; i < this.getTableHeaders().length; ++i) {
                LinkedList cellLinkedList = new LinkedList();
                this.analyzeCellData(this.getTableHeaders()[i], cellLinkedList, i, "\n");
                this.m_lstHeadDataLst.add(cellLinkedList);
            }
        }
        return this.m_lstHeadDataLst;
    }

    protected void analyzeCellData(String cellData, LinkedList cellLinkedList, int column, String delimStr) {
        StringTokenizer st = new StringTokenizer(cellData, delimStr);
        while (st.hasMoreTokens()) {
            String str = st.nextToken();
            if ((str = str.replaceAll("\r", " ")).length() <= 0) continue;
            cellLinkedList.add(str);
        }
    }

    public int getTableHeaderHeight() {
        if (this.m_lstTableHeaderLst.size() == 0) {
            for (int i = 0; i < this.getTableHeaders().length; ++i) {
                LinkedList cellLinkedList = new LinkedList();
                this.analyzeCellData(this.getTableHeaders()[i], cellLinkedList, i);
                this.m_lstTableHeaderLst.add(cellLinkedList);
            }
        }
        int cellRowCount = 1;
        for (LinkedList cellLinkedList : this.m_lstTableHeaderLst) {
            if (cellRowCount >= cellLinkedList.size()) continue;
            cellRowCount = cellLinkedList.size();
        }
        int tableHeaderHeight = cellRowCount * PrintableTool.getFontHeight(TableHeaderFont) + 6;
        return tableHeaderHeight;
    }

    public int getLastPageRowCount() {
        Object rowCountObject = this.m_oPageIndexHashMap.get(this.getPageCount() - 1);
        if (rowCountObject == null) {
            return 0;
        }
        return (Integer)rowCountObject;
    }

    public int getTotalRowCount() {
        return this.m_iTotalRowCount;
    }

    public int getTotalDeviceCount() {
        return this.totalDeviceCount;
    }

    public int[] getTxtColumnWidths() {
        return this.m_icolumnWidthProportion;
    }

    private int getOneLineCharCount() {
        int oneLineCharCount = 0;
        for (int i = 0; i < this.m_icolumnWidthProportion.length; ++i) {
            oneLineCharCount += this.m_icolumnWidthProportion[i];
        }
        return oneLineCharCount;
    }

    public String getTxtSeparatorLine() {
        int oneLineCharCount = this.getOneLineCharCount();
        oneLineCharCount += this.m_strtableHeaders.length * 5 + 1;
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < oneLineCharCount; ++i) {
            sb.append("-");
        }
        return sb.toString();
    }

    public static String getTxtBlackText(int blackCount) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < blackCount; ++i) {
            sb.append(" ");
        }
        return sb.toString();
    }

    public static int getTxtTextWidth(String lineText) {
        int lineTextWidth = lineText.length();
        char[] lineCharArray = lineText.toCharArray();
        for (int k = 0; k < lineCharArray.length; ++k) {
            if (lineCharArray[k] <= '\u007f') continue;
            ++lineTextWidth;
        }
        return lineTextWidth;
    }

    public String getTitle() {
        return this.m_strTitle;
    }

    public String getTime() {
        Calendar oCalendar = Calendar.getInstance();
        DCTimeDateUtil.switchToLocalCalendar(oCalendar);
        return DCTimeDateUtil.getLocaleDisplayTime(oCalendar);
    }

    public String[] getTableHeaders() {
        return this.m_strtableHeaders;
    }

    public String getUserName() {
        return this.m_strUserName;
    }

    public int[] getColumnWidths() {
        return this.m_icolumnWidthProportion;
    }

    public int getAnalyzedRowCount() {
        return this.m_lstRowLinkedLst.size() + this.m_iTotalRemovedRowCount;
    }

    public LinkedList getAnalyzedRowLinkList(int realRowIndex) {
        int convertIndex = realRowIndex - this.m_iTotalRemovedRowCount;
        if (convertIndex >= this.m_lstRowLinkedLst.size()) {
            DCDebugTracer.trace(" realRowIndex = " + realRowIndex);
            DCDebugTracer.trace("totalRemovedRowCount = " + this.m_iTotalRemovedRowCount);
        }
        return (LinkedList)this.m_lstRowLinkedLst.get(convertIndex);
    }

    public int getLastPrintedRowIndex() {
        return this.m_iLstPrintedRowIndex;
    }

    public void setTablePrintable(TablePrintable tablePrintable) {
        this.m_oTablePrintable = tablePrintable;
    }

    public void setLastPrintedRowIndex(int lastPrintedRowIndex) {
        this.m_iLstPrintedRowIndex = lastPrintedRowIndex;
    }

    public HashMap getTablePageHashMap() {
        return this.m_oPageIndexHashMap;
    }

    public boolean isComputeOver() {
        return this.m_bIsComputeOver;
    }

    public int getPageCount() {
        if (!this.isComputeOver()) {
            return 500000;
        }
        return this.getTablePageHashMap().size();
    }

    public LinkedList getAnalyzedTableHeaderLinkedList() {
        return this.m_lstTableHeaderLst;
    }

    public void setPageFormat(PageFormat pageFormat) {
        this.m_oPageFormat = pageFormat;
    }

    public void setPageFormatWithCompute(PageFormat pageFormat) {
        this.m_oPageFormat = pageFormat;
        this.getPageSummary();
        if (!this.m_bFlagForCheck) {
            this.setDetails(this.m_arrlstcollSourceData, pageFormat);
            this.m_bFlagForCheck = true;
        }
    }

    public ArrayList getSourceDataArrayList() {
        return this.m_arrlstcollSourceData;
    }

    public PageFormat getPageFormat() {
        return this.m_oPageFormat;
    }

    private void getPageSummary() {
        if (this.m_strSummary.length() > 0) {
            this.getSummaryLines();
            this.setTotalPageCount();
        }
    }

    private void getlineLinkedList(BufferedReader reader) throws IOException {
        LinkedList<String> lineLinkedList = new LinkedList<String>();
        String oneParagraph = null;
        int stepDelta = 20;
        int textCapacityWidth = (int)this.m_oPageFormat.getImageableWidth() - 2 - 10;
        oneParagraph = reader.readLine();
        while (oneParagraph != null) {
            char[] chars = oneParagraph.toCharArray();
            int offsetIndex = 0;
            while (PrintableTool.getCharsWidth(chars, offsetIndex, chars.length - offsetIndex, DataFont) > textCapacityWidth) {
                if (stepDelta > chars.length - offsetIndex) {
                    stepDelta = chars.length - offsetIndex;
                }
                while (PrintableTool.getCharsWidth(chars, offsetIndex, stepDelta, DataFont) < textCapacityWidth) {
                    ++stepDelta;
                }
                while (PrintableTool.getCharsWidth(chars, offsetIndex, stepDelta, DataFont) > textCapacityWidth) {
                    --stepDelta;
                }
                String oneLineText = new String(chars, offsetIndex, stepDelta);
                lineLinkedList.add(oneLineText);
                offsetIndex += stepDelta;
            }
            lineLinkedList.add(new String(chars, offsetIndex, chars.length - offsetIndex));
            oneParagraph = reader.readLine();
        }
        this.m_arlstlineLinkedList = new ArrayList(lineLinkedList);
    }

    public String[] getSummaryLines() {
        BufferedReader bufferedReader = new BufferedReader(new StringReader(this.m_strSummary));
        try {
            this.getlineLinkedList(bufferedReader);
        }
        catch (IOException ex) {
            DCDebugTracer.trace("IO Error : Can not read summary text");
        }
        String[] lines = new String[this.m_arlstlineLinkedList.size()];
        int index = 0;
        Iterator iterator = this.m_arlstlineLinkedList.iterator();
        while (iterator.hasNext()) {
            lines[index++] = (String)iterator.next();
        }
        return lines;
    }

    private void setTotalPageCount() {
        int onePageCapacityLineCount = ((int)this.m_oPageFormat.getImageableHeight() - PrintableTool.getHeadHeight(true)) / PrintableTool.getFontHeight(DataFont) - 1;
        int totalLineCount = this.m_arlstlineLinkedList.size();
        this.m_iTotalPageCount = totalLineCount % onePageCapacityLineCount == 0 ? totalLineCount / onePageCapacityLineCount : totalLineCount / onePageCapacityLineCount + 1;
    }

    public int getSummaryLastPrintingY() {
        int oneLineHeight = PrintableTool.getFontHeight(DataFont);
        int pageHeight = (int)this.m_oPageFormat.getImageableHeight();
        int onePageCapacityLineCount = (pageHeight - PrintableTool.getHeadHeight(true)) / oneLineHeight - 1;
        int lastPageIndex = this.m_iTotalPageCount - 1;
        int offsetLineIndex = onePageCapacityLineCount * lastPageIndex;
        int pageLineCount = this.m_arlstlineLinkedList.size() - offsetLineIndex;
        double lastPrintingY = PrintableTool.getHeadHeight(true) + oneLineHeight + oneLineHeight * pageLineCount;
        return (int)lastPrintingY;
    }

    public CSVFormatCalculator getCsvFormatCalculator() {
        if (this.m_oCSVFormatCalculator == null) {
            this.m_oCSVFormatCalculator = new CSVFormatCalculator(this.m_strTitle, this.m_strUserName, this.m_strSummary, this.m_strtableHeaders, this.m_icolumnWidthProportion, this.m_collSourceData, this.m_iTotalRowCount, this.totalDeviceCount);
            this.m_oCSVFormatCalculator.setTablePrintable(this.m_oTablePrintable);
        }
        return this.m_oCSVFormatCalculator;
    }

    public void setBRealTimePrint(boolean bRealTimePrint) {
        this.m_bRealTimePrint = bRealTimePrint;
    }

    public String getSummary() {
        return this.m_strSummary;
    }

    public int getSummaryPageCount() {
        return this.m_iTotalPageCount;
    }

    public ArrayList getSummaryLineList() {
        return this.m_arlstlineLinkedList;
    }

    public void setIsHtml(boolean isHtml) {
        this.m_bIsHtml = isHtml;
    }

    public boolean isBRealTimePrint() {
        return this.m_bRealTimePrint;
    }

    public void reset() {
        this.m_bFlagForCheck = false;
        this.m_lstRowLinkedLst.clear();
        this.m_iLstPrintedRowIndex = -1;
        this.m_iInitialSpace = 0;
        this.m_bIsComputeOver = false;
        this.m_oPageIndexHashMap.clear();
        this.m_lstTableHeaderLst.clear();
        this.m_oPageFormat = null;
        this.m_icolumnWidthProportion = null;
    }

    class CSVFormatCalculator
    extends FormatCalculator {
        @Override
        protected void analyzeCellData(String cellData, LinkedList cellLinkedList, int column) {
            cellLinkedList.add("\"" + cellData + "\"");
        }

        public CSVFormatCalculator(String title, String userName, String summary, String[] tableHeaders, int[] columnWidthProportion, Collection sourceData, int totalRowCount, int totalDeviceCount) {
            super(title, userName, summary, tableHeaders, columnWidthProportion, sourceData, totalRowCount, true, totalDeviceCount);
        }
    }
}

