/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.common.framework.utility;

import com.huawei.dc.common.asndatacenter.AsnDCHandShakeReq;
import com.huawei.dc.common.asndatacenter.AsnDCOpertionRsp;
import com.huawei.dc.common.controller.BaseCommManager;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.DCOptionPane;
import com.huawei.dc.common.util.GUIConstants;
import com.huawei.dc.framework.ErrorCodeReader;
import com.huawei.dc.security.ISecurityManager;
import com.swimap.iview.communicate.MSGHead;
import com.swimap.iview.framework.util.FrameworkCommandProcessor;
import java.awt.Component;
import java.math.BigInteger;
import javax.swing.SwingUtilities;
import net.commustru.fstru.FStruct;

public class ShakeHandThread
extends Thread {
    private boolean bRunShakeHandThread = false;
    private int nextPollingTimeInterval;
    private int iShakeHandBreakTime;
    private int iHandShakeTimeOut;
    private int maxShakeHandBreakTime;
    private ISecurityManager securityManager;

    public ShakeHandThread() {
        String timoutstr = ResourceManager.getInstance().getResString("Hand_Shake_Time_Out", "config");
        String nextPollingIntervalStr = ResourceManager.getInstance().getResString("Hand_Shake_Next_Polling_Interval", "config");
        String handShakeBreakTimeStr = ResourceManager.getInstance().getResString("Hand_Shake_Break_Time", "config");
        try {
            this.iHandShakeTimeOut = Integer.parseInt(timoutstr);
            this.nextPollingTimeInterval = Integer.parseInt(nextPollingIntervalStr);
            this.maxShakeHandBreakTime = Integer.parseInt(handShakeBreakTimeStr);
        }
        catch (NumberFormatException e) {
            DCDebugTracer.trace(e);
            this.maxShakeHandBreakTime = 25000;
        }
        this.securityManager = DCFrameWorkUtil.getSecurityManager();
        DCDebugTracer.trace("ShakeHandThread Thread Name : " + this.getName());
        DCDebugTracer.trace("ShakeHandThread Thread ID : " + this.getId());
        DCDebugTracer.trace("ShakeHandThread clientId: " + this.securityManager.getClientId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        DCDebugTracer.trace("ShakeHandThread start");
        while (this.bRunShakeHandThread) {
            if (this.iShakeHandBreakTime >= this.maxShakeHandBreakTime) {
                this.handleTimeout(ResourceManager.getInstance().getResString("HAND_SHAKE_CONNECT_FAIL"));
                DCDebugTracer.trace("handleTimeout ShakeHandThread end.. ");
                return;
            }
            ++this.iShakeHandBreakTime;
            AsnDCHandShakeReq asnHandShakeReq = new AsnDCHandShakeReq();
            MSGHead msgHead = null;
            try {
                asnHandShakeReq.iClientId = BigInteger.valueOf(this.securityManager.getClientId());
                DCFrameWorkUtil.getCommManager();
                msgHead = BaseCommManager.getMSGHead(43830, 2, 5, GUIConstants.DC_SERVER_ID);
            }
            catch (Exception e) {
                this.handleTimeout("get MSGHead fail!");
                DCDebugTracer.trace(e);
                DCDebugTracer.trace("handleTimeout ShakeHandThread end.. ");
                return;
            }
            AsnDCOpertionRsp opResponse = new AsnDCOpertionRsp();
            int errorcode = 0;
            String errorInfo = null;
            String htmlErrorInfo = "<html>";
            String replacedStr = "\\n";
            try {
                errorcode = DCFrameWorkUtil.getCommManager().sendHandShakeMsg(msgHead, (FStruct)asnHandShakeReq, (FStruct)opResponse, this.iHandShakeTimeOut);
            }
            catch (Exception ex) {
                DCDebugTracer.trace(ex);
                errorInfo = ErrorCodeReader.getInstance().getErrorDesc(BigInteger.valueOf(989855779L));
                htmlErrorInfo = errorInfo.contains(replacedStr) ? htmlErrorInfo + errorInfo.replace(replacedStr, "<br>") : (errorInfo.contains("\n") ? htmlErrorInfo + errorInfo.replace("\n", "<br>") : htmlErrorInfo + errorInfo);
                this.handleTimeout(htmlErrorInfo);
                DCDebugTracer.trace(ex);
                DCDebugTracer.trace("handleTimeout ShakeHandThread end.. ");
                return;
            }
            int iErrorCode = errorcode != 0 ? errorcode : opResponse.oErrorInfo.iErrorNo.intValue();
            DCDebugTracer.trace("shakeHand iErrorCode : " + iErrorCode);
            if (iErrorCode == 0) {
                this.iShakeHandBreakTime = 0;
            } else if (DCFrameWorkUtil.getIsSingleClient() && (iErrorCode == -4 || iErrorCode == -3)) {
                errorInfo = ErrorCodeReader.getInstance().getErrorDesc(BigInteger.valueOf(989855779L));
                htmlErrorInfo = errorInfo.contains(replacedStr) ? htmlErrorInfo + errorInfo.replace(replacedStr, "<br>") : (errorInfo.contains("\n") ? htmlErrorInfo + errorInfo.replace("\n", "<br>") : htmlErrorInfo + errorInfo);
                this.handleTimeout(htmlErrorInfo);
                return;
            }
            if (iErrorCode == 989855779) {
                errorInfo = ErrorCodeReader.getInstance().getErrorDesc(BigInteger.valueOf(989855779L));
                htmlErrorInfo = errorInfo.contains(replacedStr) ? htmlErrorInfo + errorInfo.replace(replacedStr, "<br>") : (errorInfo.contains("\n") ? htmlErrorInfo + errorInfo.replace("\n", "<br>") : htmlErrorInfo + errorInfo);
                this.handleTimeout(htmlErrorInfo);
                return;
            }
            Object sync = new Object();
            try {
                Object object = sync;
                synchronized (object) {
                    sync.wait(this.nextPollingTimeInterval);
                }
            }
            catch (Exception ex) {
                DCDebugTracer.trace(ex);
            }
        }
        DCDebugTracer.trace("ShakeHandThread end..");
    }

    private void handleTimeout(final String strMsg) {
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException ex) {
            DCDebugTracer.trace(ex);
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DCOptionPane.showMessageDialog((Component)DCFrameWorkUtil.getMainFrame(), strMsg, ResourceManager.getInstance().getResString("HAND_SHAKE_ERROR"), 0);
                if (null == DCFrameWorkUtil.getDCModuleManager()) {
                    DCFrameWorkUtil.closeModalDialogs();
                } else {
                    DCFrameWorkUtil.closeModalDialogs();
                    DCFrameWorkUtil.getDCModuleManager().dcServerSessionExpired();
                }
                if (DCFrameWorkUtil.isPluginMode()) {
                    FrameworkCommandProcessor.getInstance().logoutDirectly();
                }
            }
        });
    }

    public void startShakeHand() {
        DCDebugTracer.trace("bRunShakeHandThread : " + this.bRunShakeHandThread);
        this.bRunShakeHandThread = true;
    }

    public void stopShakeHand() {
        DCDebugTracer.trace("bRunShakeHandThread : " + this.bRunShakeHandThread);
        this.bRunShakeHandThread = false;
    }
}

