/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.common.framework.utility;

import com.huawei.dc.common.controller.DeviceInfoManagerImpl;
import com.huawei.dc.common.controller.DeviceInfoManagerImplHelper;
import com.huawei.dc.common.framework.interfaces.IDCObjectDeallocator;
import com.huawei.dc.common.framework.utility.ConfigurationInfo;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.util.DCCommonUtil;
import com.huawei.dc.common.util.DCDebugTracer;
import com.huawei.dc.common.util.StringUtils;
import com.huawei.dc.deviceinfo.DeviceInfo;
import com.huawei.dc.deviceinfo.DeviceTypeInfo;
import com.huawei.dc.devicemanagement.model.DeviceType;
import com.huawei.dc.standalone.StandAloneDomainInfo;
import com.swimap.iview.util.DebugTracer;
import gnu.trove.TIntObjectHashMap;
import java.awt.Color;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;

public class ResourceManager
implements IDCObjectDeallocator {
    private ResourceBundle m_oResBundle;
    private static ResourceManager m_oResourseManagerInstance;
    private ResourceBundle m_oConfigBundle;
    private ResourceBundle m_oNeTypeImageBundle;
    private ResourceBundle m_oHelpBundle;
    private boolean m_bConfigFilesInJar = false;
    private HashMap<String, ResourceBundle> devTypeResBundleMap;
    private HashMap<String, String> oDevTypeKeyMap = null;
    private String m_strLocaleDir = "";
    private String m_strSpecialRegex = "";
    private HashSet<String> m_DmsForSpecialDevTypeLst = null;
    private HashSet<String> m_oSecurityDevDevType = null;
    private TIntObjectHashMap<String> m_oNEType2ImageNameHm = null;
    private HashSet<String> m_oNorthAmericaDevDevType = null;
    private HashMap<String, URL> oURLMap = new HashMap();

    private ResourceManager() {
        this.m_bConfigFilesInJar = ConfigurationInfo.getInstance().isConfigFilesInJar();
        this.m_strLocaleDir = ConfigurationInfo.getInstance().getLocaleSpecficDirectory();
        String resourceFile = this.m_strLocaleDir + "dc";
        this.m_oResBundle = this.loadResourceBundle(resourceFile);
        String configFile = ConfigurationInfo.getInstance().getStyleDirectory() + "config";
        String sNeImageFile = ConfigurationInfo.getInstance().getStyleDirectory() + "neImage";
        this.m_oConfigBundle = this.loadResourceBundle(configFile);
        this.m_oNeTypeImageBundle = this.loadResourceBundle(sNeImageFile);
        try {
            this.m_strSpecialRegex = this.m_oConfigBundle.getString("Special_Char_Set");
        }
        catch (Exception ex) {
            DCDebugTracer.trace(ex);
        }
        String helpFile = ConfigurationInfo.getInstance().getStyleDirectory() + "helpmapfile";
        this.m_oHelpBundle = this.loadResourceBundle(helpFile);
        this.devTypeResBundleMap = new HashMap();
        this.oDevTypeKeyMap = new HashMap();
        this.m_oNEType2ImageNameHm = new TIntObjectHashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResourceBundle loadResourceBundle(String strFileName) {
        if (this.m_bConfigFilesInJar) {
            return ResourceBundle.getBundle(strFileName);
        }
        FileInputStream oFileInputStream = null;
        try {
            File oFile = new File(strFileName + ".properties");
            if (oFile.exists()) {
                oFileInputStream = new FileInputStream(oFile);
                PropertyResourceBundle propertyResourceBundle = new PropertyResourceBundle(oFileInputStream);
                return propertyResourceBundle;
            }
        }
        catch (FileNotFoundException e) {
            DCDebugTracer.trace("ResourceManager#loadResourceBundle" + strFileName + ".properties do not found!");
            DCDebugTracer.trace(e);
        }
        catch (IOException e) {
            DCDebugTracer.trace("ResourceManager#loadResourceBundle" + strFileName + ".properties do not found!");
            DCDebugTracer.trace(e);
        }
        finally {
            if (null != oFileInputStream) {
                try {
                    oFileInputStream.close();
                }
                catch (IOException e) {
                    DCDebugTracer.trace(e);
                }
            }
        }
        return null;
    }

    public static synchronized ResourceManager getInstance() {
        if (null == m_oResourseManagerInstance) {
            m_oResourseManagerInstance = new ResourceManager();
        }
        return m_oResourseManagerInstance;
    }

    public String getResString(String strKey) {
        String valueStr = strKey;
        try {
            valueStr = this.m_oResBundle.getString(strKey);
            if (null == valueStr) {
                valueStr = strKey;
            }
        }
        catch (Exception ex) {
            return strKey;
        }
        return valueStr.trim();
    }

    public String getResString(String strKey, String bundleName) {
        if ("config".equalsIgnoreCase(bundleName)) {
            return this.getResString(strKey, this.m_oConfigBundle);
        }
        if ("helpmapfile".equalsIgnoreCase(bundleName)) {
            return this.getResString(strKey, this.m_oHelpBundle);
        }
        if ("neImage".equalsIgnoreCase(bundleName)) {
            return this.getResString(strKey, this.m_oNeTypeImageBundle);
        }
        ResourceBundle oBundle = ResourceBundle.getBundle(bundleName);
        return this.getResString(strKey, oBundle);
    }

    public String getResString(String strKey, ResourceBundle oResInfo) {
        if (null == oResInfo) {
            return strKey;
        }
        String ret = strKey;
        try {
            ret = oResInfo.getString(strKey);
        }
        catch (Exception ex) {
            return ret.trim();
        }
        return ret.trim();
    }

    public String getResStringFromPattern(String strKey, String strPattern, String strValue) {
        String strResString = this.getResString(strKey);
        if (null == strPattern || 0 > strResString.indexOf(strPattern)) {
            return strResString;
        }
        return strResString.replaceAll(strPattern, strValue);
    }

    public String getResString(String strKey, String[] sValues) {
        String sFormatValue = this.getResString(strKey);
        String rtnValue = MessageFormat.format(sFormatValue, sValues);
        return rtnValue;
    }

    @Override
    public void setToNULL() {
        if (null != this.oURLMap) {
            this.oURLMap.clear();
            this.oURLMap = null;
        }
        this.m_oResBundle = null;
        m_oResourseManagerInstance = null;
    }

    public ImageIcon getImage(String imageName) {
        if (null == imageName || "".equals(imageName)) {
            return null;
        }
        String imagePath = ConfigurationInfo.getInstance().getImageDirectory();
        if (this.m_bConfigFilesInJar && this.getClass() != null) {
            return new ImageIcon(this.getClass().getResource(imagePath + imageName));
        }
        return new ImageIcon(imagePath + imageName);
    }

    public ImageIcon getNeTypeImage(int iDeviceID) {
        return this.getNeTypeImage(iDeviceID, DCFrameWorkUtil.getBackgroundColor());
    }

    public ImageIcon getNeTypeImage(int iDeviceID, Color bgColor) {
        DeviceInfo oDevInfo = DeviceInfoManagerImpl.getInstance().getDevice(iDeviceID);
        if (null == oDevInfo) {
            return this.getImage("ic_device.gif");
        }
        DeviceTypeInfo oDevTypeInfo = oDevInfo.getDeviceTypeInfo();
        ImageIcon oDevTypeImage = this.getNeTypeImage(oDevTypeInfo);
        ImageIcon oRoleTypeImage = null;
        int iRoleType = oDevInfo.getRoleType();
        int maxWidth = 0;
        int maxHigth = 0;
        if (iRoleType == 1 && oDevTypeInfo.isT2000Domain()) {
            oRoleTypeImage = this.getImage("gateway.gif");
            maxWidth = 16;
            maxHigth = 16;
        } else if (iRoleType == 3 || iRoleType == 4) {
            oRoleTypeImage = this.getImage("stack.gif");
            maxWidth = 23;
            maxHigth = 15;
        }
        if (null != oRoleTypeImage) {
            return new ImageIcon(DCCommonUtil.getComposedImage(oRoleTypeImage.getImage(), oDevTypeImage.getImage(), null, bgColor, maxWidth, maxHigth));
        }
        return oDevTypeImage;
    }

    public ImageIcon getNeTypeImage(DeviceTypeInfo oDevTypeInfo) {
        if (null == oDevTypeInfo) {
            return this.getImage("folderopen.gif");
        }
        if (-1 == oDevTypeInfo.getDevTypeID()) {
            return this.getImage("folderopen.gif");
        }
        int iDevTypeID = oDevTypeInfo.getDevTypeID();
        int iDevDomain = oDevTypeInfo.getDevDomain();
        String imageName = "";
        String sImagePath = ConfigurationInfo.getInstance().getDevTypeImageDirectory(iDevDomain);
        Object oValue = this.m_oNEType2ImageNameHm.get(iDevTypeID);
        if (null != oValue) {
            imageName = oValue.toString();
        } else {
            imageName = this.getResString("" + iDevTypeID, this.m_oNeTypeImageBundle);
            if (DCFrameWorkUtil.getIsSingleClient() && StandAloneDomainInfo.getInstance().getSelectedDomain() == 3 && !imageName.contains("_")) {
                String strMA5620Type = "76";
                imageName = this.getResString("" + strMA5620Type, this.m_oNeTypeImageBundle);
            }
            this.m_oNEType2ImageNameHm.put(iDevTypeID, (Object)imageName);
        }
        if (StringUtils.isNullOrEmptyStr(imageName) || imageName.equals("" + iDevTypeID)) {
            return this.getImage("folderopen.gif");
        }
        imageName = imageName + ".gif";
        try {
            String imgPath = sImagePath + imageName;
            if (this.m_bConfigFilesInJar) {
                URL valueURL = null;
                if (!this.oURLMap.containsKey(imgPath)) {
                    valueURL = this.getClass().getResource(imgPath);
                    this.oURLMap.put(imgPath, valueURL);
                } else {
                    valueURL = this.oURLMap.get(imgPath);
                }
                return new ImageIcon(valueURL);
            }
            return new ImageIcon(imgPath);
        }
        catch (Exception e) {
            DCDebugTracer.trace("DC can not find image " + sImagePath + imageName + " " + iDevTypeID + " " + iDevDomain);
            return this.getImage("folderopen.gif");
        }
    }

    public synchronized String getResString(DeviceTypeInfo oDevTypeInfo, String strKey) {
        String sNewKey = "" + oDevTypeInfo.getDevTypeID() + "_" + oDevTypeInfo.getDevTypeVersionId() + "_" + strKey;
        String oValue = this.oDevTypeKeyMap.get(sNewKey);
        if (null != oValue) {
            return oValue.toString();
        }
        String strValue = null;
        strValue = this.getResFromDevTypeProperties(oDevTypeInfo.getDevTypeName(), oDevTypeInfo.getDevTypeVersionName(), strKey);
        if (null == strValue) {
            strValue = this.getResFromDomainProperties(oDevTypeInfo.getDevDomain(), strKey);
        }
        if (null == strValue) {
            strValue = this.getResFromDefaultProperties(strKey);
        }
        if (null == strValue) {
            strValue = strKey;
        }
        this.oDevTypeKeyMap.put(sNewKey, strValue);
        return strValue;
    }

    public String getResString(DeviceType oDevType, String strKey) {
        int iDevTypeID = oDevType.getDeviceTypeID();
        int DevTypeVerID = oDevType.getDeviceTypeVersionID();
        DeviceTypeInfo oDevTypeInfo = DeviceInfoManagerImpl.getInstance().getDeviceTypeInfo(iDevTypeID, DevTypeVerID);
        return this.getResString(oDevTypeInfo, strKey);
    }

    private String getValueFromAppointedFile(String strFileName, String strKey) {
        String strValue = null;
        if (!this.devTypeResBundleMap.containsKey(strFileName)) {
            String strPreFilePath = this.m_strLocaleDir + strFileName;
            try {
                ResourceBundle resBundle = this.loadResourceBundle(strPreFilePath);
                strValue = resBundle.getString(strKey);
                this.devTypeResBundleMap.put(strFileName, resBundle);
            }
            catch (Exception ex) {
                return strValue;
            }
            return strValue;
        }
        if (this.devTypeResBundleMap.containsKey(strFileName)) {
            ResourceBundle resBundle = this.devTypeResBundleMap.get(strFileName);
            try {
                strValue = resBundle.getString(strKey);
            }
            catch (Exception ex) {
                return strValue;
            }
        }
        return strValue;
    }

    private String getResFromDevTypeProperties(String strDevTypeName, String strDevTypeVersionName, String strKey) {
        String strValue = null;
        String strFileName = strDevTypeName + "_" + strDevTypeVersionName;
        strFileName = strFileName.replaceAll(this.m_strSpecialRegex, "_");
        strValue = this.getValueFromAppointedFile(strFileName, strKey);
        return strValue;
    }

    private String getResFromDevTypeProperties(String strDevTypeName, String strKey) {
        String strValue = null;
        String strFileName = strDevTypeName;
        strValue = this.getValueFromAppointedFile(strFileName, strKey);
        return strValue;
    }

    public String getResFromDomainProperties(int iDomainID, String strKey) {
        String strValue = null;
        String strFileName = "Domain_type_" + iDomainID;
        strFileName = this.getResString(strFileName, "config");
        strValue = this.getValueFromAppointedFile(strFileName, strKey);
        return strValue;
    }

    public String getResFromDefaultProperties(String strKey) {
        String strValue = null;
        strValue = this.getValueFromAppointedFile("dcdefault", strKey);
        return strValue;
    }

    public String getSpecialResForDMS(String devTypeStr, String strKey) {
        if (null == strKey) {
            DCDebugTracer.trace("strKey is null");
            return strKey;
        }
        if (null == devTypeStr || StringUtils.isNullOrEmptyStr(devTypeStr)) {
            DCDebugTracer.trace("devTypeStr is null");
            return this.getResString(strKey);
        }
        if (this.isDmsForSpecialDevType(devTypeStr)) {
            String returnStr = null;
            returnStr = this.getResFromDevTypeProperties(devTypeStr, strKey);
            if (null == returnStr || returnStr.equals(strKey)) {
                return this.getResString(strKey);
            }
            return returnStr;
        }
        return this.getResString(strKey);
    }

    public boolean isDmsForSpecialDevType(String devTypeStr) {
        if (null == devTypeStr) {
            DCDebugTracer.trace("isDmsForSpecialDevType:devTypeStr is null");
            return false;
        }
        if (null == this.m_DmsForSpecialDevTypeLst) {
            this.m_DmsForSpecialDevTypeLst = new HashSet();
            String sGroupList = this.m_oConfigBundle.getString("DMS_FOR_SPECIAL_DEVICE_RES");
            String[] sGroups = sGroupList.split("[|]");
            int iLen = sGroups.length;
            for (int i = 0; i < iLen; ++i) {
                this.m_DmsForSpecialDevTypeLst.add(sGroups[i]);
            }
        }
        return this.m_DmsForSpecialDevTypeLst.contains(devTypeStr);
    }

    public boolean isSecurityDevDevType(DeviceTypeInfo devTypeInfo) {
        if (null == devTypeInfo) {
            DCDebugTracer.trace("isSecurityDevDevType#devTypeInfo is null");
            return false;
        }
        String devTypeStr = String.valueOf(devTypeInfo.getDevTypeID());
        if (null == devTypeStr) {
            DCDebugTracer.trace("m_oSecurityDevDevType is null");
            return false;
        }
        if (null == this.m_oSecurityDevDevType || this.m_oSecurityDevDevType.size() <= 0) {
            ArrayList<Object> devTypeKeyLst = new ArrayList<Object>(0);
            ArrayList<Object> devTypeKeyLstTmp = new ArrayList(0);
            String sGroupList = this.m_oConfigBundle.getString("SECURITY_DEVICE_FOR_DMS");
            String[] strDevTypeLst = sGroupList.split("[|]");
            for (int i = 0; i < strDevTypeLst.length; ++i) {
                devTypeKeyLstTmp = this.getDevTypeKey(m_oResourseManagerInstance.getResString(strDevTypeLst[i]));
                if (devTypeKeyLstTmp.size() <= 0) continue;
                devTypeKeyLst.addAll(devTypeKeyLstTmp);
            }
            this.m_oSecurityDevDevType = new HashSet();
            for (int j = 0; j < devTypeKeyLst.size(); ++j) {
                this.m_oSecurityDevDevType.add((String)devTypeKeyLst.get(j));
            }
        }
        return this.m_oSecurityDevDevType.contains(devTypeStr);
    }

    public boolean isDevInSpecDevSeries(String strDevTypeSeries, String strDevTypeID) {
        ArrayList<String> devTypeKeyLst = this.getDevTypeKey(strDevTypeSeries);
        return devTypeKeyLst.contains(strDevTypeID);
    }

    public ArrayList<String> getDevTypeKey(String strDevTypeSeries) {
        ArrayList<String> devTypeKeyLst = new ArrayList<String>(0);
        String[] strDevTypeIDLst = DeviceInfoManagerImplHelper.getSupportDevTypeIDs(strDevTypeSeries);
        if (null != strDevTypeIDLst) {
            for (int i = 0; i < strDevTypeIDLst.length; ++i) {
                String strDevType = strDevTypeIDLst[i];
                devTypeKeyLst.add(strDevType);
            }
        }
        return devTypeKeyLst;
    }

    public boolean isNorthAmericaDevDevType(DeviceTypeInfo devTypeInfo) {
        String devTypeStr = String.valueOf(devTypeInfo.getDevTypeID());
        if (null == devTypeStr) {
            DCDebugTracer.trace("m_oNorthAmericaDevDevType is null");
            return false;
        }
        if (null == this.m_oNorthAmericaDevDevType) {
            this.m_oNorthAmericaDevDevType = new HashSet();
            String sGroupList = this.m_oConfigBundle.getString("NORTH_AMERICA_DEV_TYPE");
            String[] sGroups = sGroupList.split("[|]");
            int iLen = sGroups.length;
            for (int i = 0; i < iLen; ++i) {
                this.m_oNorthAmericaDevDevType.add(sGroups[i]);
            }
        }
        return this.m_oNorthAmericaDevDevType.contains(devTypeStr);
    }

    public boolean isNorthAmericaDevDevType(int devTypeInfo) {
        String devTypeStr = String.valueOf(devTypeInfo);
        if (null == devTypeStr) {
            DebugTracer.trace((String)"m_oNorthAmericaDevDevType is null");
            return false;
        }
        if (null == this.m_oNorthAmericaDevDevType) {
            this.m_oNorthAmericaDevDevType = new HashSet();
            String sGroupList = this.m_oConfigBundle.getString("NORTH_AMERICA_DEV_TYPE");
            String[] sGroups = sGroupList.split("[|]");
            int iLen = sGroups.length;
            for (int i = 0; i < iLen; ++i) {
                this.m_oNorthAmericaDevDevType.add(sGroups[i]);
            }
        }
        return this.m_oNorthAmericaDevDevType.contains(devTypeStr);
    }
}

