/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.common.framework.utility;

import com.huawei.dc.adapter.swimap.iview.util.DCOptionPane;
import com.huawei.dc.common.framework.utility.DCFrameWorkUtil;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.ComboBoxWithToolTip;
import com.huawei.dc.common.util.TaskInfoUtil;
import com.huawei.dc.devicemanagement.deviceoperation.activation.ActivationConfigPara;
import com.huawei.dc.devicemanagement.deviceoperation.activation.ActivationType;
import com.huawei.dc.devicemanagement.deviceoperation.activation.view.ActivationOpPanel;
import com.huawei.dc.taskmgmt.model.ITask;
import com.huawei.dc.taskmgmt.model.Task;
import com.swimap.iview.util.format.TimeDateFormatUtil;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.Collator;
import java.util.Calendar;
import java.util.List;
import javax.swing.JPanel;

public class RebootComboBox {
    private Calendar m_oRebootTime = null;
    private JPanel m_oParentPanel = null;
    private ResourceManager oResMgr = ResourceManager.getInstance();

    public ComboBoxWithToolTip getRebootCombobox() {
        ComboBoxWithToolTip oRebootComboBox = new ComboBoxWithToolTip();
        return oRebootComboBox;
    }

    public void initRebootComboBox(ComboBoxWithToolTip oRebootComboBox, List oActivateTypeLst, ActivationConfigPara oActivateConfigPara) {
        while (oRebootComboBox.getItemCount() > 0) {
            oRebootComboBox.removeItemAt(0);
        }
        ActivationType oActivationType = null;
        int iSizeOfLst = oActivateTypeLst.size();
        ActivationType oSelectedActivationType = oActivateConfigPara.getSelectedActivateType();
        Task taskRef = (Task)oActivateConfigPara.getTaskRef();
        boolean isStackDevice = taskRef.isStackDevicePresent(3);
        boolean isClusterDevice = taskRef.isClusterChildDevice() && taskRef.getDeviceType().isUpgradeModeSupportedByAllDevices(1);
        Collator oCol = Collator.getInstance();
        for (int i = 0; i < iSizeOfLst; ++i) {
            oActivationType = (ActivationType)oActivateTypeLst.get(i);
            String actionTypeId = oActivationType.getParaValue().getId();
            if ((isClusterDevice || isStackDevice) && (oCol.equals("DelayReboot", actionTypeId) || oCol.equals("ScheduledReboot", actionTypeId)) || isClusterDevice && oCol.equals("ManualReboot", actionTypeId) || actionTypeId.equals("ManualReboot")) continue;
            oRebootComboBox.addItem(oActivationType);
            if (null == oActivateConfigPara.getSelectedActivateType() || !oSelectedActivationType.getParaValue().getId().equals(oActivationType.getParaValue().getId())) continue;
            if (null != oSelectedActivationType.getScheduledActivationTime()) {
                TimeDateFormatUtil.switchLocalCalendar((Calendar)oSelectedActivationType.getScheduledActivationTime());
            }
            oActivationType.setScheduledActivationTime(oSelectedActivationType.getScheduledActivationTime());
            oRebootComboBox.setSelectedItem(oActivationType);
        }
        ComboBoxActionPerformed oComboBoxAction = new ComboBoxActionPerformed(oRebootComboBox);
        oRebootComboBox.addActionListener(oComboBoxAction);
        oComboBoxAction.performActionForActivationType(false);
    }

    public boolean isValidRebootTime() {
        if (null == this.m_oRebootTime) {
            return true;
        }
        Calendar oCurrentTime = Calendar.getInstance();
        Calendar oRebootTime = Calendar.getInstance();
        oRebootTime.setTime(this.m_oRebootTime.getTime());
        return !oRebootTime.equals(oCurrentTime) && !oRebootTime.before(oCurrentTime);
    }

    public void setParentPanel(JPanel oParentPanel) {
        this.m_oParentPanel = oParentPanel;
    }

    public class ComboBoxActionPerformed
    implements ActionListener {
        ComboBoxWithToolTip m_oRebootComboBox;

        ComboBoxActionPerformed(ComboBoxWithToolTip m_oRebootComboBox) {
            this.m_oRebootComboBox = m_oRebootComboBox;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.performActionForActivationType(true);
        }

        public void performActionForActivationType(boolean isEvent) {
            if (this.m_oRebootComboBox.getSelectedIndex() == this.m_oRebootComboBox.getOldSelectIndex()) {
                return;
            }
            ActivationType oActivationType = (ActivationType)this.m_oRebootComboBox.getSelectedItem();
            if (null == oActivationType) {
                return;
            }
            if ("ScheduledReboot".equals(oActivationType.getParaValue().getId())) {
                if (isEvent) {
                    ((ActivationOpPanel)RebootComboBox.this.m_oParentPanel).updateCompForSchecActivationTime(null);
                } else {
                    ((ActivationOpPanel)RebootComboBox.this.m_oParentPanel).updateCompForSchecActivationTime(oActivationType.getScheduledActivationTime());
                }
            } else if ("DelayReboot".equals(oActivationType.getParaValue().getId())) {
                ((ActivationOpPanel)RebootComboBox.this.m_oParentPanel).updateCompForDeLayReboot();
            } else if ("ImmediateReboot".equals(oActivationType.getParaValue().getId()) || "ISSU".equals(oActivationType.getParaValue().getId()) || "OSSU".equals(oActivationType.getParaValue().getId())) {
                ((ActivationOpPanel)RebootComboBox.this.m_oParentPanel).disableTimeComp();
            } else if ("ManualReboot".equals(oActivationType.getParaValue().getId())) {
                ((ActivationOpPanel)RebootComboBox.this.m_oParentPanel).handleActivationTypeChange(oActivationType.getParaValue().getId());
                return;
            }
            ITask oTaskDataObj = ((ActivationOpPanel)RebootComboBox.this.m_oParentPanel).getTaskInfo();
            if (TaskInfoUtil.bContainV8Dev(oTaskDataObj)) {
                if (isEvent) {
                    if ("ISSU".equals(oActivationType.getParaValue().getId())) {
                        int confirm = 0;
                        String strMsg = RebootComboBox.this.oResMgr.getResString("ISSU_ACTIVATE_MSG_PRE_POST_UPGRADE");
                        confirm = DCOptionPane.showExtConfirmDialog((Component)DCFrameWorkUtil.getMainFrame(), (String)strMsg, (String)RebootComboBox.this.oResMgr.getResString("WARNING"), (int)0, (int)2);
                        if (confirm == 0) {
                            ((ActivationOpPanel)RebootComboBox.this.m_oParentPanel).disablePreUpgradeAndUpgradePatchInPostUpgrade();
                            if (null != DCFrameWorkUtil.getTaskMgmtOperationSelecPanel()) {
                                DCFrameWorkUtil.getTaskMgmtOperationSelecPanel().refreshTable();
                            }
                        } else {
                            this.m_oRebootComboBox.setSelectedIndex(this.m_oRebootComboBox.getOldSelectIndex());
                        }
                    } else {
                        ((ActivationOpPanel)RebootComboBox.this.m_oParentPanel).enablePreUpgradeAndUpgradePatchInPostUpgrade();
                        if (null != DCFrameWorkUtil.getTaskMgmtOperationSelecPanel()) {
                            DCFrameWorkUtil.getTaskMgmtOperationSelecPanel().refreshTable();
                        }
                    }
                } else if ("ISSU".equals(oActivationType.getParaValue().getId())) {
                    ((ActivationOpPanel)RebootComboBox.this.m_oParentPanel).detectedPreUpgrade();
                }
            }
            if (!"ManualReboot".equals(oActivationType.getParaValue().getId())) {
                ((ActivationOpPanel)RebootComboBox.this.m_oParentPanel).handleActivationTypeChange(oActivationType.getParaValue().getId());
            }
        }
    }
}

