/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dc.common.framework.utility;

import com.huawei.dc.common.framework.interfaces.IDCObjectDeallocator;
import com.huawei.dc.common.framework.utility.ConfigurationInfo;
import com.huawei.dc.common.framework.utility.DCObjectDestructor;
import com.huawei.dc.common.framework.utility.MenuItemModel;
import com.huawei.dc.common.framework.utility.ResourceManager;
import com.huawei.dc.common.util.CommandManager;
import java.awt.Component;
import java.text.Collator;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PopupMenuManager
implements IDCObjectDeallocator {
    private static PopupMenuManager _instance = null;
    protected JPopupMenu m_oPopupMenu = null;
    private HashMap m_oMenuItemIdInstanceMap = new HashMap(0);
    private HashMap<String, JSeparator> m_oSeparatorIdInstanceMap = new HashMap(0);

    private PopupMenuManager() {
        DCObjectDestructor.getInstance().addObjectForDestructor(_instance);
    }

    @Override
    public void setToNULL() {
        if (null != this.m_oPopupMenu) {
            this.m_oPopupMenu.removeAll();
            this.m_oPopupMenu = null;
        }
        if (null != this.m_oMenuItemIdInstanceMap) {
            this.m_oMenuItemIdInstanceMap.clear();
            this.m_oMenuItemIdInstanceMap = null;
        }
        if (null != this.m_oSeparatorIdInstanceMap) {
            this.m_oSeparatorIdInstanceMap.clear();
            this.m_oSeparatorIdInstanceMap = null;
        }
        _instance = null;
    }

    public void resetFields() {
        this.m_oPopupMenu = null;
        this.m_oMenuItemIdInstanceMap = new HashMap(0);
        this.m_oSeparatorIdInstanceMap = new HashMap(0);
    }

    public static synchronized PopupMenuManager getInstance() {
        if (_instance == null) {
            _instance = new PopupMenuManager();
            DCObjectDestructor.getInstance().addObjectForDestructor(_instance);
        }
        return _instance;
    }

    public JPopupMenu load(Object obj, String aFileName) {
        String fileName = ConfigurationInfo.getInstance().getStyleDirectory() + aFileName + ".xml";
        if (null == this.m_oMenuItemIdInstanceMap || 0 < this.m_oMenuItemIdInstanceMap.size()) {
            this.m_oMenuItemIdInstanceMap = new HashMap(0);
        }
        if (null == this.m_oSeparatorIdInstanceMap || 0 < this.m_oSeparatorIdInstanceMap.size()) {
            this.m_oSeparatorIdInstanceMap = new HashMap(0);
        }
        this.m_oPopupMenu = this.loadMenus(obj, ConfigurationInfo.getInstance().loadDocumentFromFile(fileName));
        return this.m_oPopupMenu;
    }

    private JPopupMenu loadMenus(Object obj, Document aDocument) {
        if (null == aDocument) {
            return null;
        }
        JPopupMenu popupMenu = new JPopupMenu();
        Element rootNode = aDocument.getDocumentElement();
        this.parse(popupMenu, rootNode, obj);
        return popupMenu;
    }

    private JMenu parse(JComponent oMenu, Node oParentNode, Object obj) {
        ArrayList childNodeList = this.getChildNodeList(oParentNode, "DESC");
        int size = childNodeList.size();
        for (int index = 0; index < size; ++index) {
            this.parseDESC(oMenu, (Node)childNodeList.get(index), obj);
        }
        return null;
    }

    private void parseDESC(JComponent oMenu, Node oDescNode, Object obj) {
        ArrayList oChildNodeList = this.getChildNodeList(oDescNode, "PARAS");
        if (1 == oChildNodeList.size()) {
            Node oParaNode = (Node)oChildNodeList.get(0);
            MenuItemModel oMenuItemModel = new MenuItemModel();
            ArrayList oParamNameValueList = this.getChildNodeList(oParaNode, "PARA");
            int iParamNameValueLength = oParamNameValueList.size();
            for (int iParaIndex = 0; iParaIndex < iParamNameValueLength; ++iParaIndex) {
                Node oParameter = (Node)oParamNameValueList.get(iParaIndex);
                NamedNodeMap oNodemap = oParameter.getAttributes();
                this.loadMenuItemProperties(oMenu, oMenuItemModel, oNodemap);
            }
            JMenuItem oMenuItem = null;
            if (oMenuItemModel.getIsMenuItem()) {
                oMenuItem = new JMenuItem();
                this.addMenuItemToMenu(oMenu, obj, oMenuItemModel, oMenuItem);
                this.m_oMenuItemIdInstanceMap.put(oMenuItemModel.getId(), oMenuItem);
            } else if (oMenuItemModel.getIsMenu()) {
                oMenuItem = new JMenu();
                this.addMenuItemToMenu(oMenu, obj, oMenuItemModel, oMenuItem);
                ArrayList oChildList = this.getChildNodeList(oDescNode, "DESC");
                if (0 < oChildList.size()) {
                    this.parse(oMenuItem, oDescNode, obj);
                }
                this.m_oMenuItemIdInstanceMap.put(oMenuItemModel.getId(), oMenuItem);
            } else if (oMenuItemModel.isSeparator()) {
                JSeparator oSeparator = new JSeparator(0);
                oMenu.add(oSeparator);
                this.m_oSeparatorIdInstanceMap.put(oMenuItemModel.getId(), oSeparator);
            }
        }
    }

    private void loadMenuItemProperties(JComponent oMenu, MenuItemModel oMenuItemModel, NamedNodeMap oNodemap) {
        String strName = oNodemap.getNamedItem("name").getNodeValue();
        String strValue = oNodemap.getNamedItem("value").getNodeValue();
        if (strName.equals("type")) {
            this.setMenuType(oMenuItemModel, strValue);
        } else if (strName.equals("name")) {
            this.addMenuName(oMenu, oMenuItemModel, strValue);
        } else if (strName.equals("id")) {
            oMenuItemModel.setId(strValue);
        } else if (strName.equals("mnemonic")) {
            oMenuItemModel.setMnemonic(strValue.charAt(0));
        } else if (strName.equals("command")) {
            oMenuItemModel.setCommandName(strValue);
        } else if (strName.equals("comment")) {
            this.addComment(oMenuItemModel, strValue);
        } else if (strName.equals("accelerator")) {
            oMenuItemModel.setAcclerator(strValue);
        } else if (strName.equals("image")) {
            oMenuItemModel.setImage(strValue);
        }
    }

    private void addComment(MenuItemModel oMenuItemModel, String strValue) {
        if (strValue != null && strValue.length() > 0) {
            oMenuItemModel.setComment(ResourceManager.getInstance().getResString(strValue));
        }
    }

    private void addMenuName(JComponent oMenu, MenuItemModel oMenuItemModel, String strValue) {
        oMenuItemModel.setMenuItemName(ResourceManager.getInstance().getResString(strValue));
    }

    private void setMenuType(MenuItemModel oMenuItemModel, String strValue) {
        if (strValue.equals("JMenuItem")) {
            oMenuItemModel.setIsMenuItem(true);
        }
        if (strValue.equals("JMenu")) {
            oMenuItemModel.setIsMenu(true);
        }
        if (strValue.equals("seperator")) {
            oMenuItemModel.setSeparator(true);
        }
    }

    private void addMenuItemToMenu(JComponent oMenu, Object obj, MenuItemModel oMenuItemModel, JMenuItem oMenuItem) {
        this.addMenuItemImage(oMenuItemModel, oMenuItem);
        this.addMenuItemProperty(oMenuItemModel, oMenuItem);
        if (null != oMenuItemModel.getAcclerator()) {
            this.addAccelrator(oMenuItemModel.getAcclerator(), oMenuItem);
        }
        if (null == oMenuItemModel.getComment() || 0 == oMenuItemModel.getComment().length()) {
            oMenuItemModel.setComment("");
        }
        this.addMenuItemActionListener(obj, oMenuItemModel, oMenuItem);
        oMenu.add(oMenuItem);
    }

    private void addMenuItemProperty(MenuItemModel oMenuItemModel, JMenuItem oMenuItem) {
        oMenuItem.setText(oMenuItemModel.getMenuItemName());
        oMenuItem.setMnemonic(oMenuItemModel.getMnemonic());
    }

    private void addMenuItemImage(MenuItemModel oMenuItemModel, JMenuItem oMenuItem) {
        if (null != oMenuItemModel.getImage() && oMenuItemModel.getImage().length() > 0) {
            oMenuItem.setIcon(ResourceManager.getInstance().getImage(oMenuItemModel.getImage()));
        }
    }

    private void addMenuItemActionListener(Object obj, MenuItemModel oMenuItemModel, JMenuItem oMenuItem) {
        CommandManager oMenuAction = new CommandManager(obj, oMenuItemModel.getCommandName(), oMenuItemModel.getComment());
        oMenuItem.setActionCommand(oMenuItemModel.getCommandName());
        oMenuItem.addActionListener(oMenuAction);
    }

    private void addAccelrator(String acclerator, JMenuItem oMenuItem) {
        if (acclerator.length() > 1) {
            int emptyCharIndex = acclerator.indexOf(" ");
            String acceleratorModifer = acclerator.substring(0, emptyCharIndex);
            char accleratorChar = acclerator.substring(emptyCharIndex).charAt(1);
            if (acceleratorModifer.equalsIgnoreCase("alt")) {
                oMenuItem.setAccelerator(KeyStroke.getKeyStroke((int)accleratorChar, 8));
            } else if (acceleratorModifer.equalsIgnoreCase("ctrl")) {
                oMenuItem.setAccelerator(KeyStroke.getKeyStroke((int)accleratorChar, 2));
            }
        } else if (acclerator.length() == 1) {
            oMenuItem.setAccelerator(KeyStroke.getKeyStroke(acclerator.trim().charAt(0)));
        }
    }

    private ArrayList getChildNodeList(Node parentNode, String childNodeName) {
        ArrayList nodeList = new ArrayList(2);
        NodeList childNodeList = parentNode.getChildNodes();
        if (childNodeList != null) {
            int noOfChilds = childNodeList.getLength();
            for (int index = 0; index < noOfChilds; ++index) {
                this.addNodeToNodeList(childNodeName, nodeList, childNodeList, index);
            }
        }
        return nodeList;
    }

    private void addNodeToNodeList(String childNodeName, ArrayList nodeList, NodeList childNodeList, int index) {
        Node node = childNodeList.item(index);
        if (node.getNodeName().equals(childNodeName)) {
            nodeList.add(node);
        }
    }

    public JMenuItem getMenuItem(String StrMenuItem) {
        return this.getMenuItem(StrMenuItem, (JPopupMenu)null);
    }

    public JMenu getMenu(String strMenu, JPopupMenu oPopupMenu) {
        Component[] arrComponent = new Component[]{};
        arrComponent = null == oPopupMenu ? this.m_oPopupMenu.getComponents() : oPopupMenu.getComponents();
        JMenu oMenu = null;
        Collator oEquals = Collator.getInstance();
        for (int iCompIndex = 0; iCompIndex < arrComponent.length; ++iCompIndex) {
            if (!(arrComponent[iCompIndex] instanceof JMenu) || !oEquals.equals(((JMenu)arrComponent[iCompIndex]).getText(), strMenu)) continue;
            oMenu = (JMenu)arrComponent[iCompIndex];
            return oMenu;
        }
        return null;
    }

    public JMenuItem getMenuItem(String StrMenuItem, JPopupMenu oPopupMenu) {
        Component[] arrComponent = new Component[]{};
        arrComponent = null == oPopupMenu ? this.m_oPopupMenu.getComponents() : oPopupMenu.getComponents();
        JMenuItem oMenuItem = null;
        Collator oEquals = Collator.getInstance();
        for (int iCompIndex = 0; iCompIndex < arrComponent.length; ++iCompIndex) {
            if (!(arrComponent[iCompIndex] instanceof JMenuItem) || !oEquals.equals(((JMenuItem)arrComponent[iCompIndex]).getText(), StrMenuItem)) continue;
            oMenuItem = (JMenuItem)arrComponent[iCompIndex];
            return oMenuItem;
        }
        return null;
    }

    public JMenuItem getMenuItem(String StrMenu, String StrMenuItem) {
        Component[] arrComponent = this.m_oPopupMenu.getComponents();
        JMenu oMenu = null;
        JMenuItem oMenuItem = new JMenuItem();
        Collator oEquals = Collator.getInstance();
        for (int iCompIndex = 0; iCompIndex < arrComponent.length; ++iCompIndex) {
            if (!(arrComponent[iCompIndex] instanceof JMenu) || !oEquals.equals(((JMenu)arrComponent[iCompIndex]).getText(), StrMenu)) continue;
            oMenu = (JMenu)arrComponent[iCompIndex];
            oMenuItem = this.getMenuItemFromJMenu(StrMenuItem, oMenu);
            return oMenuItem;
        }
        return null;
    }

    public JMenuItem getMenuItemFromJMenu(String StrMenuItem, JMenu oMenu) {
        Component[] arrMenuItemComponent = oMenu.getMenuComponents();
        Collator oEquals = Collator.getInstance();
        for (int iMenuIndex = 0; iMenuIndex < arrMenuItemComponent.length; ++iMenuIndex) {
            if (!(arrMenuItemComponent[iMenuIndex] instanceof JMenuItem) || !oEquals.equals(((JMenuItem)arrMenuItemComponent[iMenuIndex]).getText(), StrMenuItem)) continue;
            JMenuItem oMenuItem = (JMenuItem)arrMenuItemComponent[iMenuIndex];
            return oMenuItem;
        }
        return null;
    }

    public HashMap getMenuItemMap() {
        return this.m_oMenuItemIdInstanceMap;
    }

    public HashMap<String, JSeparator> getSeparatorMap() {
        return this.m_oSeparatorIdInstanceMap;
    }
}

